/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.UInt8ArrayConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class FSNodeConstant
extends ValueConstant {
    public static final FSNodeConstant[] NO_NODES = new FSNodeConstant[0];
    private final Constant.Format m_fmt;
    private transient int m_iName;
    private transient int m_iCreated;
    private transient int m_iModified;
    private transient int m_iData;
    private StringConstant m_constName;
    private LiteralConstant m_constPath;
    private LiteralConstant m_constCreated;
    private LiteralConstant m_constModified;
    private Constant m_constData;
    private transient ObjectHandle m_handle;

    public FSNodeConstant(ConstantPool pool, String sName, FileTime ftCreated, FileTime ftModified, FSNodeConstant[] aFSNodes) {
        super(pool);
        if (sName == null) {
            throw new IllegalArgumentException("name required");
        }
        Handy.checkElementsNonNull(aFSNodes);
        this.m_fmt = Constant.Format.FSDir;
        this.m_constName = pool.ensureStringConstant(sName);
        this.m_constCreated = pool.ensureTimeConstant(ftCreated);
        this.m_constModified = pool.ensureTimeConstant(ftModified);
        this.m_constData = pool.ensureArrayConstant(pool.ensureArrayType(pool.typeFileNode()), aFSNodes);
    }

    public FSNodeConstant(ConstantPool pool, String sName, FileTime ftCreated, FileTime ftModified, byte[] ab) {
        super(pool);
        if (sName == null) {
            throw new IllegalArgumentException("name required");
        }
        if (ab == null) {
            throw new IllegalArgumentException("file contents required");
        }
        this.m_fmt = Constant.Format.FSFile;
        this.m_constName = pool.ensureStringConstant(sName);
        this.m_constCreated = pool.ensureTimeConstant(ftCreated);
        this.m_constModified = pool.ensureTimeConstant(ftModified);
        this.m_constData = pool.ensureByteStringConstant(ab);
    }

    public FSNodeConstant(ConstantPool pool, String sName, FileTime ftCreated, FileTime ftModified, FSNodeConstant constLinkTo) {
        super(pool);
        if (sName == null) {
            throw new IllegalArgumentException("name required");
        }
        if (constLinkTo == null) {
            throw new IllegalArgumentException("link-to node required");
        }
        this.m_fmt = Constant.Format.FSLink;
        this.m_constName = pool.ensureStringConstant(sName);
        this.m_constCreated = pool.ensureTimeConstant(ftCreated);
        this.m_constModified = pool.ensureTimeConstant(ftModified);
        this.m_constData = constLinkTo;
    }

    public FSNodeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_fmt = format;
        this.m_iName = Handy.readMagnitude(in);
        this.m_iCreated = Handy.readMagnitude(in);
        this.m_iModified = Handy.readMagnitude(in);
        this.m_iData = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_constName = (StringConstant)pool.getConstant(this.m_iName);
        this.m_constCreated = (LiteralConstant)pool.getConstant(this.m_iCreated);
        this.m_constModified = (LiteralConstant)pool.getConstant(this.m_iModified);
        this.m_constData = pool.getConstant(this.m_iData);
    }

    public StringConstant getNameConstant() {
        return this.m_constName;
    }

    public String getName() {
        return this.getNameConstant().getValue();
    }

    public LiteralConstant getPathConstant() {
        LiteralConstant constPath = this.m_constPath;
        if (this.m_constPath == null) {
            constPath = this.m_constPath = new LiteralConstant(this.getConstantPool(), Constant.Format.Path, this.getName(), this.getName());
        }
        return constPath;
    }

    public String getPath() {
        return this.getPathConstant().getValue();
    }

    public LiteralConstant getCreatedConstant() {
        return this.m_constCreated;
    }

    public String getCreated() {
        return this.getCreatedConstant().getValue();
    }

    public LiteralConstant getModifiedConstant() {
        return this.m_constModified;
    }

    public String getModified() {
        return this.getModifiedConstant().getValue();
    }

    public FSNodeConstant[] getDirectoryContents() {
        assert (this.m_fmt == Constant.Format.FSDir);
        Constant[] aConst = ((ArrayConstant)this.m_constData).getValue();
        int cConsts = aConst.length;
        FSNodeConstant[] aFSNode = new FSNodeConstant[cConsts];
        for (int i = 0; i < cConsts; ++i) {
            aFSNode[i] = (FSNodeConstant)aConst[i];
        }
        return aFSNode;
    }

    public byte[] getFileBytes() {
        assert (this.m_fmt == Constant.Format.FSFile);
        return ((UInt8ArrayConstant)this.m_constData).getValue();
    }

    public FSNodeConstant getLinkTarget() {
        assert (this.m_fmt == Constant.Format.FSLink);
        return (FSNodeConstant)this.m_constData;
    }

    public ObjectHandle getHandle() {
        return this.m_handle;
    }

    public void setHandle(ObjectHandle handle) {
        assert (handle != null);
        assert (this.m_handle == null);
        this.m_handle = handle;
    }

    @Override
    public TypeConstant getType() {
        ConstantPool pool = this.getConstantPool();
        return switch (this.m_fmt) {
            case Constant.Format.FSDir -> pool.ensureEcstasyTypeConstant("fs.Directory");
            case Constant.Format.FSFile, Constant.Format.FSLink -> pool.ensureEcstasyTypeConstant("fs.File");
            default -> throw new IllegalStateException();
        };
    }

    @Override
    public Constant getValue() {
        return this.m_constData;
    }

    @Override
    public Constant.Format getFormat() {
        return this.m_fmt;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && (this.m_constName.containsUnresolved() || this.m_constCreated.containsUnresolved() || this.m_constModified.containsUnresolved() || this.m_constData.containsUnresolved());
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constName);
        visitor.accept(this.m_constCreated);
        visitor.accept(this.m_constModified);
        visitor.accept(this.m_constData);
    }

    @Override
    protected int compareDetails(Constant that) {
        if (this.getFormat() != that.getFormat()) {
            return this.getFormat().ordinal() - that.getFormat().ordinal();
        }
        FSNodeConstant nodeThat = (FSNodeConstant)that;
        int nResult = this.m_constName.compareTo(nodeThat.m_constName);
        if (nResult == 0 && (nResult = this.m_constCreated.compareTo(nodeThat.m_constCreated)) == 0 && (nResult = this.m_constModified.compareTo(nodeThat.m_constModified)) == 0) {
            nResult = this.m_constData.compareTo(nodeThat.m_constData);
        }
        return nResult;
    }

    @Override
    public String getValueString() {
        return switch (this.m_fmt) {
            case Constant.Format.FSDir -> "./" + this.m_constName.getValue() + "/";
            case Constant.Format.FSFile -> "./" + this.m_constName.getValue();
            case Constant.Format.FSLink -> "./" + this.m_constName.getValue() + " -> " + this.m_constData.getValueString();
            default -> throw new IllegalStateException();
        };
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constName = (StringConstant)pool.register(this.m_constName);
        this.m_constCreated = (LiteralConstant)pool.register(this.m_constCreated);
        this.m_constModified = (LiteralConstant)pool.register(this.m_constModified);
        this.m_constData = pool.register(this.m_constData);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constName.getPosition());
        Handy.writePackedLong(out, this.m_constCreated.getPosition());
        Handy.writePackedLong(out, this.m_constModified.getPosition());
        Handy.writePackedLong(out, this.m_constData.getPosition());
    }

    @Override
    public String getDescription() {
        return switch (this.m_fmt) {
            case Constant.Format.FSDir -> "directory:" + this.m_constName.getValue();
            case Constant.Format.FSFile -> "file:" + this.m_constName.getValue();
            case Constant.Format.FSLink -> "link:" + this.m_constName.getValue();
            default -> throw new IllegalStateException();
        };
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constName, Hash.of(this.m_constCreated, Hash.of(this.m_constModified, Hash.of(this.m_constData))));
    }
}

