/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.FSNodeConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class FileStoreConstant
extends ValueConstant {
    private transient int m_iPath;
    private transient int m_iDir;
    private StringConstant m_constPath;
    private FSNodeConstant m_constDir;
    private transient ObjectHandle m_handle;

    public FileStoreConstant(ConstantPool pool, String sPath, FSNodeConstant constDir) {
        super(pool);
        if (sPath == null) {
            throw new IllegalArgumentException("directory path required");
        }
        if (constDir == null) {
            throw new IllegalArgumentException("directory contents required");
        }
        this.m_constPath = pool.ensureStringConstant(sPath);
        this.m_constDir = constDir;
    }

    public FileStoreConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iPath = Handy.readMagnitude(in);
        this.m_iDir = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_constPath = (StringConstant)pool.getConstant(this.m_iPath);
        this.m_constDir = (FSNodeConstant)pool.getConstant(this.m_iDir);
    }

    public String getPath() {
        return this.getPathConstant().getValue();
    }

    public StringConstant getPathConstant() {
        return this.m_constPath;
    }

    @Override
    public FSNodeConstant getValue() {
        return this.m_constDir;
    }

    public ObjectHandle getHandle() {
        return this.m_handle;
    }

    public void setHandle(ObjectHandle handle) {
        assert (handle != null);
        assert (this.m_handle == null);
        this.m_handle = handle;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.FileStore;
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().ensureEcstasyTypeConstant("fs.FileStore");
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_constDir.containsUnresolved();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constPath);
        visitor.accept(this.m_constDir);
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof FileStoreConstant)) {
            return this.getFormat().compareTo(that.getFormat());
        }
        int nResult = this.m_constPath.compareTo(((FileStoreConstant)that).m_constPath);
        if (nResult == 0) {
            nResult = this.m_constDir.compareTo(((FileStoreConstant)that).m_constDir);
        }
        return nResult;
    }

    @Override
    public String getValueString() {
        return this.m_constDir.getName();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constPath = (StringConstant)pool.register(this.m_constPath);
        this.m_constDir = (FSNodeConstant)pool.register(this.m_constDir);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constPath.getPosition());
        Handy.writePackedLong(out, this.m_constDir.getPosition());
    }

    @Override
    public String getDescription() {
        return "filestore:" + this.m_constPath.getValue();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constPath, Hash.of(this.m_constDir));
    }
}

