/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class Float128Constant
extends ValueConstant {
    private final byte[] m_abVal;

    public Float128Constant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        byte[] ab = new byte[16];
        in.readFully(ab);
        this.m_abVal = ab;
    }

    public Float128Constant(ConstantPool pool, byte[] abVal) {
        super(pool);
        if (abVal == null || abVal.length != 16) {
            throw new IllegalArgumentException("Float128Constant requires an array of 16 bytes");
        }
        this.m_abVal = abVal;
    }

    public Float128Constant add(Float128Constant that) {
        throw new UnsupportedOperationException("(unsupported)");
    }

    public byte[] getValue() {
        return this.m_abVal;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Float128;
    }

    @Override
    protected Object getLocator() {
        return this.getValue();
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof Float128Constant)) {
            return -1;
        }
        byte[] abThis = this.m_abVal;
        byte[] abThat = ((Float128Constant)that).m_abVal;
        for (int of = 0; of < 16; ++of) {
            if (abThis[of] == abThat[of]) continue;
            return (abThis[of] & 0xFF) - (abThat[of] & 0xFF);
        }
        return 0;
    }

    @Override
    public String getValueString() {
        return "(unsupported)";
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        out.write(this.m_abVal);
    }

    @Override
    public String getDescription() {
        return "bytes=" + Handy.byteArrayToHexString(this.m_abVal);
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_abVal);
    }
}

