/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.FloatConstant;
import org.xvm.util.Hash;

public class Float16Constant
extends FloatConstant {
    private final float m_flVal;

    public Float16Constant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_flVal = Float16Constant.toFloat(in.readUnsignedShort());
    }

    public Float16Constant(ConstantPool pool, float flVal) {
        super(pool);
        float flVal16 = Float16Constant.toFloat(Float16Constant.toHalf(flVal));
        if (Float.isFinite(flVal) && !Float.isFinite(flVal16)) {
            throw new IllegalArgumentException("value out of range: " + flVal);
        }
        this.m_flVal = flVal16;
    }

    public Float16Constant add(Float16Constant that) {
        return this.getConstantPool().ensureFloat16Constant(this.m_flVal + that.m_flVal);
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.m_flVal);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Float16;
    }

    @Override
    protected Object getLocator() {
        return this.getValue();
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof Float16Constant)) {
            return -1;
        }
        return Float.compare(this.m_flVal, ((Float16Constant)that).m_flVal);
    }

    @Override
    public String getValueString() {
        return Float.toString(this.m_flVal);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        out.writeShort(Float16Constant.toHalf(this.m_flVal));
    }

    @Override
    public String getDescription() {
        return "value=" + this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_flVal);
    }

    public static float toFloat(int nHalf) {
        int mant = nHalf & 0x3FF;
        int exp = nHalf & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            if (mant == 0 && (exp += 114688) > 115712) {
                return Float.intBitsToFloat((nHalf & 0x8000) << 16 | exp << 13 | 0x3FF);
            }
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((nHalf & 0x8000) << 16 | (exp | mant) << 13);
    }

    public static int toHalf(float flVal) {
        int fbits = Float.floatToIntBits(flVal);
        int sign = fbits >>> 16 & 0x8000;
        int val = (fbits & Integer.MAX_VALUE) + 4096;
        if (val >= 1199570944) {
            if ((fbits & Integer.MAX_VALUE) >= 1199570944) {
                return val < 2139095040 ? sign | 0x7C00 : sign | 0x7C00 | (fbits & 0x7FFFFF) >>> 13;
            }
            return sign | 0x7BFF;
        }
        if (val >= 0x38800000) {
            return sign | val - 0x38000000 >>> 13;
        }
        if (val < 0x33000000) {
            return sign;
        }
        val = (fbits & Integer.MAX_VALUE) >>> 23;
        return sign | (fbits & 0x7FFFFF | 0x800000) + (0x800000 >>> val - 102) >>> 126 - val;
    }
}

