/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.FloatConstant;
import org.xvm.util.Hash;

public class Float32Constant
extends FloatConstant {
    private final float m_flVal;

    public Float32Constant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_flVal = in.readFloat();
    }

    public Float32Constant(ConstantPool pool, float flVal) {
        super(pool);
        this.m_flVal = flVal;
    }

    public Float32Constant add(Float32Constant that) {
        return this.getConstantPool().ensureFloat32Constant(this.m_flVal + that.m_flVal);
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.m_flVal);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Float32;
    }

    @Override
    protected Object getLocator() {
        return this.getValue();
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof Float32Constant)) {
            return -1;
        }
        return Float.compare(this.m_flVal, ((Float32Constant)that).m_flVal);
    }

    @Override
    public String getValueString() {
        return Float.toString(this.m_flVal);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        out.writeFloat(this.m_flVal);
    }

    @Override
    public String getDescription() {
        return "value=" + this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_flVal);
    }
}

