/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.util.Hash;

public class Float64Constant
extends ValueConstant {
    private final double m_dflVal;

    public Float64Constant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_dflVal = in.readDouble();
    }

    public Float64Constant(ConstantPool pool, double dflVal) {
        super(pool);
        this.m_dflVal = dflVal;
    }

    public Float64Constant add(Float64Constant that) {
        return this.getConstantPool().ensureFloat64Constant(this.m_dflVal + that.m_dflVal);
    }

    @Override
    public Double getValue() {
        return this.m_dflVal;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Float64;
    }

    @Override
    protected Object getLocator() {
        return this.getValue();
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof Float64Constant)) {
            return -1;
        }
        return Double.compare(this.m_dflVal, ((Float64Constant)that).m_dflVal);
    }

    @Override
    public String getValueString() {
        return Double.toString(this.m_dflVal);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        out.writeDouble(this.m_dflVal);
    }

    @Override
    public String getDescription() {
        return "value=" + this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_dflVal);
    }
}

