/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.FloatConstant;
import org.xvm.util.Hash;

public class Float8e5Constant
extends FloatConstant {
    private final int m_nBits;

    public Float8e5Constant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_nBits = in.readUnsignedByte();
    }

    public Float8e5Constant(ConstantPool pool, float flVal) {
        super(pool);
        this.m_nBits = Float8e5Constant.toBits(flVal);
    }

    @Override
    public Float getValue() {
        return Float.valueOf(Float8e5Constant.toFloat(this.m_nBits));
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Float8e5;
    }

    @Override
    protected Object getLocator() {
        return this.getValue();
    }

    @Override
    protected int compareDetails(Constant that) {
        if (that instanceof Float8e5Constant) {
            Float8e5Constant thatFP8 = (Float8e5Constant)that;
            return Float.compare(Float8e5Constant.toFloat(this.m_nBits), Float8e5Constant.toFloat(thatFP8.m_nBits));
        }
        return -1;
    }

    @Override
    public String getValueString() {
        return Float.toString(Float8e5Constant.toFloat(this.m_nBits));
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        out.writeByte(this.m_nBits);
    }

    @Override
    public String getDescription() {
        return "value=" + this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of((byte)this.m_nBits);
    }

    public static float toFloat(int nBits) {
        return switch (nBits) {
            case 0 -> 0.0f;
            case 128 -> -0.0f;
            case 127 -> Float.NaN;
            case 255 -> Float.intBitsToFloat(-4194304);
            case 124 -> Float.POSITIVE_INFINITY;
            case 252 -> Float.NEGATIVE_INFINITY;
            default -> throw new UnsupportedOperationException("TODO implement non-zero E5M2 float values");
        };
    }

    public static int toBits(float flVal) {
        boolean fNeg;
        boolean bl = fNeg = (Float.floatToIntBits(flVal) & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if (Float.isFinite(flVal)) {
            if (flVal == 0.0f) {
                return fNeg ? 128 : 0;
            }
            return 0;
        }
        if (Float.isNaN(flVal)) {
            return fNeg ? 255 : 127;
        }
        assert (Float.isInfinite(flVal));
        return fNeg ? 252 : 124;
    }
}

