/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.PropertyExprAST;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.ast.Context;

public class FormalTypeChildConstant
extends PropertyConstant {
    public FormalTypeChildConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    public FormalTypeChildConstant(ConstantPool pool, FormalConstant constParent, String sName) {
        super(pool, constParent, sName);
    }

    @Override
    protected void checkParent(IdentityConstant idParent) {
        switch (idParent.getFormat()) {
            case FormalTypeChild: 
            case TypeParameter: {
                break;
            }
            case Property: {
                if (((PropertyConstant)idParent).isFormalType()) break;
            }
            default: {
                throw new IllegalArgumentException("parent does not represent a formal constant: " + String.valueOf(idParent));
            }
        }
    }

    public IdentityConstant getTopParent() {
        IdentityConstant idParent = this.getParentConstant();
        while (((Constant)idParent).getFormat() == Constant.Format.FormalTypeChild) {
            idParent = ((IdentityConstant)idParent).getParentConstant();
        }
        return idParent;
    }

    @Override
    public TypeConstant getConstraintType() {
        String sName;
        TypeConstant typeConstraint = this.m_typeConstraint;
        if (typeConstraint != null) {
            return typeConstraint;
        }
        typeConstraint = this.getParentConstant().getConstraintType();
        if (typeConstraint.containsGenericParam(sName = this.getName())) {
            if (typeConstraint.isTuple()) {
                this.m_typeConstraint = this.getConstantPool().typeTuple();
                return this.m_typeConstraint;
            }
            TypeConstant type = typeConstraint.getSingleUnderlyingClass(true).getFormalType().resolveFormalType(this);
            assert (type.isGenericType());
            PropertyConstant idProp = (PropertyConstant)type.getDefiningConstant();
            this.m_typeConstraint = idProp.getConstraintType();
            return this.m_typeConstraint;
        }
        this.m_typeConstraint = "OuterType".equals(sName) && typeConstraint.isVirtualChild() ? typeConstraint.getParentType() : this.getConstantPool().typeObject();
        return this.m_typeConstraint;
    }

    @Override
    public TypeConstant resolve(GenericTypeResolver resolver) {
        TypeConstant typeResolved = super.resolve(resolver);
        if (typeResolved == null) {
            FormalConstant idParent = this.getParentConstant();
            TypeConstant typeParent = idParent.resolve(resolver);
            if (typeParent == null) {
                return null;
            }
            if (typeParent.isFormalType()) {
                FormalConstant idParentResolved = (FormalConstant)typeParent.getDefiningConstant();
                if (idParentResolved != idParent) {
                    switch (idParentResolved.getFormat()) {
                        case FormalTypeChild: 
                        case TypeParameter: {
                            return idParentResolved.getConstantPool().ensureFormalTypeChildConstant(idParentResolved, this.getName()).getType();
                        }
                    }
                }
                return null;
            }
            typeResolved = typeParent.resolveFormalType(this);
            if (typeResolved == null) {
                typeResolved = typeParent.getType().resolveFormalType(this);
            }
        }
        return typeResolved;
    }

    @Override
    public ExprAST toExprAst(Context ctx) {
        return new PropertyExprAST(this.getParentConstant().toExprAst(ctx), this.getNameConstant());
    }

    @Override
    public IdentityConstant replaceParentConstant(IdentityConstant idParent) {
        return new FormalTypeChildConstant(this.getConstantPool(), (FormalConstant)idParent, this.getName());
    }

    @Override
    public FormalConstant getParentConstant() {
        return (FormalConstant)super.getParentConstant();
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().ensureTerminalTypeConstant(this);
    }

    @Override
    public IdentityConstant appendTrailingSegmentTo(IdentityConstant that) {
        return that.getConstantPool().ensureFormalTypeChildConstant((FormalConstant)that, this.getName());
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.FormalTypeChild;
    }

    @Override
    public boolean containsUnresolved() {
        return false;
    }

    @Override
    public String getDescription() {
        return "parent=" + String.valueOf(this.getParentConstant()) + ", child=" + this.getName();
    }
}

