/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.DecoratedClassConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.TypeSystem;
import org.xvm.util.Handy;

public abstract class IdentityConstant
extends Constant {
    private transient Component m_component;
    private transient NestedIdentity m_canonicalNid;
    private transient Boolean m_fNested;

    protected IdentityConstant(ConstantPool pool) {
        super(pool);
    }

    public abstract IdentityConstant getParentConstant();

    public abstract IdentityConstant replaceParentConstant(IdentityConstant var1);

    public IdentityConstant getNamespace() {
        return this.getParentConstant();
    }

    public abstract String getName();

    public ModuleConstant getModuleConstant() {
        return this.getParentConstant().getModuleConstant();
    }

    public int getPathElementCount() {
        int c = 0;
        IdentityConstant id = this;
        do {
            ++c;
        } while ((id = id.getParentConstant()) != null);
        return c;
    }

    public List<IdentityConstant> getPath() {
        List<IdentityConstant> list = this.getParentConstant().getPath();
        list.add(this);
        return list;
    }

    public String getPathString() {
        return this.buildPath().substring(1);
    }

    protected StringBuilder buildPath() {
        return this.getParentConstant().buildPath().append('.').append(this.getPathElementString());
    }

    public Object getPathElement() {
        return this.getName();
    }

    public String getPathElementString() {
        return this.getName();
    }

    public boolean isNestMateOf(IdentityConstant idClass) {
        if (this.equals(idClass)) {
            return true;
        }
        if (this.getFormat() == Constant.Format.Class && idClass.getFormat() == Constant.Format.Class) {
            ClassConstant idThis = (ClassConstant)this;
            ClassConstant idThat = (ClassConstant)idClass;
            ClassStructure clzThis = (ClassStructure)idThis.getComponent();
            if (clzThis.isAnonInnerClass()) {
                return false;
            }
            ClassConstant idBaseThis = idThis.getAutoNarrowingBase();
            ClassConstant idBaseThat = idThat;
            do {
                if (idBaseThis.equals(idBaseThat)) {
                    return true;
                }
                ClassStructure clzThat = (ClassStructure)idBaseThat.getComponent();
                if (!clzThat.hasContribution(idBaseThis)) continue;
                return true;
            } while ((idBaseThat = idBaseThat.getParentClass()) != null);
        }
        return false;
    }

    public boolean isNested() {
        Boolean fNested = this.m_fNested;
        return fNested == null ? (this.m_fNested = this.computeIsNested()) : fNested;
    }

    private Boolean computeIsNested() {
        return switch (this.getFormat()) {
            case Constant.Format.Typedef, Constant.Format.Property, Constant.Format.MultiMethod, Constant.Format.Method -> true;
            default -> false;
        };
    }

    public int getNestedDepth() {
        int c = 0;
        IdentityConstant id = this;
        while (id.isNested()) {
            id = id.getParentConstant();
            ++c;
        }
        return c;
    }

    public IdentityConstant getClassIdentity() {
        IdentityConstant id = this;
        while (id.isNested()) {
            id = id.getParentConstant();
        }
        return id;
    }

    public String getNestedName() {
        IdentityConstant idParent = this.getParentConstant();
        return switch (idParent.getFormat()) {
            case Constant.Format.Module, Constant.Format.Package, Constant.Format.Class -> this.getName();
            case Constant.Format.MultiMethod -> idParent.getNestedName();
            case Constant.Format.Property -> idParent.getNestedName() + "." + this.getName();
            default -> null;
        };
    }

    public Object getNestedIdentity() {
        return this.isNested() ? this.getCanonicalNestedIdentity() : null;
    }

    public Object resolveNestedIdentity(ConstantPool pool, GenericTypeResolver resolver) {
        return this.isNested() ? (resolver == null ? this.getCanonicalNestedIdentity() : new NestedIdentity(resolver)) : null;
    }

    protected NestedIdentity getCanonicalNestedIdentity() {
        NestedIdentity nid = this.m_canonicalNid;
        if (nid == null) {
            this.m_canonicalNid = nid = new NestedIdentity();
        }
        return nid;
    }

    public int getNestedDepth(Object oid) {
        int n;
        if (oid instanceof NestedIdentity) {
            NestedIdentity nid = (NestedIdentity)oid;
            n = nid.getIdentityConstant().getNestedDepth();
        } else {
            n = oid == null ? 0 : 1;
        }
        return n;
    }

    public static boolean isNestedSibling(Object oid1, Object oid2) {
        if (oid1 == null || oid2 == null) {
            return oid1 == oid2;
        }
        if (oid1 instanceof NestedIdentity) {
            NestedIdentity nid1 = (NestedIdentity)oid1;
            if (oid2 instanceof NestedIdentity) {
                NestedIdentity nid2 = (NestedIdentity)oid2;
                IdentityConstant id1 = nid1.getIdentityConstant();
                IdentityConstant id2 = nid2.getIdentityConstant();
                return id1.getNestedDepth() == id2.getNestedDepth() && Handy.equals(id1.getParentConstant().getNestedIdentity(), id2.getParentConstant().getNestedIdentity());
            }
            return nid1.getIdentityConstant().getNestedDepth() == 1;
        }
        if (oid2 instanceof NestedIdentity) {
            NestedIdentity nid2 = (NestedIdentity)oid2;
            return nid2.getIdentityConstant().getNestedDepth() == 1;
        }
        return true;
    }

    public Component relocateNestedIdentity(ClassStructure clz) {
        assert (!this.isNested());
        return clz;
    }

    public IdentityConstant appendNestedIdentity(ConstantPool pool, Object oid) {
        Object object = oid;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, SignatureConstant.class, NestedIdentity.class}, (Object)object, n)) {
            case 0 -> {
                String s = (String)object;
                yield pool.ensurePropertyConstant(this, s);
            }
            case 1 -> {
                SignatureConstant sig = (SignatureConstant)object;
                yield pool.ensureMethodConstant(this, sig);
            }
            case 2 -> {
                NestedIdentity nid = (NestedIdentity)object;
                yield nid.getIdentityConstant().ensureNestedIdentity(pool, this);
            }
            case -1 -> this;
            default -> throw new IllegalArgumentException("illegal nid: " + String.valueOf(oid));
        };
    }

    protected IdentityConstant ensureNestedIdentity(ConstantPool pool, IdentityConstant that) {
        return that;
    }

    public boolean trailingPathEquals(IdentityConstant that, int cSegments) {
        return cSegments <= 0 || this == that || this.trailingSegmentEquals(that) && this.getParentConstant().trailingPathEquals(that.getParentConstant(), cSegments - 1);
    }

    public IdentityConstant appendTrailingPathTo(IdentityConstant that, int cSegments) {
        switch (cSegments) {
            default: {
                assert (cSegments > 0);
                that = this.appendTrailingPathTo(that, cSegments - 1);
            }
            case 1: {
                return this.appendTrailingSegmentTo(that);
            }
            case 0: 
        }
        return that;
    }

    public boolean trailingSegmentEquals(IdentityConstant that) {
        return this.getClass() == that.getClass() && this.getName().equals(that.getName());
    }

    public abstract IdentityConstant appendTrailingSegmentTo(IdentityConstant var1);

    public boolean isShared(ConstantPool poolOther) {
        return poolOther == this.getConstantPool() || poolOther.getFileStructure().getChild(this.getModuleConstant()) != null;
    }

    public Component getComponent() {
        Component component = this.m_component;
        if (component == null) {
            Component parent = this.getParentConstant().getComponent();
            component = parent == null ? null : parent.getChild(this);
            this.m_component = component;
        }
        return component;
    }

    public boolean extendsClass(ClassConstant clzSuper) {
        return this.isClass() && ((ClassStructure)this.getComponent()).extendsClass(clzSuper);
    }

    public boolean isDescendant(IdentityConstant idAscendant) {
        if (this.equals(idAscendant)) {
            return true;
        }
        IdentityConstant idParent = this.getParentConstant();
        return idParent != null && idParent.isDescendant(idAscendant);
    }

    public TypeConstant getValueType(ConstantPool pool, TypeConstant typeTarget) {
        if (this.isClass()) {
            Annotation[] aAnnos;
            TypeConstant type = this.getType().removeAccess().normalizeParameters();
            Component component = this.getComponent();
            switch (component.getFormat()) {
                case ENUM: {
                    return pool.ensureParameterizedTypeConstant(pool.typeEnumeration(), type);
                }
                case ENUMVALUE: {
                    return pool.ensureParameterizedTypeConstant(pool.typeEnumValue(), type);
                }
                case PROPERTY: {
                    aAnnos = Annotation.NO_ANNOTATIONS;
                    break;
                }
                default: {
                    aAnnos = ((ClassStructure)component).collectAnnotations(true);
                }
            }
            TypeConstant typeClz = pool.ensureParameterizedTypeConstant(pool.typeClass(), type, pool.ensureAccessTypeConstant(type, Constants.Access.PROTECTED), pool.ensureAccessTypeConstant(type, Constants.Access.PRIVATE), pool.ensureAccessTypeConstant(type, Constants.Access.STRUCT));
            return aAnnos.length == 0 ? typeClz : pool.ensureAnnotatedTypeConstant(typeClz, aAnnos);
        }
        throw new UnsupportedOperationException("constant-class=" + this.getClass().getSimpleName());
    }

    public TypeConstant getFormalType() {
        Component component = this.getComponent();
        if (component instanceof ClassStructure) {
            ClassStructure struct = (ClassStructure)component;
            return struct.getFormalType();
        }
        throw new IllegalStateException("not a class type: " + String.valueOf(this));
    }

    public void resetCachedInfo() {
        this.m_component = null;
    }

    public String getJitName(TypeSystem ts) {
        return this.buildJitName(ts).substring(1);
    }

    protected StringBuilder buildJitName(TypeSystem ts) {
        IdentityConstant idParent = this.getParentConstant();
        char chDelim = switch (idParent.getFormat()) {
            case Constant.Format.Module, Constant.Format.Package -> '.';
            case Constant.Format.Property, Constant.Format.Method, Constant.Format.Class -> '$';
            default -> throw new IllegalStateException("unexpected parent constant: " + String.valueOf(idParent));
        };
        return this.getParentConstant().buildJitName(ts).append(chDelim).append(this.getName());
    }

    @Override
    public TypeConstant getType() {
        switch (this.getFormat()) {
            case Typedef: 
            case Property: 
            case Module: 
            case Package: 
            case Class: 
            case NativeClass: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                break;
            }
            default: {
                throw new IllegalStateException("not a class type: " + String.valueOf(this));
            }
        }
        return this.getConstantPool().ensureTerminalTypeConstant(this);
    }

    @Override
    public boolean containsUnresolved() {
        if (this.isHashCached()) {
            return false;
        }
        IdentityConstant parent = this.getParentConstant();
        return parent != null && parent.containsUnresolved();
    }

    @Override
    public Constant convertTo(TypeConstant typeOut) {
        ConstantPool pool = this.getConstantPool();
        return typeOut.equals(pool.typeClass()) ? new DecoratedClassConstant(pool, this.getType()) : super.convertTo(typeOut);
    }

    @Override
    protected Object getLocator() {
        return super.getLocator();
    }

    @Override
    protected abstract int compareDetails(Constant var1);

    @Override
    protected void setContaining(XvmStructure xsParent) {
        super.setContaining(xsParent);
        this.resetCachedInfo();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        super.registerConstants(pool);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
    }

    public class NestedIdentity {
        private final GenericTypeResolver m_resolver;

        public NestedIdentity() {
            this(null);
        }

        public NestedIdentity(GenericTypeResolver resolver) {
            this.m_resolver = resolver;
        }

        public boolean isCacheable() {
            return this.m_resolver == null || this.m_resolver instanceof TypeConstant;
        }

        public IdentityConstant getIdentityConstant() {
            return IdentityConstant.this;
        }

        public String toString() {
            IdentityConstant id = IdentityConstant.this;
            String sClass = id.getClassIdentity().getPathString();
            return id.getPathString().substring(sClass.isEmpty() ? 0 : sClass.length() + 1);
        }

        public int hashCode() {
            int iHash = 0;
            IdentityConstant id = IdentityConstant.this;
            boolean fTop = true;
            while (id.isNested()) {
                Object oPath = id.getPathElement();
                if (fTop) {
                    oPath = this.resolve(oPath);
                    fTop = false;
                }
                iHash ^= oPath.hashCode();
                id = id.getNamespace();
            }
            return iHash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NestedIdentity)) {
                return false;
            }
            NestedIdentity that = (NestedIdentity)obj;
            IdentityConstant idThis = this.getIdentityConstant();
            IdentityConstant idThat = that.getIdentityConstant();
            boolean fTop = true;
            while (idThis.isNested() && idThat.isNested()) {
                Object oThis = idThis.getPathElement();
                Object oThat = idThat.getPathElement();
                if (fTop) {
                    oThis = this.resolve(oThis);
                    oThat = that.resolve(oThat);
                    fTop = false;
                }
                if (!oThis.equals(oThat)) {
                    return false;
                }
                idThis = idThis.getNamespace();
                idThat = idThat.getNamespace();
            }
            return idThis.isNested() == idThat.isNested();
        }

        private Object resolve(Object element) {
            Object object;
            ConstantPool pool = ConstantPool.getCurrentPool();
            if (this.m_resolver != null && element instanceof SignatureConstant) {
                SignatureConstant sig = (SignatureConstant)element;
                object = sig.resolveGenericTypes(pool, this.m_resolver);
            } else {
                object = element;
            }
            return object;
        }
    }
}

