/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.Severity;

public class ImmutableTypeConstant
extends TypeConstant {
    private int m_iType;
    private TypeConstant m_constType;

    public ImmutableTypeConstant(ConstantPool pool, TypeConstant constType) {
        super(pool);
        if (constType == null) {
            throw new IllegalArgumentException("type required");
        }
        if (!constType.isSingleDefiningConstant()) {
            throw new IllegalArgumentException("immutability cannot be specified for a relational type");
        }
        this.m_constType = constType;
    }

    public ImmutableTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iType = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_constType = (TypeConstant)this.getConstantPool().getConstant(this.m_iType);
    }

    @Override
    public boolean isModifyingType() {
        return true;
    }

    @Override
    public TypeConstant getUnderlyingType() {
        return this.m_constType;
    }

    @Override
    public boolean isImmutabilitySpecified() {
        return true;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public boolean isOnlyImmutable() {
        return this.getUnderlyingType().equals(this.getConstantPool().typeObject());
    }

    @Override
    public TypeConstant freeze() {
        return this;
    }

    @Override
    public TypeConstant ensureAccess(Constants.Access access) {
        return this.cloneSingle(this.getConstantPool(), this.getUnderlyingType().ensureAccess(access));
    }

    @Override
    public boolean isNullable() {
        return this.m_constType.isNullable();
    }

    @Override
    public TypeConstant removeNullable() {
        return this.isNullable() ? this.cloneSingle(this.getConstantPool(), this.m_constType.removeNullable()) : this;
    }

    @Override
    protected TypeConstant cloneSingle(ConstantPool pool, TypeConstant type) {
        return type.isImmutabilitySpecified() || !type.containsUnresolved() && type.isImmutable() ? type : pool.ensureImmutableTypeConstant(type);
    }

    @Override
    public TypeConstant resolveConstraints(boolean fPendingOnly) {
        TypeConstant constOriginal = this.getUnderlyingType();
        TypeConstant constResolved = constOriginal.resolveConstraints(fPendingOnly);
        return constResolved == constOriginal ? this : constResolved.freeze();
    }

    @Override
    public TypeConstant resolveAutoNarrowing(ConstantPool pool, boolean fRetainParams, TypeConstant typeTarget, IdentityConstant idCtx) {
        return this.getUnderlyingType().resolveAutoNarrowing(pool, fRetainParams, typeTarget, idCtx).freeze();
    }

    @Override
    protected TypeConstant.Relation calculateRelationToLeft(TypeConstant typeLeft) {
        return this.getUnderlyingType().calculateRelationToLeft(typeLeft.removeImmutable());
    }

    @Override
    protected TypeConstant.Relation calculateRelationToRight(TypeConstant typeRight) {
        return this.getUnderlyingType().calculateRelationToRight(typeRight);
    }

    @Override
    protected TypeInfo buildTypeInfo(ErrorListener errs) {
        return this.m_constType.ensureTypeInfoInternal(errs);
    }

    @Override
    protected boolean isDuckTypeAbleFrom(TypeConstant typeRight) {
        return typeRight.isImmutable() && super.isDuckTypeAbleFrom(typeRight);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ImmutableType;
    }

    @Override
    protected Object getLocator() {
        return this.m_constType;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_constType.containsUnresolved();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constType);
    }

    @Override
    protected int compareDetails(Constant obj) {
        int n;
        if (obj instanceof ImmutableTypeConstant) {
            ImmutableTypeConstant that = (ImmutableTypeConstant)obj;
            n = this.m_constType.compareTo(that.m_constType);
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public String getValueString() {
        return "immutable " + this.m_constType.getValueString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constType = (TypeConstant)pool.register(this.m_constType);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, ImmutableTypeConstant.indexOf(this.m_constType));
    }

    @Override
    public boolean validate(ErrorListener errs) {
        if (!this.isValidated()) {
            IdentityConstant idClz;
            boolean fHalt = false;
            TypeConstant type = this.m_constType;
            if (type instanceof ImmutableTypeConstant) {
                fHalt |= this.log(errs, Severity.WARNING, "VERIFY-25", new Object[0]);
            }
            if (type.isExplicitClassIdentity(true) && (idClz = this.getSingleUnderlyingClass(true)).getComponent().getFormat() == Component.Format.SERVICE) {
                this.log(errs, Severity.ERROR, "VERIFY-24", type.getValueString());
                fHalt = true;
            }
            if (!fHalt) {
                return super.validate(errs);
            }
        }
        return false;
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constType);
    }
}

