/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.AbstractDependantChildTypeConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class InnerChildTypeConstant
extends AbstractDependantChildTypeConstant {
    private transient int m_iChild;
    protected ClassConstant m_idChild;

    public InnerChildTypeConstant(ConstantPool pool, TypeConstant typeParent, ClassConstant idChild) {
        super(pool, typeParent);
        if (typeParent.isAccessSpecified()) {
            throw new IllegalArgumentException("parent's access cannot be specified");
        }
        if (idChild == null) {
            throw new IllegalArgumentException("id is required");
        }
        this.m_idChild = idChild;
    }

    public InnerChildTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
        this.m_iChild = Handy.readIndex(in);
    }

    @Override
    protected void resolveConstants() {
        super.resolveConstants();
        this.m_idChild = (ClassConstant)this.getConstantPool().getConstant(this.m_iChild);
    }

    @Override
    protected ClassStructure getChildStructure() {
        return (ClassStructure)this.m_idChild.getComponent();
    }

    @Override
    public boolean isShared(ConstantPool poolOther) {
        return super.isShared(poolOther) && this.m_idChild.isShared(poolOther);
    }

    @Override
    public boolean isInnerChildClass() {
        return true;
    }

    @Override
    protected TypeConstant cloneSingle(ConstantPool pool, TypeConstant type) {
        return pool.ensureInnerChildTypeConstant(type, this.m_idChild);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.InnerChildType;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        super.forEachUnderlying(visitor);
        visitor.accept(this.m_idChild);
    }

    @Override
    protected int compareDetails(Constant obj) {
        int n = super.compareDetails(obj);
        if (n == 0) {
            if (!(obj instanceof InnerChildTypeConstant)) {
                return -1;
            }
            InnerChildTypeConstant that = (InnerChildTypeConstant)obj;
            n = this.m_idChild.compareTo(that.m_idChild);
        }
        return n;
    }

    @Override
    public String getValueString() {
        return this.m_typeParent.getValueString() + "." + this.m_idChild.getValueString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        super.registerConstants(pool);
        this.m_idChild = (ClassConstant)pool.register(this.m_idChild);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
        Handy.writePackedLong(out, this.m_idChild.getPosition());
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_typeParent, Hash.of(this.m_idChild));
    }
}

