/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.ByteConstant;
import org.xvm.asm.constants.DecimalConstant;
import org.xvm.asm.constants.Float32Constant;
import org.xvm.asm.constants.Float64Constant;
import org.xvm.asm.constants.FloatConstant;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.compiler.Token;
import org.xvm.type.Decimal64;
import org.xvm.util.Hash;
import org.xvm.util.PackedInteger;

public class IntConstant
extends ValueConstant {
    private final Constant.Format m_fmt;
    private final PackedInteger m_pint;

    public IntConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        this(pool, format, new PackedInteger(in));
    }

    public IntConstant(ConstantPool pool, Constant.Format format, PackedInteger pint) {
        super(pool);
        int cBytes;
        if (format == null) {
            throw new IllegalStateException("format required");
        }
        if (pint == null) {
            throw new IllegalStateException("integer value required");
        }
        pint.verifyInitialized();
        if (switch (format) {
            case Constant.Format.Int16 -> {
                cBytes = 2;
                yield false;
            }
            case Constant.Format.Int32 -> {
                cBytes = 4;
                yield false;
            }
            case Constant.Format.Int64 -> {
                cBytes = 8;
                yield false;
            }
            case Constant.Format.Int128 -> {
                cBytes = 16;
                yield false;
            }
            case Constant.Format.IntN -> {
                cBytes = 1024;
                yield false;
            }
            case Constant.Format.UInt16 -> {
                cBytes = 2;
                yield true;
            }
            case Constant.Format.UInt32 -> {
                cBytes = 4;
                yield true;
            }
            case Constant.Format.UInt64 -> {
                cBytes = 8;
                yield true;
            }
            case Constant.Format.UInt128 -> {
                cBytes = 16;
                yield true;
            }
            case Constant.Format.UIntN -> {
                cBytes = 1024;
                yield true;
            }
            default -> throw new IllegalStateException("unsupported format: " + String.valueOf((Object)format));
        }) {
            if (pint.compareTo(PackedInteger.ZERO) < 0) {
                throw new IllegalStateException("illegal unsigned value: " + String.valueOf(pint));
            }
            if (pint.getUnsignedByteSize() > cBytes || format == Constant.Format.UInt64 && pint.compareTo(PackedInteger.SINT16_MAX) > 0) {
                throw new IllegalStateException("value exceeds " + cBytes + " bytes: " + String.valueOf(pint));
            }
        } else if (pint.getSignedByteSize() > cBytes) {
            throw new IllegalStateException("value exceeds " + cBytes + " bytes: " + String.valueOf(pint));
        }
        this.m_fmt = format;
        this.m_pint = pint;
    }

    @Override
    public PackedInteger getValue() {
        return this.m_pint;
    }

    public boolean isUnsigned() {
        return switch (this.m_fmt) {
            case Constant.Format.Int16, Constant.Format.Int32, Constant.Format.Int64, Constant.Format.Int128, Constant.Format.IntN -> false;
            case Constant.Format.UInt16, Constant.Format.UInt32, Constant.Format.UInt64, Constant.Format.UInt128, Constant.Format.UIntN -> true;
            default -> throw new IllegalStateException();
        };
    }

    public int byteSize() {
        return switch (this.m_fmt) {
            case Constant.Format.Int16, Constant.Format.UInt16 -> 2;
            case Constant.Format.Int32, Constant.Format.UInt32 -> 4;
            case Constant.Format.Int64, Constant.Format.UInt64 -> 8;
            case Constant.Format.Int128, Constant.Format.UInt128 -> 16;
            default -> throw new IllegalStateException();
        };
    }

    public PackedInteger getMinLimit() {
        return IntConstant.getMinLimit(this.m_fmt);
    }

    public static PackedInteger getMinLimit(Constant.Format format) {
        return switch (format) {
            case Constant.Format.Int16 -> PackedInteger.SINT2_MIN;
            case Constant.Format.Int32 -> PackedInteger.SINT4_MIN;
            case Constant.Format.Int64 -> PackedInteger.SINT8_MIN;
            case Constant.Format.Int128 -> PackedInteger.SINT16_MIN;
            case Constant.Format.IntN -> PackedInteger.SINTN_MIN;
            case Constant.Format.UInt16, Constant.Format.UInt32, Constant.Format.UInt64, Constant.Format.UInt128, Constant.Format.UIntN -> PackedInteger.ZERO;
            default -> throw new IllegalStateException();
        };
    }

    public PackedInteger getMaxLimit() {
        return IntConstant.getMaxLimit(this.m_fmt);
    }

    public static PackedInteger getMaxLimit(Constant.Format format) {
        return switch (format) {
            case Constant.Format.Int16 -> PackedInteger.SINT2_MAX;
            case Constant.Format.Int32 -> PackedInteger.SINT4_MAX;
            case Constant.Format.Int64 -> PackedInteger.SINT8_MAX;
            case Constant.Format.Int128 -> PackedInteger.SINT16_MAX;
            case Constant.Format.IntN -> PackedInteger.SINTN_MAX;
            case Constant.Format.UInt16 -> PackedInteger.UINT2_MAX;
            case Constant.Format.UInt32 -> PackedInteger.UINT4_MAX;
            case Constant.Format.UInt64 -> PackedInteger.UINT8_MAX;
            case Constant.Format.UInt128 -> PackedInteger.UINT16_MAX;
            case Constant.Format.UIntN -> PackedInteger.UINTN_MAX;
            default -> throw new IllegalStateException();
        };
    }

    public IntConstant add(IntConstant that) {
        if (this.getFormat() != that.getFormat()) {
            throw new IllegalStateException("format mismatch: this=" + String.valueOf((Object)this.getFormat()) + ", that=" + String.valueOf((Object)that.getFormat()));
        }
        return this.add(that.getValue());
    }

    public IntConstant add(LiteralConstant that) {
        if (that.getFormat() != Constant.Format.IntLiteral) {
            throw new IllegalStateException();
        }
        PackedInteger piThat = that.getPackedInteger();
        if (piThat.compareTo(this.getMinLimit()) < 0 || piThat.compareTo(this.getMaxLimit()) > 0) {
            throw new ArithmeticException("value to add is out of range");
        }
        return this.add(piThat);
    }

    protected IntConstant add(PackedInteger piThat) {
        PackedInteger piVal = this.getValue().add(piThat);
        if (piVal.compareTo(this.getMinLimit()) < 0 || piVal.compareTo(this.getMaxLimit()) > 0) {
            throw new ArithmeticException("overflow");
        }
        return this.getConstantPool().ensureIntConstant(piVal, this.getFormat());
    }

    public IntConstant validate(PackedInteger n) {
        if (n.compareTo(this.getMinLimit()) < 0 || n.compareTo(this.getMaxLimit()) > 0) {
            n = n.and(switch (this.byteSize()) {
                case 2 -> PackedInteger.UINT2_MAX;
                case 4 -> PackedInteger.UINT4_MAX;
                case 8 -> PackedInteger.UINT8_MAX;
                case 16 -> PackedInteger.UINT16_MAX;
                default -> throw new IllegalStateException("Unexpected byte size: " + this.byteSize());
            });
        }
        return this.getConstantPool().ensureIntConstant(n, this.getFormat());
    }

    @Override
    public Constant.Format getFormat() {
        return this.m_fmt;
    }

    @Override
    public PackedInteger getIntValue() {
        return this.m_pint;
    }

    @Override
    public Constant apply(Token.Id op, Constant that) {
        switch (that == null ? op.TEXT + this.getFormat().name() : this.getFormat().name() + op.TEXT + that.getFormat().name()) {
            case "+Int": 
            case "+UInt": 
            case "+Int16": 
            case "+Int32": 
            case "+Int64": 
            case "+Int128": 
            case "+IntN": 
            case "+UInt16": 
            case "+UInt32": 
            case "+UInt64": 
            case "+UInt128": 
            case "+UIntN": {
                return this;
            }
            case "-Int": 
            case "-UInt": 
            case "-Int16": 
            case "-Int32": 
            case "-Int64": 
            case "-Int128": 
            case "-IntN": 
            case "-UInt16": 
            case "-UInt32": 
            case "-UInt64": 
            case "-UInt128": 
            case "-UIntN": {
                return this.validate(this.getValue().negate());
            }
            case "~Int": 
            case "~Int16": 
            case "~Int32": 
            case "~Int64": 
            case "~Int128": 
            case "~IntN": 
            case "~UInt": 
            case "~UInt16": 
            case "~UInt32": 
            case "~UInt64": 
            case "~UInt128": 
            case "~UIntN": {
                return this.validate(this.getValue().complement());
            }
            case "Int+IntLiteral": 
            case "Int-IntLiteral": 
            case "Int*IntLiteral": 
            case "Int/IntLiteral": 
            case "Int%IntLiteral": 
            case "Int..IntLiteral": 
            case "Int..<IntLiteral": 
            case "Int==IntLiteral": 
            case "Int!=IntLiteral": 
            case "Int<IntLiteral": 
            case "Int<=IntLiteral": 
            case "Int>IntLiteral": 
            case "Int>=IntLiteral": 
            case "Int<=>IntLiteral": 
            case "UInt+IntLiteral": 
            case "UInt-IntLiteral": 
            case "UInt*IntLiteral": 
            case "UInt/IntLiteral": 
            case "UInt%IntLiteral": 
            case "UInt..IntLiteral": 
            case "UInt..<IntLiteral": 
            case "UInt==IntLiteral": 
            case "UInt!=IntLiteral": 
            case "UInt<IntLiteral": 
            case "UInt<=IntLiteral": 
            case "UInt>IntLiteral": 
            case "UInt>=IntLiteral": 
            case "UInt<=>IntLiteral": 
            case "Int16+IntLiteral": 
            case "Int16-IntLiteral": 
            case "Int16*IntLiteral": 
            case "Int16/IntLiteral": 
            case "Int16%IntLiteral": 
            case "Int16&IntLiteral": 
            case "Int16|IntLiteral": 
            case "Int16^IntLiteral": 
            case "Int16..IntLiteral": 
            case "Int16..<IntLiteral": 
            case "Int16==IntLiteral": 
            case "Int16!=IntLiteral": 
            case "Int16<IntLiteral": 
            case "Int16<=IntLiteral": 
            case "Int16>IntLiteral": 
            case "Int16>=IntLiteral": 
            case "Int16<=>IntLiteral": 
            case "Int32+IntLiteral": 
            case "Int32-IntLiteral": 
            case "Int32*IntLiteral": 
            case "Int32/IntLiteral": 
            case "Int32%IntLiteral": 
            case "Int32&IntLiteral": 
            case "Int32|IntLiteral": 
            case "Int32^IntLiteral": 
            case "Int32..IntLiteral": 
            case "Int32..<IntLiteral": 
            case "Int32==IntLiteral": 
            case "Int32!=IntLiteral": 
            case "Int32<IntLiteral": 
            case "Int32<=IntLiteral": 
            case "Int32>IntLiteral": 
            case "Int32>=IntLiteral": 
            case "Int32<=>IntLiteral": 
            case "Int64+IntLiteral": 
            case "Int64-IntLiteral": 
            case "Int64*IntLiteral": 
            case "Int64/IntLiteral": 
            case "Int64%IntLiteral": 
            case "Int64&IntLiteral": 
            case "Int64|IntLiteral": 
            case "Int64^IntLiteral": 
            case "Int64..IntLiteral": 
            case "Int64..<IntLiteral": 
            case "Int64==IntLiteral": 
            case "Int64!=IntLiteral": 
            case "Int64<IntLiteral": 
            case "Int64<=IntLiteral": 
            case "Int64>IntLiteral": 
            case "Int64>=IntLiteral": 
            case "Int64<=>IntLiteral": 
            case "Int128+IntLiteral": 
            case "Int128-IntLiteral": 
            case "Int128*IntLiteral": 
            case "Int128/IntLiteral": 
            case "Int128%IntLiteral": 
            case "Int128&IntLiteral": 
            case "Int128|IntLiteral": 
            case "Int128^IntLiteral": 
            case "Int128..IntLiteral": 
            case "Int128..<IntLiteral": 
            case "Int128==IntLiteral": 
            case "Int128!=IntLiteral": 
            case "Int128<IntLiteral": 
            case "Int128<=IntLiteral": 
            case "Int128>IntLiteral": 
            case "Int128>=IntLiteral": 
            case "Int128<=>IntLiteral": 
            case "IntN+IntLiteral": 
            case "IntN-IntLiteral": 
            case "IntN*IntLiteral": 
            case "IntN/IntLiteral": 
            case "IntN%IntLiteral": 
            case "IntN&IntLiteral": 
            case "IntN|IntLiteral": 
            case "IntN^IntLiteral": 
            case "IntN..IntLiteral": 
            case "IntN..<IntLiteral": 
            case "IntN==IntLiteral": 
            case "IntN!=IntLiteral": 
            case "IntN<IntLiteral": 
            case "IntN<=IntLiteral": 
            case "IntN>IntLiteral": 
            case "IntN>=IntLiteral": 
            case "IntN<=>IntLiteral": 
            case "UInt16+IntLiteral": 
            case "UInt16-IntLiteral": 
            case "UInt16*IntLiteral": 
            case "UInt16/IntLiteral": 
            case "UInt16%IntLiteral": 
            case "UInt16&IntLiteral": 
            case "UInt16|IntLiteral": 
            case "UInt16^IntLiteral": 
            case "UInt16..IntLiteral": 
            case "UInt16..<IntLiteral": 
            case "UInt16==IntLiteral": 
            case "UInt16!=IntLiteral": 
            case "UInt16<IntLiteral": 
            case "UInt16<=IntLiteral": 
            case "UInt16>IntLiteral": 
            case "UInt16>=IntLiteral": 
            case "UInt16<=>IntLiteral": 
            case "UInt32+IntLiteral": 
            case "UInt32-IntLiteral": 
            case "UInt32*IntLiteral": 
            case "UInt32/IntLiteral": 
            case "UInt32%IntLiteral": 
            case "UInt32&IntLiteral": 
            case "UInt32|IntLiteral": 
            case "UInt32^IntLiteral": 
            case "UInt32..IntLiteral": 
            case "UInt32..<IntLiteral": 
            case "UInt32==IntLiteral": 
            case "UInt32!=IntLiteral": 
            case "UInt32<IntLiteral": 
            case "UInt32<=IntLiteral": 
            case "UInt32>IntLiteral": 
            case "UInt32>=IntLiteral": 
            case "UInt32<=>IntLiteral": 
            case "UInt64+IntLiteral": 
            case "UInt64-IntLiteral": 
            case "UInt64*IntLiteral": 
            case "UInt64/IntLiteral": 
            case "UInt64%IntLiteral": 
            case "UInt64&IntLiteral": 
            case "UInt64|IntLiteral": 
            case "UInt64^IntLiteral": 
            case "UInt64..IntLiteral": 
            case "UInt64..<IntLiteral": 
            case "UInt64==IntLiteral": 
            case "UInt64!=IntLiteral": 
            case "UInt64<IntLiteral": 
            case "UInt64<=IntLiteral": 
            case "UInt64>IntLiteral": 
            case "UInt64>=IntLiteral": 
            case "UInt64<=>IntLiteral": 
            case "UInt128+IntLiteral": 
            case "UInt128-IntLiteral": 
            case "UInt128*IntLiteral": 
            case "UInt128/IntLiteral": 
            case "UInt128%IntLiteral": 
            case "UInt128&IntLiteral": 
            case "UInt128|IntLiteral": 
            case "UInt128^IntLiteral": 
            case "UInt128..IntLiteral": 
            case "UInt128..<IntLiteral": 
            case "UInt128==IntLiteral": 
            case "UInt128!=IntLiteral": 
            case "UInt128<IntLiteral": 
            case "UInt128<=IntLiteral": 
            case "UInt128>IntLiteral": 
            case "UInt128>=IntLiteral": 
            case "UInt128<=>IntLiteral": 
            case "UIntN+IntLiteral": 
            case "UIntN-IntLiteral": 
            case "UIntN*IntLiteral": 
            case "UIntN/IntLiteral": 
            case "UIntN%IntLiteral": 
            case "UIntN&IntLiteral": 
            case "UIntN|IntLiteral": 
            case "UIntN^IntLiteral": 
            case "UIntN..IntLiteral": 
            case "UIntN..<IntLiteral": 
            case "UIntN==IntLiteral": 
            case "UIntN!=IntLiteral": 
            case "UIntN<IntLiteral": 
            case "UIntN<=IntLiteral": 
            case "UIntN>IntLiteral": 
            case "UIntN>=IntLiteral": 
            case "UIntN<=>IntLiteral": {
                return this.apply(op, ((LiteralConstant)that).toIntConstant(this.getFormat()));
            }
            case "Int16<<IntLiteral": 
            case "Int16>>IntLiteral": 
            case "Int16>>>IntLiteral": 
            case "Int32<<IntLiteral": 
            case "Int32>>IntLiteral": 
            case "Int32>>>IntLiteral": 
            case "Int64<<IntLiteral": 
            case "Int64>>IntLiteral": 
            case "Int64>>>IntLiteral": 
            case "Int128<<IntLiteral": 
            case "Int128>>IntLiteral": 
            case "Int128>>>IntLiteral": 
            case "IntN<<IntLiteral": 
            case "IntN>>IntLiteral": 
            case "IntN>>>IntLiteral": 
            case "UInt16<<IntLiteral": 
            case "UInt16>>IntLiteral": 
            case "UInt16>>>IntLiteral": 
            case "UInt32<<IntLiteral": 
            case "UInt32>>IntLiteral": 
            case "UInt32>>>IntLiteral": 
            case "UInt64<<IntLiteral": 
            case "UInt64>>IntLiteral": 
            case "UInt64>>>IntLiteral": 
            case "UInt128<<IntLiteral": 
            case "UInt128>>IntLiteral": 
            case "UInt128>>>IntLiteral": 
            case "UIntN<<IntLiteral": 
            case "UIntN>>IntLiteral": 
            case "UIntN>>>IntLiteral": {
                return this.apply(op, ((LiteralConstant)that).toIntConstant(Constant.Format.Int64));
            }
            case "Int+Int": 
            case "UInt+UInt": 
            case "Int16+Int16": 
            case "Int32+Int32": 
            case "Int64+Int64": 
            case "Int128+Int128": 
            case "IntN+IntN": 
            case "UInt16+UInt16": 
            case "UInt32+UInt32": 
            case "UInt64+UInt64": 
            case "UInt128+UInt128": 
            case "UIntN+UIntN": {
                return this.validate(this.getValue().add(((IntConstant)that).getValue()));
            }
            case "Int-Int": 
            case "UInt-UInt": 
            case "Int16-Int16": 
            case "Int32-Int32": 
            case "Int64-Int64": 
            case "Int128-Int128": 
            case "IntN-IntN": 
            case "UInt16-UInt16": 
            case "UInt32-UInt32": 
            case "UInt64-UInt64": 
            case "UInt128-UInt128": 
            case "UIntN-UIntN": {
                return this.validate(this.getValue().sub(((IntConstant)that).getValue()));
            }
            case "Int*Int": 
            case "UInt*UInt": 
            case "Int16*Int16": 
            case "Int32*Int32": 
            case "Int64*Int64": 
            case "Int128*Int128": 
            case "IntN*IntN": 
            case "UInt16*UInt16": 
            case "UInt32*UInt32": 
            case "UInt64*UInt64": 
            case "UInt128*UInt128": 
            case "UIntN*UIntN": {
                return this.validate(this.getValue().mul(((IntConstant)that).getValue()));
            }
            case "Int/Int": 
            case "UInt/UInt": 
            case "Int16/Int16": 
            case "Int32/Int32": 
            case "Int64/Int64": 
            case "Int128/Int128": 
            case "IntN/IntN": 
            case "UInt16/UInt16": 
            case "UInt32/UInt32": 
            case "UInt64/UInt64": 
            case "UInt128/UInt128": 
            case "UIntN/UIntN": {
                return this.validate(this.getValue().div(((IntConstant)that).getValue()));
            }
            case "Int%Int": 
            case "UInt%UInt": 
            case "Int16%Int16": 
            case "Int32%Int32": 
            case "Int64%Int64": 
            case "Int128%Int128": 
            case "IntN%IntN": 
            case "UInt16%UInt16": 
            case "UInt32%UInt32": 
            case "UInt64%UInt64": 
            case "UInt128%UInt128": 
            case "UIntN%UIntN": {
                return this.validate(this.getValue().mod(((IntConstant)that).getValue()));
            }
            case "Int16&Int16": 
            case "Int32&Int32": 
            case "Int64&Int64": 
            case "Int128&Int128": 
            case "IntN&IntN": 
            case "UInt16&UInt16": 
            case "UInt32&UInt32": 
            case "UInt64&UInt64": 
            case "UInt128&UInt128": 
            case "UIntN&UIntN": {
                return this.validate(this.getValue().and(((IntConstant)that).getValue()));
            }
            case "Int16|Int16": 
            case "Int32|Int32": 
            case "Int64|Int64": 
            case "Int128|Int128": 
            case "IntN|IntN": 
            case "UInt16|UInt16": 
            case "UInt32|UInt32": 
            case "UInt64|UInt64": 
            case "UInt128|UInt128": 
            case "UIntN|UIntN": {
                return this.validate(this.getValue().or(((IntConstant)that).getValue()));
            }
            case "Int16^Int16": 
            case "Int32^Int32": 
            case "Int64^Int64": 
            case "Int128^Int128": 
            case "IntN^IntN": 
            case "UInt16^UInt16": 
            case "UInt32^UInt32": 
            case "UInt64^UInt64": 
            case "UInt128^UInt128": 
            case "UIntN^UIntN": {
                return this.validate(this.getValue().xor(((IntConstant)that).getValue()));
            }
            case "Int..Int": 
            case "UInt..UInt": 
            case "Int16..Int16": 
            case "Int32..Int32": 
            case "Int64..Int64": 
            case "Int128..Int128": 
            case "IntN..IntN": 
            case "UInt16..UInt16": 
            case "UInt32..UInt32": 
            case "UInt64..UInt64": 
            case "UInt128..UInt128": 
            case "UIntN..UIntN": {
                return ConstantPool.getCurrentPool().ensureRangeConstant(this, that);
            }
            case "Int..<Int": 
            case "UInt..<UInt": 
            case "Int16..<Int16": 
            case "Int32..<Int32": 
            case "Int64..<Int64": 
            case "Int128..<Int128": 
            case "IntN..<IntN": 
            case "UInt16..<UInt16": 
            case "UInt32..<UInt32": 
            case "UInt64..<UInt64": 
            case "UInt128..<UInt128": 
            case "UIntN..<UIntN": {
                return ConstantPool.getCurrentPool().ensureRangeConstant(this, false, that, true);
            }
            case "Int>..Int": 
            case "UInt>..UInt": 
            case "Int16>..Int16": 
            case "Int32>..Int32": 
            case "Int64>..Int64": 
            case "Int128>..Int128": 
            case "IntN>..IntN": 
            case "UInt16>..UInt16": 
            case "UInt32>..UInt32": 
            case "UInt64>..UInt64": 
            case "UInt128>..UInt128": 
            case "UIntN>..UIntN": {
                return ConstantPool.getCurrentPool().ensureRangeConstant(this, true, that, false);
            }
            case "Int>..<Int": 
            case "UInt>..<UInt": 
            case "Int16>..<Int16": 
            case "Int32>..<Int32": 
            case "Int64>..<Int64": 
            case "Int128>..<Int128": 
            case "IntN>..<IntN": 
            case "UInt16>..<UInt16": 
            case "UInt32>..<UInt32": 
            case "UInt64>..<UInt64": 
            case "UInt128>..<UInt128": 
            case "UIntN>..<UIntN": {
                return ConstantPool.getCurrentPool().ensureRangeConstant(this, true, that, true);
            }
            case "Int<<Int": 
            case "Int16<<Int64": 
            case "Int32<<Int64": 
            case "Int64<<Int64": 
            case "Int128<<Int64": 
            case "IntN<<Int64": 
            case "UInt16<<Int64": 
            case "UInt32<<Int64": 
            case "UInt64<<Int64": 
            case "UInt128<<Int64": 
            case "UIntN<<Int64": 
            case "Int16<<Int": 
            case "Int32<<Int": 
            case "Int64<<Int": 
            case "Int128<<Int": 
            case "IntN<<Int": 
            case "UInt<<Int": 
            case "UInt16<<Int": 
            case "UInt32<<Int": 
            case "UInt64<<Int": 
            case "UInt128<<Int": 
            case "UIntN<<Int": {
                return this.validate(this.getValue().shl(((IntConstant)that).getValue()));
            }
            case "Int>>Int": 
            case "Int16>>Int64": 
            case "Int32>>Int64": 
            case "Int64>>Int64": 
            case "Int128>>Int64": 
            case "IntN>>Int64": 
            case "UInt16>>Int64": 
            case "UInt32>>Int64": 
            case "UInt64>>Int64": 
            case "UInt128>>Int64": 
            case "UIntN>>Int64": 
            case "Int16>>Int": 
            case "Int32>>Int": 
            case "Int64>>Int": 
            case "Int128>>Int": 
            case "IntN>>Int": 
            case "UInt>>Int": 
            case "UInt16>>Int": 
            case "UInt32>>Int": 
            case "UInt64>>Int": 
            case "UInt128>>Int": 
            case "UIntN>>Int": {
                return this.validate(this.getValue().shr(((IntConstant)that).getValue()));
            }
            case "Int16>>>Int64": 
            case "Int32>>>Int64": 
            case "Int64>>>Int64": 
            case "Int128>>>Int64": 
            case "IntN>>>Int64": 
            case "UInt16>>>Int64": 
            case "UInt32>>>Int64": 
            case "UInt64>>>Int64": 
            case "UInt128>>>Int64": 
            case "UIntN>>>Int64": 
            case "Int16>>>Int": 
            case "Int32>>>Int": 
            case "Int64>>>Int": 
            case "Int128>>>Int": 
            case "IntN>>>Int": 
            case "UInt16>>>Int": 
            case "UInt32>>>Int": 
            case "UInt64>>>Int": 
            case "UInt128>>>Int": 
            case "UIntN>>>Int": {
                return this.validate(this.getValue().ushr(((IntConstant)that).getValue()));
            }
            case "Int==Int": 
            case "UInt==UInt": 
            case "Int16==Int16": 
            case "Int32==Int32": 
            case "Int64==Int64": 
            case "Int128==Int128": 
            case "IntN==IntN": 
            case "UInt16==UInt16": 
            case "UInt32==UInt32": 
            case "UInt64==UInt64": 
            case "UInt128==UInt128": 
            case "UIntN==UIntN": 
            case "Int!=Int": 
            case "UInt!=UInt": 
            case "Int16!=Int16": 
            case "Int32!=Int32": 
            case "Int64!=Int64": 
            case "Int128!=Int128": 
            case "IntN!=IntN": 
            case "UInt16!=UInt16": 
            case "UInt32!=UInt32": 
            case "UInt64!=UInt64": 
            case "UInt128!=UInt128": 
            case "UIntN!=UIntN": 
            case "Int<Int": 
            case "UInt<UInt": 
            case "Int16<Int16": 
            case "Int32<Int32": 
            case "Int64<Int64": 
            case "Int128<Int128": 
            case "IntN<IntN": 
            case "UInt16<UInt16": 
            case "UInt32<UInt32": 
            case "UInt64<UInt64": 
            case "UInt128<UInt128": 
            case "UIntN<UIntN": 
            case "Int<=Int": 
            case "UInt<=UInt": 
            case "Int16<=Int16": 
            case "Int32<=Int32": 
            case "Int64<=Int64": 
            case "Int128<=Int128": 
            case "IntN<=IntN": 
            case "UInt16<=UInt16": 
            case "UInt32<=UInt32": 
            case "UInt64<=UInt64": 
            case "UInt128<=UInt128": 
            case "UIntN<=UIntN": 
            case "Int>Int": 
            case "UInt>UInt": 
            case "Int16>Int16": 
            case "Int32>Int32": 
            case "Int64>Int64": 
            case "Int128>Int128": 
            case "IntN>IntN": 
            case "UInt16>UInt16": 
            case "UInt32>UInt32": 
            case "UInt64>UInt64": 
            case "UInt128>UInt128": 
            case "UIntN>UIntN": 
            case "Int>=Int": 
            case "UInt>=UInt": 
            case "Int16>=Int16": 
            case "Int32>=Int32": 
            case "Int64>=Int64": 
            case "Int128>=Int128": 
            case "IntN>=IntN": 
            case "UInt16>=UInt16": 
            case "UInt32>=UInt32": 
            case "UInt64>=UInt64": 
            case "UInt128>=UInt128": 
            case "UIntN>=UIntN": 
            case "Int<=>Int": 
            case "UInt<=>UInt": 
            case "Int16<=>Int16": 
            case "Int32<=>Int32": 
            case "Int64<=>Int64": 
            case "Int128<=>Int128": 
            case "IntN<=>IntN": 
            case "UInt16<=>UInt16": 
            case "UInt32<=>UInt32": 
            case "UInt64<=>UInt64": 
            case "UInt128<=>UInt128": 
            case "UIntN<=>UIntN": {
                return this.translateOrder(this.getValue().cmp(((IntConstant)that).getValue()), op);
            }
        }
        return super.apply(op, that);
    }

    @Override
    public Constant convertTo(TypeConstant typeOut) {
        Constant constant = super.convertTo(typeOut);
        if (constant != null) {
            return constant;
        }
        ConstantPool pool = this.getConstantPool();
        if (typeOut.equals(pool.typeInt8())) {
            return this.toByteConstant(Constant.Format.Int8);
        }
        if (typeOut.equals(pool.typeInt16())) {
            return this.toIntConstant(Constant.Format.Int16);
        }
        if (typeOut.equals(pool.typeInt32())) {
            return this.toIntConstant(Constant.Format.Int32);
        }
        if (typeOut.equals(pool.typeInt64())) {
            return this.toIntConstant(Constant.Format.Int64);
        }
        if (typeOut.equals(pool.typeInt128())) {
            return this.toIntConstant(Constant.Format.Int128);
        }
        if (typeOut.equals(pool.typeIntN())) {
            return this.toIntConstant(Constant.Format.IntN);
        }
        if (typeOut.equals(pool.typeBit())) {
            return this.toByteConstant(Constant.Format.Bit);
        }
        if (typeOut.equals(pool.typeNibble())) {
            return this.toByteConstant(Constant.Format.Nibble);
        }
        if (typeOut.equals(pool.typeUInt8())) {
            return this.toByteConstant(Constant.Format.UInt8);
        }
        if (typeOut.equals(pool.typeUInt16())) {
            return this.toIntConstant(Constant.Format.UInt16);
        }
        if (typeOut.equals(pool.typeUInt32())) {
            return this.toIntConstant(Constant.Format.UInt32);
        }
        if (typeOut.equals(pool.typeUInt64())) {
            return this.toIntConstant(Constant.Format.UInt64);
        }
        if (typeOut.equals(pool.typeUInt128())) {
            return this.toIntConstant(Constant.Format.UInt128);
        }
        if (typeOut.equals(pool.typeUIntN())) {
            return this.toIntConstant(Constant.Format.UIntN);
        }
        if (typeOut.equals(pool.typeDec64())) {
            return this.toDecConstant(Constant.Format.Dec64);
        }
        if (typeOut.equals(pool.typeFloat32())) {
            return this.toFloatConstant(Constant.Format.Float32);
        }
        if (typeOut.equals(pool.typeFloat64())) {
            return this.toFloat64Constant();
        }
        return null;
    }

    public ByteConstant toByteConstant(Constant.Format format) {
        PackedInteger pi = this.getValue();
        if (pi.compareTo(PackedInteger.valueOf(ByteConstant.getMinLimit(format))) < 0 || pi.compareTo(PackedInteger.valueOf(ByteConstant.getMaxLimit(format))) > 0) {
            throw new ArithmeticException("out of range: " + String.valueOf(pi));
        }
        return this.getConstantPool().ensureByteConstant(format, pi.getInt());
    }

    public IntConstant toIntConstant(Constant.Format format) {
        return IntConstant.toIntConstant(format, this.getValue(), this.getConstantPool());
    }

    public DecimalConstant toDecConstant(Constant.Format format) {
        return IntConstant.toDecConstant(format, this.getValue(), this.getConstantPool());
    }

    public FloatConstant toFloatConstant(Constant.Format format) {
        return IntConstant.toFloatConstant(format, this.getValue(), this.getConstantPool());
    }

    public Float64Constant toFloat64Constant() {
        PackedInteger pi = this.getValue();
        return new Float64Constant(this.getConstantPool(), pi.isBig() ? pi.getBigInteger().doubleValue() : (double)pi.getLong());
    }

    public static IntConstant toIntConstant(Constant.Format format, PackedInteger pi, ConstantPool pool) {
        if (pi.compareTo(IntConstant.getMinLimit(format)) < 0 || pi.compareTo(IntConstant.getMaxLimit(format)) > 0) {
            throw new ArithmeticException("out of range: " + String.valueOf(pi));
        }
        return pool.ensureIntConstant(pi, format);
    }

    public static DecimalConstant toDecConstant(Constant.Format format, PackedInteger pi, ConstantPool pool) {
        return switch (format) {
            case Constant.Format.Dec64 -> pool.ensureDecConstant(new Decimal64(new BigDecimal(pi.getBigInteger(), MathContext.DECIMAL64)));
            default -> null;
        };
    }

    public static FloatConstant toFloatConstant(Constant.Format format, PackedInteger pi, ConstantPool pool) {
        return switch (format) {
            case Constant.Format.Float32 -> new Float32Constant(pool, pi.isBig() ? pi.getBigInteger().floatValue() : (float)pi.getLong());
            default -> null;
        };
    }

    @Override
    public Object getLocator() {
        return this.m_pint;
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof IntConstant)) {
            return -1;
        }
        return this.m_pint.compareTo(((IntConstant)that).m_pint);
    }

    @Override
    public String getValueString() {
        return this.m_pint.toString();
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        this.m_pint.writeObject(out);
    }

    @Override
    public String getDescription() {
        return "value=" + this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_pint);
    }
}

