/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.ChildInfo;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.ParamInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.RelationalTypeConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.UnionTypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class IntersectionTypeConstant
extends RelationalTypeConstant {
    public IntersectionTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    public IntersectionTypeConstant(ConstantPool pool, TypeConstant constType1, TypeConstant constType2) {
        super(pool, constType1, constType2);
    }

    @Override
    protected TypeConstant cloneRelational(ConstantPool pool, TypeConstant type1, TypeConstant type2) {
        return pool.ensureIntersectionTypeConstant(type1, type2);
    }

    @Override
    protected TypeConstant simplifyInternal(TypeConstant type1, TypeConstant type2) {
        if (type1.isA(type2)) {
            return type1;
        }
        if (type2.isA(type1)) {
            return type2;
        }
        return null;
    }

    public TypeConstant extractParent(String sChild) {
        TypeConstant typeParent = this.extractParentImpl(this.m_constType1, sChild);
        return typeParent == null ? this.extractParentImpl(this.m_constType2, sChild) : typeParent;
    }

    private TypeConstant extractParentImpl(TypeConstant type1, String sChild) {
        if (type1.isSingleUnderlyingClass(true)) {
            ClassStructure clz = (ClassStructure)type1.getSingleUnderlyingClass(true).getComponent();
            if (clz.findChildDeep(sChild) != null) {
                return type1;
            }
        } else if (type1 instanceof IntersectionTypeConstant) {
            IntersectionTypeConstant typeInter = (IntersectionTypeConstant)type1;
            return typeInter.extractParent(sChild);
        }
        return null;
    }

    @Override
    public boolean isImmutabilitySpecified() {
        return this.m_constType1.isImmutabilitySpecified() || this.m_constType2.isImmutabilitySpecified();
    }

    @Override
    public boolean isImmutable() {
        return this.m_constType1.isImmutable() || this.m_constType2.isImmutable();
    }

    @Override
    public boolean isService() {
        return this.m_constType1.isService() || this.m_constType2.isService();
    }

    @Override
    public TypeConstant ensureService() {
        TypeConstant type1 = this.m_constType1;
        TypeConstant type2 = this.m_constType2;
        return type1.isService() && type2.isService() ? this : this.cloneRelational(this.getConstantPool(), type1.ensureService(), type2.ensureService());
    }

    @Override
    public boolean isAccessSpecified() {
        return this.m_constType1.isAccessSpecified() || this.m_constType2.isAccessSpecified();
    }

    @Override
    public Constants.Access getAccess() {
        return this.m_constType1.getAccess().minOf(this.m_constType2.getAccess());
    }

    @Override
    public boolean isAccessModifiable() {
        return this.m_constType1.isAccessModifiable() && this.m_constType2.isAccessModifiable();
    }

    @Override
    public TypeConstant ensureAccess(Constants.Access access) {
        TypeConstant type1 = this.m_constType1;
        TypeConstant type2 = this.m_constType2;
        TypeConstant type1A = type1.ensureAccess(access);
        TypeConstant type2A = type2.ensureAccess(access);
        return type1.equals(type1A) && type2.equals(type2A) ? this : this.cloneRelational(this.getConstantPool(), type1A, type2A);
    }

    @Override
    public boolean isNullable() {
        TypeConstant type1 = this.m_constType1;
        TypeConstant type2 = this.m_constType2;
        return type1.isNullable() && type2.isNullable() || type1.isFormalType() && type2.isNullable() || type1.isNullable() && type2.isFormalType();
    }

    @Override
    public TypeConstant removeNullable() {
        return this.isNullable() ? this.m_constType1.removeNullable().combine(this.getConstantPool(), this.m_constType2.removeNullable()) : this;
    }

    @Override
    public boolean isIncompatibleCombo(TypeConstant that) {
        TypeConstant type1 = this.m_constType1.resolveTypedefs();
        TypeConstant type2 = this.m_constType2.resolveTypedefs();
        return type1.isIncompatibleCombo(that) || type2.isIncompatibleCombo(that);
    }

    @Override
    public TypeConstant andNot(ConstantPool pool, TypeConstant that) {
        TypeConstant type1 = this.m_constType1.resolveTypedefs();
        TypeConstant type2 = this.m_constType2.resolveTypedefs();
        if (type1.equals(that)) {
            return type2;
        }
        if (type2.equals(that)) {
            return type1;
        }
        if (type1.isA(that) && !type2.isA(that)) {
            return type2;
        }
        if (type2.isA(that) && !type1.isA(that)) {
            return type1;
        }
        if (type1.isRelationalType() || type2.isRelationalType()) {
            TypeConstant type1R = type1.andNot(pool, that);
            TypeConstant type2R = type2.andNot(pool, that);
            if (type1R == null) {
                return type2R;
            }
            if (type2R == null) {
                return type1R;
            }
            if (type1R != type1 || type2R != type2) {
                return type1R.combine(pool, type2R);
            }
        }
        return super.andNot(pool, that);
    }

    @Override
    public TypeConstant.Category getCategory() {
        TypeConstant.Category cat1 = this.m_constType1.getCategory();
        TypeConstant.Category cat2 = this.m_constType2.getCategory();
        return switch (cat1) {
            case TypeConstant.Category.CLASS -> {
                switch (cat2) {
                    case CLASS: 
                    case IFACE: {
                        yield TypeConstant.Category.CLASS;
                    }
                }
                yield TypeConstant.Category.OTHER;
            }
            case TypeConstant.Category.IFACE -> {
                switch (cat2) {
                    case CLASS: {
                        yield TypeConstant.Category.CLASS;
                    }
                    case IFACE: {
                        yield TypeConstant.Category.IFACE;
                    }
                }
                yield TypeConstant.Category.OTHER;
            }
            default -> TypeConstant.Category.OTHER;
        };
    }

    @Override
    public boolean isSingleUnderlyingClass(boolean fAllowInterface) {
        return this.m_constType1.isSingleUnderlyingClass(fAllowInterface) ^ this.m_constType2.isSingleUnderlyingClass(fAllowInterface);
    }

    @Override
    public IdentityConstant getSingleUnderlyingClass(boolean fAllowInterface) {
        assert (this.isSingleUnderlyingClass(fAllowInterface));
        return this.m_constType1.isSingleUnderlyingClass(fAllowInterface) ? this.m_constType1.getSingleUnderlyingClass(fAllowInterface) : this.m_constType2.getSingleUnderlyingClass(fAllowInterface);
    }

    @Override
    public boolean isConst() {
        return this.m_constType1.isConst() || this.m_constType2.isConst();
    }

    @Override
    public boolean containsGenericParam(String sName) {
        return this.m_constType1.containsGenericParam(sName) || this.m_constType2.containsGenericParam(sName);
    }

    @Override
    protected TypeConstant getGenericParamType(String sName, List<TypeConstant> listParams) {
        TypeConstant typeActual1 = this.m_constType1.getGenericParamType(sName, listParams);
        TypeConstant typeActual2 = this.m_constType2.getGenericParamType(sName, listParams);
        if (typeActual1 == null) {
            return typeActual2;
        }
        if (typeActual2 == null) {
            return typeActual1;
        }
        return typeActual1.combine(this.getConstantPool(), typeActual2);
    }

    @Override
    public ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, MethodConstant idMethod, ComponentResolver.ResolutionCollector collector) {
        ComponentResolver.ResolutionResult result1 = this.m_constType1.resolveContributedName(sName, access, idMethod, collector);
        if (result1 == ComponentResolver.ResolutionResult.RESOLVED) {
            return result1;
        }
        ComponentResolver.ResolutionResult result2 = this.m_constType2.resolveContributedName(sName, access, idMethod, collector);
        if (result2 == ComponentResolver.ResolutionResult.RESOLVED) {
            return result2;
        }
        return result1.combine(result2);
    }

    @Override
    public TypeConstant resolveTypeParameter(TypeConstant typeActual, String sFormalName) {
        typeActual = typeActual.resolveTypedefs();
        if (this.getFormat() == typeActual.getFormat()) {
            return super.resolveTypeParameter(typeActual, sFormalName);
        }
        TypeConstant typeResult1 = this.getUnderlyingType().resolveTypeParameter(typeActual, sFormalName);
        TypeConstant typeResult2 = this.getUnderlyingType2().resolveTypeParameter(typeActual, sFormalName);
        return typeResult1 == null ? typeResult2 : (typeResult2 == null ? typeResult1 : (typeResult1.isA(typeResult2) ? typeResult1 : (typeResult2.isA(typeResult1) ? typeResult2 : null)));
    }

    @Override
    public boolean isNestMateOf(IdentityConstant idClass) {
        TypeConstant type2C;
        TypeConstant type1 = this.m_constType1;
        TypeConstant type2 = this.m_constType2;
        if (type1.isFormalType()) {
            TypeConstant type1C = ((FormalConstant)type1.getDefiningConstant()).getConstraintType();
            if (type2.isA(type1C)) {
                return type2.isNestMateOf(idClass);
            }
        } else if (type2.isFormalType() && type1.isA(type2C = ((FormalConstant)type2.getDefiningConstant()).getConstraintType())) {
            return type1.isNestMateOf(idClass);
        }
        return type1.isNestMateOf(idClass) && type2.isNestMateOf(idClass);
    }

    @Override
    protected Map<Object, ParamInfo> mergeTypeParams(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        Object nid;
        if (info1 == null) {
            return info2.getTypeParams();
        }
        if (info2 == null) {
            return info1.getTypeParams();
        }
        Map<Object, ParamInfo> map1 = info1.getTypeParams();
        Map<Object, ParamInfo> map2 = info2.getTypeParams();
        HashMap<Object, ParamInfo> map = new HashMap<Object, ParamInfo>(map1);
        for (Map.Entry entry : map.entrySet()) {
            nid = entry.getKey();
            ParamInfo param2 = map2.get(nid);
            if (param2 == null) continue;
            ParamInfo param1 = (ParamInfo)entry.getValue();
            TypeConstant type1 = param1.getActualType();
            TypeConstant type2 = param2.getActualType();
            if (type2.isA(type1)) continue;
            if (type1.isA(type2)) {
                entry.setValue(param2);
                continue;
            }
            this.log(errs, Severity.ERROR, "VERIFY-33", info1.getType().getValueString(), nid, type1.getValueString(), info2.getType().getValueString(), type2.getValueString());
        }
        for (Map.Entry<Object, Object> entry : map2.entrySet()) {
            nid = entry.getKey();
            ParamInfo param1 = map1.get(nid);
            if (param1 != null) continue;
            map.put(nid, (ParamInfo)entry.getValue());
        }
        return map;
    }

    @Override
    protected Annotation[] mergeAnnotations(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        return null;
    }

    @Override
    protected Map<PropertyConstant, PropertyInfo> mergeProperties(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        String sName;
        if (info1 == null) {
            return info2.getProperties();
        }
        if (info2 == null) {
            return info1.getProperties();
        }
        HashMap<PropertyConstant, PropertyInfo> map = new HashMap<PropertyConstant, PropertyInfo>();
        for (Map.Entry<String, PropertyInfo> entry : info1.ensurePropertiesByName().entrySet()) {
            sName = entry.getKey();
            PropertyInfo prop1 = entry.getValue();
            assert (prop1 != null);
            PropertyInfo prop2 = info2.findProperty(sName);
            if (prop2 == null) {
                map.put(prop1.getIdentity(), prop1);
                continue;
            }
            if (prop2.containsBody(prop1.getIdentity())) {
                map.put(prop2.getIdentity(), prop2);
                continue;
            }
            map.put(prop1.getIdentity(), prop1);
        }
        for (Map.Entry<String, PropertyInfo> entry : info2.ensurePropertiesByName().entrySet()) {
            sName = entry.getKey();
            PropertyInfo prop2 = entry.getValue();
            assert (prop2 != null);
            PropertyInfo prop1 = info1.findProperty(sName);
            if (prop1 != null) continue;
            map.put(prop2.getIdentity(), prop2);
        }
        return map;
    }

    @Override
    protected Map<MethodConstant, MethodInfo> mergeMethods(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        SignatureConstant sig;
        if (info1 == null) {
            return info2.getMethods();
        }
        if (info2 == null) {
            return info1.getMethods();
        }
        HashMap<MethodConstant, MethodInfo> map = new HashMap<MethodConstant, MethodInfo>();
        for (Map.Entry<SignatureConstant, MethodInfo> entry : info1.ensureMethodsBySignature().entrySet()) {
            sig = entry.getKey();
            MethodInfo method1 = entry.getValue();
            if (method1.isConstructor() && !method1.containsVirtualConstructor()) continue;
            MethodInfo method2 = info2.getMethodBySignature(sig);
            if (method2 == null) {
                map.put(method1.getIdentity(), method1);
                continue;
            }
            if (method2.containsBody(method1.getIdentity())) {
                map.put(method2.getIdentity(), method2);
                continue;
            }
            map.put(method1.getIdentity(), method1);
        }
        for (Map.Entry<SignatureConstant, MethodInfo> entry : info2.ensureMethodsBySignature().entrySet()) {
            MethodInfo method1;
            sig = entry.getKey();
            MethodInfo method2 = entry.getValue();
            if (method2.isConstructor() && !method2.containsVirtualConstructor() || (method1 = info1.getMethodBySignature(sig)) != null && (!method1.isConstructor() || method1.containsVirtualConstructor())) continue;
            map.put(method2.getIdentity(), method2);
        }
        return map;
    }

    @Override
    protected ListMap<String, ChildInfo> mergeChildren(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        String sChild;
        ListMap<String, ChildInfo> map2;
        ListMap<String, ChildInfo> map1 = info1 == null ? ListMap.EMPTY : info1.getChildInfosByName();
        ListMap<String, ChildInfo> listMap = map2 = info1 == null ? ListMap.EMPTY : info2.getChildInfosByName();
        if (map1.isEmpty()) {
            return map2;
        }
        if (map2.isEmpty()) {
            return map1;
        }
        ListMap<String, ChildInfo> mapMerge = new ListMap<String, ChildInfo>();
        for (Map.Entry<String, ChildInfo> entry : map1.entrySet()) {
            sChild = entry.getKey();
            ChildInfo child1 = entry.getValue();
            if (map2.containsKey(sChild)) {
                ChildInfo child2 = map2.get(sChild);
                ChildInfo childM = child1.layerOn(child2);
                if (childM == null) {
                    this.log(errs, Severity.ERROR, "VERIFY-85", this.getValueString(), sChild, child2.getIdentity().getValueString(), child1.getIdentity().getValueString());
                    continue;
                }
                mapMerge.put(sChild, childM);
                continue;
            }
            mapMerge.put(sChild, child1);
        }
        for (Map.Entry<String, ChildInfo> entry : map2.entrySet()) {
            sChild = entry.getKey();
            if (map1.containsKey(sChild)) continue;
            mapMerge.put(sChild, entry.getValue());
        }
        return mapMerge;
    }

    @Override
    protected TypeConstant.Relation calculateRelationToLeft(TypeConstant typeLeft) {
        TypeConstant.Relation rel;
        if ((typeLeft.isRelationalType() || typeLeft.isAnnotated()) && (rel = super.calculateRelationToLeft(typeLeft)) != TypeConstant.Relation.INCOMPATIBLE) {
            return rel;
        }
        TypeConstant thisRight1 = this.getUnderlyingType();
        TypeConstant thisRight2 = this.getUnderlyingType2();
        if (thisRight1.isImmutable()) {
            thisRight2 = thisRight2.freeze();
        }
        if (thisRight2.isImmutable()) {
            thisRight1 = thisRight1.freeze();
        }
        TypeConstant.Relation rel1 = thisRight1.calculateRelation(typeLeft);
        TypeConstant.Relation rel2 = thisRight2.calculateRelation(typeLeft);
        return rel1.bestOf(rel2);
    }

    @Override
    protected TypeConstant.Relation calculateRelationToRight(TypeConstant typeRight) {
        TypeConstant thisLeft1 = this.getUnderlyingType();
        TypeConstant thisLeft2 = this.getUnderlyingType2();
        TypeConstant.Relation rel1 = typeRight.calculateRelation(thisLeft1);
        TypeConstant.Relation rel2 = typeRight.calculateRelation(thisLeft2);
        if (this.isEnumOrNullable(typeRight)) {
            if (this.isEnumOrNullable(thisLeft1) && thisLeft2.isFormalType()) {
                return rel1.worseOf(typeRight.calculateRelation(thisLeft2.resolveConstraints()));
            }
            if (thisLeft1.isFormalType() && this.isEnumOrNullable(thisLeft2)) {
                return rel2.worseOf(typeRight.calculateRelation(thisLeft1.resolveConstraints()));
            }
        }
        return rel1.worseOf(rel2);
    }

    private boolean isEnumOrNullable(TypeConstant type) {
        return type.isEnumValue() || type.isOnlyNullable();
    }

    @Override
    protected TypeConstant.Relation findUnionContribution(UnionTypeConstant typeLeft) {
        TypeConstant thisRight1 = this.getUnderlyingType();
        TypeConstant thisRight2 = this.getUnderlyingType2();
        TypeConstant.Relation rel1 = thisRight1.findUnionContribution(typeLeft);
        TypeConstant.Relation rel2 = thisRight2.findUnionContribution(typeLeft);
        return rel1.bestOf(rel2);
    }

    @Override
    protected Set<SignatureConstant> isInterfaceAssignableFrom(TypeConstant typeRight, Constants.Access accessLeft, List<TypeConstant> listLeft) {
        assert (this.isInterfaceType());
        Set<SignatureConstant> setMiss1 = this.getUnderlyingType().isInterfaceAssignableFrom(typeRight, accessLeft, listLeft);
        Set<SignatureConstant> setMiss2 = this.getUnderlyingType2().isInterfaceAssignableFrom(typeRight, accessLeft, listLeft);
        setMiss1.addAll(setMiss2);
        return setMiss1;
    }

    @Override
    public boolean containsSubstitutableMethod(SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams) {
        return this.getUnderlyingType().containsSubstitutableMethod(signature, access, fFunction, listParams) || this.getUnderlyingType2().containsSubstitutableMethod(signature, access, fFunction, listParams);
    }

    @Override
    public int callEquals(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return Utils.callEqualsSequence(frame, this.m_constType1, this.m_constType2, hValue1, hValue2, iReturn);
    }

    @Override
    public int callCompare(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return Utils.callCompareSequence(frame, this.m_constType1, this.m_constType2, hValue1, hValue2, iReturn);
    }

    @Override
    public int callHashCode(Frame frame, ObjectHandle hValue, int iReturn) {
        return this.m_constType1.callHashCode(frame, hValue, iReturn);
    }

    @Override
    public MethodInfo findFunctionInfo(SignatureConstant sig) {
        MethodInfo info1 = this.m_constType1.findFunctionInfo(sig);
        MethodInfo info2 = this.m_constType2.findFunctionInfo(sig);
        return info1 == null ? info2 : (info2 == null ? info1 : (info1.containsBody(info2.getIdentity()) ? info1 : (info2.containsBody(info1.getIdentity()) ? info2 : null)));
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.IntersectionType;
    }

    @Override
    public String getValueString() {
        return this.m_constType1.getValueString() + " + " + this.m_constType2.getValueString();
    }
}

