/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Hash;

public class KeywordConstant
extends PseudoConstant {
    private final Constant.Format f_format;

    public KeywordConstant(ConstantPool pool, Constant.Format format) {
        super(pool);
        if (!this.isValid(format)) {
            throw new IllegalStateException("illegal format: " + String.valueOf((Object)format));
        }
        this.f_format = format;
    }

    public KeywordConstant(ConstantPool pool, Constant.Format format, DataInput in) {
        this(pool, format);
    }

    private boolean isValid(Constant.Format format) {
        boolean bl;
        block4: {
            block3: {
                if (format == null) break block3;
                switch (format) {
                    case IsConst: 
                    case IsEnum: 
                    case IsModule: 
                    case IsPackage: 
                    case IsClass: {
                        break;
                    }
                    default: {
                        break block3;
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public TypeConstant getBaseType() {
        ConstantPool pool = this.getConstantPool();
        return switch (this.f_format) {
            case Constant.Format.IsConst -> pool.typeConst();
            case Constant.Format.IsEnum -> pool.typeEnumValue();
            case Constant.Format.IsModule -> pool.typeModule();
            case Constant.Format.IsPackage -> pool.typePackage();
            case Constant.Format.IsClass -> pool.typeObject();
            default -> throw new IllegalStateException();
        };
    }

    @Override
    public boolean isCongruentWith(PseudoConstant that) {
        return that instanceof KeywordConstant && this.getFormat() == that.getFormat();
    }

    @Override
    public Constant.Format getFormat() {
        return this.f_format;
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().ensureTerminalTypeConstant(this);
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    protected Object getLocator() {
        return this.f_format;
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof KeywordConstant)) {
            return -1;
        }
        return this.f_format.compareTo(((KeywordConstant)that).f_format);
    }

    @Override
    public String getValueString() {
        return this.getDescription();
    }

    @Override
    public String getDescription() {
        return switch (this.f_format) {
            case Constant.Format.IsConst -> "const";
            case Constant.Format.IsEnum -> "enum";
            case Constant.Format.IsModule -> "module";
            case Constant.Format.IsPackage -> "package";
            case Constant.Format.IsClass -> "class";
            default -> throw new IllegalStateException("format=" + String.valueOf((Object)this.f_format));
        };
    }

    @Override
    public int computeHashCode() {
        return Hash.of((Object)this.f_format);
    }
}

