/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.BFloat16Constant;
import org.xvm.asm.constants.ByteConstant;
import org.xvm.asm.constants.FPNConstant;
import org.xvm.asm.constants.Float128Constant;
import org.xvm.asm.constants.Float16Constant;
import org.xvm.asm.constants.Float32Constant;
import org.xvm.asm.constants.Float64Constant;
import org.xvm.asm.constants.Float8e4Constant;
import org.xvm.asm.constants.Float8e5Constant;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.asm.constants.VersionConstant;
import org.xvm.compiler.Token;
import org.xvm.type.Decimal;
import org.xvm.type.Decimal128;
import org.xvm.type.Decimal32;
import org.xvm.type.Decimal64;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.PackedInteger;

public class LiteralConstant
extends ValueConstant {
    private final Constant.Format m_fmt;
    private transient int m_iStr;
    private StringConstant m_constStr;
    private transient Object m_oVal;

    public LiteralConstant(ConstantPool pool, Constant.Format format, String sVal, Object oVal) {
        this(pool, format);
        if (sVal == null) {
            throw new IllegalStateException("literal value required");
        }
        switch (format) {
            case IntLiteral: {
                break;
            }
            case FPLiteral: {
                break;
            }
            case Date: {
                break;
            }
            case TimeOfDay: {
                break;
            }
            case Time: {
                break;
            }
            case Duration: {
                break;
            }
            case Version: {
                if (this instanceof VersionConstant) break;
                throw new IllegalStateException("version requires VersionConstant subclass");
            }
            case Path: {
                break;
            }
            default: {
                throw new IllegalStateException("unsupported format: " + String.valueOf((Object)format));
            }
        }
        this.m_constStr = pool.ensureStringConstant(sVal);
        this.m_oVal = oVal;
    }

    private LiteralConstant(ConstantPool pool, Constant.Format format) {
        super(pool);
        if (format == null) {
            throw new IllegalStateException("format required");
        }
        switch (format) {
            case IntLiteral: 
            case FPLiteral: 
            case Date: 
            case TimeOfDay: 
            case Time: 
            case Duration: 
            case Version: 
            case Path: {
                break;
            }
            default: {
                throw new IllegalStateException("unsupported format: " + String.valueOf((Object)format));
            }
        }
        this.m_fmt = format;
    }

    public LiteralConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        this(pool, format);
        this.m_iStr = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_constStr = (StringConstant)this.getConstantPool().getConstant(this.m_iStr);
    }

    @Override
    public TypeConstant getType() {
        ConstantPool pool = this.getConstantPool();
        return switch (this.m_fmt) {
            case Constant.Format.IntLiteral -> pool.typeIntLiteral();
            case Constant.Format.FPLiteral -> pool.typeFPLiteral();
            case Constant.Format.Date -> pool.typeDate();
            case Constant.Format.TimeOfDay -> pool.typeTimeOfDay();
            case Constant.Format.Time -> pool.typeTime();
            case Constant.Format.Duration -> pool.typeDuration();
            case Constant.Format.Version -> pool.typeVersion();
            case Constant.Format.Path -> pool.typePath();
            default -> super.getType();
        };
    }

    @Override
    public String getValue() {
        return this.m_constStr.getValue();
    }

    public StringConstant getStringConstant() {
        return this.m_constStr;
    }

    public int getRadix() {
        int of;
        assert (this.getFormat() == Constant.Format.IntLiteral || this.getFormat() == Constant.Format.FPLiteral);
        String s = this.getValue();
        int n = of = s.startsWith("-") ? 1 : 0;
        if (s.length() > of + 2 && s.charAt(of) == '0') {
            switch (s.charAt(of + 1)) {
                case 'B': 
                case 'b': {
                    assert (this.getFormat() == Constant.Format.IntLiteral);
                    return 2;
                }
                case 'o': {
                    assert (this.getFormat() == Constant.Format.IntLiteral);
                    return 8;
                }
                case 'X': 
                case 'x': {
                    return 16;
                }
            }
        }
        return 10;
    }

    private int pickFPRadixForNumericOperation(LiteralConstant const1, LiteralConstant const2) {
        assert (const1.getFormat() == Constant.Format.FPLiteral || const2.getFormat() == Constant.Format.FPLiteral);
        return const1.getRadix() == 16 && const2.getRadix() == 16 ? 16 : 10;
    }

    public PackedInteger getPackedInteger() {
        PackedInteger pint;
        assert (this.getFormat() == Constant.Format.IntLiteral);
        PackedInteger packedInteger = pint = this.m_oVal instanceof PackedInteger ? (PackedInteger)this.m_oVal : null;
        if (pint == null) {
            block30: {
                BigInteger bigint;
                long lValue;
                int radix;
                boolean fNeg;
                int cch;
                int of;
                char ch;
                String s;
                block29: {
                    s = this.getValue();
                    ch = s.charAt(0);
                    of = 1;
                    cch = s.length();
                    fNeg = false;
                    if (ch == '+' || ch == '-') {
                        fNeg = ch == '-';
                        ch = s.charAt(of++);
                    }
                    radix = 10;
                    if (ch == '0' && of < cch) {
                        switch (s.charAt(of++)) {
                            case 'B': 
                            case 'b': {
                                radix = 2;
                                break;
                            }
                            case 'o': {
                                radix = 8;
                                break;
                            }
                            case 'X': 
                            case 'x': {
                                radix = 16;
                                break;
                            }
                            default: {
                                --of;
                            }
                        }
                    }
                    lValue = 0L;
                    bigint = null;
                    while (true) {
                        switch (ch) {
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': 
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                if (radix < 16) break block29;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                if (bigint == null) {
                                    if ((lValue = lValue * (long)radix + (long)Handy.hexitValue(ch)) <= 0xFFFFFFFFFFFFFFL) break;
                                    bigint = BigInteger.valueOf(lValue);
                                    break;
                                }
                                bigint = bigint.multiply(BigInteger.valueOf(radix)).add(BigInteger.valueOf(Handy.hexitValue(ch)));
                                break;
                            }
                            case '_': {
                                break;
                            }
                            default: {
                                break block29;
                            }
                        }
                        if (of >= cch) break;
                        ch = s.charAt(of++);
                    }
                    ch = '\u0000';
                }
                PackedInteger packedInteger2 = bigint == null ? new PackedInteger(fNeg ? -lValue : lValue) : (pint = new PackedInteger(fNeg ? bigint.negate() : bigint));
                if (radix == 10) {
                    int iMul;
                    switch (ch) {
                        case 'K': 
                        case 'k': {
                            iMul = 0;
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            iMul = 1;
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            iMul = 2;
                            break;
                        }
                        case 'T': 
                        case 't': {
                            iMul = 3;
                            break;
                        }
                        case 'P': 
                        case 'p': {
                            iMul = 4;
                            break;
                        }
                        case 'E': 
                        case 'e': {
                            iMul = 5;
                            break;
                        }
                        case 'Z': 
                        case 'z': {
                            iMul = 6;
                            break;
                        }
                        case 'Y': 
                        case 'y': {
                            iMul = 7;
                            break;
                        }
                        default: {
                            break block30;
                        }
                    }
                    PackedInteger[] factors = PackedInteger.xB_FACTORS;
                    if (of < cch && (s.charAt(of) == 'I' || s.charAt(of) == 'i')) {
                        factors = PackedInteger.xI_FACTORS;
                    }
                    pint = pint.mul(factors[iMul]);
                }
            }
            this.m_oVal = pint;
        }
        return pint;
    }

    public BigDecimal getBigDecimal() {
        BigDecimal dec;
        assert (this.getFormat() == Constant.Format.IntLiteral || this.getFormat() == Constant.Format.FPLiteral);
        BigDecimal bigDecimal = dec = this.m_oVal instanceof BigDecimal ? (BigDecimal)this.m_oVal : null;
        if (dec == null) {
            if (this.getFormat() == Constant.Format.IntLiteral) {
                dec = new BigDecimal(this.getPackedInteger().getBigInteger());
            } else {
                String sLit = this.m_constStr.getValue();
                dec = this.getRadix() == 16 ? BigDecimal.valueOf(Double.valueOf(sLit)) : new BigDecimal(sLit);
            }
            this.m_oVal = dec;
        }
        return dec;
    }

    public Decimal getDecimal(Constant.Format format) {
        BigDecimal bigdec = this.getBigDecimal();
        return switch (format) {
            case Constant.Format.Dec32 -> new Decimal32(bigdec);
            case Constant.Format.Dec64 -> new Decimal64(bigdec);
            case Constant.Format.Dec128 -> new Decimal128(bigdec);
            default -> throw new IllegalStateException();
        };
    }

    public float getFloat() {
        if (this.m_oVal instanceof Float) {
            return ((Float)this.m_oVal).floatValue();
        }
        float fl = this.getFormat() == Constant.Format.IntLiteral ? this.getPackedInteger().getBigInteger().floatValue() : Float.parseFloat(this.m_constStr.getValue());
        this.m_oVal = Float.valueOf(fl);
        return fl;
    }

    public double getDouble() {
        if (this.m_oVal instanceof Double) {
            return (Double)this.m_oVal;
        }
        double dfl = this.getFormat() == Constant.Format.IntLiteral ? this.getPackedInteger().getBigInteger().doubleValue() : Double.parseDouble(this.m_constStr.getValue());
        this.m_oVal = dfl;
        return dfl;
    }

    public ByteConstant toBitConstant() {
        if (this.getFormat() != Constant.Format.IntLiteral) {
            throw new IllegalStateException("format=" + String.valueOf((Object)this.getFormat()));
        }
        PackedInteger pi = this.getPackedInteger();
        if (pi.isBig() || pi.getLong() < 0L || pi.getLong() > 1L) {
            throw new ArithmeticException("out of range: " + String.valueOf(pi));
        }
        return this.getConstantPool().ensureBitConstant(pi.getInt());
    }

    public ByteConstant toNibbleConstant() {
        if (this.getFormat() != Constant.Format.IntLiteral) {
            throw new IllegalStateException("format=" + String.valueOf((Object)this.getFormat()));
        }
        PackedInteger pi = this.getPackedInteger();
        if (pi.isBig() || pi.getLong() < 0L || pi.getLong() > 15L) {
            throw new ArithmeticException("out of range: " + String.valueOf(pi));
        }
        return this.getConstantPool().ensureNibbleConstant(pi.getInt());
    }

    public ByteConstant toByteConstant(Constant.Format format) {
        if (this.getFormat() != Constant.Format.IntLiteral) {
            throw new IllegalStateException("format=" + String.valueOf((Object)this.getFormat()));
        }
        PackedInteger pi = this.getPackedInteger();
        switch (format) {
            case Int8: {
                if (!pi.isBig() && pi.getLong() >= -128L && pi.getLong() <= 127L) break;
                throw new ArithmeticException("out of range: " + String.valueOf(pi));
            }
            case UInt8: {
                if (!pi.isBig() && pi.getLong() >= 0L && pi.getLong() <= 255L) break;
                throw new ArithmeticException("out of range: " + String.valueOf(pi));
            }
            default: {
                throw new IllegalArgumentException("unsupported format: " + String.valueOf((Object)format));
            }
        }
        return this.getConstantPool().ensureByteConstant(format, pi.getInt());
    }

    public IntConstant toIntConstant(Constant.Format format) {
        if (this.getFormat() != Constant.Format.IntLiteral) {
            throw new IllegalStateException("format=" + String.valueOf((Object)this.getFormat()));
        }
        PackedInteger pi = this.getPackedInteger();
        if (pi.compareTo(IntConstant.getMinLimit(format)) < 0 || pi.compareTo(IntConstant.getMaxLimit(format)) > 0) {
            throw new ArithmeticException("out of range: " + String.valueOf(pi));
        }
        return this.getConstantPool().ensureIntConstant(pi, format);
    }

    public Float8e4Constant toFloat8e4Constant() {
        assert (this.m_fmt == Constant.Format.IntLiteral || this.m_fmt == Constant.Format.FPLiteral);
        return this.getConstantPool().ensureFloat8e4Constant(this.getFloat());
    }

    public Float8e5Constant toFloat8e5Constant() {
        assert (this.m_fmt == Constant.Format.IntLiteral || this.m_fmt == Constant.Format.FPLiteral);
        return this.getConstantPool().ensureFloat8e5Constant(this.getFloat());
    }

    public BFloat16Constant toBFloat16Constant() {
        assert (this.m_fmt == Constant.Format.IntLiteral || this.m_fmt == Constant.Format.FPLiteral);
        return this.getConstantPool().ensureBFloat16Constant(this.getFloat());
    }

    public Float16Constant toFloat16Constant() {
        assert (this.m_fmt == Constant.Format.IntLiteral || this.m_fmt == Constant.Format.FPLiteral);
        return this.getConstantPool().ensureFloat16Constant(this.getFloat());
    }

    public Float32Constant toFloat32Constant() {
        assert (this.m_fmt == Constant.Format.IntLiteral || this.m_fmt == Constant.Format.FPLiteral);
        return this.getConstantPool().ensureFloat32Constant(this.getFloat());
    }

    public Float64Constant toFloat64Constant() {
        assert (this.m_fmt == Constant.Format.IntLiteral || this.m_fmt == Constant.Format.FPLiteral);
        return this.getConstantPool().ensureFloat64Constant(this.getDouble());
    }

    public Float128Constant toFloat128Constant() {
        long l;
        PackedInteger pi;
        assert (this.m_fmt == Constant.Format.IntLiteral || this.m_fmt == Constant.Format.FPLiteral);
        byte[] ab = null;
        if (this.m_fmt == Constant.Format.IntLiteral && !(pi = this.getPackedInteger()).isBig() && (l = pi.getLong()) == 0L) {
            ab = new byte[16];
            if (this.getValue().startsWith("-")) {
                ab[0] = -128;
            }
        }
        if (ab != null) {
            return this.getConstantPool().ensureFloat128Constant(ab);
        }
        throw new UnsupportedOperationException();
    }

    public FPNConstant toFloatNConstant() {
        long l;
        PackedInteger pi;
        assert (this.m_fmt == Constant.Format.IntLiteral || this.m_fmt == Constant.Format.FPLiteral);
        byte[] ab = null;
        if (this.m_fmt == Constant.Format.IntLiteral && !(pi = this.getPackedInteger()).isBig() && (l = pi.getLong()) == 0L) {
            ab = new byte[2];
            if (this.getValue().startsWith("-")) {
                ab[0] = -128;
            }
        }
        if (ab != null) {
            return this.getConstantPool().ensureFloatNConstant(ab);
        }
        throw new UnsupportedOperationException();
    }

    public Constant toDecimalConstant(Constant.Format format) {
        assert (this.m_fmt == Constant.Format.IntLiteral || this.m_fmt == Constant.Format.FPLiteral);
        return this.getConstantPool().ensureDecConstant(this.getDecimal(format));
    }

    public FPNConstant toDecNConstant() {
        long l;
        PackedInteger pi;
        assert (this.m_fmt == Constant.Format.IntLiteral || this.m_fmt == Constant.Format.FPLiteral);
        byte[] ab = null;
        if (this.m_fmt == Constant.Format.IntLiteral && !(pi = this.getPackedInteger()).isBig() && (l = pi.getLong()) == 0L) {
            ab = new byte[4];
            if (this.getValue().startsWith("-")) {
                ab[0] = -128;
            }
        }
        if (ab != null) {
            return this.getConstantPool().ensureDecNConstant(ab);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Constant.Format getFormat() {
        return this.m_fmt;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_constStr.containsUnresolved();
    }

    @Override
    public Constant apply(Token.Id op, Constant that) {
        ConstantPool pool = this.getConstantPool();
        switch (that == null ? op.TEXT + this.getFormat().name() : this.getFormat().name() + op.TEXT + that.getFormat().name()) {
            case "-IntLiteral": {
                PackedInteger piThis = this.getPackedInteger();
                return pool.ensureLiteralConstant(Constant.Format.IntLiteral, piThis.negate().toString());
            }
            case "IntLiteral+IntLiteral": 
            case "IntLiteral-IntLiteral": 
            case "IntLiteral*IntLiteral": 
            case "IntLiteral/IntLiteral": 
            case "IntLiteral%IntLiteral": 
            case "IntLiteral&IntLiteral": 
            case "IntLiteral|IntLiteral": 
            case "IntLiteral^IntLiteral": 
            case "IntLiteral<<IntLiteral": 
            case "IntLiteral>>IntLiteral": 
            case "IntLiteral>>>IntLiteral": {
                PackedInteger piThis = this.getPackedInteger();
                PackedInteger piThat = ((LiteralConstant)that).getPackedInteger();
                return pool.ensureLiteralConstant(Constant.Format.IntLiteral, (switch (op) {
                    case Token.Id.ADD -> piThis.add(piThat);
                    case Token.Id.SUB -> piThis.sub(piThat);
                    case Token.Id.MUL -> piThis.mul(piThat);
                    case Token.Id.DIV -> piThis.div(piThat);
                    case Token.Id.MOD -> piThis.mod(piThat);
                    case Token.Id.BIT_AND -> piThis.and(piThat);
                    case Token.Id.BIT_OR -> piThis.or(piThat);
                    case Token.Id.BIT_XOR -> piThis.xor(piThat);
                    case Token.Id.SHL -> piThis.shl(piThat);
                    case Token.Id.SHR -> piThis.shr(piThat);
                    case Token.Id.USHR -> piThis.ushr(piThat);
                    default -> throw new IllegalStateException();
                }).toString(this.getRadix()));
            }
            case "IntLiteral==IntLiteral": 
            case "IntLiteral!=IntLiteral": 
            case "IntLiteral<IntLiteral": 
            case "IntLiteral<=IntLiteral": 
            case "IntLiteral>IntLiteral": 
            case "IntLiteral>=IntLiteral": 
            case "IntLiteral<=>IntLiteral": {
                return this.translateOrder(this.getPackedInteger().cmp(((LiteralConstant)that).getPackedInteger()), op);
            }
            case "FPLiteral+IntLiteral": 
            case "IntLiteral+FPLiteral": 
            case "FPLiteral+FPLiteral": {
                LiteralConstant litThat = (LiteralConstant)that;
                String sLit = this.pickFPRadixForNumericOperation(this, litThat) == 16 ? Double.toHexString(this.getDouble() + litThat.getDouble()) : this.getBigDecimal().add(litThat.getBigDecimal()).toString();
                return pool.ensureLiteralConstant(Constant.Format.FPLiteral, sLit);
            }
            case "FPLiteral-IntLiteral": 
            case "FPLiteral-FPLiteral": 
            case "IntLiteral-FPLiteral": {
                LiteralConstant litThat = (LiteralConstant)that;
                String sLit = this.pickFPRadixForNumericOperation(this, litThat) == 16 ? Double.toHexString(this.getDouble() - litThat.getDouble()) : this.getBigDecimal().subtract(litThat.getBigDecimal()).toString();
                return pool.ensureLiteralConstant(Constant.Format.FPLiteral, sLit);
            }
            case "FPLiteral*IntLiteral": 
            case "FPLiteral*FPLiteral": 
            case "IntLiteral*FPLiteral": {
                LiteralConstant litThat = (LiteralConstant)that;
                String sLit = this.pickFPRadixForNumericOperation(this, litThat) == 16 ? Double.toHexString(this.getDouble() * litThat.getDouble()) : this.getBigDecimal().multiply(litThat.getBigDecimal()).toString();
                return pool.ensureLiteralConstant(Constant.Format.FPLiteral, sLit);
            }
            case "FPLiteral/IntLiteral": 
            case "FPLiteral/FPLiteral": 
            case "IntLiteral/FPLiteral": {
                LiteralConstant litThat = (LiteralConstant)that;
                String sLit = this.pickFPRadixForNumericOperation(this, litThat) == 16 ? Double.toHexString(this.getDouble() / litThat.getDouble()) : this.getBigDecimal().divide(litThat.getBigDecimal()).toString();
                return pool.ensureLiteralConstant(Constant.Format.FPLiteral, sLit);
            }
            case "FPLiteral==FPLiteral": 
            case "FPLiteral!=FPLiteral": 
            case "FPLiteral<FPLiteral": 
            case "FPLiteral<=FPLiteral": 
            case "FPLiteral>FPLiteral": 
            case "FPLiteral>=FPLiteral": 
            case "FPLiteral<=>FPLiteral": {
                int nOrd;
                LiteralConstant litThat = (LiteralConstant)that;
                if (this.pickFPRadixForNumericOperation(this, litThat) == 16) {
                    double dflThis = this.getDouble();
                    double dflThat = litThat.getDouble();
                    nOrd = Double.isNaN(dflThis) ? (Double.isNaN(dflThat) ? 0 : -1) : (Double.isNaN(dflThat) ? 1 : Double.compare(dflThis, dflThat));
                } else {
                    nOrd = this.getBigDecimal().compareTo(litThat.getBigDecimal());
                }
                return this.translateOrder(nOrd, op);
            }
            case "IntLiteral+Int": 
            case "IntLiteral-Int": 
            case "IntLiteral*Int": 
            case "IntLiteral/Int": 
            case "IntLiteral%Int": 
            case "IntLiteral&Int": 
            case "IntLiteral|Int": 
            case "IntLiteral^Int": 
            case "IntLiteral<<Int": 
            case "IntLiteral>>Int": 
            case "IntLiteral>>>Int": 
            case "IntLiteral+UInt": 
            case "IntLiteral-UInt": 
            case "IntLiteral*UInt": 
            case "IntLiteral/UInt": 
            case "IntLiteral%UInt": 
            case "IntLiteral&UInt": 
            case "IntLiteral|UInt": 
            case "IntLiteral^UInt": {
                PackedInteger piThis = this.getPackedInteger();
                PackedInteger piThat = ((IntConstant)that).getValue();
                return pool.ensureLiteralConstant(Constant.Format.IntLiteral, (switch (op) {
                    case Token.Id.ADD -> piThis.add(piThat);
                    case Token.Id.SUB -> piThis.sub(piThat);
                    case Token.Id.MUL -> piThis.mul(piThat);
                    case Token.Id.DIV -> piThis.div(piThat);
                    case Token.Id.MOD -> piThis.mod(piThat);
                    case Token.Id.BIT_AND -> piThis.and(piThat);
                    case Token.Id.BIT_OR -> piThis.or(piThat);
                    case Token.Id.BIT_XOR -> piThis.xor(piThat);
                    case Token.Id.SHL -> piThis.shl(piThat);
                    case Token.Id.SHR -> piThis.shr(piThat);
                    case Token.Id.USHR -> piThis.ushr(piThat);
                    default -> throw new UnsupportedOperationException(op.TEXT);
                }).toString(this.getRadix()));
            }
            case "IntLiteral==Int": 
            case "IntLiteral!=Int": 
            case "IntLiteral<Int": 
            case "IntLiteral<=Int": 
            case "IntLiteral>Int": 
            case "IntLiteral>=Int": 
            case "IntLiteral<=>Int": 
            case "IntLiteral==UInt": 
            case "IntLiteral!=UInt": 
            case "IntLiteral<UInt": 
            case "IntLiteral<=UInt": 
            case "IntLiteral>UInt": 
            case "IntLiteral>=UInt": 
            case "IntLiteral<=>UInt": {
                return this.toIntConstant(that.getFormat()).apply(op, that);
            }
            case "IntLiteral+Int8": 
            case "IntLiteral-Int8": 
            case "IntLiteral*Int8": 
            case "IntLiteral/Int8": 
            case "IntLiteral%Int8": 
            case "IntLiteral&Int8": 
            case "IntLiteral|Int8": 
            case "IntLiteral^Int8": 
            case "IntLiteral==Int8": 
            case "IntLiteral!=Int8": 
            case "IntLiteral<Int8": 
            case "IntLiteral<=Int8": 
            case "IntLiteral>Int8": 
            case "IntLiteral>=Int8": 
            case "IntLiteral<=>Int8": 
            case "IntLiteral+UInt8": 
            case "IntLiteral-UInt8": 
            case "IntLiteral*UInt8": 
            case "IntLiteral/UInt8": 
            case "IntLiteral%UInt8": 
            case "IntLiteral&UInt8": 
            case "IntLiteral|UInt8": 
            case "IntLiteral^UInt8": 
            case "IntLiteral==UInt8": 
            case "IntLiteral!=UInt8": 
            case "IntLiteral<UInt8": 
            case "IntLiteral<=UInt8": 
            case "IntLiteral>UInt8": 
            case "IntLiteral>=UInt8": 
            case "IntLiteral<=>UInt8": {
                return this.toByteConstant(that.getFormat()).apply(op, that);
            }
            case "IntLiteral+Int16": 
            case "IntLiteral-Int16": 
            case "IntLiteral*Int16": 
            case "IntLiteral/Int16": 
            case "IntLiteral%Int16": 
            case "IntLiteral&Int16": 
            case "IntLiteral|Int16": 
            case "IntLiteral^Int16": 
            case "IntLiteral==Int16": 
            case "IntLiteral!=Int16": 
            case "IntLiteral<Int16": 
            case "IntLiteral<=Int16": 
            case "IntLiteral>Int16": 
            case "IntLiteral>=Int16": 
            case "IntLiteral<=>Int16": 
            case "IntLiteral+Int32": 
            case "IntLiteral-Int32": 
            case "IntLiteral*Int32": 
            case "IntLiteral/Int32": 
            case "IntLiteral%Int32": 
            case "IntLiteral&Int32": 
            case "IntLiteral|Int32": 
            case "IntLiteral^Int32": 
            case "IntLiteral==Int32": 
            case "IntLiteral!=Int32": 
            case "IntLiteral<Int32": 
            case "IntLiteral<=Int32": 
            case "IntLiteral>Int32": 
            case "IntLiteral>=Int32": 
            case "IntLiteral<=>Int32": 
            case "IntLiteral+Int64": 
            case "IntLiteral-Int64": 
            case "IntLiteral*Int64": 
            case "IntLiteral/Int64": 
            case "IntLiteral%Int64": 
            case "IntLiteral&Int64": 
            case "IntLiteral|Int64": 
            case "IntLiteral^Int64": 
            case "IntLiteral==Int64": 
            case "IntLiteral!=Int64": 
            case "IntLiteral<Int64": 
            case "IntLiteral<=Int64": 
            case "IntLiteral>Int64": 
            case "IntLiteral>=Int64": 
            case "IntLiteral<=>Int64": 
            case "IntLiteral+Int128": 
            case "IntLiteral-Int128": 
            case "IntLiteral*Int128": 
            case "IntLiteral/Int128": 
            case "IntLiteral%Int128": 
            case "IntLiteral&Int128": 
            case "IntLiteral|Int128": 
            case "IntLiteral^Int128": 
            case "IntLiteral==Int128": 
            case "IntLiteral!=Int128": 
            case "IntLiteral<Int128": 
            case "IntLiteral<=Int128": 
            case "IntLiteral>Int128": 
            case "IntLiteral>=Int128": 
            case "IntLiteral<=>Int128": 
            case "IntLiteral+IntN": 
            case "IntLiteral-IntN": 
            case "IntLiteral*IntN": 
            case "IntLiteral/IntN": 
            case "IntLiteral%IntN": 
            case "IntLiteral&IntN": 
            case "IntLiteral|IntN": 
            case "IntLiteral^IntN": 
            case "IntLiteral==IntN": 
            case "IntLiteral!=IntN": 
            case "IntLiteral<IntN": 
            case "IntLiteral<=IntN": 
            case "IntLiteral>IntN": 
            case "IntLiteral>=IntN": 
            case "IntLiteral<=>IntN": 
            case "IntLiteral+UInt16": 
            case "IntLiteral-UInt16": 
            case "IntLiteral*UInt16": 
            case "IntLiteral/UInt16": 
            case "IntLiteral%UInt16": 
            case "IntLiteral&UInt16": 
            case "IntLiteral|UInt16": 
            case "IntLiteral^UInt16": 
            case "IntLiteral==UInt16": 
            case "IntLiteral!=UInt16": 
            case "IntLiteral<UInt16": 
            case "IntLiteral<=UInt16": 
            case "IntLiteral>UInt16": 
            case "IntLiteral>=UInt16": 
            case "IntLiteral<=>UInt16": 
            case "IntLiteral+UInt32": 
            case "IntLiteral-UInt32": 
            case "IntLiteral*UInt32": 
            case "IntLiteral/UInt32": 
            case "IntLiteral%UInt32": 
            case "IntLiteral&UInt32": 
            case "IntLiteral|UInt32": 
            case "IntLiteral^UInt32": 
            case "IntLiteral==UInt32": 
            case "IntLiteral!=UInt32": 
            case "IntLiteral<UInt32": 
            case "IntLiteral<=UInt32": 
            case "IntLiteral>UInt32": 
            case "IntLiteral>=UInt32": 
            case "IntLiteral<=>UInt32": 
            case "IntLiteral+UInt64": 
            case "IntLiteral-UInt64": 
            case "IntLiteral*UInt64": 
            case "IntLiteral/UInt64": 
            case "IntLiteral%UInt64": 
            case "IntLiteral&UInt64": 
            case "IntLiteral|UInt64": 
            case "IntLiteral^UInt64": 
            case "IntLiteral==UInt64": 
            case "IntLiteral!=UInt64": 
            case "IntLiteral<UInt64": 
            case "IntLiteral<=UInt64": 
            case "IntLiteral>UInt64": 
            case "IntLiteral>=UInt64": 
            case "IntLiteral<=>UInt64": 
            case "IntLiteral+UInt128": 
            case "IntLiteral-UInt128": 
            case "IntLiteral*UInt128": 
            case "IntLiteral/UInt128": 
            case "IntLiteral%UInt128": 
            case "IntLiteral&UInt128": 
            case "IntLiteral|UInt128": 
            case "IntLiteral^UInt128": 
            case "IntLiteral==UInt128": 
            case "IntLiteral!=UInt128": 
            case "IntLiteral<UInt128": 
            case "IntLiteral<=UInt128": 
            case "IntLiteral>UInt128": 
            case "IntLiteral>=UInt128": 
            case "IntLiteral<=>UInt128": 
            case "IntLiteral+UIntN": 
            case "IntLiteral-UIntN": 
            case "IntLiteral*UIntN": 
            case "IntLiteral/UIntN": 
            case "IntLiteral%UIntN": 
            case "IntLiteral&UIntN": 
            case "IntLiteral|UIntN": 
            case "IntLiteral^UIntN": 
            case "IntLiteral==UIntN": 
            case "IntLiteral!=UIntN": 
            case "IntLiteral<UIntN": 
            case "IntLiteral<=UIntN": 
            case "IntLiteral>UIntN": 
            case "IntLiteral>=UIntN": 
            case "IntLiteral<=>UIntN": {
                return this.toIntConstant(that.getFormat()).apply(op, that);
            }
            case "IntLiteral+Dec": 
            case "IntLiteral-Dec": 
            case "IntLiteral*Dec": 
            case "IntLiteral/Dec": 
            case "IntLiteral==Dec": 
            case "IntLiteral!=Dec": 
            case "IntLiteral<Dec": 
            case "IntLiteral<=Dec": 
            case "IntLiteral>Dec": 
            case "IntLiteral>=Dec": 
            case "IntLiteral<=>Dec": 
            case "FPLiteral+Dec": 
            case "FPLiteral-Dec": 
            case "FPLiteral*Dec": 
            case "FPLiteral/Dec": 
            case "FPLiteral==Dec": 
            case "FPLiteral!=Dec": 
            case "FPLiteral<Dec": 
            case "FPLiteral<=Dec": 
            case "FPLiteral>Dec": 
            case "FPLiteral>=Dec": 
            case "FPLiteral<=>Dec": 
            case "IntLiteral+Dec32": 
            case "IntLiteral-Dec32": 
            case "IntLiteral*Dec32": 
            case "IntLiteral/Dec32": 
            case "IntLiteral==Dec32": 
            case "IntLiteral!=Dec32": 
            case "IntLiteral<Dec32": 
            case "IntLiteral<=Dec32": 
            case "IntLiteral>Dec32": 
            case "IntLiteral>=Dec32": 
            case "IntLiteral<=>Dec32": 
            case "FPLiteral+Dec32": 
            case "FPLiteral-Dec32": 
            case "FPLiteral*Dec32": 
            case "FPLiteral/Dec32": 
            case "FPLiteral==Dec32": 
            case "FPLiteral!=Dec32": 
            case "FPLiteral<Dec32": 
            case "FPLiteral<=Dec32": 
            case "FPLiteral>Dec32": 
            case "FPLiteral>=Dec32": 
            case "FPLiteral<=>Dec32": 
            case "IntLiteral+Dec64": 
            case "IntLiteral-Dec64": 
            case "IntLiteral*Dec64": 
            case "IntLiteral/Dec64": 
            case "IntLiteral==Dec64": 
            case "IntLiteral!=Dec64": 
            case "IntLiteral<Dec64": 
            case "IntLiteral<=Dec64": 
            case "IntLiteral>Dec64": 
            case "IntLiteral>=Dec64": 
            case "IntLiteral<=>Dec64": 
            case "FPLiteral+Dec64": 
            case "FPLiteral-Dec64": 
            case "FPLiteral*Dec64": 
            case "FPLiteral/Dec64": 
            case "FPLiteral==Dec64": 
            case "FPLiteral!=Dec64": 
            case "FPLiteral<Dec64": 
            case "FPLiteral<=Dec64": 
            case "FPLiteral>Dec64": 
            case "FPLiteral>=Dec64": 
            case "FPLiteral<=>Dec64": 
            case "IntLiteral+Dec128": 
            case "IntLiteral-Dec128": 
            case "IntLiteral*Dec128": 
            case "IntLiteral/Dec128": 
            case "IntLiteral==Dec128": 
            case "IntLiteral!=Dec128": 
            case "IntLiteral<Dec128": 
            case "IntLiteral<=Dec128": 
            case "IntLiteral>Dec128": 
            case "IntLiteral>=Dec128": 
            case "IntLiteral<=>Dec128": 
            case "FPLiteral+Dec128": 
            case "FPLiteral-Dec128": 
            case "FPLiteral*Dec128": 
            case "FPLiteral/Dec128": 
            case "FPLiteral==Dec128": 
            case "FPLiteral!=Dec128": 
            case "FPLiteral<Dec128": 
            case "FPLiteral<=Dec128": 
            case "FPLiteral>Dec128": 
            case "FPLiteral>=Dec128": 
            case "FPLiteral<=>Dec128": {
                return this.toDecimalConstant(that.getFormat()).apply(op, that);
            }
            case "IntLiteral+DecN": 
            case "IntLiteral-DecN": 
            case "IntLiteral*DecN": 
            case "IntLiteral/DecN": 
            case "IntLiteral==DecN": 
            case "IntLiteral!=DecN": 
            case "IntLiteral<DecN": 
            case "IntLiteral<=DecN": 
            case "IntLiteral>DecN": 
            case "IntLiteral>=DecN": 
            case "IntLiteral<=>DecN": 
            case "FPLiteral+DecN": 
            case "FPLiteral-DecN": 
            case "FPLiteral*DecN": 
            case "FPLiteral/DecN": 
            case "FPLiteral==DecN": 
            case "FPLiteral!=DecN": 
            case "FPLiteral<DecN": 
            case "FPLiteral<=DecN": 
            case "FPLiteral>DecN": 
            case "FPLiteral>=DecN": 
            case "FPLiteral<=>DecN": {
                return this.toDecNConstant().apply(op, that);
            }
            case "IntLiteral+Float8e4": 
            case "IntLiteral-Float8e4": 
            case "IntLiteral*Float8e4": 
            case "IntLiteral/Float8e4": 
            case "IntLiteral==Float8e4": 
            case "IntLiteral!=Float8e4": 
            case "IntLiteral<Float8e4": 
            case "IntLiteral<=Float8e4": 
            case "IntLiteral>Float8e4": 
            case "IntLiteral>=Float8e4": 
            case "IntLiteral<=>Float8e4": 
            case "FPLiteral+Float8e4": 
            case "FPLiteral-Float8e4": 
            case "FPLiteral*Float8e4": 
            case "FPLiteral/Float8e4": 
            case "FPLiteral==Float8e4": 
            case "FPLiteral!=Float8e4": 
            case "FPLiteral<Float8e4": 
            case "FPLiteral<=Float8e4": 
            case "FPLiteral>Float8e4": 
            case "FPLiteral>=Float8e4": 
            case "FPLiteral<=>Float8e4": {
                return this.toFloat8e4Constant().apply(op, that);
            }
            case "IntLiteral+Float8e5": 
            case "IntLiteral-Float8e5": 
            case "IntLiteral*Float8e5": 
            case "IntLiteral/Float8e5": 
            case "IntLiteral==Float8e5": 
            case "IntLiteral!=Float8e5": 
            case "IntLiteral<Float8e5": 
            case "IntLiteral<=Float8e5": 
            case "IntLiteral>Float8e5": 
            case "IntLiteral>=Float8e5": 
            case "IntLiteral<=>Float8e5": 
            case "FPLiteral+Float8e5": 
            case "FPLiteral-Float8e5": 
            case "FPLiteral*Float8e5": 
            case "FPLiteral/Float8e5": 
            case "FPLiteral==Float8e5": 
            case "FPLiteral!=Float8e5": 
            case "FPLiteral<Float8e5": 
            case "FPLiteral<=Float8e5": 
            case "FPLiteral>Float8e5": 
            case "FPLiteral>=Float8e5": 
            case "FPLiteral<=>Float8e5": {
                return this.toFloat8e5Constant().apply(op, that);
            }
            case "IntLiteral+BFloat16": 
            case "IntLiteral-BFloat16": 
            case "IntLiteral*BFloat16": 
            case "IntLiteral/BFloat16": 
            case "IntLiteral==BFloat16": 
            case "IntLiteral!=BFloat16": 
            case "IntLiteral<BFloat16": 
            case "IntLiteral<=BFloat16": 
            case "IntLiteral>BFloat16": 
            case "IntLiteral>=BFloat16": 
            case "IntLiteral<=>BFloat16": 
            case "FPLiteral+BFloat16": 
            case "FPLiteral-BFloat16": 
            case "FPLiteral*BFloat16": 
            case "FPLiteral/BFloat16": 
            case "FPLiteral==BFloat16": 
            case "FPLiteral!=BFloat16": 
            case "FPLiteral<BFloat16": 
            case "FPLiteral<=BFloat16": 
            case "FPLiteral>BFloat16": 
            case "FPLiteral>=BFloat16": 
            case "FPLiteral<=>BFloat16": {
                return this.toBFloat16Constant().apply(op, that);
            }
            case "IntLiteral+Float16": 
            case "IntLiteral-Float16": 
            case "IntLiteral*Float16": 
            case "IntLiteral/Float16": 
            case "IntLiteral==Float16": 
            case "IntLiteral!=Float16": 
            case "IntLiteral<Float16": 
            case "IntLiteral<=Float16": 
            case "IntLiteral>Float16": 
            case "IntLiteral>=Float16": 
            case "IntLiteral<=>Float16": 
            case "FPLiteral+Float16": 
            case "FPLiteral-Float16": 
            case "FPLiteral*Float16": 
            case "FPLiteral/Float16": 
            case "FPLiteral==Float16": 
            case "FPLiteral!=Float16": 
            case "FPLiteral<Float16": 
            case "FPLiteral<=Float16": 
            case "FPLiteral>Float16": 
            case "FPLiteral>=Float16": 
            case "FPLiteral<=>Float16": {
                return this.toFloat16Constant().apply(op, that);
            }
            case "IntLiteral+Float32": 
            case "IntLiteral-Float32": 
            case "IntLiteral*Float32": 
            case "IntLiteral/Float32": 
            case "IntLiteral==Float32": 
            case "IntLiteral!=Float32": 
            case "IntLiteral<Float32": 
            case "IntLiteral<=Float32": 
            case "IntLiteral>Float32": 
            case "IntLiteral>=Float32": 
            case "IntLiteral<=>Float32": 
            case "FPLiteral+Float32": 
            case "FPLiteral-Float32": 
            case "FPLiteral*Float32": 
            case "FPLiteral/Float32": 
            case "FPLiteral==Float32": 
            case "FPLiteral!=Float32": 
            case "FPLiteral<Float32": 
            case "FPLiteral<=Float32": 
            case "FPLiteral>Float32": 
            case "FPLiteral>=Float32": 
            case "FPLiteral<=>Float32": {
                return this.toFloat32Constant().apply(op, that);
            }
            case "IntLiteral+Float64": 
            case "IntLiteral-Float64": 
            case "IntLiteral*Float64": 
            case "IntLiteral/Float64": 
            case "IntLiteral==Float64": 
            case "IntLiteral!=Float64": 
            case "IntLiteral<Float64": 
            case "IntLiteral<=Float64": 
            case "IntLiteral>Float64": 
            case "IntLiteral>=Float64": 
            case "IntLiteral<=>Float64": 
            case "FPLiteral+Float64": 
            case "FPLiteral-Float64": 
            case "FPLiteral*Float64": 
            case "FPLiteral/Float64": 
            case "FPLiteral==Float64": 
            case "FPLiteral!=Float64": 
            case "FPLiteral<Float64": 
            case "FPLiteral<=Float64": 
            case "FPLiteral>Float64": 
            case "FPLiteral>=Float64": 
            case "FPLiteral<=>Float64": {
                return this.toFloat64Constant().apply(op, that);
            }
            case "IntLiteral+Float128": 
            case "IntLiteral-Float128": 
            case "IntLiteral*Float128": 
            case "IntLiteral/Float128": 
            case "IntLiteral==Float128": 
            case "IntLiteral!=Float128": 
            case "IntLiteral<Float128": 
            case "IntLiteral<=Float128": 
            case "IntLiteral>Float128": 
            case "IntLiteral>=Float128": 
            case "IntLiteral<=>Float128": 
            case "FPLiteral+Float128": 
            case "FPLiteral-Float128": 
            case "FPLiteral*Float128": 
            case "FPLiteral/Float128": 
            case "FPLiteral==Float128": 
            case "FPLiteral!=Float128": 
            case "FPLiteral<Float128": 
            case "FPLiteral<=Float128": 
            case "FPLiteral>Float128": 
            case "FPLiteral>=Float128": 
            case "FPLiteral<=>Float128": {
                return this.toFloat128Constant().apply(op, that);
            }
            case "IntLiteral+FloatN": 
            case "IntLiteral-FloatN": 
            case "IntLiteral*FloatN": 
            case "IntLiteral/FloatN": 
            case "IntLiteral==FloatN": 
            case "IntLiteral!=FloatN": 
            case "IntLiteral<FloatN": 
            case "IntLiteral<=FloatN": 
            case "IntLiteral>FloatN": 
            case "IntLiteral>=FloatN": 
            case "IntLiteral<=>FloatN": 
            case "FPLiteral+FloatN": 
            case "FPLiteral-FloatN": 
            case "FPLiteral*FloatN": 
            case "FPLiteral/FloatN": 
            case "FPLiteral==FloatN": 
            case "FPLiteral!=FloatN": 
            case "FPLiteral<FloatN": 
            case "FPLiteral<=FloatN": 
            case "FPLiteral>FloatN": 
            case "FPLiteral>=FloatN": 
            case "FPLiteral<=>FloatN": {
                return this.toFloatNConstant().apply(op, that);
            }
        }
        return super.apply(op, that);
    }

    @Override
    public Constant convertTo(TypeConstant typeOut) {
        ConstantPool pool = this.getConstantPool();
        switch (this.getFormat()) {
            case IntLiteral: {
                if (typeOut.equals(pool.typeBit())) {
                    return this.toBitConstant();
                }
                if (typeOut.equals(pool.typeNibble())) {
                    return this.toNibbleConstant();
                }
                if (typeOut.equals(pool.typeInt8())) {
                    return this.toByteConstant(Constant.Format.Int8);
                }
                if (typeOut.equals(pool.typeInt16())) {
                    return this.toIntConstant(Constant.Format.Int16);
                }
                if (typeOut.equals(pool.typeInt32())) {
                    return this.toIntConstant(Constant.Format.Int32);
                }
                if (typeOut.equals(pool.typeInt64())) {
                    return this.toIntConstant(Constant.Format.Int64);
                }
                if (typeOut.equals(pool.typeInt128())) {
                    return this.toIntConstant(Constant.Format.Int128);
                }
                if (typeOut.equals(pool.typeIntN())) {
                    return this.toIntConstant(Constant.Format.IntN);
                }
                if (typeOut.equals(pool.typeUInt8())) {
                    return this.toByteConstant(Constant.Format.UInt8);
                }
                if (typeOut.equals(pool.typeUInt16())) {
                    return this.toIntConstant(Constant.Format.UInt16);
                }
                if (typeOut.equals(pool.typeUInt32())) {
                    return this.toIntConstant(Constant.Format.UInt32);
                }
                if (typeOut.equals(pool.typeUInt64())) {
                    return this.toIntConstant(Constant.Format.UInt64);
                }
                if (typeOut.equals(pool.typeUInt128())) {
                    return this.toIntConstant(Constant.Format.UInt128);
                }
                if (typeOut.equals(pool.typeUIntN())) {
                    return this.toIntConstant(Constant.Format.UIntN);
                }
                if (typeOut.equals(pool.typeFPLiteral())) {
                    return pool.ensureLiteralConstant(Constant.Format.FPLiteral, this.getValue());
                }
                String sSimpleName = typeOut.getEcstasyClassName();
                int ofDot = sSimpleName.lastIndexOf(46);
                if (ofDot > 0) {
                    sSimpleName = sSimpleName.substring(ofDot + 1);
                }
                switch (sSimpleName) {
                    case "Dec": {
                        return this.toDecimalConstant(Constant.Format.Dec64);
                    }
                    case "Dec32": {
                        return this.toDecimalConstant(Constant.Format.Dec32);
                    }
                    case "Dec64": {
                        return this.toDecimalConstant(Constant.Format.Dec64);
                    }
                    case "Dec128": {
                        return this.toDecimalConstant(Constant.Format.Dec128);
                    }
                    case "DecN": {
                        return this.toDecNConstant();
                    }
                    case "Float8e4": {
                        return this.toFloat8e4Constant();
                    }
                    case "Float8e5": {
                        return this.toFloat8e5Constant();
                    }
                    case "BFloat16": {
                        return this.toBFloat16Constant();
                    }
                    case "Float16": {
                        return this.toFloat16Constant();
                    }
                    case "Float32": {
                        return this.toFloat32Constant();
                    }
                    case "Float64": {
                        return this.toFloat64Constant();
                    }
                    case "Float128": {
                        return this.toFloat128Constant();
                    }
                    case "FloatN": {
                        return this.toFloatNConstant();
                    }
                }
                if (pool.typeInt64().isA(typeOut)) {
                    return this.toIntConstant(Constant.Format.Int64);
                }
                if (pool.typeUInt8().isA(typeOut)) {
                    return this.toByteConstant(Constant.Format.UInt8);
                }
                Constant.Format format = Constant.Format.Bit;
                while (format.ordinal() <= Constant.Format.FloatN.ordinal()) {
                    TypeConstant typeSupported = format.getType(pool);
                    if (typeSupported.isA(typeOut)) {
                        return this.convertTo(typeSupported);
                    }
                    format = format.next();
                }
                break;
            }
            case FPLiteral: {
                String sSimpleName = typeOut.getEcstasyClassName();
                int ofDot = sSimpleName.lastIndexOf(46);
                if (ofDot > 0) {
                    sSimpleName = sSimpleName.substring(ofDot + 1);
                }
                switch (sSimpleName) {
                    case "Dec": {
                        return this.toDecimalConstant(Constant.Format.Dec64);
                    }
                    case "Dec32": {
                        return this.toDecimalConstant(Constant.Format.Dec32);
                    }
                    case "Dec64": {
                        return this.toDecimalConstant(Constant.Format.Dec64);
                    }
                    case "Dec128": {
                        return this.toDecimalConstant(Constant.Format.Dec128);
                    }
                    case "DecN": {
                        return this.toDecNConstant();
                    }
                    case "Float8e4": {
                        return this.toFloat8e4Constant();
                    }
                    case "Float8e5": {
                        return this.toFloat8e5Constant();
                    }
                    case "BFloat16": {
                        return this.toBFloat16Constant();
                    }
                    case "Float16": {
                        return this.toFloat16Constant();
                    }
                    case "Float32": {
                        return this.toFloat32Constant();
                    }
                    case "Float64": {
                        return this.toFloat64Constant();
                    }
                    case "Float128": {
                        return this.toFloat128Constant();
                    }
                    case "FloatN": {
                        return this.toFloatNConstant();
                    }
                }
                Object format = Constant.Format.Dec64;
                while (((Enum)format).ordinal() <= Constant.Format.FloatN.ordinal()) {
                    TypeConstant typeSupported = ((Constant.Format)((Object)format)).getType(pool);
                    if (typeSupported.isA(typeOut)) {
                        return this.convertTo(typeSupported);
                    }
                    format = ((Constant.Format)((Object)format)).next();
                }
                break;
            }
        }
        return super.convertTo(typeOut);
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constStr);
    }

    @Override
    public Object getLocator() {
        return this.getValue();
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof LiteralConstant)) {
            return -1;
        }
        return this.getValue().compareTo(((LiteralConstant)that).getValue());
    }

    @Override
    public String getValueString() {
        return "\"" + this.getValue() + "\"";
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constStr = (StringConstant)pool.register(this.m_constStr);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constStr.getPosition());
    }

    @Override
    public String getDescription() {
        return "value=" + this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.getValue());
    }
}

