/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class MapConstant
extends ValueConstant {
    private transient int m_iType;
    private transient int[] m_aiKeys;
    private transient int[] m_aiVals;
    private final Constant.Format m_fmt;
    private TypeConstant m_constType;
    private Constant[] m_aconstKey;
    private Constant[] m_aconstVal;

    public MapConstant(ConstantPool pool, TypeConstant constType, Constant constKey, Constant constVal) {
        this(pool, Constant.Format.MapEntry, constType, new Constant[]{constKey}, new Constant[]{constVal});
    }

    public MapConstant(ConstantPool pool, TypeConstant constType, Map<? extends Constant, ? extends Constant> map) {
        this(pool, Constant.Format.Map, constType, map.keySet().toArray(NO_CONSTS), map.values().toArray(NO_CONSTS));
    }

    public MapConstant(ConstantPool pool, Constant.Format fmt, TypeConstant constType, Constant[] aconstKey, Constant[] aconstVal) {
        super(pool);
        if (fmt != Constant.Format.Map && fmt != Constant.Format.MapEntry) {
            throw new IllegalArgumentException("fmt required to be Map or MapEntry");
        }
        if (constType == null) {
            throw new IllegalArgumentException("type required");
        }
        if (aconstKey == null) {
            throw new IllegalArgumentException("keys required");
        }
        if (aconstVal == null) {
            throw new IllegalArgumentException("values required");
        }
        int cEntries = aconstKey.length;
        if (aconstVal.length != cEntries) {
            throw new IllegalArgumentException("mismatch between number of keys and values");
        }
        for (int i = 0; i < cEntries; ++i) {
            if (aconstKey[i] == null) {
                throw new IllegalArgumentException("keys required (" + i + " missing)");
            }
            if (aconstVal[i] != null) continue;
            throw new IllegalArgumentException("values required (" + i + " missing)");
        }
        this.m_fmt = fmt;
        this.m_constType = constType;
        this.m_aconstKey = aconstKey;
        this.m_aconstVal = aconstVal;
    }

    public MapConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        int iType = Handy.readMagnitude(in);
        int cEntries = Handy.readMagnitude(in);
        int[] aiKeys = new int[cEntries];
        int[] aiVals = new int[cEntries];
        for (int i = 0; i < cEntries; ++i) {
            aiKeys[i] = Handy.readMagnitude(in);
            aiVals[i] = Handy.readMagnitude(in);
        }
        this.m_fmt = format;
        this.m_iType = iType;
        this.m_aiKeys = aiKeys;
        this.m_aiVals = aiVals;
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_constType = (TypeConstant)pool.getConstant(this.m_iType);
        int[] aiConstKey = this.m_aiKeys;
        int[] aiConstVal = this.m_aiVals;
        int cEntries = aiConstKey.length;
        Constant[] aconstKey = new Constant[cEntries];
        Constant[] aconstVal = new Constant[cEntries];
        for (int i = 0; i < cEntries; ++i) {
            aconstKey[i] = pool.getConstant(aiConstKey[i]);
            aconstVal[i] = pool.getConstant(aiConstVal[i]);
        }
        this.m_aconstKey = aconstKey;
        this.m_aconstVal = aconstVal;
    }

    @Override
    public TypeConstant getType() {
        return this.m_constType;
    }

    @Override
    public Map<Constant, Constant> getValue() {
        return new ROMap<Constant, Constant>(this.m_aconstKey, this.m_aconstVal);
    }

    @Override
    public Constant.Format getFormat() {
        return this.m_fmt;
    }

    @Override
    public boolean isValueCacheable() {
        return !this.m_constType.containsFormalType(true);
    }

    @Override
    public boolean containsUnresolved() {
        if (this.isHashCached()) {
            return false;
        }
        if (this.m_constType.containsUnresolved()) {
            return true;
        }
        Constant[] aconstKey = this.m_aconstKey;
        Constant[] aconstVal = this.m_aconstVal;
        int c = aconstKey.length;
        for (int i = 0; i < c; ++i) {
            if (!aconstKey[i].containsUnresolved() && !aconstVal[i].containsUnresolved()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constType);
        Constant[] aconstKey = this.m_aconstKey;
        Constant[] aconstVal = this.m_aconstVal;
        int c = aconstKey.length;
        for (int i = 0; i < c; ++i) {
            visitor.accept(aconstKey[i]);
            visitor.accept(aconstVal[i]);
        }
    }

    @Override
    public MapConstant resolveTypedefs() {
        TypeConstant typeOld = this.m_constType;
        TypeConstant typeNew = typeOld.resolveTypedefs();
        Constant[] aconstOldKey = this.m_aconstKey;
        Constant[] aconstNewKey = null;
        int c = aconstOldKey.length;
        for (int i = 0; i < c; ++i) {
            Constant constOldKey = aconstOldKey[i];
            Constant constNewKey = constOldKey.resolveTypedefs();
            if (constNewKey == constOldKey) continue;
            if (aconstNewKey == null) {
                aconstNewKey = (Constant[])aconstOldKey.clone();
            }
            aconstNewKey[i] = constNewKey;
        }
        Constant[] aconstOldVal = this.m_aconstVal;
        Constant[] aconstNewVal = null;
        int c2 = aconstOldVal.length;
        for (int i = 0; i < c2; ++i) {
            Constant constOldVal = aconstOldVal[i];
            Constant constNewVal = constOldVal.resolveTypedefs();
            if (constNewVal == constOldVal) continue;
            if (aconstNewVal == null) {
                aconstNewVal = (Constant[])aconstOldVal.clone();
            }
            aconstNewVal[i] = constNewVal;
        }
        return typeNew == typeOld && aconstNewKey == null && aconstNewVal == null ? this : (MapConstant)this.getConstantPool().register(new MapConstant(this.getConstantPool(), this.m_fmt, typeNew, aconstNewKey, aconstNewVal));
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof MapConstant)) {
            return -1;
        }
        int nResult = this.m_constType.compareTo(((MapConstant)that).m_constType);
        if (nResult != 0) {
            return nResult;
        }
        Constant[] aconstThisKey = this.m_aconstKey;
        Constant[] aconstThatKey = ((MapConstant)that).m_aconstKey;
        Constant[] aconstThisVal = this.m_aconstVal;
        Constant[] aconstThatVal = ((MapConstant)that).m_aconstVal;
        int cThis = aconstThisKey.length;
        int cThat = aconstThatKey.length;
        int c = Math.min(cThis, cThat);
        for (int i = 0; i < c; ++i) {
            nResult = aconstThisKey[i].compareTo(aconstThatKey[i]);
            if (nResult == 0 || (nResult = aconstThisVal[i].compareTo(aconstThatVal[i])) == 0) continue;
            return nResult;
        }
        return cThis - cThat;
    }

    @Override
    public String getValueString() {
        Constant[] aKeys = this.m_aconstKey;
        Constant[] aVals = this.m_aconstVal;
        int cKeys = aKeys.length;
        StringBuilder sb = new StringBuilder();
        sb.append("Map:{");
        for (int i = 0; i < cKeys; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aKeys[i]).append('=').append(aVals[i]);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constType = (TypeConstant)pool.register(this.m_constType);
        this.m_aconstKey = MapConstant.registerConstants(pool, this.m_aconstKey);
        this.m_aconstVal = MapConstant.registerConstants(pool, this.m_aconstVal);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constType.getPosition());
        Constant[] aconstKey = this.m_aconstKey;
        Constant[] aconstVal = this.m_aconstVal;
        int cEntries = aconstKey.length;
        Handy.writePackedLong(out, cEntries);
        for (int i = 0; i < cEntries; ++i) {
            Handy.writePackedLong(out, aconstKey[i].getPosition());
            Handy.writePackedLong(out, aconstVal[i].getPosition());
        }
    }

    @Override
    public String getDescription() {
        return "map-length=" + this.m_aconstKey.length;
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constType, Hash.of(this.m_aconstKey, Hash.of(this.m_aconstVal)));
    }

    public static class ROMap<K, V>
    extends AbstractMap<K, V> {
        private transient Set<K> setKeys;
        private transient Set<Map.Entry<K, V>> setEntries;
        public K[] ak;
        public V[] av;

        public ROMap(K[] ak, V[] av) {
            assert (ak != null && av != null && ak.length == av.length);
            this.ak = ak;
            this.av = av;
        }

        @Override
        public int size() {
            return this.ak.length;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.find(key) >= 0;
        }

        @Override
        public V get(Object key) {
            int i = this.find(key);
            return i < 0 ? null : (V)this.av[i];
        }

        @Override
        public Set<K> keySet() {
            AbstractSet set = this.setKeys;
            if (set == null) {
                this.setKeys = set = new AbstractSet<K>(){

                    @Override
                    public int size() {
                        return ak.length;
                    }

                    @Override
                    public boolean contains(Object o) {
                        return this.find(o) >= 0;
                    }

                    @Override
                    public Iterator<K> iterator() {
                        return new Iterator<K>(){
                            int iNext = 0;

                            @Override
                            public K next() {
                                if (this.hasNext()) {
                                    return ak[this.iNext++];
                                }
                                throw new NoSuchElementException();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.iNext < ak.length;
                            }
                        };
                    }
                };
            }
            return set;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            AbstractSet set = this.setEntries;
            if (set == null) {
                this.setEntries = set = new AbstractSet<Map.Entry<K, V>>(){

                    @Override
                    public int size() {
                        return ak.length;
                    }

                    @Override
                    public Iterator<Map.Entry<K, V>> iterator() {
                        return new Iterator<Map.Entry<K, V>>(){
                            int iNext = 0;

                            @Override
                            public Map.Entry<K, V> next() {
                                if (this.hasNext()) {
                                    return new ROEntry(ak[this.iNext], av[this.iNext++]);
                                }
                                throw new NoSuchElementException();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.iNext < ak.length;
                            }
                        };
                    }
                };
            }
            return set;
        }

        private int find(Object key) {
            int i;
            K[] ak = this.ak;
            int c = ak.length;
            for (i = 0; i < c; ++i) {
                if (key != ak[i]) continue;
                return i;
            }
            c = ak.length;
            for (i = 0; i < c; ++i) {
                if (!key.equals(ak[i])) continue;
                return i;
            }
            return -1;
        }
    }

    public static class ROEntry<K, V>
    extends AbstractMap.SimpleEntry<K, V> {
        public ROEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

