/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class MatchAnyConstant
extends ValueConstant {
    private transient int m_iType;
    private TypeConstant m_constType;

    public MatchAnyConstant(ConstantPool pool, TypeConstant type) {
        super(pool);
        if (type == null) {
            throw new IllegalArgumentException("type of the match required");
        }
        this.m_constType = type;
    }

    public MatchAnyConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iType = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_constType = (TypeConstant)this.getConstantPool().getConstant(this.m_iType);
    }

    @Override
    public TypeConstant getType() {
        return this.m_constType;
    }

    @Override
    public Object getValue() {
        return "_";
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Any;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_constType.containsUnresolved();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constType);
    }

    @Override
    public MatchAnyConstant resolveTypedefs() {
        TypeConstant constOld = this.m_constType;
        TypeConstant constNew = constOld.resolveTypedefs();
        return constNew == constOld ? this : this.getConstantPool().ensureMatchAnyConstant(constNew);
    }

    @Override
    public Object getLocator() {
        return this.m_constType;
    }

    @Override
    protected int compareDetails(Constant that) {
        return this.m_constType.compareDetails(((MatchAnyConstant)that).m_constType);
    }

    @Override
    public String getValueString() {
        return "<" + this.m_constType.getValueString() + "> _";
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constType = (TypeConstant)pool.register(this.m_constType);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constType.getPosition());
    }

    @Override
    public String getDescription() {
        return "match-any=" + this.getType().getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constType);
    }
}

