/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.FrameDependentConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.xException;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class MethodBindingConstant
extends FrameDependentConstant {
    private int m_iMethod;
    private transient MethodConstant m_idMethod;

    public MethodBindingConstant(ConstantPool pool, MethodConstant idMethod) {
        super(pool);
        this.m_idMethod = idMethod;
    }

    public MethodBindingConstant(ConstantPool pool, DataInput in) throws IOException {
        super(pool);
        this.m_iMethod = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_idMethod = (MethodConstant)this.getConstantPool().getConstant(this.m_iMethod);
    }

    public MethodConstant getMethodConstant() {
        return this.m_idMethod;
    }

    @Override
    public ObjectHandle getHandle(Frame frame) {
        CallChain chain;
        ObjectHandle hTarget;
        ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)frame.getThis();
        MethodConstant idMethod = this.m_idMethod;
        MethodStructure method = (MethodStructure)idMethod.getComponent();
        if (idMethod.isLambda()) {
            hTarget = hThis;
            chain = new CallChain(method);
        } else {
            hTarget = hThis.getField(frame, "$outer");
            if (method != null && method.getAccess() == Constants.Access.PRIVATE) {
                chain = new CallChain(method);
            } else {
                Object nid = idMethod.resolveNestedIdentity(frame.poolContext(), frame.getGenericsResolver(true));
                chain = hTarget.getComposition().getMethodCallChain(nid);
            }
        }
        if (chain.isEmpty()) {
            return new ObjectHandle.DeferredCallHandle(xException.makeHandle(frame, "Missing method \"" + idMethod.getValueString() + "\" on " + hTarget.getType().getValueString()));
        }
        return xRTFunction.makeHandle(frame, chain, 0).bindTarget(frame, hTarget);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.BindTarget;
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().typeMethod();
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_idMethod.containsUnresolved();
    }

    @Override
    protected int compareDetails(Constant constant) {
        int n;
        if (constant instanceof MethodBindingConstant) {
            MethodBindingConstant that = (MethodBindingConstant)constant;
            n = this.getMethodConstant().compareDetails(that.getMethodConstant());
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public String getValueString() {
        return "BindTarget: " + this.m_idMethod.getValueString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_idMethod = (MethodConstant)pool.register(this.m_idMethod);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
        Handy.writePackedLong(out, this.m_idMethod.getPosition());
    }

    @Override
    public String getDescription() {
        return this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_idMethod);
    }
}

