/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayList;
import org.xvm.asm.Annotation;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.Builder;
import org.xvm.javajit.JitCtorDesc;
import org.xvm.javajit.JitFlavor;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.javajit.JitParamDesc;
import org.xvm.javajit.JitTypeDesc;
import org.xvm.javajit.TypeSystem;
import org.xvm.util.Handy;

public class MethodBody {
    public static final MethodBody[] NO_BODIES = new MethodBody[0];
    private final MethodConstant m_id;
    private final SignatureConstant m_sig;
    private final Implementation m_impl;
    private final Object m_target;
    private transient MethodStructure m_structMethod;
    private transient JitMethodDesc m_jmd;

    public MethodBody(MethodStructure method) {
        this(method.getIdentityConstant(), method.getIdentityConstant().getSignature(), method.isNative() ? Implementation.Native : Implementation.Explicit, null);
        assert (method.getAccess() == Constants.Access.PRIVATE);
        this.m_structMethod = method;
    }

    public MethodBody(MethodConstant id, SignatureConstant sig, Implementation impl) {
        this(id, sig, impl, null);
    }

    public MethodBody(MethodConstant id, SignatureConstant sig, Implementation impl, Object target) {
        assert (id != null && sig != null && impl != null);
        switch (impl.ordinal()) {
            case 5: {
                assert (target instanceof SignatureConstant || target instanceof IdentityConstant.NestedIdentity);
                break;
            }
            case 6: 
            case 7: {
                assert (target instanceof PropertyConstant);
                break;
            }
            default: {
                assert (target == null);
                break;
            }
        }
        this.m_id = id;
        this.m_sig = sig;
        this.m_impl = impl;
        this.m_target = target;
    }

    public MethodBody(MethodBody body, Implementation impl) {
        this.m_id = body.m_id;
        this.m_sig = body.m_sig;
        this.m_target = body.m_target;
        this.m_impl = impl;
    }

    public MethodBody resolveGenerics(ConstantPool pool, GenericTypeResolver resolver) {
        assert (this.m_impl != Implementation.Capped);
        SignatureConstant sig = this.m_sig.resolveGenericTypes(pool, resolver);
        MethodConstant id = pool.ensureMethodConstant(this.m_id.getNamespace(), sig);
        MethodBody body = new MethodBody(id, sig, this.m_impl, null);
        body.setMethodStructure(this.getMethodStructure());
        return body;
    }

    public MethodConstant getIdentity() {
        return this.m_id;
    }

    public SignatureConstant getSignature() {
        return this.m_sig;
    }

    public Constants.Access getAccess() {
        return this.m_structMethod == null ? Constants.Access.PUBLIC : this.m_structMethod.getAccess();
    }

    public MethodStructure getMethodStructure() {
        MethodStructure structMethod = this.m_structMethod;
        if (structMethod == null) {
            switch (this.m_impl.ordinal()) {
                case 5: 
                case 6: 
                case 7: {
                    return null;
                }
            }
            Component component = this.m_id.getComponent();
            if (component instanceof MethodStructure) {
                MethodStructure method;
                this.m_structMethod = method = (MethodStructure)component;
                return this.m_structMethod;
            }
        }
        return structMethod;
    }

    public void setMethodStructure(MethodStructure method) {
        assert (this.m_structMethod == null);
        this.m_structMethod = method;
    }

    public boolean isAbstract() {
        return switch (this.m_impl.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 3, 4 -> true;
            case 2, 5, 6, 7, 8, 9 -> false;
        };
    }

    public boolean isConcrete() {
        return switch (this.m_impl.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 2, 3, 4 -> false;
            case 5, 6, 7, 8, 9 -> true;
        };
    }

    public boolean isFunction() {
        MethodStructure structMethod = this.getMethodStructure();
        return structMethod != null && structMethod.isFunction();
    }

    public boolean isConstructor() {
        MethodStructure structMethod = this.getMethodStructure();
        return structMethod != null && (structMethod.isConstructor() || structMethod.isValidator());
    }

    public boolean isVirtualConstructor() {
        MethodStructure structMethod = this.getMethodStructure();
        return structMethod != null && structMethod.isVirtualConstructor();
    }

    public boolean isValidator() {
        MethodStructure structMethod = this.getMethodStructure();
        return structMethod != null && structMethod.isValidator();
    }

    public boolean isSynthetic() {
        MethodStructure structMethod = this.getMethodStructure();
        return structMethod != null && structMethod.isSynthetic();
    }

    public boolean isVisibilityReductionAllowed() {
        MethodStructure structMethod = this.getMethodStructure();
        return structMethod != null && (structMethod.isConstructor() || structMethod.isConstructorFinalizer() || structMethod.isValidator());
    }

    public boolean isOverride() {
        return this.findAnnotation(this.pool().clzOverride()) != null;
    }

    public boolean isNative() {
        return this.m_impl == Implementation.Native;
    }

    public boolean isOptimized() {
        return switch (this.m_impl.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 3, 4, 5 -> false;
            case 2, 6, 7, 8, 9 -> true;
        };
    }

    public Implementation getImplementation() {
        return this.m_impl;
    }

    public boolean usesSuper() {
        return this.m_impl == Implementation.Explicit && this.getMethodStructure().usesSuper();
    }

    public boolean blocksSuper() {
        switch (this.m_impl.ordinal()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 9: {
                MethodStructure structMethod = this.getMethodStructure();
                assert (!structMethod.isAbstract());
                return !structMethod.usesSuper();
            }
        }
        throw new IllegalStateException();
    }

    public PropertyConstant getPropertyConstant() {
        return this.m_impl == Implementation.Delegating || this.m_impl == Implementation.Field ? (PropertyConstant)this.m_target : null;
    }

    public Object getNarrowingNestedIdentity() {
        return this.m_impl == Implementation.Capped ? this.m_target : null;
    }

    public Annotation findAnnotation(ClassConstant clzAnno) {
        MethodStructure structMethod = this.getMethodStructure();
        if (structMethod != null && structMethod.getAnnotationCount() > 0) {
            for (Annotation annotation : structMethod.getAnnotations()) {
                if (!((ClassConstant)annotation.getAnnotationClass()).extendsClass(clzAnno)) continue;
                return annotation;
            }
        }
        return null;
    }

    public boolean isAuto() {
        SignatureConstant sig = this.m_id.getSignature();
        MethodStructure struct = this.getMethodStructure();
        int cRequired = struct == null ? sig.getParamCount() : struct.getParamCount() - struct.getDefaultParamCount();
        return cRequired == 0 && sig.getReturnCount() > 0 && this.findAnnotation(this.pool().clzAuto()) != null;
    }

    public boolean isOp(String sName, String sOp, int cParams) {
        StringConstant s;
        Constant constant;
        if (this.isFunction() || this.isConstructor()) {
            return false;
        }
        Annotation annotation = this.findAnnotation(this.pool().clzOp());
        if (annotation == null) {
            return false;
        }
        SignatureConstant sig = this.getSignature();
        if (cParams >= 0) {
            int cRequired;
            MethodStructure struct = this.getMethodStructure();
            int n = cRequired = struct == null ? sig.getParamCount() : struct.getParamCount() - struct.getDefaultParamCount();
            if (cRequired != cParams) {
                return false;
            }
        }
        if (sName != null && sig.getName().equals(sName)) {
            return true;
        }
        Constant[] aconstParams = annotation.getParams();
        return aconstParams.length >= 1 && (constant = aconstParams[0]) instanceof StringConstant && (s = (StringConstant)constant).getValue().equals(sOp);
    }

    private ConstantPool pool() {
        return ConstantPool.getCurrentPool();
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodBody)) {
            return false;
        }
        MethodBody that = (MethodBody)obj;
        return this.m_impl == that.m_impl && Handy.equals(this.m_id, that.m_id) && Handy.equals(this.m_sig, that.m_sig) && Handy.equals(this.m_target, that.m_target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_id.getPathString()).append(" {sig=").append(this.m_sig.getValueString()).append(", impl=").append((Object)this.m_impl);
        if (this.m_target != null) {
            Object object;
            StringBuilder stringBuilder = sb.append(", target=");
            Object object2 = this.m_target;
            if (object2 instanceof Constant) {
                Constant constant = (Constant)object2;
                object = constant.getValueString();
            } else {
                object = this.m_target;
            }
            stringBuilder.append(object);
        }
        return sb.append('}').toString();
    }

    public JitMethodDesc getJitDesc(TypeSystem ts) {
        JitMethodDesc jmd = this.m_jmd;
        if (jmd == null) {
            ArrayList<JitParamDesc> listParamsStd = new ArrayList<JitParamDesc>();
            ArrayList<JitParamDesc> listParamsOpt = new ArrayList<JitParamDesc>();
            boolean fOptimized = false;
            SignatureConstant signature = this.getSignature();
            MethodStructure method = this.getMethodStructure();
            int iStd = 0;
            int iOpt = 0;
            int c = method.getParamCount();
            for (int iOrig = 0; iOrig < c; ++iOrig) {
                JitFlavor flavor;
                TypeConstant type = signature.getRawParams()[iOrig];
                boolean fDflt = method.getParam(iOrig).hasDefaultValue();
                ClassDesc cd = JitTypeDesc.getPrimitiveClass(type);
                if (cd != null) {
                    flavor = fDflt ? JitFlavor.SpecificWithDefault : JitFlavor.Specific;
                    ClassDesc cdStd = ClassDesc.of(ts.ensureJitClassName(type));
                    listParamsStd.add(new JitParamDesc(type, flavor, cdStd, iOrig, iStd++, false));
                    fOptimized = true;
                    if (fDflt) {
                        listParamsOpt.add(new JitParamDesc(type, JitFlavor.PrimitiveWithDefault, cd, iOrig, iOpt++, false));
                        listParamsOpt.add(new JitParamDesc(type, JitFlavor.PrimitiveWithDefault, ConstantDescs.CD_boolean, iOrig, iOpt++, true));
                        continue;
                    }
                    listParamsOpt.add(new JitParamDesc(type, JitFlavor.Primitive, cd, iOrig, iOpt++, false));
                    continue;
                }
                cd = JitTypeDesc.getMultiSlotPrimitiveClass(type);
                if (cd != null) {
                    flavor = fDflt ? JitFlavor.WidenedWithDefault : JitFlavor.Widened;
                    listParamsStd.add(new JitParamDesc(type, flavor, Builder.CD_xObj, iOrig, iStd++, false));
                    if (fDflt) {
                        listParamsOpt.add(new JitParamDesc(type, flavor, Builder.CD_xObj, iOrig, iOpt++, false));
                        continue;
                    }
                    fOptimized = true;
                    listParamsOpt.add(new JitParamDesc(type, JitFlavor.MultiSlotPrimitive, cd, iOrig, iOpt++, false));
                    listParamsOpt.add(new JitParamDesc(type, JitFlavor.MultiSlotPrimitive, ConstantDescs.CD_boolean, iOrig, iOpt++, true));
                    continue;
                }
                cd = JitTypeDesc.getWidenedClass(type);
                if (cd != null) {
                    flavor = fDflt ? JitFlavor.WidenedWithDefault : JitFlavor.Widened;
                    listParamsStd.add(new JitParamDesc(type, flavor, cd, iOrig, iStd++, false));
                    listParamsOpt.add(new JitParamDesc(type, flavor, cd, iOrig, iOpt++, false));
                    continue;
                }
                assert (type.isSingleUnderlyingClass(true));
                cd = ClassDesc.of(ts.ensureJitClassName(type));
                flavor = fDflt ? JitFlavor.SpecificWithDefault : JitFlavor.Specific;
                listParamsStd.add(new JitParamDesc(type, flavor, cd, iOrig, iStd++, false));
                listParamsOpt.add(new JitParamDesc(type, flavor, cd, iOrig, iOpt++, false));
            }
            JitParamDesc[] apdStdParam = listParamsStd.toArray(JitParamDesc.NONE);
            JitParamDesc[] apdOptParam = fOptimized ? listParamsOpt.toArray(JitParamDesc.NONE) : apdStdParam;
            listParamsStd.clear();
            listParamsOpt.clear();
            int ixLong = -1;
            int ixOptObj = -1;
            int ixStdObj = -1;
            int c2 = method.getReturnCount();
            for (int iOrig = 0; iOrig < c2; ++iOrig) {
                TypeConstant type = signature.getRawReturns()[iOrig];
                ClassDesc cd = JitTypeDesc.getPrimitiveClass(type);
                if (cd != null) {
                    ClassDesc cdStd = ClassDesc.of(ts.ensureJitClassName(type));
                    listParamsStd.add(new JitParamDesc(type, JitFlavor.Specific, cdStd, iOrig, ixStdObj++, false));
                    listParamsOpt.add(new JitParamDesc(type, JitFlavor.Primitive, cd, iOrig, ixLong++, false));
                    fOptimized = true;
                } else {
                    cd = JitTypeDesc.getMultiSlotPrimitiveClass(type);
                    if (cd != null) {
                        TypeConstant typePrimitive = type.removeNullable();
                        TypeConstant typeBoolean = this.pool().typeBoolean();
                        listParamsStd.add(new JitParamDesc(type, JitFlavor.Widened, Builder.CD_xObj, iOrig, ixStdObj++, false));
                        listParamsOpt.add(new JitParamDesc(typePrimitive, JitFlavor.MultiSlotPrimitive, cd, iOrig, ixLong++, false));
                        listParamsOpt.add(new JitParamDesc(typeBoolean, JitFlavor.MultiSlotPrimitive, ConstantDescs.CD_boolean, iOrig, ixLong++, true));
                        fOptimized = true;
                    } else {
                        cd = JitTypeDesc.getWidenedClass(type);
                        if (cd != null) {
                            listParamsStd.add(new JitParamDesc(type, JitFlavor.Widened, cd, iOrig, ixStdObj++, false));
                            listParamsOpt.add(new JitParamDesc(type, JitFlavor.Widened, cd, iOrig, ixOptObj++, false));
                        } else {
                            assert (type.isSingleUnderlyingClass(true));
                            cd = ClassDesc.of(ts.ensureJitClassName(type));
                            listParamsStd.add(new JitParamDesc(type, JitFlavor.Specific, cd, iOrig, ixStdObj++, false));
                            listParamsOpt.add(new JitParamDesc(type, JitFlavor.Specific, cd, iOrig, ixOptObj++, false));
                        }
                    }
                }
                if (ixLong == -1) {
                    ixLong = 0;
                }
                if (ixOptObj != -1) continue;
                ixOptObj = 0;
            }
            JitParamDesc[] apdStdReturn = listParamsStd.toArray(JitParamDesc.NONE);
            JitParamDesc[] apdOptReturn = fOptimized ? listParamsOpt.toArray(JitParamDesc.NONE) : null;
            jmd = this.isConstructor() ? new JitCtorDesc(ts, this, apdStdReturn, apdStdParam, apdOptReturn, apdOptParam) : new JitMethodDesc(apdStdReturn, apdStdParam, apdOptReturn, apdOptParam);
            this.m_jmd = jmd;
        }
        return jmd;
    }

    public static enum Implementation {
        Implicit,
        Declared,
        Default,
        Abstract,
        SansCode,
        Capped,
        Delegating,
        Field,
        Native,
        Explicit;


        public Existence getExistence() {
            return switch (this.ordinal()) {
                case 0 -> Existence.Implied;
                case 1, 2 -> Existence.Interface;
                default -> Existence.Class;
            };
        }
    }

    public static enum Existence {
        Implied,
        Interface,
        Class;

    }
}

