/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MultiMethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.TypeSystem;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class MethodConstant
extends IdentityConstant
implements GenericTypeResolver {
    private int m_iParent;
    private int m_iSig;
    private MultiMethodConstant m_constParent;
    private SignatureConstant m_constSig;
    private final int m_iLambda;
    private transient TypeConstant m_type;
    private transient String m_sJitName;

    public MethodConstant(ConstantPool pool, MultiMethodConstant constParent, SignatureConstant constSig) {
        this(pool, constParent, constSig, 0);
    }

    public MethodConstant(ConstantPool pool, MultiMethodConstant constParent, TypeConstant[] params, TypeConstant[] returns) {
        this(pool, constParent, pool.ensureSignatureConstant(constParent.getName(), params, returns), 0);
    }

    public MethodConstant(ConstantPool pool, MultiMethodConstant constParent, int iLambda) {
        this(pool, constParent, null, iLambda);
    }

    protected MethodConstant(ConstantPool pool, MultiMethodConstant constParent, SignatureConstant constSig, int iLambda) {
        super(pool);
        if (constParent == null) {
            throw new IllegalArgumentException("parent required");
        }
        if (constSig == null && iLambda == 0) {
            throw new IllegalArgumentException("signature or lambda identity required");
        }
        if (iLambda < 0) {
            throw new IllegalArgumentException("illegal lambda identity: " + iLambda);
        }
        this.m_constParent = constParent;
        this.m_constSig = constSig;
        this.m_iLambda = iLambda;
    }

    public MethodConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iParent = Handy.readMagnitude(in);
        this.m_iSig = Handy.readMagnitude(in);
        this.m_iLambda = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_constParent = (MultiMethodConstant)pool.getConstant(this.m_iParent);
        this.m_constSig = (SignatureConstant)pool.getConstant(this.m_iSig);
    }

    public boolean isLambda() {
        boolean fLambda;
        boolean bl = fLambda = this.m_iLambda > 0;
        assert (fLambda || this.m_constSig != null);
        assert (fLambda == "->".equals(this.getName()));
        return fLambda;
    }

    public int getLambdaIndex() {
        return this.m_iLambda;
    }

    public boolean isNascent() {
        return this.m_constSig == null;
    }

    public SignatureConstant getSignature() {
        assert (!this.isNascent());
        return this.m_constSig;
    }

    public void setSignature(SignatureConstant sig) {
        assert (this.isLambda());
        assert (this.isNascent());
        assert (sig != null);
        this.m_constSig = sig;
    }

    public TypeConstant[] getRawParams() {
        return this.getSignature().getRawParams();
    }

    public List<TypeConstant> getParams() {
        return this.getSignature().getParams();
    }

    public TypeConstant[] getRawReturns() {
        return this.getSignature().getRawReturns();
    }

    public List<TypeConstant> getReturns() {
        return this.getSignature().getReturns();
    }

    public TypeConstant getReturnsAsTuple() {
        return this.getConstantPool().ensureTupleType(this.getRawReturns());
    }

    public boolean isFunction() {
        assert (!this.isNascent());
        MethodStructure method = (MethodStructure)this.getComponent();
        return method != null && method.isFunction();
    }

    public boolean isConstructor() {
        assert (!this.isNascent());
        MethodStructure method = (MethodStructure)this.getComponent();
        return method != null && method.isConstructor();
    }

    public boolean isTopLevel() {
        return this.getParentConstant().getParentConstant().isClass();
    }

    public TypeConstant getBjarneLambdaType() {
        assert (!this.isFunction());
        return this.m_constSig.asBjarneLambdaType(this.getConstantPool(), this.getNamespace().getType());
    }

    @Override
    protected StringBuilder buildJitName(TypeSystem ts) {
        return this.getParentConstant().buildJitName(ts).append(this.getSignature().ensureJitMethodName(ts));
    }

    public String ensureJitMethodName(TypeSystem ts) {
        String sJitName = this.m_sJitName;
        if (sJitName == null) {
            Object prefix = "";
            IdentityConstant idParent = this.getNamespace();
            block5: while (true) {
                switch (idParent.getFormat()) {
                    case Class: 
                    case Package: 
                    case Module: {
                        break block5;
                    }
                    case Property: {
                        prefix = ((PropertyConstant)idParent).ensureJitPropertyName(ts) + "$" + (String)prefix;
                        break;
                    }
                    case Method: {
                        prefix = ((MethodConstant)idParent).ensureJitMethodName(ts) + "$" + (String)prefix;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                idParent = idParent.getNamespace();
            }
            SignatureConstant sigJit = this.getSignature();
            if (!((String)prefix).isEmpty()) {
                sigJit = sigJit.getConstantPool().ensureSignatureConstant((String)prefix + sigJit.getName(), sigJit.getRawParams(), sigJit.getRawReturns());
            }
            this.m_sJitName = sJitName = sigJit.ensureJitMethodName(ts);
        }
        return sJitName;
    }

    @Override
    public TypeConstant resolveGenericType(String sFormalName) {
        MethodStructure method = (MethodStructure)this.getComponent();
        if (method != null) {
            int c = method.getTypeParamCount();
            for (int i = 0; i < c; ++i) {
                Parameter param = method.getParam(i);
                if (!sFormalName.equals(param.getName())) continue;
                return param.asTypeParameterConstant(this).getType();
            }
        }
        return null;
    }

    @Override
    public IdentityConstant replaceParentConstant(IdentityConstant idParent) {
        return new MethodConstant(this.getConstantPool(), (MultiMethodConstant)idParent, this.getSignature());
    }

    @Override
    public MultiMethodConstant getParentConstant() {
        return this.m_constParent;
    }

    @Override
    public IdentityConstant getNamespace() {
        return this.getParentConstant().getNamespace();
    }

    @Override
    public String getName() {
        return this.getParentConstant().getName();
    }

    @Override
    protected StringBuilder buildPath() {
        return this.getParentConstant().buildPath().append(this.getPathElementString());
    }

    @Override
    public Object getPathElement() {
        return this.isLambda() ? Integer.valueOf(this.m_iLambda) : this.m_constSig;
    }

    @Override
    public String getPathElementString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNascent()) {
            sb.append('[').append(this.m_iLambda).append(']');
        } else {
            sb.append('(');
            TypeConstant[] aParamType = this.getRawParams();
            int c = aParamType.length;
            for (int i = 0; i < c; ++i) {
                TypeConstant typeParam = aParamType[i];
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(typeParam.getValueString());
            }
            sb.append(')');
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean trailingSegmentEquals(IdentityConstant idThat) {
        if (!(idThat instanceof MethodConstant)) return false;
        MethodConstant that = (MethodConstant)idThat;
        if (this.isLambda()) {
            if (this.m_iLambda != that.m_iLambda) return false;
            return true;
        } else if (!this.m_constSig.equals(that.m_constSig)) return false;
        return true;
    }

    @Override
    public IdentityConstant appendTrailingSegmentTo(IdentityConstant that) {
        return that.getConstantPool().ensureMethodConstant(that, this.m_constSig);
    }

    @Override
    public TypeConstant getType() {
        TypeConstant type = this.m_type;
        if (type == null) {
            if (this.isFunction()) {
                type = this.getSignature().asFunctionType();
            } else {
                TypeConstant typeTarget;
                ConstantPool pool = this.getConstantPool();
                IdentityConstant idTarget = this.getNamespace();
                if (idTarget.isClass()) {
                    typeTarget = ((ClassStructure)idTarget.getComponent()).getFormalType();
                    if (this.isConstructor()) {
                        typeTarget = pool.ensureAccessTypeConstant(typeTarget, Constants.Access.STRUCT);
                    }
                } else {
                    typeTarget = idTarget.getType();
                }
                type = this.getSignature().asMethodType(pool, typeTarget);
            }
            if (!type.containsUnresolved()) {
                this.m_type = type;
            }
        }
        return type;
    }

    @Override
    public Object getNestedIdentity() {
        return this.getNamespace().isNested() ? this.getCanonicalNestedIdentity() : this.getPathElement();
    }

    @Override
    public Object resolveNestedIdentity(ConstantPool pool, GenericTypeResolver resolver) {
        MethodStructure method = (MethodStructure)this.getComponent();
        if (resolver != null && method != null && method.isFunction()) {
            resolver = null;
        }
        return this.getNamespace().isNested() ? (resolver == null ? this.getCanonicalNestedIdentity() : new IdentityConstant.NestedIdentity(resolver)) : this.getSignature().resolveGenericTypes(pool, resolver);
    }

    @Override
    public MethodStructure relocateNestedIdentity(ClassStructure clz) {
        assert (!this.isLambda());
        Component parent = this.getNamespace().relocateNestedIdentity(clz);
        return parent == null ? null : parent.findMethod(this.getSignature());
    }

    @Override
    public MethodConstant ensureNestedIdentity(ConstantPool pool, IdentityConstant that) {
        assert (!this.isLambda());
        return pool.ensureMethodConstant(this.getParentConstant().ensureNestedIdentity(pool, that), this.getSignature());
    }

    @Override
    public TypeConstant getValueType(ConstantPool pool, TypeConstant typeTarget) {
        int cTypeParams;
        MethodStructure method;
        SignatureConstant sig = this.getSignature();
        boolean fFunction = this.isFunction();
        if (!fFunction) {
            if (typeTarget == null) {
                typeTarget = ((ClassStructure)this.getClassIdentity().getComponent()).getFormalType();
            }
            sig = sig.resolveAutoNarrowing(pool, typeTarget, null);
        }
        if ((method = (MethodStructure)this.getComponent()) != null && (cTypeParams = method.getTypeParamCount()) > 0) {
            sig = sig.truncateParams(cTypeParams, sig.getParamCount() - cTypeParams);
        }
        return fFunction ? sig.asFunctionType() : sig.asMethodType(pool, typeTarget);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Method;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constParent);
        if (this.m_constSig != null) {
            visitor.accept(this.m_constSig);
        }
    }

    @Override
    public boolean isValueCacheable() {
        return this.isFunction();
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && (super.containsUnresolved() || this.isNascent() || this.getSignature().containsUnresolved());
    }

    @Override
    public MethodConstant resolveTypedefs() {
        SignatureConstant sigNew;
        MultiMethodConstant idOldParent = this.getParentConstant();
        MultiMethodConstant idNewParent = (MultiMethodConstant)idOldParent.resolveTypedefs();
        SignatureConstant sigOld = this.m_constSig;
        SignatureConstant signatureConstant = sigNew = sigOld == null ? null : sigOld.resolveTypedefs();
        if (idOldParent == idNewParent && sigNew == sigOld) {
            return this;
        }
        ConstantPool pool = this.getConstantPool();
        return (MethodConstant)pool.register(new MethodConstant(pool, idNewParent, sigNew, this.m_iLambda));
    }

    @Override
    protected int compareDetails(Constant obj) {
        if (!(obj instanceof MethodConstant)) {
            return -1;
        }
        MethodConstant that = (MethodConstant)obj;
        int n = this.m_constParent.compareTo(that.m_constParent);
        if (n == 0 && (n = this.m_iLambda - that.m_iLambda) == 0) {
            SignatureConstant sigThis = this.m_constSig;
            SignatureConstant sigThat = that.m_constSig;
            if (sigThis != null && sigThat != null) {
                return sigThis.compareTo(sigThat);
            }
        }
        return n;
    }

    @Override
    public String getValueString() {
        return this.isNascent() ? this.getPathElementString() : this.m_constSig.getValueString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_type = null;
        this.m_constParent = (MultiMethodConstant)pool.register(this.m_constParent);
        this.m_constSig = (SignatureConstant)pool.register(this.m_constSig);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        this.m_type = null;
        assert (!this.isNascent());
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constParent.getPosition());
        Handy.writePackedLong(out, Constant.indexOf(this.m_constSig));
        Handy.writePackedLong(out, this.m_iLambda);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        IdentityConstant idParent = this.getNamespace();
        while (idParent.isNested()) {
            switch (idParent.getFormat()) {
                case Property: 
                case Method: {
                    sb.insert(0, idParent.getName() + "#");
                    break;
                }
            }
            idParent = idParent.getNamespace();
        }
        sb.insert(0, ", name=");
        sb.insert(0, "host=" + idParent.getName());
        if (!this.isNascent()) {
            sb.append(", signature=").append(this.getSignature().getValueString());
        }
        if (this.isLambda()) {
            sb.append(", lambda=").append(this.m_iLambda);
        }
        return sb.toString();
    }

    @Override
    protected int computeHashCode() {
        return Hash.of(this.m_constParent, Hash.of(this.m_iLambda, Hash.of(this.m_constSig)));
    }
}

