/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.javajit.TypeSystem;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class MethodInfo
implements Constants {
    public static final Comparator<Map.Entry<MethodConstant, MethodInfo>> RANKER = Comparator.comparingInt(e -> ((MethodInfo)e.getValue()).getRank());
    private final MethodBody[] m_aBody;
    private final int f_nRank;
    private transient MethodBody[] m_aBodyResolved;

    public MethodInfo(MethodBody body, int nRank) {
        this(new MethodBody[]{body}, nRank);
    }

    protected MethodInfo(MethodBody[] aBody, int nRank) {
        assert (aBody != null && aBody.length >= 1);
        this.m_aBody = aBody;
        this.f_nRank = nRank;
    }

    MethodInfo capWith(TypeConstant typeCtx, MethodInfo that) {
        assert (this.isOverridable() || this.containsVirtualConstructor());
        assert (that.isOverridable() || that.isPotentialPropertyOverlay() || that.containsVirtualConstructor());
        SignatureConstant sigThis = this.getSignature();
        SignatureConstant sigThat = that.getSignature();
        MethodConstant idThat = null;
        for (MethodBody bodyThat : that.getChain()) {
            if (!bodyThat.getSignature().equals(sigThat)) {
                assert (idThat != null);
                break;
            }
            idThat = bodyThat.getIdentity();
        }
        ConstantPool pool = this.pool();
        MethodConstant idCap = pool.ensureMethodConstant(idThat.getParentConstant(), sigThis);
        MethodBody[] aOld = this.m_aBody;
        int cOld = aOld.length;
        MethodBody[] aNew = new MethodBody[cOld + 1];
        aNew[0] = new MethodBody(idCap, sigThis, MethodBody.Implementation.Capped, idThat.resolveNestedIdentity(pool, typeCtx));
        System.arraycopy(aOld, 0, aNew, 1, cOld);
        return new MethodInfo(aNew, this.f_nRank);
    }

    public MethodInfo layerOn(MethodInfo that, boolean fSelf, ErrorListener errs) {
        assert (this.getIdentity().getName().equals(that.getIdentity().getName()));
        assert (!this.isFunction() && !that.isFunction());
        if (!this.getAccess().isAsAccessibleAs(Constants.Access.PROTECTED) || !that.getAccess().isAsAccessibleAs(Constants.Access.PROTECTED) || this.isConstructor() && !this.containsVirtualConstructor() || that.isConstructor() && !that.isVirtualConstructor()) {
            MethodConstant id = this.getIdentity();
            id.log(errs, Severity.ERROR, "VERIFY-80", that.getIdentity().getNamespace().getValueString(), id.getSignature().getValueString(), id.getNamespace().getValueString());
            return this;
        }
        if (this.equals(that)) {
            return this;
        }
        MethodBody[] aBase = this.m_aBody;
        MethodBody[] aAdd = that.m_aBody;
        int cBase = aBase.length;
        int cAdd = aAdd.length;
        if (fSelf) {
            assert (cAdd == 1);
            MethodBody bodyAdd = aAdd[0];
            if (!bodyAdd.isOverride() && !this.containsBody(bodyAdd.getIdentity())) {
                MethodConstant id = this.getIdentity();
                id.log(errs, Severity.ERROR, "VERIFY-81", that.getIdentity().getNamespace().getValueString(), id.getSignature().getValueString(), id.getNamespace().getValueString());
            }
            if (!that.getAccess().isAsAccessibleAs(this.getAccess())) {
                MethodConstant idThat = that.getIdentity();
                idThat.log(errs, Severity.ERROR, "VERIFY-87", ((IdentityConstant)idThat).getNamespace().getValueString(), ((Constant)idThat).getValueString());
                return that;
            }
            MethodStructure methodThat = bodyAdd.getMethodStructure();
            MethodStructure methodThis = aBase[cBase - 1].getMethodStructure();
            if (methodThis != null && methodThat != null) {
                int cParamsThat;
                int cParamsAll = methodThis.getVisibleParamCount();
                int cParamsReq = methodThis.getRequiredParamCount();
                if (cParamsReq < (cParamsThat = methodThat.getRequiredParamCount()) && cParamsThat <= cParamsAll) {
                    Parameter param = methodThat.getParam(cParamsReq);
                    MethodConstant idThat = that.getIdentity();
                    idThat.log(errs, Severity.ERROR, "VERIFY-89", idThat.getClassIdentity().getValueString(), idThat.getValueString(), param.getName());
                }
            }
        }
        ArrayList<MethodBody> listMerge = null;
        block0: for (int iThat = 0; iThat < cAdd; ++iThat) {
            MethodBody bodyThat = aAdd[iThat];
            boolean fAllowDuplicate = bodyThat.getIdentity().getNamespace() != this.pool().clzObject() && bodyThat.getImplementation().getExistence() == MethodBody.Existence.Interface;
            for (int iThis = 0; iThis < cBase; ++iThis) {
                if (!bodyThat.equals(aBase[iThis]) || fAllowDuplicate && (iThis != 0 || iThat != cAdd - 1)) continue;
                if (cBase != 1) continue block0;
                return that;
            }
            if (listMerge == null) {
                listMerge = new ArrayList<MethodBody>();
            }
            listMerge.add(bodyThat);
        }
        if (listMerge == null) {
            return this;
        }
        if (!this.isOverridable()) {
            if (fSelf) {
                MethodConstant id = this.getIdentity();
                id.log(errs, Severity.ERROR, "VERIFY-80", that.getIdentity().getNamespace().getValueString(), id.getSignature().getValueString(), id.getNamespace().getValueString());
            }
            return this;
        }
        Collections.addAll(listMerge, aBase);
        return new MethodInfo(listMerge.toArray(MethodBody.NO_BODIES), this.f_nRank);
    }

    public MethodInfo layerOnValidator(MethodInfo that) {
        assert (this.isValidator() && that.isValidator());
        MethodBody[] aBase = this.m_aBody;
        MethodBody[] aAdd = that.m_aBody;
        ArrayList<MethodBody> listMerge = null;
        block0: for (MethodBody bodyThat : aAdd) {
            for (MethodBody methodBody : aBase) {
                if (bodyThat.equals(methodBody)) continue block0;
            }
            if (listMerge == null) {
                listMerge = new ArrayList<MethodBody>();
            }
            listMerge.add(bodyThat);
        }
        if (listMerge == null) {
            return this;
        }
        Collections.addAll(listMerge, aBase);
        return new MethodInfo(listMerge.toArray(MethodBody.NO_BODIES), this.f_nRank);
    }

    public MethodInfo layerOnVirtualConstructor(MethodInfo that) {
        MethodBody[] aThis = this.m_aBody;
        int cThis = -1;
        for (int i = aThis.length - 1; i >= 0; --i) {
            if (!aThis[i].isVirtualConstructor()) continue;
            cThis = i + 1;
            break;
        }
        assert (cThis > 0);
        MethodBody[] aThat = that.m_aBody;
        int cThat = aThat.length;
        MethodBody[] aNew = new MethodBody[cThat + cThis];
        System.arraycopy(aThat, 0, aNew, 0, cThat);
        System.arraycopy(aThis, 0, aNew, cThat, cThis);
        return new MethodInfo(aNew, this.f_nRank);
    }

    public MethodInfo subsumeFunction(MethodInfo that) {
        assert (this.isFunction());
        assert (that.isFunction());
        MethodBody[] aBase = that.m_aBody;
        MethodBody[] aAdd = this.m_aBody;
        ArrayList<MethodBody> listMerge = null;
        block0: for (MethodBody bodyAdd : aAdd) {
            for (MethodBody bodyBase : aBase) {
                if (bodyAdd.equals(bodyBase) || bodyAdd.isAbstract() && !bodyBase.isAbstract()) continue block0;
            }
            if (listMerge == null) {
                listMerge = new ArrayList<MethodBody>();
            }
            listMerge.add(bodyAdd);
        }
        if (listMerge == null) {
            return that;
        }
        Collections.addAll(listMerge, aBase);
        return new MethodInfo(listMerge.toArray(MethodBody.NO_BODIES), this.f_nRank);
    }

    public MethodInfo retainOnly(MethodConstant constId, Set<IdentityConstant> setClass, Set<IdentityConstant> setDefault) {
        if (this.isFunction() || this.isConstructor()) {
            return this;
        }
        ArrayList<MethodBody> list = null;
        MethodBody[] aBody = this.m_aBody;
        int c = aBody.length;
        for (int i = 0; i < c; ++i) {
            boolean fRetain;
            MethodBody body = aBody[i];
            IdentityConstant constClz = constId.getClassIdentity();
            switch (body.getImplementation()) {
                case Implicit: 
                case SansCode: 
                case Declared: 
                case Default: 
                case Native: {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = fRetain = setClass.contains(constClz) || setDefault.contains(constClz);
                }
            }
            if (fRetain) {
                if (list == null) continue;
                list.add(body);
                continue;
            }
            if (list != null) continue;
            list = Handy.startList(aBody, i);
        }
        if (list == null) {
            return this;
        }
        return list.isEmpty() ? null : new MethodInfo(list.toArray(MethodBody.NO_BODIES), this.f_nRank);
    }

    public MethodInfo finishAdoption(boolean fNative, ErrorListener errs) {
        assert (fNative);
        if (this.isFunction() || this.isConstructor()) {
            return this;
        }
        MethodBody bodyFirstNonDefault = null;
        block4: for (MethodBody body : this.m_aBody) {
            switch (body.getImplementation()) {
                case Implicit: 
                case SansCode: 
                case Declared: 
                case Abstract: {
                    if (bodyFirstNonDefault != null) continue block4;
                    bodyFirstNonDefault = body;
                    continue block4;
                }
                case Default: 
                case Native: 
                case Explicit: 
                case Capped: {
                    return this;
                }
                default: {
                    throw new IllegalStateException("Unexpected native class declaration: " + String.valueOf(body.getSignature()));
                }
            }
        }
        MethodBody bodyResult = new MethodBody(bodyFirstNonDefault.getIdentity(), bodyFirstNonDefault.getSignature(), MethodBody.Implementation.Native);
        return this.layerOn(new MethodInfo(bodyResult, this.f_nRank), true, errs);
    }

    public MethodInfo nestNarrowingIdentity(ConstantPool pool, PropertyConstant idProp) {
        assert (this.isCapped());
        MethodBody bodyCap = this.getHead();
        Object nidTarget = idProp.appendNestedIdentity(pool, bodyCap.getNarrowingNestedIdentity()).resolveNestedIdentity(pool, null);
        MethodBody[] chainNew = (MethodBody[])this.getChain().clone();
        chainNew[0] = new MethodBody(bodyCap.getIdentity(), bodyCap.getSignature(), MethodBody.Implementation.Capped, nidTarget);
        return new MethodInfo(chainNew, this.f_nRank);
    }

    public MethodInfo asInto() {
        if ((this.isFunction() || this.isConstructor() || this.isCapped()) && !this.getIdentity().getNamespace().equals(this.pool().clzObject())) {
            return this;
        }
        return this.markImplicit();
    }

    public MethodInfo markImplicitConstructor() {
        assert (this.isConstructor());
        return this.markImplicit();
    }

    private MethodInfo markImplicit() {
        MethodBody[] aBodyOld = this.m_aBody;
        int cBodies = aBodyOld.length;
        MethodBody[] aBodyNew = new MethodBody[cBodies];
        for (int i = 0; i < cBodies; ++i) {
            MethodBody body = aBodyOld[i];
            aBodyNew[i] = new MethodBody(body.getIdentity(), body.getSignature(), MethodBody.Implementation.Implicit);
        }
        return new MethodInfo(aBodyNew, this.f_nRank);
    }

    public MethodConstant getIdentity() {
        return this.getHead().getIdentity();
    }

    public boolean containsBody(MethodConstant id) {
        for (MethodBody body : this.m_aBody) {
            if (!id.equals(body.getIdentity())) continue;
            return true;
        }
        return false;
    }

    public SignatureConstant getSignature() {
        return this.getHead().getSignature();
    }

    public MethodStructure getTopmostMethodStructure(TypeInfo infoType) {
        for (MethodBody body : this.m_aBody) {
            if (body.getImplementation() == MethodBody.Implementation.Capped) {
                MethodInfo methodNarrowing = infoType.getNarrowingMethod(this);
                assert (methodNarrowing != this);
                return methodNarrowing.getTopmostMethodStructure(infoType);
            }
            MethodStructure method = body.getMethodStructure();
            if (method == null) continue;
            return method;
        }
        throw new IllegalStateException();
    }

    public Object getNarrowingMethod(Map<Object, MethodInfo> mapVirtMethods) {
        MethodInfo methodCapped;
        assert (this.isCapped());
        Object nidNarrowing = this.getHead().getNarrowingNestedIdentity();
        for (int i = 0; i < 32 && (methodCapped = mapVirtMethods.get(nidNarrowing)) != null && methodCapped.isCapped(); ++i) {
            nidNarrowing = methodCapped.getHead().getNarrowingNestedIdentity();
        }
        return nidNarrowing;
    }

    public MethodBody getHead() {
        return this.m_aBody[0];
    }

    public MethodBody getTail() {
        return this.m_aBody[this.m_aBody.length - 1];
    }

    public boolean isAbstract() {
        boolean fIgnoreAbstract = false;
        int cDeclParams = -1;
        int cDeclReturns = -1;
        block7: for (MethodBody body : this.m_aBody) {
            switch (body.getImplementation()) {
                case Implicit: {
                    if (!this.isConstructor()) continue block7;
                    return false;
                }
                case Declared: {
                    cDeclParams = Math.max(cDeclParams, body.getSignature().getParamCount());
                    cDeclReturns = Math.max(cDeclReturns, body.getSignature().getReturnCount());
                    continue block7;
                }
                case Abstract: {
                    if (fIgnoreAbstract) continue block7;
                    return true;
                }
                case SansCode: {
                    fIgnoreAbstract = true;
                    continue block7;
                }
                case Default: 
                case Native: 
                case Explicit: 
                case Capped: 
                case Delegating: 
                case Field: {
                    if (cDeclParams != -1 && (body.getSignature().getParamCount() < cDeclParams || body.getSignature().getReturnCount() < cDeclReturns)) continue block7;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isNative() {
        return this.getHead().isNative();
    }

    public boolean isFunction() {
        return this.getHead().isFunction();
    }

    public boolean isConstructor() {
        return this.getTail().isConstructor();
    }

    public boolean isValidator() {
        return this.getHead().isValidator();
    }

    public boolean isVirtual() {
        if (this.getHead().isVirtualConstructor()) {
            return true;
        }
        if (this.isFunction() || this.isConstructor() || this.getAccess() == Constants.Access.PRIVATE) {
            return false;
        }
        IdentityConstant id = this.getIdentity();
        int c = id.getNestedDepth();
        for (int i = 1; i < c; ++i) {
            PropertyStructure prop;
            if ((id = id.getParentConstant()) instanceof MethodConstant) {
                return false;
            }
            if (!(id instanceof PropertyConstant) || (prop = (PropertyStructure)id.getComponent()) == null || prop.getAccess() != Constants.Access.PRIVATE || !prop.isSimple()) continue;
            return false;
        }
        return true;
    }

    public boolean isVirtualConstructor() {
        return this.getHead().isVirtualConstructor();
    }

    public boolean containsVirtualConstructor() {
        for (MethodBody body : this.getChain()) {
            if (!body.isVirtualConstructor()) continue;
            return true;
        }
        return false;
    }

    public boolean isUncoveredVirtualConstructor(TypeInfo info) {
        return this.containsVirtualConstructor() && !this.isCapped() && this.getTopmostMethodStructure(info).getContainingClass() != info.getClassStructure();
    }

    public boolean isAbstractFunction() {
        MethodBody head = this.getHead();
        return head.isFunction() && head.getImplementation() == MethodBody.Implementation.Declared;
    }

    public boolean isPotentialPropertyOverlay() {
        assert (!this.isVirtual());
        return this.getIdentity().getNamespace() instanceof PropertyConstant;
    }

    public boolean isCapped() {
        return this.getHead().getImplementation() == MethodBody.Implementation.Capped;
    }

    public boolean isOverridable() {
        return this.isVirtual() && !this.isCapped();
    }

    public void populateCache(MethodConstant idMethod, Map<MethodConstant, MethodInfo> mapMethods, Map<Object, MethodInfo> mapVirtMethods) {
        MethodConstant id = this.getHead().getIdentity();
        if (id.getNestedDepth() == idMethod.getNestedDepth()) {
            mapMethods.putIfAbsent(id, this);
            if (this.isVirtual()) {
                mapVirtMethods.putIfAbsent(id.getNestedIdentity(), this);
            }
        }
    }

    public MethodBody[] getChain() {
        return this.m_aBody;
    }

    public MethodBody[] ensureOptimizedMethodChain(TypeInfo infoType) {
        MethodBody[] chain = this.m_aBodyResolved;
        if (chain == null) {
            chain = this.getChain();
            MethodBody bodyHead = chain[0];
            if (bodyHead.getImplementation() == MethodBody.Implementation.Capped) {
                return infoType.getOptimizedMethodChain(bodyHead.getNarrowingNestedIdentity());
            }
            boolean fAnno = infoType.getFormat() == Component.Format.ANNOTATION;
            boolean fMixin = infoType.getFormat() == Component.Format.MIXIN;
            ArrayList<MethodBody> listNew = null;
            ArrayList<MethodBody> listDefault = null;
            int c = chain.length;
            block7: for (int i = 0; i < c; ++i) {
                MethodBody body = chain[i];
                MethodBody.Implementation impl = body.getImplementation();
                switch (impl) {
                    case Implicit: {
                        if (fAnno || fMixin) {
                            if (listNew == null) continue block7;
                            listNew.add(body);
                            continue block7;
                        }
                    }
                    case SansCode: 
                    case Declared: 
                    case Abstract: {
                        if (listNew != null) continue block7;
                        listNew = Handy.startList(chain, i);
                        continue block7;
                    }
                    case Default: {
                        if (listDefault == null) {
                            boolean fAllDefaults = true;
                            for (int j = i + 1; j < c; ++j) {
                                if (chain[j].getImplementation() == MethodBody.Implementation.Default) continue;
                                fAllDefaults = false;
                                break;
                            }
                            if (fAllDefaults) {
                                if (listNew == null) break block7;
                                Handy.appendList(listNew, chain, i, c - i);
                                break block7;
                            }
                            listDefault = new ArrayList<MethodBody>();
                        }
                        if (!listDefault.contains(body)) {
                            listDefault.add(body);
                        }
                        if (listNew != null) continue block7;
                        listNew = Handy.startList(chain, i);
                        continue block7;
                    }
                    case Explicit: 
                    case Delegating: 
                    case Field: {
                        MethodStructure method = body.getMethodStructure();
                        if (method == null) {
                            assert (impl == MethodBody.Implementation.Delegating);
                            IdentityConstant idHost = body.getIdentity().getNamespace();
                            ClassStructure clzHost = (ClassStructure)idHost.getComponent();
                            method = clzHost.ensureMethodDelegation(this.getTopmostMethodStructure(infoType), body.getPropertyConstant().getName());
                            body.setMethodStructure(method);
                        } else if (method.isNative()) {
                            if (listNew == null) {
                                listNew = Handy.startList(chain, i);
                            }
                            body = new MethodBody(body, MethodBody.Implementation.Native);
                        }
                        if (listNew == null) continue block7;
                        listNew.add(body);
                        continue block7;
                    }
                    case Native: {
                        if (listDefault != null || listNew == null) continue block7;
                        listNew.add(body);
                        break block7;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (listNew != null) {
                if (listDefault != null) {
                    listNew.addAll(listDefault);
                }
                chain = listNew.isEmpty() ? MethodBody.NO_BODIES : listNew.toArray(MethodBody.NO_BODIES);
            }
            this.m_aBodyResolved = chain;
        }
        return chain;
    }

    public boolean hasSuper(TypeInfo infoType) {
        return this.getSuper(infoType) != null;
    }

    public SignatureConstant getSuper(TypeInfo infoType) {
        PropertyInfo infoProp;
        PropertyStructure property;
        MethodBody[] chain = this.m_aBodyResolved;
        if (chain != null) {
            return chain.length > 1 ? chain[1].getSignature() : null;
        }
        chain = this.getChain();
        MethodBody bodyHead = chain[0];
        if (bodyHead.getImplementation() == MethodBody.Implementation.Capped) {
            return infoType.getMethodByNestedId(bodyHead.getNarrowingNestedIdentity()).getSuper(infoType);
        }
        MethodStructure method = bodyHead.getMethodStructure();
        Component container = method.getParent().getParent();
        if (container instanceof PropertyStructure && (method == (property = (PropertyStructure)container).getGetter() || method == property.getSetter()) && (infoProp = infoType.findProperty(property.getIdentityConstant())).hasField()) {
            return method.getIdentityConstant().getSignature();
        }
        MethodBody bodySuper = this.findSuper(infoType, chain);
        if (bodySuper == null) {
            return null;
        }
        SignatureConstant sigSuper = bodySuper.getSignature();
        if (bodyHead.getSignature().containsAutoNarrowing(false)) {
            sigSuper = sigSuper.resolveAutoNarrowing(this.pool(), infoType.getType(), null);
        }
        if (sigSuper.containsTypeParameters()) {
            sigSuper = sigSuper.resolveGenericTypes(this.pool(), bodyHead.getIdentity());
        }
        return sigSuper;
    }

    private MethodBody findSuper(TypeInfo infoType, MethodBody[] chain) {
        boolean fAnno = infoType.getFormat() == Component.Format.ANNOTATION;
        boolean fMixin = infoType.getFormat() == Component.Format.MIXIN;
        MethodBody bodySuper = null;
        int cMethods = 0;
        for (MethodBody body : chain) {
            switch (body.getImplementation()) {
                case Implicit: {
                    if (!fAnno && !fMixin) break;
                    ++cMethods;
                    break;
                }
                case SansCode: 
                case Declared: 
                case Abstract: 
                case Capped: {
                    break;
                }
                case Default: 
                case Delegating: {
                    ++cMethods;
                    break;
                }
                case Native: 
                case Explicit: 
                case Field: {
                    TypeConstant typeThis;
                    if (cMethods > 0 && !fAnno && !fMixin && (typeThis = infoType.getType()).isSingleDefiningConstant() && typeThis.getDefiningConstant().equals(body.getIdentity().getNamespace())) {
                        cMethods = 0;
                        bodySuper = null;
                    }
                    ++cMethods;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (cMethods != 2 || bodySuper != null) continue;
            bodySuper = body;
        }
        return bodySuper;
    }

    public Constants.Access getAccess() {
        for (MethodBody body : this.m_aBody) {
            MethodStructure struct = body.getMethodStructure();
            if (struct == null) continue;
            return struct.getAccess();
        }
        return Constants.Access.PUBLIC;
    }

    public boolean isVisible(IdentityConstant idClz) {
        if (this.getHead().getAccess() == Constants.Access.PUBLIC) {
            return true;
        }
        for (MethodBody body : this.m_aBody) {
            if (!body.getIdentity().getClassIdentity().isNestMateOf(idClz)) continue;
            return true;
        }
        return false;
    }

    public boolean isAuto() {
        return this.getHead().isAuto();
    }

    public boolean isOp() {
        return this.getHead().findAnnotation(this.pool().clzOp()) != null;
    }

    public boolean isOp(String sName, String sOp, int cParams) {
        return this.getHead().isOp(sName, sOp, cParams);
    }

    public int getRank() {
        return this.f_nRank;
    }

    private ConstantPool pool() {
        return ConstantPool.getCurrentPool();
    }

    public JitMethodDesc getJitDesc(TypeSystem ts) {
        return this.getHead().getJitDesc(ts);
    }

    public int hashCode() {
        return this.getSignature().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodInfo)) {
            return false;
        }
        MethodInfo that = (MethodInfo)obj;
        return Arrays.equals(this.m_aBody, that.m_aBody);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSignature().getValueString());
        int i = 0;
        for (MethodBody body : this.m_aBody) {
            sb.append("\n    [").append(body.isConcrete() ? String.valueOf(i++) : "*").append("] ").append(body);
        }
        return sb.toString();
    }
}

