/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Version;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.VersionConstant;
import org.xvm.javajit.TypeSystem;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class ModuleConstant
extends IdentityConstant {
    private int m_iName;
    private int m_iVersion;
    private StringConstant m_constName;
    private VersionConstant m_constVersion;

    public ModuleConstant(ConstantPool pool, String sName) {
        this(pool, sName, null);
    }

    public ModuleConstant(ConstantPool pool, String sName, Version version) {
        super(pool);
        this.m_constName = pool.ensureStringConstant(sName);
        this.m_constVersion = version == null ? null : pool.ensureVersionConstant(version);
    }

    public ModuleConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iName = Handy.readMagnitude(in);
        this.m_iVersion = Handy.readIndex(in);
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_constName = (StringConstant)pool.getConstant(this.m_iName);
        this.m_constVersion = (VersionConstant)pool.getConstant(this.m_iVersion);
    }

    public String getUnqualifiedName() {
        String sName = this.getName();
        int ofDot = sName.indexOf(46);
        return ofDot < 0 ? sName : sName.substring(0, ofDot);
    }

    public String getDomainName() {
        String sName = this.getName();
        int ofDot = sName.indexOf(46);
        return ofDot < 0 ? null : sName.substring(ofDot + 1);
    }

    public Version getVersion() {
        VersionConstant constVersion = this.m_constVersion;
        return constVersion == null ? null : constVersion.getVersion();
    }

    public boolean isEcstasyModule() {
        return this.getName().equals("ecstasy.xtclang.org");
    }

    public boolean isCoreModule() {
        String sName = this.getName();
        return sName.equals("ecstasy.xtclang.org") || sName.equals("mack.xtclang.org") || sName.equals("_native.xtclang.org");
    }

    @Override
    public IdentityConstant getParentConstant() {
        return null;
    }

    @Override
    public IdentityConstant replaceParentConstant(IdentityConstant idParent) {
        return this;
    }

    @Override
    public String getName() {
        return this.m_constName.getValue();
    }

    @Override
    public ModuleConstant getModuleConstant() {
        return this;
    }

    @Override
    public List<IdentityConstant> getPath() {
        ArrayList<IdentityConstant> list = new ArrayList<IdentityConstant>();
        list.add(this);
        return list;
    }

    @Override
    public Component getComponent() {
        ModuleStructure struct = this.getFileStructure().getModule(this);
        if (struct == null) {
            return null;
        }
        ModuleStructure structOrigin = struct.getFingerprintOrigin();
        return structOrigin == null ? struct : structOrigin;
    }

    @Override
    public String getPathString() {
        return "";
    }

    @Override
    protected StringBuilder buildPath() {
        return new StringBuilder();
    }

    @Override
    public boolean trailingPathEquals(IdentityConstant that, int cSegments) {
        return this.trailingSegmentEquals(that);
    }

    @Override
    public IdentityConstant appendTrailingSegmentTo(IdentityConstant that) {
        throw new IllegalStateException(this.toString());
    }

    @Override
    public String getNestedName() {
        return null;
    }

    @Override
    public String getJitName(TypeSystem ts) {
        return "$module";
    }

    @Override
    protected StringBuilder buildJitName(TypeSystem ts) {
        return new StringBuilder();
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Module;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constName);
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof ModuleConstant)) {
            return -1;
        }
        ModuleConstant idThat = (ModuleConstant)that;
        int n = this.m_constName.compareTo(idThat.m_constName);
        if (n != 0) {
            return n;
        }
        return this.m_constVersion == null ? (idThat.m_constVersion == null ? 0 : -1) : (idThat.m_constVersion == null ? 1 : this.m_constVersion.compareDetails(idThat.m_constVersion));
    }

    @Override
    public String getValueString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_constName.getValue());
        if (this.m_constVersion != null) {
            sb.append(" v:").append(this.m_constVersion.getVersion());
        }
        return sb.toString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constName = (StringConstant)pool.register(this.m_constName);
        this.m_constVersion = (VersionConstant)pool.register(this.m_constVersion);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constName.getPosition());
        Handy.writePackedLong(out, Constant.indexOf(this.m_constVersion));
    }

    @Override
    public String getDescription() {
        return "module=" + this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constName, Hash.of(this.m_constVersion));
    }
}

