/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public abstract class MultiCondition
extends ConditionalConstant {
    private int[] m_aiCond;
    protected ConditionalConstant[] m_aconstCond;

    protected MultiCondition(ConstantPool pool, ConditionalConstant[] aconstCond) {
        super(pool);
        if (aconstCond == null) {
            throw new IllegalArgumentException("conditions required");
        }
        int c = aconstCond.length;
        if (c < 1 || c > 1000) {
            throw new IllegalArgumentException("# conditions: " + c);
        }
        for (int i = 0; i < c; ++i) {
            if (aconstCond[i] != null) continue;
            throw new IllegalArgumentException("condition " + i + " required");
        }
        this.m_aconstCond = aconstCond;
    }

    protected MultiCondition(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        int c = Handy.readMagnitude(in);
        if (c < 2 || c > 63) {
            throw new IllegalStateException("# conditions=" + c);
        }
        int[] ai = new int[c];
        for (int i = 0; i < c; ++i) {
            ai[i] = Handy.readMagnitude(in);
        }
        this.m_aiCond = ai;
    }

    @Override
    protected void resolveConstants() {
        int[] ai = this.m_aiCond;
        int c = ai.length;
        ConditionalConstant[] aconstCond = new ConditionalConstant[c];
        if (c > 0) {
            ConstantPool pool = this.getConstantPool();
            for (int i = 0; i < c; ++i) {
                aconstCond[i] = (ConditionalConstant)pool.getConstant(ai[i]);
            }
        }
        this.m_aconstCond = aconstCond;
    }

    @Override
    public void collectTerminals(Set<ConditionalConstant> terminals) {
        for (ConditionalConstant cond : this.m_aconstCond) {
            cond.collectTerminals(terminals);
        }
    }

    @Override
    public boolean containsTerminal(ConditionalConstant that) {
        for (ConditionalConstant cond : this.m_aconstCond) {
            if (!cond.containsTerminal(that)) continue;
            return true;
        }
        return false;
    }

    public Iterator<ConditionalConstant> flatIterator() {
        return new Iterator<ConditionalConstant>(){
            final ConditionalConstant[] acond;
            int iNext;
            Iterator<ConditionalConstant> iterSub;
            {
                this.acond = MultiCondition.this.m_aconstCond;
                this.iNext = 0;
                this.iterSub = null;
            }

            @Override
            public boolean hasNext() {
                return this.iNext < this.acond.length || this.iterSub != null;
            }

            @Override
            public ConditionalConstant next() {
                if (this.iterSub != null) {
                    ConditionalConstant cond = this.iterSub.next();
                    if (!this.iterSub.hasNext()) {
                        this.iterSub = null;
                    }
                    return cond;
                }
                if (this.iNext < this.acond.length) {
                    ConditionalConstant cond;
                    if ((cond = this.acond[this.iNext++]).getClass() == MultiCondition.this.getClass()) {
                        this.iterSub = ((MultiCondition)cond).flatIterator();
                        return this.next();
                    }
                    return cond;
                }
                throw new NoSuchElementException();
            }
        };
    }

    protected abstract String getOperatorString();

    public ConditionalConstant remove(ConditionalConstant cond) {
        ConditionalConstant[] acond = this.m_aconstCond;
        int c = acond.length;
        for (int i = 0; i < c; ++i) {
            if (!acond[i].equals(cond)) continue;
            return this.remove(i);
        }
        return this;
    }

    public ConditionalConstant remove(int i) {
        ConditionalConstant[] acondOld = this.m_aconstCond;
        int cConds = acondOld.length;
        assert (i >= 0 && i < cConds);
        if (cConds < 2) {
            throw new IllegalStateException("length=" + cConds);
        }
        if (cConds == 2) {
            return acondOld[-(i - 1)];
        }
        ConditionalConstant[] acondNew = new ConditionalConstant[cConds - 1];
        System.arraycopy(acondOld, 0, acondNew, 0, i);
        System.arraycopy(acondOld, i + 1, acondNew, i, cConds - i - 1);
        return this.instantiate(acondNew);
    }

    protected abstract MultiCondition instantiate(ConditionalConstant[] var1);

    @Override
    public boolean containsUnresolved() {
        if (this.isHashCached()) {
            return false;
        }
        for (ConditionalConstant constant : this.m_aconstCond) {
            if (!constant.containsUnresolved()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        for (ConditionalConstant constant : this.m_aconstCond) {
            visitor.accept(constant);
        }
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof MultiCondition)) {
            return -1;
        }
        return this.equals(that) ? 0 : Handy.compareArrays(this.m_aconstCond, ((MultiCondition)that).m_aconstCond);
    }

    @Override
    public String getValueString() {
        ConditionalConstant[] aconstCond = this.m_aconstCond;
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(this.m_aconstCond[0].getValueString());
        int c = aconstCond.length;
        for (int i = 1; i < c; ++i) {
            sb.append(' ').append(this.getOperatorString()).append(' ').append(aconstCond[i].getValueString());
        }
        return sb.append(')').toString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_aconstCond = (ConditionalConstant[])MultiCondition.registerConstants(pool, this.m_aconstCond);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        ConditionalConstant[] aconstCond = this.m_aconstCond;
        Handy.writePackedLong(out, aconstCond.length);
        for (ConditionalConstant constCond : aconstCond) {
            Handy.writePackedLong(out, constCond.getPosition());
        }
    }

    @Override
    public int computeHashCode() {
        int nHash = 0;
        for (ConditionalConstant cond : this.m_aconstCond) {
            nHash ^= cond.hashCode();
        }
        return Hash.of(this.getOperatorString(), nHash);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MultiCondition)) {
            return false;
        }
        MultiCondition that = (MultiCondition)obj;
        if (!this.getOperatorString().equals(that.getOperatorString())) {
            return false;
        }
        ConditionalConstant[] aconstThis = this.m_aconstCond;
        int cConds = aconstThis.length;
        ConditionalConstant[] aconstThat = that.m_aconstCond;
        if (cConds != aconstThat.length) {
            return false;
        }
        int cSeqMatch = 0;
        for (int i = 0; i < cConds && aconstThis[i].equals(aconstThat[i]); ++i) {
            ++cSeqMatch;
        }
        if (cSeqMatch < cConds) {
            boolean[] matched = new boolean[cConds];
            for (int iThis = cSeqMatch; iThis < cConds; ++iThis) {
                block8: {
                    ConditionalConstant constThis = aconstThis[iThis];
                    for (int iThat = cSeqMatch; iThat < cConds; ++iThat) {
                        if (matched[iThat] || !constThis.equals(aconstThat[iThat])) {
                            continue;
                        }
                        break block8;
                    }
                    return false;
                }
                matched[iThat] = true;
            }
        }
        return true;
    }
}

