/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.NamedConstant;

public class MultiMethodConstant
extends NamedConstant {
    public MultiMethodConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    public MultiMethodConstant(ConstantPool pool, IdentityConstant constParent, String sName) {
        super(pool, constParent, sName);
        switch (constParent.getFormat()) {
            case Module: 
            case Package: 
            case Class: 
            case NativeClass: 
            case Method: 
            case Property: 
            case FormalTypeChild: 
            case TypeParameter: 
            case DynamicFormal: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid parent: " + String.valueOf((Object)constParent.getFormat()));
            }
        }
    }

    @Override
    public IdentityConstant replaceParentConstant(IdentityConstant idParent) {
        return new MultiMethodConstant(this.getConstantPool(), idParent, this.getName());
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.MultiMethod;
    }

    @Override
    public MultiMethodStructure relocateNestedIdentity(ClassStructure clz) {
        Component parent = this.getNamespace().relocateNestedIdentity(clz);
        if (parent == null) {
            return null;
        }
        Component that = parent.getChild(this.getName());
        return that instanceof MultiMethodStructure ? (MultiMethodStructure)that : null;
    }

    @Override
    public MultiMethodConstant ensureNestedIdentity(ConstantPool pool, IdentityConstant that) {
        return pool.ensureMultiMethodConstant(this.getParentConstant().ensureNestedIdentity(pool, that), this.getName());
    }

    @Override
    public IdentityConstant appendTrailingSegmentTo(IdentityConstant that) {
        return that.getConstantPool().ensureMultiMethodConstant(that, this.getName());
    }

    @Override
    public String getDescription() {
        return "multimethod=" + this.getValueString();
    }
}

