/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class NamedCondition
extends ConditionalConstant {
    private transient int m_iName;
    private StringConstant m_constName;

    public NamedCondition(ConstantPool pool, StringConstant constName) {
        super(pool);
        assert (constName != null);
        this.m_constName = constName;
    }

    public NamedCondition(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iName = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_constName = (StringConstant)this.getConstantPool().getConstant(this.m_iName);
    }

    public String getName() {
        return this.m_constName.getValue();
    }

    @Override
    public boolean evaluate(LinkerContext ctx) {
        return ctx.isSpecified(this.m_constName.getValue());
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public ConditionalConstant.Relation calcRelation(ConditionalConstant that) {
        assert (that.isTerminal());
        if (that instanceof NamedCondition) {
            return this.m_constName.equals(((NamedCondition)that).m_constName) ? ConditionalConstant.Relation.EQUIV : ConditionalConstant.Relation.INDEP;
        }
        return ConditionalConstant.Relation.INDEP;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ConditionNamed;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constName);
    }

    @Override
    protected Object getLocator() {
        return this.getName();
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof NamedCondition)) {
            return -1;
        }
        return this.getName().compareTo(((NamedCondition)that).getName());
    }

    @Override
    public String getValueString() {
        return "isSpecified(\"" + this.getName() + "\")";
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constName = (StringConstant)pool.register(this.m_constName);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constName.getPosition());
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constName);
    }
}

