/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public abstract class NamedConstant
extends IdentityConstant {
    private int m_iParent;
    private int m_iName;
    private IdentityConstant m_constParent;
    private StringConstant m_constName;

    public NamedConstant(ConstantPool pool, IdentityConstant constParent, String sName) {
        super(pool);
        if (constParent == null) {
            throw new IllegalArgumentException("parent required");
        }
        if (sName == null) {
            throw new IllegalArgumentException("name required");
        }
        this.m_constParent = constParent;
        this.m_constName = pool.ensureStringConstant(sName);
    }

    public NamedConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iParent = Handy.readMagnitude(in);
        this.m_iName = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_constParent = (IdentityConstant)pool.getConstant(this.m_iParent);
        this.m_constName = (StringConstant)pool.getConstant(this.m_iName);
    }

    @Override
    public IdentityConstant getParentConstant() {
        return this.m_constParent;
    }

    public StringConstant getNameConstant() {
        return this.m_constName;
    }

    @Override
    public String getName() {
        return this.m_constName.getValue();
    }

    @Override
    public abstract Constant.Format getFormat();

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constParent);
        visitor.accept(this.m_constName);
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof NamedConstant)) {
            return -1;
        }
        int n = this.m_constParent.compareTo(((NamedConstant)that).m_constParent);
        if (n == 0) {
            n = this.getName().compareTo(((NamedConstant)that).getName());
        }
        return n;
    }

    @Override
    public String getValueString() {
        Object sParent;
        IdentityConstant constParent = this.m_constParent;
        return (String)sParent + (switch (constParent.getFormat()) {
            case Constant.Format.Module -> {
                sParent = ((ModuleConstant)constParent).getUnqualifiedName();
                yield ':';
            }
            case Constant.Format.Package, Constant.Format.Class, Constant.Format.NativeClass -> {
                sParent = constParent.getValueString();
                yield '.';
            }
            case Constant.Format.Property -> {
                sParent = ((NamedConstant)constParent).getName();
                yield '#';
            }
            case Constant.Format.Method -> {
                sParent = ((MethodConstant)constParent).getName() + "(?)";
                yield '#';
            }
            case Constant.Format.TypeParameter, Constant.Format.FormalTypeChild -> {
                sParent = ((NamedConstant)constParent).getName();
                yield '.';
            }
            default -> throw new IllegalStateException("parent=" + String.valueOf(constParent));
        }) + this.m_constName.getValue();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constParent = (IdentityConstant)pool.register(this.m_constParent);
        this.m_constName = (StringConstant)pool.register(this.m_constName);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constParent.getPosition());
        Handy.writePackedLong(out, this.m_constName.getPosition());
    }

    @Override
    public abstract String getDescription();

    @Override
    protected int computeHashCode() {
        return Hash.of(this.m_constParent, Hash.of(this.m_constName));
    }
}

