/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataOutput;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.util.Hash;

public class NativeRebaseConstant
extends ClassConstant {
    private final ClassConstant m_constIface;

    public NativeRebaseConstant(ClassConstant constIface) {
        super(constIface.getConstantPool(), constIface.getParentConstant(), constIface.getName());
        assert (constIface.getComponent().getFormat() == Component.Format.INTERFACE);
        this.m_constIface = constIface;
    }

    public ClassConstant getClassConstant() {
        return this.m_constIface;
    }

    @Override
    public IdentityConstant replaceParentConstant(IdentityConstant idParent) {
        return new NativeRebaseConstant((ClassConstant)this.getClassConstant().replaceParentConstant(idParent));
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && (super.containsUnresolved() || this.m_constIface.containsUnresolved());
    }

    @Override
    public boolean validate(ErrorListener errs) {
        return true;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.NativeClass;
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof NativeRebaseConstant)) {
            return -1;
        }
        return this.m_constIface.compareDetails(((NativeRebaseConstant)that).m_constIface);
    }

    @Override
    protected void assemble(DataOutput out) {
        throw new IllegalStateException();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constIface);
    }

    @Override
    public String toString() {
        return this.getValueString();
    }

    @Override
    public String getValueString() {
        return "Native(" + this.m_constIface.getValueString() + ")";
    }
}

