/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class NotCondition
extends ConditionalConstant {
    private transient int m_iCond;
    private ConditionalConstant m_constCond;

    public NotCondition(ConstantPool pool, ConditionalConstant constCond) {
        super(pool);
        if (constCond == null) {
            throw new IllegalArgumentException("condition required");
        }
        this.m_constCond = constCond;
    }

    public NotCondition(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iCond = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_constCond = (ConditionalConstant)this.getConstantPool().getConstant(this.m_iCond);
    }

    public ConditionalConstant getUnderlyingCondition() {
        return this.m_constCond;
    }

    @Override
    public boolean evaluate(LinkerContext ctx) {
        return !this.m_constCond.evaluate(ctx);
    }

    @Override
    public boolean testEvaluate(long n) {
        return !this.m_constCond.testEvaluate(n);
    }

    @Override
    public void collectTerminals(Set<ConditionalConstant> terminals) {
        this.m_constCond.collectTerminals(terminals);
    }

    @Override
    public boolean containsTerminal(ConditionalConstant that) {
        if (this.equals(that)) {
            return true;
        }
        return this.m_constCond.containsTerminal(that);
    }

    @Override
    public boolean isTerminalInfluenceBruteForce() {
        return !this.isTerminalInfluenceFinessable(true, new HashSet<ConditionalConstant>(), new HashSet<ConditionalConstant>());
    }

    @Override
    protected boolean isTerminalInfluenceFinessable(boolean fInNot, Set<ConditionalConstant> setSimple, Set<ConditionalConstant> setComplex) {
        return this.m_constCond.isTerminalInfluenceFinessable(true, setSimple, setComplex);
    }

    @Override
    public Map<ConditionalConstant, ConditionalConstant.Influence> terminalInfluences() {
        if (this.isTerminalInfluenceBruteForce()) {
            return super.terminalInfluences();
        }
        Map<ConditionalConstant, ConditionalConstant.Influence> mapRaw = this.m_constCond.terminalInfluences();
        HashMap<ConditionalConstant, ConditionalConstant.Influence> mapInv = new HashMap<ConditionalConstant, ConditionalConstant.Influence>();
        for (Map.Entry<ConditionalConstant, ConditionalConstant.Influence> entry : mapRaw.entrySet()) {
            mapInv.put(entry.getKey(), entry.getValue().inverse());
        }
        return mapInv;
    }

    @Override
    public ConditionalConstant negate() {
        return this.m_constCond;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ConditionNot;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_constCond.containsUnresolved();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constCond);
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof NotCondition)) {
            return -1;
        }
        return this.m_constCond.compareTo(((NotCondition)that).m_constCond);
    }

    @Override
    public String getValueString() {
        return "!" + this.m_constCond.getValueString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constCond = (ConditionalConstant)pool.register(this.m_constCond);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constCond.getPosition());
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constCond);
    }
}

