/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.NamedConstant;

public class PackageConstant
extends NamedConstant {
    public PackageConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    public PackageConstant(ConstantPool pool, IdentityConstant constParent, String sName) {
        super(pool, constParent, sName);
        if (constParent.getFormat() != Constant.Format.Module && constParent.getFormat() != Constant.Format.Package) {
            throw new IllegalArgumentException("parent module or package required");
        }
    }

    @Override
    public IdentityConstant replaceParentConstant(IdentityConstant idParent) {
        return new PackageConstant(this.getConstantPool(), idParent, this.getName());
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Package;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public IdentityConstant appendTrailingSegmentTo(IdentityConstant that) {
        return that.getConstantPool().ensurePackageConstant(that, this.getName());
    }

    @Override
    public String getDescription() {
        IdentityConstant constParent = this.getNamespace();
        while (constParent instanceof PackageConstant) {
            constParent = ((PackageConstant)constParent).getNamespace();
        }
        return "package=" + this.getValueString() + ", " + constParent.getDescription();
    }
}

