/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import org.xvm.asm.Constant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;

public class ParamInfo {
    private final Object f_nid;
    private final String f_sName;
    private final TypeConstant f_typeConstraint;
    private final TypeConstant f_typeActual;

    public ParamInfo(String sName, TypeConstant typeConstraint, TypeConstant typeActual) {
        this(sName, sName, typeConstraint, typeActual);
    }

    public ParamInfo(Object nid, String sName, TypeConstant typeConstraint, TypeConstant typeActual) {
        assert (nid != null);
        assert (sName != null);
        assert (typeConstraint != null);
        this.f_nid = nid;
        this.f_sName = sName;
        this.f_typeConstraint = typeConstraint;
        this.f_typeActual = typeActual;
    }

    public String getName() {
        return this.f_sName;
    }

    public TypeConstant getConstraintType() {
        return this.f_typeConstraint;
    }

    public TypeConstant getActualType() {
        return this.f_typeActual == null ? this.f_typeConstraint : this.f_typeActual;
    }

    public boolean isActualTypeSpecified() {
        return this.f_typeActual != null;
    }

    public Object getNestedIdentity() {
        return this.f_nid;
    }

    public boolean isFormalType() {
        TypeConstant typeActual = this.f_typeActual;
        return typeActual != null && typeActual.isSingleDefiningConstant() && typeActual.getDefiningConstant().getFormat() == Constant.Format.Property;
    }

    public String getFormalTypeName() {
        assert (this.isFormalType());
        return ((PropertyConstant)this.f_typeActual.getDefiningConstant()).getName();
    }

    public boolean isFormalTypeSequence() {
        return this.f_typeConstraint.isFormalTypeSequence();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.isActualTypeSpecified() ? this.getActualType().getValueString() : this.getName());
        TypeConstant typeConstraint = this.getConstraintType();
        if (!typeConstraint.equals(typeConstraint.getConstantPool().typeObject()) && !typeConstraint.isTuple()) {
            sb.append(" extends ").append(typeConstraint.getValueString());
        }
        sb.append(">");
        return sb.toString();
    }
}

