/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.Register;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.Severity;

public class ParameterizedTypeConstant
extends TypeConstant {
    private transient int m_iType;
    private transient int[] m_aiTypeParams;
    private TypeConstant m_constType;
    private TypeConstant[] m_atypeParams;
    private final StampedLock m_lockPrev = new StampedLock();
    private transient TypeConstant m_typeResolverPrev;
    private transient TypeConstant m_typeResolvedPrev;

    public ParameterizedTypeConstant(ConstantPool pool, TypeConstant constType, TypeConstant ... constTypeParams) {
        super(pool);
        if (constType == null) {
            throw new IllegalArgumentException("type required");
        }
        if (constType.isParamsSpecified()) {
            throw new IllegalArgumentException("type is already parameterized");
        }
        switch (constType.getFormat()) {
            case TerminalType: 
            case VirtualChildType: 
            case InnerChildType: 
            case AnonymousClassType: 
            case UnresolvedType: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid format: " + String.valueOf(constType));
            }
        }
        if (constTypeParams == null) {
            throw new IllegalArgumentException("must have parameters");
        }
        this.m_constType = constType;
        this.m_atypeParams = constTypeParams;
    }

    public ParameterizedTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iType = Handy.readIndex(in);
        int cTypes = Handy.readMagnitude(in);
        if (cTypes > 0) {
            int[] aiType = new int[cTypes];
            for (int i = 0; i < cTypes; ++i) {
                aiType[i] = Handy.readIndex(in);
            }
            this.m_aiTypeParams = aiType;
        }
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_constType = (TypeConstant)pool.getConstant(this.m_iType);
        if (this.m_aiTypeParams == null) {
            this.m_atypeParams = ConstantPool.NO_TYPES;
        } else {
            int cParams = this.m_aiTypeParams.length;
            TypeConstant[] atypeParams = new TypeConstant[cParams];
            for (int i = 0; i < cParams; ++i) {
                atypeParams[i] = (TypeConstant)pool.getConstant(this.m_aiTypeParams[i]);
            }
            this.m_atypeParams = atypeParams;
            this.m_aiTypeParams = null;
        }
    }

    @Override
    public boolean isModifyingType() {
        return true;
    }

    @Override
    public TypeConstant getUnderlyingType() {
        return this.m_constType;
    }

    @Override
    public boolean isShared(ConstantPool poolOther) {
        if (!super.isShared(poolOther)) {
            return false;
        }
        for (TypeConstant typeParam : this.m_atypeParams) {
            if (typeParam.isShared(poolOther)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isParamsSpecified() {
        return true;
    }

    @Override
    public List<TypeConstant> getParamTypes() {
        return this.m_atypeParams.length == 0 ? Collections.emptyList() : Arrays.asList(this.m_atypeParams);
    }

    @Override
    public TypeConstant[] getParamTypesArray() {
        return this.m_atypeParams;
    }

    @Override
    public int getTypeDepth() {
        int nDepth = 1;
        for (TypeConstant typeParam : this.m_atypeParams) {
            nDepth = Math.max(nDepth, typeParam.getTypeDepth() + 1);
        }
        return nDepth;
    }

    @Override
    protected TypeConstant getGenericParamType(String sName, List<TypeConstant> listParams) {
        assert (listParams.isEmpty());
        return super.getGenericParamType(sName, this.getParamTypes());
    }

    @Override
    public boolean isExplicitClassIdentity(boolean fAllowParams) {
        return fAllowParams && this.getUnderlyingType().isExplicitClassIdentity(false);
    }

    @Override
    public boolean containsAutoNarrowing(boolean fAllowVirtChild) {
        if (this.m_constType.containsAutoNarrowing(fAllowVirtChild)) {
            return true;
        }
        for (TypeConstant typeParam : this.m_atypeParams) {
            if (!typeParam.containsAutoNarrowing(fAllowVirtChild)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TypeConstant getExplicitClassInto(boolean fResolve) {
        TypeConstant constResolved = this.m_constType.getExplicitClassInto();
        return fResolve ? constResolved.resolveGenerics(this.getConstantPool(), this) : constResolved;
    }

    @Override
    public TypeConstant resolveTypedefs() {
        TypeConstant[] aconstOriginal;
        boolean fDiff;
        TypeConstant constOriginal = this.m_constType;
        TypeConstant constResolved = constOriginal.resolveTypedefs();
        boolean bl = fDiff = constOriginal != constResolved;
        if (constResolved.isParamsSpecified()) {
            System.err.println("Unexpected type parameters for " + constOriginal.getValueString());
            return constResolved;
        }
        TypeConstant[] aconstResolved = aconstOriginal = this.m_atypeParams;
        int c = aconstOriginal.length;
        for (int i = 0; i < c; ++i) {
            TypeConstant constParamOriginal = aconstOriginal[i];
            TypeConstant constParamResolved = constParamOriginal.resolveTypedefs();
            if (constParamOriginal == constParamResolved) continue;
            if (aconstResolved == aconstOriginal) {
                aconstResolved = (TypeConstant[])aconstOriginal.clone();
            }
            aconstResolved[i] = constParamResolved;
            fDiff = true;
        }
        return fDiff ? this.getConstantPool().ensureParameterizedTypeConstant(constResolved, aconstResolved) : this;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public TypeConstant resolveGenerics(ConstantPool pool, GenericTypeResolver resolver) {
        if (!(resolver instanceof TypeConstant)) ** GOTO lbl-1000
        typeResolver = (TypeConstant)resolver;
        if (pool == this.getConstantPool() && pool == typeResolver.getConstantPool()) {
            fCache = true;
            typeResolver = typeResolver.removeAccess();
            stamp = this.m_lockPrev.tryOptimisticRead();
            if (stamp != 0L) {
                typeResolvedPrev = this.m_typeResolvedPrev;
                if (typeResolver.equals(this.m_typeResolverPrev) && this.m_lockPrev.validate(stamp)) {
                    return typeResolvedPrev;
                }
            }
        } else lbl-1000:
        // 2 sources

        {
            fCache = false;
        }
        v0 = fDiff = (constOriginal = this.m_constType) != (constResolved = constOriginal.resolveGenerics(pool, resolver));
        if (!ParameterizedTypeConstant.$assertionsDisabled && constResolved.isParamsSpecified()) {
            throw new AssertionError();
        }
        aconstResolved = aconstOriginal = this.m_atypeParams;
        c = aconstOriginal.length;
        for (i = 0; i < c; ++i) {
            constParamOriginal = aconstOriginal[i];
            constParamResolved = constParamOriginal.resolveGenerics(pool, resolver);
            if (constParamOriginal == constParamResolved) continue;
            if (constOriginal.isTuple() && constParamOriginal.isFormalTypeSequence()) {
                if (!(ParameterizedTypeConstant.$assertionsDisabled || c == 1 && constParamResolved.isTuple())) {
                    throw new AssertionError();
                }
                aconstResolved = constParamResolved.getParamTypesArray();
            } else {
                if (aconstResolved == aconstOriginal) {
                    aconstResolved = (TypeConstant[])aconstOriginal.clone();
                }
                aconstResolved[i] = constParamResolved;
            }
            fDiff = true;
        }
        v1 /* !! */  = typeResolved = fDiff != false ? pool.ensureParameterizedTypeConstant(constResolved, aconstResolved) : this;
        if (fCache && (stamp = this.m_lockPrev.tryWriteLock()) != 0L) {
            this.m_typeResolvedPrev = typeResolved;
            this.m_typeResolverPrev = (TypeConstant)resolver;
            this.m_lockPrev.unlockWrite(stamp);
        }
        return typeResolved;
    }

    @Override
    public TypeConstant resolveConstraints(boolean fPendingOnly) {
        TypeConstant[] aconstOriginal;
        boolean fDiff;
        TypeConstant constOriginal = this.m_constType;
        TypeConstant constResolved = constOriginal.resolveConstraints(fPendingOnly);
        boolean bl = fDiff = constOriginal != constResolved;
        assert (!constResolved.isParamsSpecified());
        TypeConstant[] aconstResolved = aconstOriginal = this.m_atypeParams;
        int c = aconstOriginal.length;
        for (int i = 0; i < c; ++i) {
            TypeConstant constParamOriginal = aconstOriginal[i];
            TypeConstant constParamResolved = constParamOriginal.resolveConstraints(fPendingOnly);
            if (constParamOriginal == constParamResolved) continue;
            if (aconstResolved == aconstOriginal) {
                aconstResolved = (TypeConstant[])aconstOriginal.clone();
            }
            aconstResolved[i] = constParamResolved;
            fDiff = true;
        }
        return fDiff ? this.getConstantPool().ensureParameterizedTypeConstant(constResolved, aconstResolved) : this;
    }

    @Override
    public TypeConstant resolveDynamicConstraints(Register register) {
        TypeConstant[] aconstOriginal;
        TypeConstant constUnderlying = this.m_constType;
        assert (!constUnderlying.isDynamicType());
        TypeConstant[] aconstResolved = aconstOriginal = this.m_atypeParams;
        int c = aconstOriginal.length;
        for (int i = 0; i < c; ++i) {
            TypeConstant constParamOriginal = aconstOriginal[i];
            TypeConstant constParamResolved = constParamOriginal.resolveDynamicConstraints(register);
            if (constParamOriginal == constParamResolved) continue;
            if (aconstResolved == aconstOriginal) {
                aconstResolved = (TypeConstant[])aconstOriginal.clone();
            }
            aconstResolved[i] = constParamResolved;
        }
        return aconstResolved == aconstOriginal ? this : this.getConstantPool().ensureParameterizedTypeConstant(constUnderlying, aconstResolved);
    }

    @Override
    public boolean containsFormalType(boolean fAllowParams) {
        if (fAllowParams) {
            for (TypeConstant typeParam : this.m_atypeParams) {
                if (!typeParam.containsFormalType(true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void collectFormalTypes(boolean fAllowParams, Set<TypeConstant> setFormal) {
        if (fAllowParams) {
            for (TypeConstant typeParam : this.m_atypeParams) {
                typeParam.collectFormalTypes(fAllowParams, setFormal);
            }
        }
    }

    @Override
    public boolean containsDynamicType(Register register) {
        for (TypeConstant typeParam : this.m_atypeParams) {
            if (!typeParam.containsDynamicType(register)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsGenericType(boolean fAllowParams) {
        if (fAllowParams) {
            for (TypeConstant typeParam : this.m_atypeParams) {
                if (!typeParam.containsGenericType(fAllowParams)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsTypeParameter(boolean fAllowParams) {
        if (fAllowParams) {
            for (TypeConstant typeParam : this.m_atypeParams) {
                if (!typeParam.containsTypeParameter(true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsRecursiveType() {
        for (TypeConstant type : this.m_atypeParams) {
            if (!type.containsRecursiveType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public TypeConstant adoptParameters(ConstantPool pool, TypeConstant[] atypeParams) {
        if (atypeParams == null) {
            atypeParams = this.m_atypeParams;
        } else {
            int c = Math.min(atypeParams.length, this.m_atypeParams.length);
            for (int i = 0; i < c; ++i) {
                TypeConstant typeAdopt = atypeParams[i];
                TypeConstant typeCurr = this.m_atypeParams[i];
                if (typeAdopt.isA(typeCurr) || typeCurr.isFormalType()) continue;
                System.err.println("Un-adoptable type parameter " + String.valueOf(typeAdopt) + " for " + String.valueOf(this));
                atypeParams = this.m_atypeParams;
                break;
            }
        }
        return this.m_constType.adoptParameters(pool, atypeParams);
    }

    @Override
    public TypeConstant[] collectGenericParameters() {
        return null;
    }

    @Override
    public TypeConstant resolveAutoNarrowing(ConstantPool pool, boolean fRetainParams, TypeConstant typeTarget, IdentityConstant idCtx) {
        TypeConstant constOriginal = this.m_constType;
        TypeConstant constResolved = constOriginal.resolveAutoNarrowing(pool, fRetainParams, typeTarget, idCtx);
        if (fRetainParams) {
            IdentityConstant idClz;
            ClassStructure clz;
            if (constOriginal == constResolved) {
                return this;
            }
            if (constResolved.isParamsSpecified()) {
                return constResolved;
            }
            if (constResolved.isExplicitClassIdentity(true) && (clz = (ClassStructure)(idClz = constResolved.getSingleUnderlyingClass(true)).getComponent()).isParameterized()) {
                return pool.ensureParameterizedTypeConstant(constResolved, this.m_atypeParams);
            }
            return constResolved;
        }
        if (constOriginal == constResolved) {
            TypeConstant[] aconstOriginal;
            boolean fDiff = false;
            TypeConstant[] aconstResolved = aconstOriginal = this.m_atypeParams;
            int c = aconstOriginal.length;
            for (int i = 0; i < c; ++i) {
                TypeConstant constParamOriginal = aconstOriginal[i];
                TypeConstant constParamResolved = constParamOriginal.resolveAutoNarrowing(pool, false, typeTarget, idCtx);
                if (constParamOriginal == constParamResolved) continue;
                if (aconstResolved == aconstOriginal) {
                    aconstResolved = (TypeConstant[])aconstOriginal.clone();
                }
                aconstResolved[i] = constParamResolved;
                fDiff = true;
            }
            return fDiff ? pool.ensureParameterizedTypeConstant(constOriginal, aconstResolved) : this;
        }
        if (constResolved.isParamsSpecified()) {
            return constResolved;
        }
        if (constResolved.isExplicitClassIdentity(true)) {
            IdentityConstant idClz = constResolved.getSingleUnderlyingClass(true);
            ClassStructure clz = (ClassStructure)idClz.getComponent();
            if (clz.isParameterized()) {
                TypeConstant[] aconstOriginal;
                TypeConstant[] aconstResolved = aconstOriginal = this.m_atypeParams;
                int c = aconstOriginal.length;
                for (int i = 0; i < c; ++i) {
                    TypeConstant constParamOriginal = aconstOriginal[i];
                    TypeConstant constParamResolved = constParamOriginal.resolveAutoNarrowing(pool, false, typeTarget, idCtx);
                    if (constParamOriginal == constParamResolved) continue;
                    if (aconstResolved == aconstOriginal) {
                        aconstResolved = (TypeConstant[])aconstOriginal.clone();
                    }
                    aconstResolved[i] = constParamResolved;
                }
                return pool.ensureParameterizedTypeConstant(constResolved, aconstResolved);
            }
            return constResolved;
        }
        return constResolved;
    }

    @Override
    public TypeConstant resolveTypeParameter(TypeConstant typeActual, String sFormalName) {
        typeActual = typeActual.resolveTypedefs();
        block4: while (true) {
            if (!typeActual.isModifyingType()) {
                return typeActual.resolveGenericType(sFormalName);
            }
            switch (typeActual.getFormat()) {
                case ParameterizedType: {
                    break block4;
                }
                case AnnotatedType: {
                    TypeConstant typeAnno = ((AnnotatedTypeConstant)typeActual).getAnnotationType();
                    TypeConstant typeResolve = this.resolveTypeParameter(typeAnno, sFormalName);
                    if (typeResolve != null) {
                        return typeResolve;
                    }
                }
                default: {
                    typeActual = typeActual.getUnderlyingType();
                    continue block4;
                }
            }
            break;
        }
        ParameterizedTypeConstant that = (ParameterizedTypeConstant)typeActual;
        TypeConstant typeTermThis = this.m_constType;
        TypeConstant typeTermThat = that.m_constType;
        if (!typeTermThat.isA(typeTermThis)) {
            if (typeTermThis.isTypeOfType() && typeTermThat.equals(this.getConstantPool().typeClass())) {
                TypeConstant typeThis = this.getParamType(0);
                TypeConstant typeThat = that.getParamType(0);
                return typeThis.resolveTypeParameter(typeThat, sFormalName);
            }
            return null;
        }
        IdentityConstant idThis = typeTermThis.getSingleUnderlyingClass(true);
        IdentityConstant idThat = typeTermThat.getSingleUnderlyingClass(true);
        ClassStructure clzThis = (ClassStructure)idThis.getComponent();
        int iParam = clzThis.indexOfGenericParameter(sFormalName);
        if (iParam >= 0) {
            return idThis.equals(idThat) ? typeActual.getParamType(iParam) : typeActual.resolveGenericType(sFormalName);
        }
        if (idThis.equals(idThat)) {
            TypeConstant[] atypeThis = this.m_atypeParams;
            TypeConstant[] atypeThat = that.m_atypeParams;
            int c = Math.min(atypeThis.length, atypeThat.length);
            for (int i = 0; i < c; ++i) {
                TypeConstant typeResult = atypeThis[i].resolveTypeParameter(atypeThat[i], sFormalName);
                if (typeResult == null) continue;
                return typeResult;
            }
        } else {
            iParam = 0;
            for (StringConstant constName : clzThis.getTypeParams().keySet()) {
                TypeConstant typeThis;
                TypeConstant typeResult;
                TypeConstant typeThat = typeActual.resolveGenericType(constName.getValue());
                if (typeThat != null && (typeResult = (typeThis = this.m_atypeParams[iParam]).resolveTypeParameter(typeThat, sFormalName)) != null) {
                    return typeResult;
                }
                ++iParam;
            }
        }
        return null;
    }

    @Override
    public TypeConstant resolvePending(ConstantPool pool, TypeConstant typeActual) {
        if (typeActual instanceof ParameterizedTypeConstant) {
            ParameterizedTypeConstant that = (ParameterizedTypeConstant)typeActual;
            TypeConstant constUnderlyingThat = that.m_constType;
            TypeConstant constUnderlyingThis = this.m_constType;
            if (constUnderlyingThat.isA(constUnderlyingThis)) {
                TypeConstant[] aconstThis = this.m_atypeParams;
                TypeConstant[] aconstThat = that.m_atypeParams;
                TypeConstant[] aconstResolved = aconstThis;
                int c = Math.min(aconstThis.length, aconstThat.length);
                for (int i = 0; i < c; ++i) {
                    TypeConstant constParamOriginal = aconstThis[i];
                    TypeConstant constParamResolved = constParamOriginal.resolvePending(pool, aconstThat[i]);
                    if (constParamOriginal == constParamResolved) continue;
                    if (aconstResolved == aconstThis) {
                        aconstResolved = (TypeConstant[])aconstThis.clone();
                    }
                    aconstResolved[i] = constParamResolved;
                }
                return aconstResolved == aconstThis ? this : this.getConstantPool().ensureParameterizedTypeConstant(constUnderlyingThis, aconstResolved);
            }
        }
        return super.resolvePending(pool, typeActual);
    }

    @Override
    protected TypeConstant cloneSingle(ConstantPool pool, TypeConstant type) {
        return pool.ensureParameterizedTypeConstant(type, this.m_atypeParams);
    }

    @Override
    public ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, MethodConstant idMethod, ComponentResolver.ResolutionCollector collector) {
        ComponentResolver.ResolutionResult result = super.resolveContributedName(sName, access, idMethod, collector);
        if (result == ComponentResolver.ResolutionResult.RESOLVED) {
            return result;
        }
        for (TypeConstant typeParam : this.m_atypeParams) {
            ComponentResolver.ResolutionResult resultParam = typeParam.resolveContributedName(sName, access, idMethod, collector);
            if (resultParam != ComponentResolver.ResolutionResult.RESOLVED) continue;
            return resultParam;
        }
        return result;
    }

    @Override
    public TypeConstant widenEnumValueTypes() {
        TypeConstant[] aconstOriginal;
        TypeConstant constUnderlying = this.m_constType;
        TypeConstant[] aconstResolved = aconstOriginal = this.m_atypeParams;
        int c = aconstOriginal.length;
        for (int i = 0; i < c; ++i) {
            TypeConstant constParamOriginal = aconstOriginal[i];
            TypeConstant constParamResolved = constParamOriginal.widenEnumValueTypes();
            if (constParamOriginal == constParamResolved) continue;
            if (aconstResolved == aconstOriginal) {
                aconstResolved = (TypeConstant[])aconstOriginal.clone();
            }
            aconstResolved[i] = constParamResolved;
        }
        return aconstResolved == aconstOriginal ? this : this.getConstantPool().ensureParameterizedTypeConstant(constUnderlying, aconstResolved);
    }

    @Override
    protected Set<SignatureConstant> isInterfaceAssignableFrom(TypeConstant typeRight, Constants.Access accessLeft, List<TypeConstant> listLeft) {
        assert (listLeft.isEmpty());
        return super.isInterfaceAssignableFrom(typeRight, accessLeft, this.getParamTypes());
    }

    @Override
    public TypeConstant.Usage checkConsumption(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        assert (listParams.isEmpty());
        ConstantPool pool = this.getConstantPool();
        if (this.m_constType.equals(pool.typeFunction())) {
            TypeConstant[] atypeReturns;
            TypeConstant[] atypeParams = pool.extractFunctionParams(this);
            if (atypeParams != null) {
                for (TypeConstant typeParam : atypeParams) {
                    if (!typeParam.producesFormalType(sTypeName, access)) continue;
                    return TypeConstant.Usage.YES;
                }
            }
            if ((atypeReturns = pool.extractFunctionReturns(this)) != null) {
                for (TypeConstant typeReturn : atypeReturns) {
                    if (!typeReturn.consumesFormalType(sTypeName, access)) continue;
                    return TypeConstant.Usage.YES;
                }
            }
            return TypeConstant.Usage.NO;
        }
        return super.checkConsumption(sTypeName, access, this.getParamTypes());
    }

    @Override
    public TypeConstant.Usage checkProduction(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        assert (listParams.isEmpty());
        ConstantPool pool = this.getConstantPool();
        if (this.m_constType.equals(pool.typeFunction())) {
            TypeConstant[] atypeReturns;
            TypeConstant[] atypeParams = pool.extractFunctionParams(this);
            if (atypeParams != null) {
                for (TypeConstant typeParam : atypeParams) {
                    if (!typeParam.consumesFormalType(sTypeName, access)) continue;
                    return TypeConstant.Usage.YES;
                }
            }
            if ((atypeReturns = pool.extractFunctionReturns(this)) != null) {
                for (TypeConstant typeReturn : atypeReturns) {
                    if (!typeReturn.producesFormalType(sTypeName, access)) continue;
                    return TypeConstant.Usage.YES;
                }
                return TypeConstant.Usage.NO;
            }
        }
        return super.checkProduction(sTypeName, access, this.getParamTypes());
    }

    @Override
    public boolean containsSubstitutableMethod(SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams) {
        assert (listParams.isEmpty());
        return super.containsSubstitutableMethod(signature, access, fFunction, this.getParamTypes());
    }

    @Override
    public boolean isNullable() {
        assert (!this.m_constType.isNullable());
        return false;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ParameterizedType;
    }

    @Override
    public boolean containsUnresolved() {
        if (this.isHashCached()) {
            return false;
        }
        if (this.m_constType.containsUnresolved()) {
            return true;
        }
        for (TypeConstant param : this.m_atypeParams) {
            if (!param.containsUnresolved()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constType);
        for (TypeConstant param : this.m_atypeParams) {
            visitor.accept(param);
        }
    }

    @Override
    protected Object getLocator() {
        return this.m_atypeParams.length == 0 ? this.m_constType : null;
    }

    @Override
    protected int compareDetails(Constant obj) {
        if (!(obj instanceof ParameterizedTypeConstant)) {
            return -1;
        }
        ParameterizedTypeConstant that = (ParameterizedTypeConstant)obj;
        int n = this.m_constType.compareTo(that.m_constType);
        if (n == 0) {
            TypeConstant[] atypeThis = this.m_atypeParams;
            TypeConstant[] atypeThat = that.m_atypeParams;
            int c = Math.min(atypeThis.length, atypeThat.length);
            for (int i = 0; i < c; ++i) {
                n = atypeThis[i].compareTo(atypeThat[i]);
                if (n == 0) continue;
                return n;
            }
            n = atypeThis.length - atypeThat.length;
        }
        return n;
    }

    @Override
    public String getValueString() {
        StringBuilder sb = new StringBuilder();
        ConstantPool pool = this.getConstantPool();
        if (this.m_constType.isA(pool.typeFunction())) {
            int i;
            sb.append("function ");
            TypeConstant[] atypeParams = pool.extractFunctionParams(this);
            TypeConstant[] atypeReturns = pool.extractFunctionReturns(this);
            int cParams = atypeParams.length;
            int cReturns = atypeReturns.length;
            switch (cReturns) {
                case 0: {
                    sb.append("void");
                    break;
                }
                case 1: {
                    sb.append(atypeReturns[0].getValueString());
                    break;
                }
                default: {
                    sb.append('(');
                    for (i = 0; i < cReturns; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(atypeReturns[i].getValueString());
                    }
                    sb.append(')');
                }
            }
            sb.append('(');
            switch (cParams) {
                case 0: {
                    break;
                }
                case 1: {
                    sb.append(atypeParams[0].getValueString());
                    break;
                }
                default: {
                    for (i = 0; i < cParams; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(atypeParams[i].getValueString());
                    }
                }
            }
            sb.append(')');
        } else {
            sb.append(this.m_constType.getValueString()).append('<');
            boolean first = true;
            for (TypeConstant type : this.m_atypeParams) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(type.getValueString());
            }
            sb.append('>');
        }
        return sb.toString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constType = (TypeConstant)pool.register(this.m_constType);
        this.m_atypeParams = ParameterizedTypeConstant.registerTypeConstants(pool, this.m_atypeParams);
        long stamp = this.m_lockPrev.writeLock();
        this.m_typeResolverPrev = null;
        this.m_typeResolvedPrev = null;
        this.m_lockPrev.unlockWrite(stamp);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, ParameterizedTypeConstant.indexOf(this.m_constType));
        Handy.writePackedLong(out, this.m_atypeParams.length);
        for (TypeConstant constType : this.m_atypeParams) {
            Handy.writePackedLong(out, constType.getPosition());
        }
    }

    @Override
    public boolean validate(ErrorListener errs) {
        if (!this.isValidated()) {
            boolean fHalt = super.validate(errs);
            if (!fHalt && !this.m_constType.isExplicitClassIdentity(false)) {
                this.log(errs, Severity.ERROR, "VERIFY-31", this.m_constType.getValueString());
                fHalt = true;
            }
            for (TypeConstant type : this.m_atypeParams) {
                fHalt |= type.validate(errs);
            }
            return fHalt;
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Hash.of(this.m_constType, Hash.of(this.m_atypeParams));
    }
}

