/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.ThisClassConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class ParentClassConstant
extends PseudoConstant {
    private int m_iChild;
    private PseudoConstant m_constChild;

    public ParentClassConstant(ConstantPool pool, PseudoConstant constChild) {
        super(pool);
        if (constChild == null) {
            throw new IllegalArgumentException("child class required");
        }
        if (!(constChild instanceof ParentClassConstant) && !(constChild instanceof ThisClassConstant)) {
            throw new IllegalArgumentException("child must be an auto-narrowable class identity, either \"this:class\" or a parent class thereof (child=" + String.valueOf(constChild) + ")");
        }
        this.m_constChild = constChild;
    }

    public ParentClassConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iChild = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_constChild = (PseudoConstant)this.getConstantPool().getConstant(this.m_iChild);
    }

    public PseudoConstant getChildClass() {
        return this.m_constChild;
    }

    public int getDepth() {
        PseudoConstant idClz = this;
        int cDepth = 0;
        do {
            ++cDepth;
        } while ((idClz = idClz.getChildClass()) instanceof ParentClassConstant);
        assert (idClz instanceof ThisClassConstant);
        return cDepth;
    }

    @Override
    public IdentityConstant getDeclarationLevelClass() {
        PseudoConstant constChild = this.m_constChild;
        switch (constChild.getFormat()) {
            case ParentClass: 
            case ChildClass: 
            case ThisClass: {
                IdentityConstant idParent = constChild.getDeclarationLevelClass().getParentConstant();
                while (!idParent.isClass()) {
                    idParent = idParent.getParentConstant();
                }
                return idParent;
            }
        }
        throw new IllegalStateException("constChild=" + String.valueOf(constChild));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCongruentWith(PseudoConstant that) {
        if (!(that instanceof ParentClassConstant)) return false;
        ParentClassConstant thatParent = (ParentClassConstant)that;
        if (!this.m_constChild.isCongruentWith(thatParent.m_constChild)) return false;
        return true;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ParentClass;
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().ensureParentTypeConstant(this.m_constChild.getType());
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isAutoNarrowing() {
        return true;
    }

    @Override
    protected Object getLocator() {
        return this.m_constChild.getLocator() != null ? this.m_constChild : null;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_constChild.containsUnresolved();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constChild);
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof ParentClassConstant)) {
            return -1;
        }
        return this.m_constChild.compareTo(((ParentClassConstant)that).m_constChild);
    }

    @Override
    public String getValueString() {
        return this.m_constChild.getValueString() + ":parent";
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constChild = (PseudoConstant)pool.register(this.m_constChild);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constChild.getPosition());
    }

    @Override
    public String getDescription() {
        return "child=" + String.valueOf(this.m_constChild);
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constChild);
    }
}

