/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.PackageConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.UnresolvedNameConstant;
import org.xvm.asm.constants.VersionMatchesCondition;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class PresentCondition
extends ConditionalConstant {
    private transient int m_iStruct;
    private Constant m_constStruct;

    public PresentCondition(ConstantPool pool, Constant constVMStruct) {
        super(pool);
        assert (constVMStruct instanceof IdentityConstant || constVMStruct instanceof UnresolvedNameConstant);
        this.m_constStruct = constVMStruct;
    }

    public PresentCondition(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iStruct = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_constStruct = this.getConstantPool().getConstant(this.m_iStruct);
        assert (this.m_constStruct instanceof ModuleConstant || this.m_constStruct instanceof PackageConstant || this.m_constStruct instanceof ClassConstant || this.m_constStruct instanceof PropertyConstant || this.m_constStruct instanceof MethodConstant);
    }

    public IdentityConstant getPresentConstant() {
        return (IdentityConstant)this.m_constStruct;
    }

    @Override
    public boolean evaluate(LinkerContext ctx) {
        return ctx.isPresent((IdentityConstant)this.m_constStruct);
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public ConditionalConstant.Relation calcRelation(ConditionalConstant constant) {
        if (constant instanceof PresentCondition) {
            PresentCondition that = (PresentCondition)constant;
            IdentityConstant constThis = (IdentityConstant)this.m_constStruct;
            IdentityConstant constThat = (IdentityConstant)that.m_constStruct;
            if (constThis.equals(constThat)) {
                return ConditionalConstant.Relation.EQUIV;
            }
            if (constThis.getModuleConstant().equals(constThat.getModuleConstant())) {
                List<IdentityConstant> listThis = constThis.getPath();
                List<IdentityConstant> listThat = constThat.getPath();
                int cThis = listThis.size();
                int cThat = listThat.size();
                int c = Math.min(cThis, cThat);
                for (int i = 0; i < c; ++i) {
                    if (listThis.get(i).equals(listThat.get(i))) continue;
                    return ConditionalConstant.Relation.INDEP;
                }
                assert (cThis != cThat);
                return cThis > cThat ? ConditionalConstant.Relation.IMPLIES : ConditionalConstant.Relation.IMPLIED;
            }
        } else if (constant instanceof VersionMatchesCondition) {
            ModuleConstant constThatModule;
            ModuleConstant constThisModule;
            VersionMatchesCondition thatCond = (VersionMatchesCondition)constant;
            Constant constThis = this.m_constStruct;
            if (constThis instanceof ModuleConstant && (constThisModule = (ModuleConstant)constThis).equals(constThatModule = thatCond.getModuleConstant())) {
                return ConditionalConstant.Relation.IMPLIED;
            }
        }
        return ConditionalConstant.Relation.INDEP;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ConditionPresent;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_constStruct.containsUnresolved();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constStruct);
    }

    @Override
    protected int compareDetails(Constant obj) {
        if (!(obj instanceof PresentCondition)) {
            return -1;
        }
        PresentCondition that = (PresentCondition)obj;
        return this.m_constStruct.compareTo(that.m_constStruct);
    }

    @Override
    public String getValueString() {
        return "isPresent(" + this.m_constStruct.getValueString() + ")";
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constStruct = (IdentityConstant)pool.register(this.m_constStruct);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constStruct.getPosition());
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constStruct);
    }
}

