/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import org.xvm.asm.Annotation;
import org.xvm.asm.Constant;
import org.xvm.asm.Constants;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ParamInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.util.Handy;

public class PropertyBody
implements Constants {
    private final PropertyStructure m_structProp;
    private final MethodBody.Implementation m_impl;
    private final PropertyConstant m_constDelegate;
    private final ParamInfo m_infoFormal;
    private final TypeConstant m_type;
    private final boolean m_fRO;
    private final boolean m_fRW;
    private final boolean m_fCustom;
    private final Effect m_effectGet;
    private final Effect m_effectSet;
    private final boolean m_fField;
    private final boolean m_fConstant;
    private final Constant m_constInitVal;
    private final MethodConstant m_constInitFunc;

    public PropertyBody(PropertyStructure struct, MethodBody.Implementation impl, PropertyConstant constDelegate, TypeConstant type, boolean fRO, boolean fRW, boolean fCustomCode, Effect effectGet, Effect effectSet, boolean fReqField, boolean fConstant, Constant constInitVal, MethodConstant constInitFunc) {
        assert (struct != null);
        assert (type != null);
        assert (impl == MethodBody.Implementation.Implicit || impl == MethodBody.Implementation.Declared || impl == MethodBody.Implementation.Default || impl == MethodBody.Implementation.Delegating || impl == MethodBody.Implementation.Native || impl == MethodBody.Implementation.SansCode || impl == MethodBody.Implementation.Explicit);
        assert (impl == MethodBody.Implementation.Delegating ^ constDelegate == null);
        if (constInitVal != null && constInitFunc != null) {
            constInitFunc = null;
        } else if (fConstant && constInitVal == null && constInitFunc == null && !struct.isInjected()) {
            impl = MethodBody.Implementation.Implicit;
        }
        assert (effectGet != null && effectSet != null);
        this.m_structProp = struct;
        this.m_impl = struct != null && struct.isNative() ? MethodBody.Implementation.Native : impl;
        this.m_constDelegate = constDelegate;
        this.m_infoFormal = null;
        this.m_type = type;
        this.m_fRO = fRO;
        this.m_fRW = fRW;
        this.m_fCustom = fCustomCode;
        this.m_effectGet = effectGet;
        this.m_effectSet = effectSet;
        this.m_fField = fReqField;
        this.m_fConstant = fConstant;
        this.m_constInitVal = constInitVal;
        this.m_constInitFunc = constInitFunc;
    }

    public PropertyBody(PropertyStructure struct, ParamInfo infoFormal) {
        assert (infoFormal != null);
        assert (struct == null || struct.getName().equals(infoFormal.getName()));
        assert (struct != null || infoFormal.getNestedIdentity() instanceof IdentityConstant.NestedIdentity);
        TypeConstant typeActual = infoFormal.getActualType();
        TypeConstant typeType = struct != null && struct.getIdentityConstant().isTypeSequenceTypeParameter() ? struct.getType() : typeActual.getType();
        this.m_structProp = struct;
        this.m_impl = MethodBody.Implementation.Native;
        this.m_constDelegate = null;
        this.m_infoFormal = infoFormal;
        this.m_type = typeType;
        this.m_fRO = true;
        this.m_fRW = false;
        this.m_fCustom = false;
        this.m_fField = false;
        this.m_fConstant = false;
        this.m_constInitVal = null;
        this.m_constInitFunc = null;
        this.m_effectGet = Effect.None;
        this.m_effectSet = Effect.None;
    }

    public PropertyBody withInitialValue(Constant constInit) {
        return new PropertyBody(this.m_structProp, this.m_impl, this.m_constDelegate, this.m_type, this.m_fRO, this.m_fRW, this.m_fCustom, this.m_effectGet, this.m_effectSet, this.m_fField, this.m_fConstant, constInit, null);
    }

    public IdentityConstant getParent() {
        return this.getIdentity().getParentConstant();
    }

    public PropertyConstant getIdentity() {
        return this.m_structProp == null ? (PropertyConstant)((IdentityConstant.NestedIdentity)this.m_infoFormal.getNestedIdentity()).getIdentityConstant() : this.m_structProp.getIdentityConstant();
    }

    public PropertyStructure getStructure() {
        return this.m_structProp;
    }

    public String getName() {
        return this.m_structProp == null ? this.m_infoFormal.getName() : this.m_structProp.getName();
    }

    public MethodBody.Implementation getImplementation() {
        return this.m_impl;
    }

    public MethodBody.Existence getExistence() {
        return this.m_impl.getExistence();
    }

    public PropertyConstant getDelegate() {
        return this.m_constDelegate;
    }

    public TypeConstant getType() {
        return this.m_type;
    }

    public boolean isFormalType() {
        return this.m_infoFormal != null;
    }

    public TypeConstant getConstraintType() {
        return this.m_infoFormal == null ? null : this.m_infoFormal.getConstraintType();
    }

    public Constants.Access getRefAccess() {
        return this.m_structProp == null ? Constants.Access.PUBLIC : this.m_structProp.getAccess();
    }

    public Constants.Access getVarAccess() {
        return this.m_structProp == null ? null : this.m_structProp.getVarAccess();
    }

    public boolean isRO() {
        return this.m_fRO;
    }

    public boolean isRW() {
        return this.m_fRW;
    }

    public boolean hasField() {
        return this.m_fField;
    }

    public boolean impliesField() {
        return this.m_fField || this.getExistence() == MethodBody.Existence.Class && !this.isRO() && !this.isExplicitAbstract() && !this.isGetterBlockingSuper();
    }

    public boolean isConstant() {
        return this.m_fConstant;
    }

    public Constant getInitialValue() {
        return this.m_constInitVal;
    }

    public MethodConstant getInitializer() {
        return this.m_constInitFunc;
    }

    public boolean hasCustomCode() {
        return this.m_fCustom;
    }

    public Annotation[] getRefAnnotations() {
        return this.m_structProp == null ? Annotation.NO_ANNOTATIONS : this.m_structProp.getRefAnnotations();
    }

    public boolean hasGetter() {
        return this.m_effectGet != Effect.None;
    }

    public boolean hasSetter() {
        return this.m_effectSet != Effect.None;
    }

    public boolean isGetterBlockingSuper() {
        return this.m_effectGet == Effect.BlocksSuper;
    }

    public boolean isSetterBlockingSuper() {
        return this.m_effectSet == Effect.BlocksSuper;
    }

    public boolean isAbstract() {
        return switch (this.getImplementation()) {
            case MethodBody.Implementation.Delegating, MethodBody.Implementation.Native -> false;
            case MethodBody.Implementation.Explicit -> {
                if (this.isExplicitAbstract() || this.isImplicitAbstract()) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public boolean isSynthetic() {
        PropertyStructure prop = this.m_structProp;
        return prop != null && prop.isSynthetic();
    }

    public boolean isExplicitAbstract() {
        PropertyStructure prop = this.m_structProp;
        return prop != null && this.m_impl != MethodBody.Implementation.Implicit && TypeInfo.containsAnnotation(prop.getPropertyAnnotations(), "Abstract");
    }

    public boolean isImplicitAbstract() {
        PropertyStructure prop = this.m_structProp;
        return prop != null && this.m_impl != MethodBody.Implementation.Implicit && !this.isInjected() && !this.hasGetter() && this.isExplicitReadOnly() && prop.getContainingClass().isExplicitlyAbstract();
    }

    public boolean isExplicitOverride() {
        PropertyStructure prop = this.m_structProp;
        return prop != null && this.m_impl != MethodBody.Implementation.Implicit && prop.isExplicitOverride();
    }

    public boolean isExplicitReadOnly() {
        PropertyStructure prop = this.m_structProp;
        return prop != null && this.m_impl != MethodBody.Implementation.Implicit && prop.isExplicitReadOnly();
    }

    public boolean isInjected() {
        PropertyStructure prop = this.m_structProp;
        return prop != null && this.m_impl != MethodBody.Implementation.Implicit && prop.isInjected();
    }

    public int hashCode() {
        return this.getIdentity().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertyBody)) {
            return false;
        }
        PropertyBody that = (PropertyBody)obj;
        return Handy.equals(this.m_structProp, that.m_structProp) && this.m_type.equals(that.m_type) && this.m_impl == that.m_impl && this.m_effectGet == that.m_effectGet && this.m_effectSet == that.m_effectSet && this.m_fRO == that.m_fRO && this.m_fRW == that.m_fRW && this.m_fCustom == that.m_fCustom && this.m_fField == that.m_fField && this.m_fConstant == that.m_fConstant && Handy.equals(this.m_infoFormal, that.m_infoFormal) && Handy.equals(this.m_constDelegate, that.m_constDelegate) && Handy.equals(this.m_constInitVal, that.m_constInitVal) && Handy.equals(this.m_constInitFunc, that.m_constInitFunc);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_type.getValueString()).append(' ').append(this.getName()).append("; (id=").append(this.getIdentity().getValueString()).append(", impl=").append((Object)this.m_impl);
        if (this.m_infoFormal != null) {
            sb.append(", formal");
        }
        if (this.m_fRO) {
            sb.append(", RO");
        }
        if (this.m_fRW) {
            sb.append(", RW");
        }
        if (this.m_fConstant) {
            sb.append(", constant");
        }
        if (this.m_fField) {
            sb.append(", has-field");
        }
        if (this.m_fCustom) {
            sb.append(", has-code");
        }
        if (this.isInjected()) {
            sb.append(", @Inject");
        }
        if (this.isExplicitAbstract()) {
            sb.append(", @Abstract");
        }
        if (this.isExplicitOverride()) {
            sb.append(", @Override");
        }
        if (this.isExplicitReadOnly()) {
            sb.append(", @RO");
        }
        if (this.m_constInitVal != null) {
            sb.append(", has-init-value");
        }
        if (this.m_constInitFunc != null) {
            sb.append(", has-init-fn");
        }
        if (this.m_constDelegate != null) {
            sb.append(", delegate=").append(this.m_constDelegate);
        }
        return sb.append(')').toString();
    }

    public static enum Effect {
        None,
        BlocksSuper,
        MayUseSuper;

    }
}

