/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.xvm.asm.Annotation;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.constants.AbstractDependantTypeConstant;
import org.xvm.asm.constants.ChildInfo;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.NamedConstant;
import org.xvm.asm.constants.ParamInfo;
import org.xvm.asm.constants.PropertyBody;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.ListMap;

public class PropertyClassTypeConstant
extends AbstractDependantTypeConstant {
    protected PropertyConstant m_idProp;
    private transient int m_iProp;
    private transient PropertyInfo m_info;

    public PropertyClassTypeConstant(ConstantPool pool, TypeConstant typeParent, PropertyConstant idProp) {
        super(pool, typeParent);
        if (typeParent.containsUnresolved()) {
            throw new IllegalArgumentException("parent must be a resolved type");
        }
        if (idProp == null) {
            throw new IllegalArgumentException("property is required");
        }
        this.m_idProp = idProp;
    }

    public PropertyClassTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
        this.m_iProp = Handy.readIndex(in);
    }

    @Override
    protected void resolveConstants() {
        super.resolveConstants();
        this.m_idProp = (PropertyConstant)this.getConstantPool().getConstant(this.m_iProp);
    }

    public PropertyConstant getProperty() {
        return this.m_idProp;
    }

    public PropertyInfo getPropertyInfo() {
        PropertyInfo info = this.m_info;
        if (info == null) {
            TypeConstant typeParent = this.m_typeParent;
            if (typeParent.isSingleDefiningConstant() && !typeParent.isFormalType()) {
                typeParent = typeParent.ensureAccess(Constants.Access.PRIVATE);
            }
            this.m_info = info = typeParent.ensureTypeInfo().findProperty(this.m_idProp);
            assert (info != null);
        }
        return info;
    }

    public TypeConstant getRefType() {
        return this.getPropertyInfo().getBaseRefType();
    }

    @Override
    public boolean isShared(ConstantPool poolOther) {
        return super.isShared(poolOther) && this.m_idProp.isShared(poolOther);
    }

    @Override
    public int getMaxParamsCount() {
        return 0;
    }

    @Override
    public Constant getDefiningConstant() {
        return this.getPropertyInfo().getIdentity();
    }

    @Override
    protected TypeConstant cloneSingle(ConstantPool pool, TypeConstant type) {
        return pool.ensurePropertyClassTypeConstant(type, this.m_idProp);
    }

    @Override
    public ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, MethodConstant idMethod, ComponentResolver.ResolutionCollector collector) {
        return ComponentResolver.ResolutionResult.UNKNOWN;
    }

    @Override
    public TypeConstant resolveTypedefs() {
        return this;
    }

    @Override
    public TypeConstant resolveGenerics(ConstantPool pool, GenericTypeResolver resolver) {
        return this;
    }

    @Override
    public TypeConstant adoptParameters(ConstantPool pool, TypeConstant[] atypeParams) {
        return this;
    }

    @Override
    public TypeConstant[] collectGenericParameters() {
        return null;
    }

    @Override
    public boolean extendsClass(IdentityConstant constClass) {
        PropertyConstant idProp = (PropertyConstant)this.getDefiningConstant();
        return idProp.getType().extendsClass(constClass);
    }

    @Override
    public TypeConstant.Category getCategory() {
        return TypeConstant.Category.OTHER;
    }

    @Override
    public boolean isSingleUnderlyingClass(boolean fAllowInterface) {
        return false;
    }

    @Override
    public boolean containsGenericParam(String sName) {
        return "Referent".equals(sName) || this.m_typeParent.containsGenericParam(sName);
    }

    @Override
    protected TypeConstant getGenericParamType(String sName, List<TypeConstant> listParams) {
        TypeConstant type;
        TypeConstant typeConstant = type = "Referent".equals(sName) && listParams.isEmpty() ? this.m_idProp.getType() : null;
        return type == null ? this.m_typeParent.getGenericParamType(sName, Collections.emptyList()) : (type.containsGenericType(true) ? type.resolveGenerics(this.getConstantPool(), this.m_typeParent) : type);
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    protected TypeConstant.Relation calculateRelationToLeft(TypeConstant typeLeft) {
        return this.getRefType().calculateRelationToLeft(typeLeft);
    }

    @Override
    protected TypeConstant.Relation calculateRelationToRight(TypeConstant typeRight) {
        return this.getRefType().calculateRelationToRight(typeRight);
    }

    @Override
    public boolean containsSubstitutableMethod(SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams) {
        return this.getRefType().containsSubstitutableMethod(signature, access, fFunction, listParams);
    }

    @Override
    protected TypeConstant.Usage checkConsumption(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return TypeConstant.Usage.NO;
    }

    @Override
    protected TypeConstant.Usage checkProduction(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return TypeConstant.Usage.NO;
    }

    @Override
    protected TypeInfo buildTypeInfo(ErrorListener errs) {
        ConstantPool pool = this.getConstantPool();
        int cInvals = pool.getInvalidationCount();
        PropertyInfo infoProp = this.getPropertyInfo();
        PropertyBody[] aBody = infoProp.getPropertyBodies();
        HashMap<Object, ParamInfo> mapTypeParams = new HashMap<Object, ParamInfo>();
        HashMap<PropertyConstant, PropertyInfo> mapProps = new HashMap<PropertyConstant, PropertyInfo>();
        HashMap<MethodConstant, MethodInfo> mapMethods = new HashMap<MethodConstant, MethodInfo>();
        HashMap<Object, PropertyInfo> mapVirtProps = new HashMap<Object, PropertyInfo>();
        ListMap<Object, MethodInfo> mapVirtMethods = new ListMap<Object, MethodInfo>();
        ListMap<String, ChildInfo> mapChildren = new ListMap<String, ChildInfo>();
        TypeInfo infoBase = null;
        IdentityConstant idBase = null;
        TypeConstant typeBase = null;
        for (int i = aBody.length - 1; i >= 0; --i) {
            ListMap<Object, Object> mapContribChildren;
            Map<Object, Object> mapContribMethods;
            Map<Object, Object> mapContribProps;
            TypeConstant typeContrib;
            boolean fSelf;
            PropertyBody body = aBody[i];
            if (i != 0 && body.getExistence() != MethodBody.Existence.Class) continue;
            if (infoBase == null) {
                TypeConstant typeRef = infoProp.getBaseRefType().removeAutoNarrowing();
                typeBase = pool.ensureAccessTypeConstant(typeRef, Constants.Access.PROTECTED);
                infoBase = typeBase.ensureTypeInfoInternal(errs);
                if (!PropertyClassTypeConstant.isComplete(infoBase)) {
                    return null;
                }
                idBase = (IdentityConstant)typeRef.getDefiningConstant();
                mapProps.putAll(infoBase.getProperties());
                mapMethods.putAll(infoBase.getMethods());
                mapVirtProps.putAll(infoBase.getVirtProperties());
                mapVirtMethods.putAll(infoBase.getVirtMethods());
            }
            boolean bl = fSelf = i == 0;
            if (fSelf) {
                IdentityConstant idReplace;
                IdentityConstant idContrib;
                HashMap<PropertyConstant, Constants> mapContrib;
                typeContrib = this;
                mapContribProps = new HashMap();
                mapContribMethods = new HashMap();
                mapContribChildren = new ListMap();
                ArrayList<PropertyConstant> listExplode = new ArrayList<PropertyConstant>();
                PropertyStructure prop = infoProp.getHead().getStructure();
                this.collectChildInfo(idBase, false, prop, mapTypeParams, mapContribProps, mapContribMethods, mapContribChildren, listExplode, 0, 0, errs);
                if (!listExplode.isEmpty()) {
                    // empty if block
                }
                if (mapContribProps.isEmpty() && mapContribMethods.isEmpty() && mapContribChildren.isEmpty()) {
                    return infoBase;
                }
                if (!mapContribProps.isEmpty()) {
                    mapContrib = new HashMap<PropertyConstant, Constants>(mapContribProps.size());
                    for (Map.Entry<Object, Object> entry : mapContribProps.entrySet()) {
                        idContrib = (PropertyConstant)entry.getKey();
                        idReplace = pool.ensurePropertyConstant(idBase, ((NamedConstant)idContrib).getName());
                        mapContrib.put((PropertyConstant)idReplace, (PropertyInfo)entry.getValue());
                    }
                    mapContribProps = mapContrib;
                }
                if (!mapContribMethods.isEmpty()) {
                    mapContrib = new HashMap(mapContribMethods.size());
                    for (Map.Entry<Object, Object> entry : mapContribMethods.entrySet()) {
                        idContrib = (MethodConstant)entry.getKey();
                        idReplace = pool.ensureMethodConstant(idBase, ((MethodConstant)idContrib).getSignature());
                        mapContrib.put((PropertyConstant)idReplace, (MethodInfo)entry.getValue());
                    }
                    mapContribMethods = mapContrib;
                }
            } else {
                typeContrib = body.getIdentity().getRefType(null);
                if (!(typeContrib instanceof PropertyClassTypeConstant)) continue;
                TypeInfo infoContrib = typeContrib.ensureTypeInfoInternal(errs);
                if (!PropertyClassTypeConstant.isComplete(infoContrib)) {
                    return null;
                }
                mapContribProps = infoContrib.getProperties();
                mapContribMethods = infoContrib.getMethods();
                mapContribChildren = infoContrib.getChildInfosByName();
            }
            if (!mapContribProps.isEmpty()) {
                this.layerOnProps(idBase, fSelf, null, mapProps, mapVirtProps, typeContrib, mapContribProps, errs);
            }
            if (!mapContribMethods.isEmpty()) {
                this.layerOnMethods(idBase, fSelf ? TypeConstant.ContribSource.Self : TypeConstant.ContribSource.Regular, null, mapMethods, mapVirtMethods, typeContrib, mapContribMethods, errs);
            }
            if (mapContribChildren.isEmpty()) continue;
        }
        return new TypeInfo(this, cInvals, infoBase.getClassStructure(), idBase.getNestedDepth() + 1, false, mapTypeParams, Annotation.NO_ANNOTATIONS, infoBase.getMixinAnnotations(), typeBase, null, null, Collections.emptyList(), ListMap.EMPTY, ListMap.EMPTY, mapProps, mapMethods, mapVirtProps, mapVirtMethods, mapChildren, null, TypeInfo.Progress.Complete);
    }

    @Override
    public ClassTemplate getTemplate(Container container) {
        return this.getRefType().getTemplate(container);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.PropertyClassType;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        super.forEachUnderlying(visitor);
        visitor.accept(this.m_idProp);
    }

    @Override
    protected int compareDetails(Constant obj) {
        int n = super.compareDetails(obj);
        if (n == 0) {
            if (!(obj instanceof PropertyClassTypeConstant)) {
                return -1;
            }
            PropertyClassTypeConstant that = (PropertyClassTypeConstant)obj;
            n = this.m_idProp.compareTo(that.m_idProp);
        }
        return n;
    }

    @Override
    public String getValueString() {
        return this.m_typeParent.getValueString() + "." + this.m_idProp.getName();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        super.registerConstants(pool);
        this.m_idProp = (PropertyConstant)pool.register(this.m_idProp);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
        Handy.writePackedLong(out, this.m_idProp.getPosition());
    }

    @Override
    protected int computeHashCode() {
        return Hash.of(this.m_typeParent, Hash.of(this.m_idProp));
    }
}

