/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.PropertyExprAST;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.FormalTypeChildConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeSequenceTypeConstant;
import org.xvm.compiler.ast.Context;
import org.xvm.javajit.TypeSystem;

public class PropertyConstant
extends FormalConstant {
    private transient TypeConstant m_type;
    private transient SignatureConstant m_constSig;
    protected transient TypeConstant m_typeConstraint;
    protected transient PropertyInfo m_info;
    private volatile transient String m_sJitName;

    public PropertyConstant(ConstantPool pool, IdentityConstant constParent, String sName) {
        super(pool, constParent, sName);
        this.checkParent(constParent);
    }

    public PropertyConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    protected void checkParent(IdentityConstant idParent) {
        switch (idParent.getFormat()) {
            case Module: 
            case Package: 
            case Class: 
            case NativeClass: 
            case Property: 
            case Method: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid parent: " + String.valueOf((Object)idParent.getFormat()));
            }
        }
    }

    @Override
    public TypeConstant getConstraintType() {
        TypeConstant typeConstraint = this.m_typeConstraint;
        if (typeConstraint != null) {
            return typeConstraint;
        }
        assert (this.isFormalType());
        typeConstraint = this.getType();
        assert (typeConstraint.isTypeOfType() && typeConstraint.isParamsSpecified());
        if (!(typeConstraint = typeConstraint.getParamType(0)).isParamsSpecified() && typeConstraint.isExplicitClassIdentity(true)) {
            ConstantPool pool = this.getConstantPool();
            ClassStructure clz = (ClassStructure)typeConstraint.getSingleUnderlyingClass(true).getComponent();
            if (clz == null) {
                return typeConstraint;
            }
            if (clz.isParameterized()) {
                Set setFormalNames = clz.getTypeParams().keySet();
                TypeConstant[] atypeFormal = new TypeConstant[setFormalNames.size()];
                int ix = 0;
                for (StringConstant constName : setFormalNames) {
                    FormalTypeChildConstant constant = pool.ensureFormalTypeChildConstant(this, constName.getValue());
                    atypeFormal[ix++] = ((Constant)constant).getType();
                }
                typeConstraint = pool.ensureParameterizedTypeConstant(typeConstraint, atypeFormal);
            }
        }
        this.m_typeConstraint = typeConstraint;
        return this.m_typeConstraint;
    }

    @Override
    public TypeConstant resolve(GenericTypeResolver resolver) {
        TypeConstant typeResolver;
        if (this.isTypeSequenceTypeParameter() && resolver instanceof TypeConstant && (typeResolver = (TypeConstant)resolver).isTuple() && !typeResolver.isParamsSpecified()) {
            return null;
        }
        return super.resolve(resolver);
    }

    @Override
    public ExprAST toExprAst(Context ctx) {
        return ctx.isMethod() || ctx.isConstructor() ? new PropertyExprAST(ctx.getThisRegisterAST(), this) : null;
    }

    public SignatureConstant getSignature() {
        SignatureConstant sig = this.m_constSig;
        if (sig == null) {
            sig = this.m_constSig = new SignatureConstant(this.getConstantPool(), this);
        }
        return sig;
    }

    public boolean isFormalType() {
        PropertyStructure struct = (PropertyStructure)this.getComponent();
        return struct != null && struct.isGenericTypeParameter();
    }

    @Override
    public TypeConstant getFormalType() {
        assert (this.isFormalType());
        return this.getConstantPool().ensureTerminalTypeConstant(this);
    }

    public boolean isTypeSequenceTypeParameter() {
        return this.isFormalType() && this.getConstraintType() instanceof TypeSequenceTypeConstant;
    }

    public boolean isConstant() {
        PropertyStructure prop = (PropertyStructure)this.getComponent();
        return prop != null && prop.isConstant();
    }

    public boolean isFuture() {
        PropertyStructure prop = (PropertyStructure)this.getComponent();
        return prop != null && prop.isFuture();
    }

    public TypeConstant getRefType(TypeConstant typeTarget) {
        PropertyInfo infoThis = this.getPropertyInfo(typeTarget);
        if (infoThis.isCustomLogic()) {
            if (typeTarget == null) {
                typeTarget = this.getConstantPool().ensureAccessTypeConstant(this.getClassIdentity().getType(), Constants.Access.PRIVATE);
            }
            return this.getConstantPool().ensurePropertyClassTypeConstant(typeTarget, this);
        }
        return infoThis.getBaseRefType();
    }

    public PropertyInfo getPropertyInfo() {
        PropertyInfo info = this.m_info;
        if (info == null) {
            info = this.m_info = this.getPropertyInfo(null);
        }
        return info;
    }

    public PropertyInfo getPropertyInfo(TypeConstant typeTarget) {
        if (typeTarget == null) {
            typeTarget = this.getConstantPool().ensureAccessTypeConstant(this.getClassIdentity().getType(), Constants.Access.PRIVATE);
        } else {
            Constants.Access access = this.getComponent().getAccess();
            if (access.isLessAccessibleThan(typeTarget.getAccess())) {
                typeTarget = typeTarget.getConstantPool().ensureAccessTypeConstant(typeTarget, access);
            }
        }
        PropertyInfo infoThis = typeTarget.ensureTypeInfo().findProperty(this);
        assert (infoThis != null);
        return infoThis;
    }

    public TypeConstant getBjarneLambdaType() {
        return this.getConstantPool().buildFunctionType(new TypeConstant[]{this.getNamespace().getType()}, this.getType());
    }

    public boolean isTopLevel() {
        return this.getParentConstant().isClass();
    }

    public void invalidateCache() {
        this.m_type = null;
        this.m_constSig = null;
        this.m_typeConstraint = null;
    }

    @Override
    public IdentityConstant replaceParentConstant(IdentityConstant idParent) {
        return new PropertyConstant(this.getConstantPool(), idParent, this.getName());
    }

    @Override
    public TypeConstant getValueType(ConstantPool pool, TypeConstant typeTarget) {
        if (typeTarget == null) {
            typeTarget = this.getClassIdentity().getType();
        }
        TypeConstant typePrivate = typeTarget.ensureAccess(Constants.Access.PRIVATE);
        PropertyInfo infoProp = typePrivate.ensureTypeInfo().findProperty(this);
        TypeConstant typeReferent = infoProp.getType();
        TypeConstant typeImpl = pool.ensurePropertyClassTypeConstant(typePrivate, this);
        return pool.ensureParameterizedTypeConstant(pool.typeProperty(), typeTarget, typeReferent, typeImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ensureJitPropertyName(TypeSystem ts) {
        String sJitName = this.m_sJitName;
        if (sJitName == null) {
            PropertyConstant propertyConstant = this;
            synchronized (propertyConstant) {
                sJitName = this.m_sJitName;
                if (sJitName == null) {
                    PropertyStructure prop = (PropertyStructure)this.getComponent();
                    assert (prop != null);
                    ClassStructure clzParent = prop.getContainingClass();
                    String sNameOrig = this.getName();
                    this.m_sJitName = sJitName = (switch (clzParent.getFormat()) {
                        case Component.Format.ANNOTATION, Component.Format.MIXIN -> sNameOrig + ts.xvm.createUniqueSuffix(sNameOrig);
                        default -> sNameOrig;
                    });
                }
            }
        }
        return sJitName;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Property;
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public TypeConstant getType() {
        TypeConstant type = this.m_type;
        if (type == null) {
            PropertyStructure prop = (PropertyStructure)this.getComponent();
            type = prop == null ? this.getConstantPool().typeObject() : prop.getType();
            this.m_type = type;
        }
        return type;
    }

    @Override
    public Object getNestedIdentity() {
        return this.getNamespace().isNested() ? this.getCanonicalNestedIdentity() : this.getName();
    }

    @Override
    public Object resolveNestedIdentity(ConstantPool pool, GenericTypeResolver resolver) {
        return this.getNamespace().isNested() ? (resolver == null ? this.getCanonicalNestedIdentity() : new IdentityConstant.NestedIdentity(resolver)) : this.getName();
    }

    @Override
    public PropertyStructure relocateNestedIdentity(ClassStructure clz) {
        Component parent = this.getNamespace().relocateNestedIdentity(clz);
        if (parent == null) {
            return null;
        }
        Component that = parent.getChild(this.getName());
        return that instanceof PropertyStructure ? (PropertyStructure)that : null;
    }

    @Override
    public PropertyConstant ensureNestedIdentity(ConstantPool pool, IdentityConstant that) {
        IdentityConstant idParent = this.getParentConstant();
        return idParent.equals(that) ? this : pool.ensurePropertyConstant(idParent.ensureNestedIdentity(pool, that), this.getName());
    }

    @Override
    public IdentityConstant appendTrailingSegmentTo(IdentityConstant that) {
        return that.getConstantPool().ensurePropertyConstant(that, this.getName());
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.invalidateCache();
        super.registerConstants(pool);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
        this.m_type = null;
        this.m_constSig = null;
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder("property=");
        sb.append(this.getName());
        IdentityConstant idParent = this.getNamespace();
        block3: while (idParent != null) {
            switch (idParent.getFormat()) {
                case Property: 
                case Method: {
                    sb.insert(0, idParent.getName() + "#");
                    idParent = idParent.getNamespace();
                    continue block3;
                }
            }
            idParent = null;
        }
        return sb.toString();
    }
}

