/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.lang.constant.ClassDesc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyBody;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.javajit.Builder;
import org.xvm.javajit.JitFlavor;
import org.xvm.javajit.JitMethodDesc;
import org.xvm.javajit.JitParamDesc;
import org.xvm.javajit.JitTypeDesc;
import org.xvm.javajit.TypeSystem;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

public class PropertyInfo
implements Constants {
    public static final Comparator<Map.Entry<PropertyConstant, PropertyInfo>> RANKER = Comparator.comparingInt(e -> ((PropertyInfo)e.getValue()).getRank());
    private final PropertyBody[] m_aBody;
    private final TypeConstant m_type;
    private final boolean m_fRequireField;
    private final boolean m_fSuppressVar;
    private final int f_nRank;
    private MethodBody[] m_chainGet;
    private MethodBody[] m_chainSet;
    private Annotation[] m_annotations;
    private Boolean m_FInjected;
    private Boolean m_FImplicitlyAssigned;
    private TypeConstant m_typeBaseRef;
    private MethodConstant m_idGetter;
    private MethodConstant m_idSetter;
    private transient JitMethodDesc m_jmdGetter;
    private transient JitMethodDesc m_jmdSetter;

    public PropertyInfo(PropertyBody body, int nRank) {
        this(new PropertyBody[]{body}, body.getType(), body.hasField(), false, nRank);
    }

    public PropertyInfo(PropertyInfo that, PropertyBody body) {
        this(Handy.prepend(that.getPropertyBodies(), body), body.getType(), body.hasField(), body.isSetterBlockingSuper(), that.f_nRank);
    }

    private PropertyInfo(PropertyBody[] aBody, TypeConstant type, boolean fRequireField, boolean fSuppressVar, int nRank) {
        this.m_aBody = aBody;
        this.m_type = type;
        this.m_fRequireField = fRequireField;
        this.m_fSuppressVar = fSuppressVar;
        this.f_nRank = nRank;
    }

    public PropertyInfo layerOn(PropertyInfo that, boolean fSelf, boolean fMixin, ErrorListener errs) {
        Annotation[] aAnnoBase;
        int cAnnoBase;
        boolean fRequireField;
        boolean fAllowWidening;
        assert (that != null && errs != null);
        PropertyConstant idProp = this.getIdentity();
        assert (idProp.getName().equals(that.getName()));
        if (this.isFormalType() ^ that.isFormalType()) {
            idProp.log(errs, Severity.ERROR, "VERIFY-66", that.getIdentity().getValueString());
            return this;
        }
        if (this.isConstant() || that.isConstant()) {
            idProp.log(errs, Severity.ERROR, "VERIFY-68", that.getIdentity().getValueString());
            return this;
        }
        TypeConstant typeThis = this.getType();
        TypeConstant typeThat = that.getType();
        boolean bl = fAllowWidening = fMixin || !fSelf;
        if (!(typeThat.isA(typeThis) || fAllowWidening && typeThis.isA(typeThat))) {
            idProp.log(errs, Severity.ERROR, "VERIFY-67", that.getIdentity().getPathString(), typeThis.getValueString(), typeThat.getValueString());
            return this;
        }
        if (this.getRefAccess() == Constants.Access.STRUCT || that.getRefAccess() == Constants.Access.STRUCT) {
            throw new IllegalStateException("cannot combine struct with anything");
        }
        if (this.getRefAccess() == Constants.Access.PRIVATE || that.getRefAccess() == Constants.Access.PRIVATE) {
            throw new IllegalStateException("cannot combine private with anything");
        }
        PropertyBody[] aBase = this.m_aBody;
        PropertyBody[] aAdd = that.m_aBody;
        int cAdd = aAdd.length;
        ArrayList<PropertyBody> listMerge = null;
        block0: for (PropertyBody bodyAdd : aAdd) {
            for (PropertyBody bodyBase : aBase) {
                if (bodyAdd.equals(bodyBase) || bodyAdd.getIdentity().equals(bodyBase.getIdentity()) && bodyAdd.getImplementation() == MethodBody.Implementation.Implicit) continue block0;
            }
            if (listMerge == null) {
                listMerge = new ArrayList<PropertyBody>();
            }
            listMerge.add(bodyAdd);
        }
        if (listMerge == null) {
            return this;
        }
        Collections.addAll(listMerge, aBase);
        PropertyBody[] aResult = listMerge.toArray(new PropertyBody[0]);
        if (fSelf && !this.isFormalType()) {
            assert (cAdd == 1);
            PropertyBody bodyAdd = aAdd[0];
            if (!(bodyAdd.isExplicitOverride() || this.containsBody(bodyAdd.getIdentity()) || bodyAdd.isSynthetic())) {
                idProp.log(errs, Severity.ERROR, "VERIFY-47", bodyAdd.getIdentity().getValueString(), aBase[0].getIdentity().getValueString());
            }
        }
        TypeConstant typeResult = this.getType();
        for (int iAdd = cAdd - 1; iAdd >= 0; --iAdd) {
            PropertyBody bodyAdd;
            bodyAdd = aAdd[iAdd];
            TypeConstant typeAdd = bodyAdd.getType();
            MethodBody.Existence exAdd = bodyAdd.getExistence();
            if (typeAdd.equals(typeResult)) continue;
            MethodBody.Existence exBase = this.getHead().getExistence();
            if (typeAdd.isA(typeResult) && (exAdd != MethodBody.Existence.Implied || exBase == MethodBody.Existence.Implied)) {
                typeResult = typeAdd;
                continue;
            }
            if (bodyAdd.isRO() && typeResult.isA(typeAdd) || bodyAdd.isSynthetic() || fMixin) continue;
            idProp.log(errs, Severity.ERROR, "VERIFY-67", bodyAdd.getIdentity().getValueString(), typeAdd.getValueString(), typeResult.getValueString());
        }
        boolean bl2 = fRequireField = this.m_fRequireField || that.m_fRequireField && (!that.getHead().isSynthetic() || !this.getHead().isSetterBlockingSuper());
        if (!fRequireField && Arrays.stream(aBase).allMatch(body -> body.getImplementation().compareTo(MethodBody.Implementation.Delegating) <= 0)) {
            for (int i = cAdd - 1; i >= 0; --i) {
                PropertyBody body2 = aAdd[i];
                if (body2.getImplementation().compareTo(MethodBody.Implementation.Abstract) <= 0) continue;
                fRequireField = body2.impliesField();
                break;
            }
        }
        if ((cAnnoBase = (aAnnoBase = this.getRefAnnotations()).length) > 0 && this.getExistence() != MethodBody.Existence.Implied) {
            for (int iBodyAdd = cAdd - 1; iBodyAdd >= 0; --iBodyAdd) {
                PropertyBody bodyAdd = aAdd[iBodyAdd];
                Annotation[] aAnnoAdd = bodyAdd.getRefAnnotations();
                block5: for (int iAnnoAdd = aAnnoAdd.length - 1; iAnnoAdd >= 0; --iAnnoAdd) {
                    Annotation annoAdd = aAnnoAdd[iAnnoAdd];
                    TypeConstant typeAnnoAdd = annoAdd.getAnnotationType();
                    for (Annotation annotation : aAnnoBase) {
                        TypeConstant typeAnnoBase = annotation.getAnnotationType();
                        if (typeAnnoAdd.equals(typeAnnoBase)) {
                            idProp.log(errs, Severity.WARNING, "VERIFY-75", that.getIdentity().getParentConstant().getValueString(), this.getName(), annoAdd.getAnnotationClass().getValueString());
                            continue block5;
                        }
                        if (!typeAnnoAdd.isA(typeAnnoBase)) continue;
                        idProp.log(errs, Severity.WARNING, "VERIFY-76", that.getIdentity().getParentConstant().getValueString(), this.getName(), typeAnnoAdd.getValueString(), typeAnnoBase.getValueString());
                        continue block5;
                    }
                }
            }
        }
        boolean fSuppressVar = this.m_fSuppressVar | that.m_fSuppressVar;
        if (this.isSetterUnreachable() && that.isVar() && !that.getHead().isSynthetic()) {
            idProp.log(errs, Severity.ERROR, "VERIFY-77", that.getIdentity().getParentConstant().getValueString(), this.getName());
        }
        Constants.Access accessThisVar = this.calcVarAccess();
        Constants.Access accessThatVar = that.getVarAccess();
        if (that.getRefAccess().isLessAccessibleThan(this.getRefAccess()) || accessThisVar != null && accessThatVar != null && accessThatVar.isLessAccessibleThan(accessThisVar)) {
            idProp.log(errs, Severity.ERROR, "VERIFY-79", that.getIdentity().getParentConstant().getValueString(), this.getName());
        }
        return new PropertyInfo(aResult, typeResult, fRequireField, fSuppressVar, that.f_nRank);
    }

    public PropertyInfo finishAdoption(boolean fNative, ErrorListener errs) {
        if (this.isConstant() || this.isFormalType() || this.getExistence() != MethodBody.Existence.Interface) {
            return this;
        }
        assert (!this.hasField());
        PropertyStructure struct = null;
        boolean fRO = false;
        for (PropertyBody body : this.m_aBody) {
            if (body.getExistence() == MethodBody.Existence.Implied) continue;
            assert (body.getExistence() == MethodBody.Existence.Interface);
            if (struct == null) {
                struct = body.getStructure();
            }
            if (body.isExplicitReadOnly()) {
                fRO |= body.hasGetter();
                continue;
            }
            fRO = false;
            break;
        }
        PropertyBody bodyNew = fNative ? new PropertyBody(struct, MethodBody.Implementation.Native, null, this.getType(), fRO, false, true, PropertyBody.Effect.BlocksSuper, fRO ? PropertyBody.Effect.None : PropertyBody.Effect.BlocksSuper, false, false, null, null) : new PropertyBody(struct, MethodBody.Implementation.SansCode, null, this.getType(), fRO, false, false, PropertyBody.Effect.None, PropertyBody.Effect.None, !fRO, false, null, null);
        return this.layerOn(new PropertyInfo(bodyNew, this.f_nRank), false, false, errs);
    }

    public PropertyInfo retainOnly(PropertyConstant idProp, Set<IdentityConstant> setClass, Set<IdentityConstant> setDefault) {
        ArrayList<PropertyBody> list = null;
        PropertyBody[] aBody = this.m_aBody;
        int c = aBody.length;
        for (int i = 0; i < c; ++i) {
            PropertyBody body = aBody[i];
            IdentityConstant constClz = idProp.getClassIdentity();
            if (switch (body.getImplementation()) {
                case MethodBody.Implementation.Implicit, MethodBody.Implementation.Default, MethodBody.Implementation.Declared -> true;
                case MethodBody.Implementation.Native -> setClass.contains(constClz) || setDefault.contains(constClz);
                case MethodBody.Implementation.SansCode, MethodBody.Implementation.Delegating, MethodBody.Implementation.Explicit -> setClass.contains(constClz);
                default -> throw new IllegalStateException();
            }) {
                if (list == null) continue;
                list.add(body);
                continue;
            }
            if (list != null) continue;
            list = new ArrayList<PropertyBody>(Arrays.asList(aBody).subList(0, i));
        }
        if (list == null) {
            return this;
        }
        return list.isEmpty() ? null : new PropertyInfo(list.toArray(new PropertyBody[0]), this.m_type, this.m_fRequireField, this.m_fSuppressVar, this.f_nRank);
    }

    public PropertyInfo limitAccess(Constants.Access access) {
        assert (access != null && access != Constants.Access.STRUCT);
        Constants.Access accessRef = this.getRefAccess();
        if (accessRef.isLessAccessibleThan(access)) {
            return null;
        }
        Constants.Access accessVar = this.getVarAccess();
        if (accessVar != null && this.isVar() && accessVar.isLessAccessibleThan(access)) {
            return new PropertyInfo(this.m_aBody, this.m_type, this.m_fRequireField, true, this.f_nRank);
        }
        return this;
    }

    public PropertyInfo ensureVar() {
        assert (this.hasField() && this.isRefAnnotated());
        return this.m_fSuppressVar ? new PropertyInfo(this.m_aBody, this.m_type, true, false, this.f_nRank) : this;
    }

    public PropertyInfo asInto() {
        if (this.isConstant() || this.isFormalType()) {
            return this;
        }
        PropertyBody[] aBodyOld = this.m_aBody;
        int cBodies = aBodyOld.length;
        PropertyBody[] aBodyNew = new PropertyBody[cBodies];
        for (int i = 0; i < cBodies; ++i) {
            PropertyBody body = aBodyOld[i];
            aBodyNew[i] = new PropertyBody(body.getStructure(), MethodBody.Implementation.Implicit, null, body.getType(), body.isRO(), body.isRW(), body.hasCustomCode(), PropertyBody.Effect.None, PropertyBody.Effect.None, body.hasField(), false, null, null);
        }
        return new PropertyInfo(aBodyNew, this.m_type, this.m_fRequireField, this.m_fSuppressVar, this.f_nRank);
    }

    public PropertyInfo withInitialValue(Constant constInit) {
        PropertyBody[] aBodyOld = this.m_aBody;
        int cBodies = aBodyOld.length;
        PropertyBody[] aBodyNew = Arrays.copyOf(aBodyOld, cBodies);
        aBodyNew[0] = aBodyNew[0].withInitialValue(constInit);
        return new PropertyInfo(aBodyNew, this.m_type, this.m_fRequireField, this.m_fSuppressVar, this.f_nRank);
    }

    public PropertyInfo withRank(int nRank) {
        return new PropertyInfo(this.m_aBody, this.m_type, this.m_fRequireField, this.m_fSuppressVar, nRank);
    }

    public IdentityConstant getParent() {
        return this.getIdentity().getParentConstant();
    }

    public PropertyConstant getIdentity() {
        return this.getHead().getIdentity();
    }

    public PropertyBody[] getPropertyBodies() {
        return this.m_aBody;
    }

    public boolean containsBody(PropertyConstant id) {
        for (PropertyBody body : this.m_aBody) {
            if (!id.equals(body.getIdentity())) continue;
            return true;
        }
        return false;
    }

    public PropertyBody getHead() {
        return this.m_aBody[0];
    }

    public PropertyBody getTail() {
        return this.m_aBody[this.m_aBody.length - 1];
    }

    public boolean isIdentityValid(PropertyConstant idProp) {
        if (idProp.getName().equals(this.getName())) {
            ConstantPool pool;
            if (this.containsBody(idProp)) {
                return true;
            }
            Component parent = idProp.getNamespace().getComponent();
            if (parent == null && idProp.isShared(pool = ConstantPool.getCurrentPool())) {
                idProp = (PropertyConstant)pool.register(idProp);
                parent = idProp.getNamespace().getComponent();
            }
            return parent != null && parent.getFormat() == Component.Format.INTERFACE;
        }
        return false;
    }

    public String getName() {
        return this.getHead().getName();
    }

    public TypeConstant getType() {
        return this.m_type;
    }

    public TypeConstant inferImmutable(TypeConstant typeParent) {
        TypeConstant typeProp = this.getType();
        if (typeParent != null && this.hasField()) {
            ConstantPool pool = typeParent.getConstantPool();
            if (typeParent.getAccess() != Constants.Access.STRUCT && typeParent.isImmutable() && typeProp.isSingleUnderlyingClass(false) && !typeProp.isImmutable() && !typeProp.isA(pool.typeService())) {
                typeProp = typeProp.freeze();
            }
        }
        return typeProp;
    }

    public boolean isConstant() {
        return this.getHead().isConstant();
    }

    public boolean isInitialized() {
        for (PropertyBody body : this.m_aBody) {
            if (body.getInitialValue() == null && body.getInitializer() == null) continue;
            return true;
        }
        return false;
    }

    public Constant getInitialValue() {
        for (PropertyBody body : this.m_aBody) {
            Constant constVal = body.getInitialValue();
            if (constVal != null) {
                return constVal;
            }
            if (body.getInitializer() == null) continue;
            return null;
        }
        return null;
    }

    public MethodConstant getInitializer() {
        for (PropertyBody body : this.m_aBody) {
            MethodConstant methodInit = body.getInitializer();
            if (methodInit != null) {
                return methodInit;
            }
            if (body.getInitialValue() == null) continue;
            return null;
        }
        return null;
    }

    public boolean isFormalType() {
        return this.getHead().isFormalType();
    }

    public TypeConstant getConstraintType() {
        return this.getHead().getConstraintType();
    }

    public MethodBody.Existence getExistence() {
        return PropertyInfo.getExistence(this.m_aBody);
    }

    private static MethodBody.Existence getExistence(PropertyBody[] aBody) {
        MethodBody.Existence ex = null;
        for (PropertyBody body : aBody) {
            MethodBody.Existence exBody = body.getExistence();
            if (exBody == MethodBody.Existence.Class) {
                return exBody;
            }
            if (ex != null && exBody.compareTo(ex) <= 0) continue;
            ex = exBody;
        }
        return ex;
    }

    public boolean isVar() {
        if (this.m_fSuppressVar || this.isConstant() || this.isFormalType() || this.isInjected()) {
            return false;
        }
        if (this.hasField()) {
            return true;
        }
        for (PropertyBody body : this.m_aBody) {
            if (body.isRO()) {
                return false;
            }
            if (body.isRW() || body.isAbstract()) {
                return true;
            }
            if (body.getImplementation() != MethodBody.Implementation.Delegating) continue;
            TypeInfo typeThat = body.getDelegate().getType().ensureTypeInfo();
            PropertyInfo propThat = typeThat.findProperty(this.getName());
            return propThat != null && propThat.isVar();
        }
        return false;
    }

    public boolean requiresNativeRef() {
        return this.isVar() || this.isFormalType() || this.isInjected() || this.isRefAnnotated();
    }

    public Constants.Access getRefAccess() {
        return this.getHead().getRefAccess();
    }

    public Constants.Access getVarAccess() {
        return this.getHead().getVarAccess();
    }

    public Constants.Access calcVarAccess() {
        Constants.Access access = this.getVarAccess();
        if (access == null && this.isVar() && !this.isAdopted()) {
            access = this.getRefAccess();
        }
        return access;
    }

    public boolean isAdopted() {
        return this.getHead().getImplementation() == MethodBody.Implementation.SansCode;
    }

    public boolean isSetterUnreachable() {
        return this.m_fSuppressVar;
    }

    public boolean isNative() {
        block4: for (PropertyBody body : this.m_aBody) {
            switch (body.getImplementation()) {
                case Implicit: {
                    continue block4;
                }
                case Native: {
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean hasField() {
        return this.m_fRequireField;
    }

    public PropertyConstant getFieldIdentity() {
        if (!this.hasField()) {
            return null;
        }
        PropertyConstant idBest = null;
        for (int i = this.m_aBody.length - 1; i >= 0; --i) {
            PropertyBody body = this.m_aBody[i];
            if (body.hasField()) {
                return body.getIdentity();
            }
            if (idBest != null || body.getImplementation().compareTo(MethodBody.Implementation.Abstract) < 0) continue;
            idBest = body.getIdentity();
        }
        assert (idBest != null);
        return idBest;
    }

    public boolean isVirtual() {
        if (this.isConstant() || this.getRefAccess() == Constants.Access.PRIVATE) {
            return false;
        }
        IdentityConstant id = this.getIdentity();
        int c = id.getNestedDepth();
        for (int i = 1; i < c; ++i) {
            PropertyStructure prop;
            if ((id = id.getParentConstant()) instanceof MethodConstant) {
                return false;
            }
            if (!(id instanceof PropertyConstant) || (prop = (PropertyStructure)id.getComponent()) == null || prop.getAccess() != Constants.Access.PRIVATE) continue;
            return false;
        }
        return true;
    }

    public Annotation[] getPropertyAnnotations() {
        return this.getHead().getStructure().getPropertyAnnotations();
    }

    public boolean containsPropertyAnnotation(IdentityConstant idAnno) {
        for (Annotation anno : this.getPropertyAnnotations()) {
            if (!anno.getAnnotationClass().equals(idAnno)) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getRefAnnotations() {
        Annotation[] aAnnos = this.m_annotations;
        if (aAnnos == null) {
            aAnnos = Annotation.NO_ANNOTATIONS;
            ArrayList<Annotation> list = null;
            for (PropertyBody body : this.m_aBody) {
                Annotation[] aAdd;
                PropertyStructure prop = body.getStructure();
                if (prop == null || (aAdd = prop.getRefAnnotations()).length <= 0) continue;
                if (list == null) {
                    if (aAnnos.length == 0) {
                        aAnnos = aAdd;
                    } else {
                        list = new ArrayList<Annotation>();
                        Collections.addAll(list, aAnnos);
                    }
                }
                if (list == null) continue;
                for (Annotation anno : aAdd) {
                    if (list.contains(anno)) continue;
                    list.add(anno);
                }
            }
            if (list != null) {
                aAnnos = list.toArray(Annotation.NO_ANNOTATIONS);
            }
            this.m_annotations = aAnnos;
        }
        return aAnnos;
    }

    public boolean containsRefAnnotation(IdentityConstant idAnno) {
        for (Annotation anno : this.getRefAnnotations()) {
            if (!anno.getAnnotationClass().equals(idAnno)) continue;
            return true;
        }
        return false;
    }

    public TypeConstant getBaseRefType() {
        TypeConstant typeBaseRef = this.m_typeBaseRef;
        if (typeBaseRef == null) {
            TypeConstant typeProp = this.getType();
            ConstantPool pool = typeProp.getConstantPool();
            TypeConstant typeRef = pool.ensureParameterizedTypeConstant(this.isVar() ? pool.typeVar() : pool.typeRef(), typeProp);
            typeBaseRef = this.isRefAnnotated() ? pool.ensureAnnotatedTypeConstant(typeRef, this.getRefAnnotations()) : typeRef;
            this.m_typeBaseRef = typeBaseRef;
        }
        return typeBaseRef;
    }

    public boolean isLazy() {
        return this.containsRefAnnotation(this.pool().clzLazy());
    }

    public boolean isAtomic() {
        return this.containsRefAnnotation(this.pool().clzAtomic());
    }

    public boolean isCustomLogic() {
        if (!this.isNative()) {
            for (PropertyBody body : this.m_aBody) {
                if (!body.hasCustomCode()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRefAnnotated() {
        return this.getRefAnnotations().length > 0 && !this.isInjected() && !this.isSimpleUnassigned();
    }

    public boolean isSimpleUnassigned() {
        Annotation[] aAnnos = this.getRefAnnotations();
        return aAnnos.length == 1 && aAnnos[0].getAnnotationClass().equals(this.pool().clzUnassigned()) && !this.getHead().hasGetter() && !this.getHead().hasSetter();
    }

    public boolean isImplicitlyAssigned() {
        if (this.m_FImplicitlyAssigned != null) {
            return this.m_FImplicitlyAssigned;
        }
        ConstantPool pool = this.pool();
        if (this.containsRefAnnotation(pool.clzFuture()) || this.containsRefAnnotation(pool.clzUnassigned())) {
            this.m_FImplicitlyAssigned = true;
            return this.m_FImplicitlyAssigned;
        }
        for (Annotation anno : this.getRefAnnotations()) {
            if (!anno.hasExplicitGetter()) continue;
            this.m_FImplicitlyAssigned = true;
            return this.m_FImplicitlyAssigned;
        }
        PropertyBody head = this.getHead();
        this.m_FImplicitlyAssigned = head.hasGetter() && head.isGetterBlockingSuper();
        return this.m_FImplicitlyAssigned;
    }

    public boolean isTransient() {
        return this.containsPropertyAnnotation(this.pool().clzTransient());
    }

    public MethodConstant getGetterId() {
        MethodConstant idGetter = this.m_idGetter;
        if (idGetter == null) {
            this.m_idGetter = idGetter = this.pool().ensureMethodConstant(this.getIdentity(), "get", ConstantPool.NO_TYPES, new TypeConstant[]{this.getType()});
        }
        return idGetter;
    }

    public MethodBody[] ensureOptimizedGetChain(TypeInfo infoType, PropertyConstant idNested) {
        MethodBody[] chain = this.m_chainGet;
        if (chain == null) {
            MethodConstant idGet = this.getGetterId();
            if (idNested != null) {
                idGet = (MethodConstant)idNested.appendNestedIdentity(this.pool(), idGet.getSignature());
            }
            chain = this.isDelegating() ? this.createDelegatingChain(infoType, idGet) : this.augmentPropertyChain(infoType.getOptimizedMethodChain(idGet), infoType, idGet);
            this.m_chainGet = chain;
        }
        return chain;
    }

    public MethodConstant getSetterId() {
        MethodConstant idSetter = this.m_idSetter;
        if (idSetter == null) {
            this.m_idSetter = idSetter = this.pool().ensureMethodConstant(this.getIdentity(), "set", new TypeConstant[]{this.getType()}, ConstantPool.NO_TYPES);
        }
        return idSetter;
    }

    public MethodBody[] ensureOptimizedSetChain(TypeInfo infoType, PropertyConstant idNested) {
        MethodBody[] chain = this.m_chainSet;
        if (chain == null) {
            MethodConstant idSet = this.getSetterId();
            if (idNested != null) {
                idSet = (MethodConstant)idNested.appendNestedIdentity(this.pool(), idSet.getSignature());
            }
            chain = this.isDelegating() ? this.createDelegatingChain(infoType, idSet) : this.augmentPropertyChain(infoType.getOptimizedMethodChain(idSet), infoType, idSet);
            this.m_chainSet = chain;
        }
        return chain;
    }

    public boolean isAbstract() {
        return this.getHead().isAbstract();
    }

    public boolean isExplicitlyAbstract() {
        return this.getHead().isExplicitAbstract();
    }

    public boolean isOverride() {
        return this.getTail().isExplicitOverride();
    }

    public boolean isInjected() {
        Boolean FInjected = this.m_FInjected;
        if (FInjected == null) {
            this.m_FInjected = FInjected = Boolean.valueOf(this.getHead().isInjected());
        }
        return FInjected;
    }

    public boolean isDelegating() {
        return this.getHead().getImplementation() == MethodBody.Implementation.Delegating;
    }

    public PropertyConstant getDelegate() {
        return this.getHead().getDelegate();
    }

    public boolean isVisible(IdentityConstant idClz) {
        if (this.getHead().getRefAccess() == Constants.Access.PUBLIC) {
            return true;
        }
        for (PropertyBody body : this.m_aBody) {
            if (!body.getIdentity().getClassIdentity().isNestMateOf(idClz)) continue;
            return true;
        }
        return false;
    }

    protected MethodBody[] augmentPropertyChain(MethodBody[] chain, TypeInfo infoType, MethodConstant idMethod) {
        if (chain == null || chain.length == 0) {
            chain = this.isNative() ? new MethodBody[]{new MethodBody(idMethod, idMethod.getSignature(), MethodBody.Implementation.Native, null)} : (this.hasField() ? new MethodBody[]{new MethodBody(idMethod, idMethod.getSignature(), MethodBody.Implementation.Field, this.getFieldIdentity())} : (this.isInjected() ? new MethodBody[]{new MethodBody(idMethod, idMethod.getSignature(), MethodBody.Implementation.Field, this.getHead().getIdentity())} : MethodBody.NO_BODIES));
        } else if (this.hasField() && !this.isNative()) {
            int cBodies;
            int ixTail;
            MethodBody.Implementation implTail;
            MethodBody bodyHead = chain[0];
            if (bodyHead.isNative()) {
                chain = new MethodBody[]{new MethodBody(idMethod, idMethod.getSignature(), MethodBody.Implementation.Field, this.getFieldIdentity())};
            } else if (this.isCustomLogic() && (implTail = chain[ixTail = (cBodies = chain.length) - 1].getImplementation()) != MethodBody.Implementation.Field) {
                if (bodyHead.getImplementation() == MethodBody.Implementation.Default) {
                    chain = new MethodBody[1];
                    ixTail = 0;
                } else if (implTail == MethodBody.Implementation.Native) {
                    chain = (MethodBody[])chain.clone();
                } else {
                    MethodBody[] chainNew = new MethodBody[cBodies + 1];
                    System.arraycopy(chain, 0, chainNew, 0, cBodies);
                    chain = chainNew;
                    ++ixTail;
                }
                chain[ixTail] = new MethodBody(idMethod, idMethod.getSignature(), MethodBody.Implementation.Field, this.getFieldIdentity());
            }
        }
        return chain;
    }

    protected MethodBody[] createDelegatingChain(TypeInfo infoType, MethodConstant idMethod) {
        PropertyStructure propDelegate = this.getHead().getStructure();
        PropertyStructure propTarget = (PropertyStructure)this.getDelegate().getComponent();
        ClassStructure clz = propTarget.getContainingClass();
        MethodStructure method = clz.ensurePropertyDelegation(propDelegate, propTarget, idMethod.getSignature());
        MethodConstant idDelegate = method.getIdentityConstant();
        SignatureConstant sigDelegate = idDelegate.getSignature();
        MethodBody body = new MethodBody(idDelegate, sigDelegate, MethodBody.Implementation.Explicit);
        body.setMethodStructure(method);
        assert (sigDelegate.resolveGenericTypes(this.pool(), infoType.getType()).equals(idMethod.getSignature()));
        return new MethodBody[]{body};
    }

    public int getRank() {
        return this.f_nRank;
    }

    private ConstantPool pool() {
        return this.m_type.getConstantPool();
    }

    public JitMethodDesc getGetterJitDesc(TypeSystem ts) {
        JitMethodDesc jmd = this.m_jmdGetter;
        if (jmd == null) {
            JitParamDesc[] apdStdReturn;
            JitParamDesc[] apdOptReturn = null;
            TypeConstant type = this.getType();
            JitTypeDesc jtd = type.getJitDesc(ts);
            switch (jtd.flavor) {
                case Primitive: {
                    ClassDesc cdStd = ClassDesc.of(ts.ensureJitClassName(type));
                    apdStdReturn = new JitParamDesc[]{new JitParamDesc(type, JitFlavor.Specific, cdStd, 0, 0, false)};
                    apdOptReturn = new JitParamDesc[]{new JitParamDesc(type, JitFlavor.Primitive, jtd.cd, 0, 0, false)};
                    break;
                }
                case MultiSlotPrimitive: {
                    apdStdReturn = new JitParamDesc[]{new JitParamDesc(type, JitFlavor.Widened, Builder.CD_xObj, 0, 0, false)};
                    apdOptReturn = new JitParamDesc[]{new JitParamDesc(type, JitFlavor.Primitive, jtd.cd, 0, 0, false)};
                    break;
                }
                case Specific: 
                case Widened: {
                    apdStdReturn = new JitParamDesc[]{new JitParamDesc(type, jtd.flavor, jtd.cd, 0, 0, false)};
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported property flavor: " + String.valueOf((Object)jtd.flavor));
                }
            }
            this.m_jmdGetter = jmd = new JitMethodDesc(apdStdReturn, JitParamDesc.NONE, apdOptReturn, JitParamDesc.NONE);
        }
        return jmd;
    }

    public JitMethodDesc getSetterJitDesc(TypeSystem ts) {
        JitMethodDesc jmd = this.m_jmdSetter;
        if (jmd == null) {
            JitParamDesc[] apdStdParam;
            JitParamDesc[] apdOptParam = null;
            TypeConstant type = this.getType();
            JitTypeDesc jtd = type.getJitDesc(ts);
            switch (jtd.flavor) {
                case Primitive: {
                    ClassDesc cdStd = ClassDesc.of(ts.ensureJitClassName(type));
                    apdStdParam = new JitParamDesc[]{new JitParamDesc(type, JitFlavor.Specific, cdStd, 0, 0, false)};
                    apdOptParam = new JitParamDesc[]{new JitParamDesc(type, JitFlavor.Primitive, jtd.cd, 0, 0, false)};
                    break;
                }
                case MultiSlotPrimitive: {
                    apdStdParam = new JitParamDesc[]{new JitParamDesc(type, JitFlavor.Widened, Builder.CD_xObj, 0, 0, false)};
                    apdOptParam = new JitParamDesc[]{new JitParamDesc(type, JitFlavor.Primitive, jtd.cd, 0, 0, false)};
                    break;
                }
                case Specific: 
                case Widened: {
                    apdStdParam = new JitParamDesc[]{new JitParamDesc(type, jtd.flavor, jtd.cd, 0, 0, false)};
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported property flavor: " + String.valueOf((Object)jtd.flavor));
                }
            }
            this.m_jmdSetter = jmd = new JitMethodDesc(JitParamDesc.NONE, apdStdParam, JitParamDesc.NONE, apdOptParam);
        }
        return jmd;
    }

    public int hashCode() {
        return this.getHead().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertyInfo)) {
            return false;
        }
        PropertyInfo that = (PropertyInfo)obj;
        return this.m_fRequireField == that.m_fRequireField && this.m_fSuppressVar == that.m_fSuppressVar && Handy.equals(this.m_aBody, that.m_aBody);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType().getValueString()).append(' ').append(this.getName());
        if (this.m_fRequireField) {
            sb.append(", require-field");
        }
        if (this.m_fSuppressVar) {
            sb.append(", suppress-var");
        }
        int i = 0;
        for (PropertyBody body : this.m_aBody) {
            sb.append("\n    [").append(i++).append("] ").append(body);
        }
        return sb.toString();
    }
}

