/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.EnumValueConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.compiler.Token;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class RangeConstant
extends ValueConstant {
    private transient int m_iVal1;
    private transient int m_iVal2;
    private Constant m_const1;
    private final boolean m_fExclude1;
    private Constant m_const2;
    private final boolean m_fExclude2;

    public RangeConstant(ConstantPool pool, Constant const1, boolean fExclude1, Constant const2, boolean fExclude2) {
        super(pool);
        if (const1 == null) {
            throw new IllegalArgumentException("value 1 required");
        }
        if (const2 == null) {
            throw new IllegalArgumentException("value 2 required");
        }
        if (const1.getFormat() != const2.getFormat() && !const1.getType().equals(const2.getType())) {
            throw new IllegalArgumentException("values must be of the same type");
        }
        this.m_const1 = const1;
        this.m_fExclude1 = fExclude1;
        this.m_const2 = const2;
        this.m_fExclude2 = fExclude2;
    }

    public RangeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        switch (format) {
            case RangeExclusive: {
                this.m_fExclude1 = false;
                this.m_fExclude2 = true;
                break;
            }
            case RangeInclusive: {
                this.m_fExclude1 = false;
                this.m_fExclude2 = false;
                break;
            }
            case Range: {
                int b = in.readUnsignedByte();
                this.m_fExclude1 = (b & 1) != 0;
                this.m_fExclude2 = (b & 2) != 0;
                break;
            }
            default: {
                throw new IllegalStateException("illegal format: " + String.valueOf((Object)format));
            }
        }
        this.m_iVal1 = Handy.readMagnitude(in);
        this.m_iVal2 = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_const1 = pool.getConstant(this.m_iVal1);
        this.m_const2 = pool.getConstant(this.m_iVal2);
    }

    public Constant getFirst() {
        return this.m_const1;
    }

    public boolean isFirstExcluded() {
        return this.m_fExclude1;
    }

    public Constant getLast() {
        return this.m_const2;
    }

    public boolean isLastExcluded() {
        return this.m_fExclude2;
    }

    public boolean contains(Constant value) {
        if (value.equals(this.m_const1)) {
            return !this.m_fExclude1 && (!value.equals(this.m_const2) || !this.m_fExclude2);
        }
        if (value.equals(this.m_const2)) {
            return !this.m_fExclude2;
        }
        return switch (Integer.signum(this.m_const1.compareTo(this.m_const2))) {
            case -1 -> {
                if (value.compareTo(this.m_const1) >= 0 && value.compareTo(this.m_const2) <= 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
            case 1 -> value.compareTo(this.m_const2) >= 0 && value.compareTo(this.m_const1) <= 0;
        };
    }

    public boolean isReverse() {
        return this.getConstantPool().valTrue().equals(this.m_const1.apply(Token.Id.COMP_GT, this.m_const2));
    }

    public boolean isInterval() {
        return this.m_const1 instanceof EnumValueConstant || this.m_const1.getType().isA(this.getConstantPool().typeSequential());
    }

    public long size() {
        Constant constLo = this.getEffectiveLow();
        Constant constHi = this.getEffectiveHigh();
        Constant constGT = constLo.apply(Token.Id.COMP_GT, constHi);
        if (this.getConstantPool().valTrue().equals(constGT)) {
            return 0L;
        }
        return RangeConstant.sub(constHi, constLo) + 1L;
    }

    private static long sub(Constant const1, Constant const2) {
        try {
            return const1.apply(Token.Id.SUB, const2).getIntValue().getLong();
        }
        catch (RuntimeException e) {
            return const1.getIntValue().sub(const2.getIntValue()).getLong();
        }
    }

    public Constant getEffectiveFirst() {
        assert (this.isInterval());
        Constant constFirst = this.getFirst();
        return this.isFirstExcluded() ? constFirst.apply(this.isReverse() ? Token.Id.SUB : Token.Id.ADD, this.getConstantPool().ensureLiteralConstant(Constant.Format.IntLiteral, "1")) : constFirst;
    }

    public Constant getEffectiveLast() {
        assert (this.isInterval());
        Constant constLast = this.getLast();
        return this.isLastExcluded() ? constLast.apply(this.isReverse() ? Token.Id.ADD : Token.Id.SUB, this.getConstantPool().ensureLiteralConstant(Constant.Format.IntLiteral, "1")) : constLast;
    }

    public Constant getEffectiveLow() {
        return this.isReverse() ? this.getEffectiveLast() : this.getEffectiveFirst();
    }

    public Constant getEffectiveHigh() {
        return this.isReverse() ? this.getEffectiveFirst() : this.getEffectiveLast();
    }

    @Override
    public TypeConstant getType() {
        TypeConstant type2;
        TypeConstant type1 = this.m_const1.getType();
        if (type1.equals(type2 = this.m_const2.getType())) {
            return this.getConstantPool().ensureRangeType(type1);
        }
        Constant constant = this.m_const1;
        if (constant instanceof EnumValueConstant) {
            EnumValueConstant enumVal1 = (EnumValueConstant)constant;
            constant = this.m_const2;
            if (constant instanceof EnumValueConstant) {
                IdentityConstant idEnum2;
                EnumValueConstant enumVal2 = (EnumValueConstant)constant;
                IdentityConstant idEnum1 = enumVal1.getClassConstant().getParentConstant();
                if (idEnum1.equals(idEnum2 = enumVal2.getClassConstant().getParentConstant())) {
                    return this.getConstantPool().ensureRangeType(idEnum1.getType());
                }
            }
        }
        throw new IllegalStateException("Non-uniform range " + String.valueOf(this));
    }

    public Constant[] getValue() {
        return new Constant[]{this.m_const1, this.m_const2};
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Range;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && (this.m_const1.containsUnresolved() || this.m_const2.containsUnresolved());
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_const1);
        visitor.accept(this.m_const2);
    }

    @Override
    public RangeConstant resolveTypedefs() {
        Constant constOld1 = this.m_const1;
        Constant constOld2 = this.m_const2;
        Constant constNew1 = constOld1.resolveTypedefs();
        Constant constNew2 = constOld2.resolveTypedefs();
        return constNew1 == constOld1 && constNew2 == constOld2 ? this : this.getConstantPool().ensureRangeConstant(constNew1, constNew2);
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof RangeConstant)) {
            return -1;
        }
        RangeConstant range = (RangeConstant)that;
        int nResult = this.m_const1.compareTo(range.m_const1);
        if (nResult == 0) {
            if (this.m_fExclude1 != range.m_fExclude1) {
                nResult = this.m_fExclude1 ? 1 : -1;
            } else {
                nResult = this.m_const2.compareTo(range.m_const2);
                if (nResult == 0 && this.m_fExclude2 != range.m_fExclude2) {
                    nResult = this.m_fExclude2 ? -1 : 1;
                }
            }
        }
        return nResult;
    }

    @Override
    public String getValueString() {
        return (this.m_fExclude1 ? (char)'(' : '[') + this.m_const1.getValueString() + ".." + this.m_const2.getValueString() + (this.m_fExclude2 ? (char)')' : ']');
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_const1 = pool.register(this.m_const1);
        this.m_const2 = pool.register(this.m_const2);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        if (!this.m_fExclude1) {
            out.writeByte((this.m_fExclude2 ? Constant.Format.RangeExclusive : Constant.Format.RangeInclusive).ordinal());
        } else {
            out.writeByte(Constant.Format.Range.ordinal());
            out.writeByte((this.m_fExclude1 ? 1 : 0) | (this.m_fExclude2 ? 2 : 0));
        }
        Handy.writePackedLong(out, this.m_const1.getPosition());
        Handy.writePackedLong(out, this.m_const2.getPosition());
    }

    @Override
    public String getDescription() {
        return this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_const1, Hash.of(this.m_const2, Hash.of(this.m_fExclude1, Hash.of(this.m_fExclude2))));
    }

    public static void testSize(ConstantPool pool) {
        IntConstant n0 = pool.ensureIntConstant(0L);
        IntConstant n1 = pool.ensureIntConstant(1L);
        RangeConstant r0e0e = pool.ensureRangeConstant(n0, true, n0, true);
        RangeConstant r0e0i = pool.ensureRangeConstant(n0, true, n0, false);
        RangeConstant r0i0e = pool.ensureRangeConstant(n0, false, n0, true);
        RangeConstant r0i0i = pool.ensureRangeConstant(n0, false, n0, false);
        assert (r0e0e.size() == 0L);
        assert (r0e0i.size() == 0L);
        assert (r0i0e.size() == 0L);
        assert (r0i0i.size() == 1L);
        RangeConstant r0e1e = pool.ensureRangeConstant(n0, true, n1, true);
        RangeConstant r0e1i = pool.ensureRangeConstant(n0, true, n1, false);
        RangeConstant r0i1e = pool.ensureRangeConstant(n0, false, n1, true);
        RangeConstant r0i1i = pool.ensureRangeConstant(n0, false, n1, false);
        assert (r0e1e.size() == 0L);
        assert (r0e1i.size() == 1L);
        assert (r0i1e.size() == 1L);
        assert (r0i1i.size() == 2L);
    }
}

