/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.Register;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TerminalTypeConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.TypedefConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Hash;

public class RecursiveTypeConstant
extends TerminalTypeConstant {
    public RecursiveTypeConstant(ConstantPool pool, TypedefConstant constId) {
        super(pool, constId);
    }

    public RecursiveTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    public TypedefConstant getTypedef() {
        return (TypedefConstant)this.ensureResolvedConstant();
    }

    protected TypeConstant getReferredToType() {
        return ((TypedefConstant)this.ensureResolvedConstant()).getReferredToType();
    }

    @Override
    public boolean isComposedOfAny(Set<IdentityConstant> setIds) {
        return false;
    }

    @Override
    public boolean isImmutable() {
        return this.getReferredToType().isImmutable();
    }

    @Override
    public boolean isService() {
        return false;
    }

    @Override
    public boolean containsGenericParam(String sName) {
        return false;
    }

    @Override
    public TypeConstant getGenericParamType(String sName, List<TypeConstant> listParams) {
        return null;
    }

    @Override
    public boolean containsRecursiveType() {
        return true;
    }

    @Override
    public boolean containsFunctionType() {
        return false;
    }

    @Override
    public boolean isSingleDefiningConstant() {
        return false;
    }

    @Override
    public Constant getDefiningConstant() {
        throw new IllegalStateException();
    }

    @Override
    public ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, MethodConstant idMethod, ComponentResolver.ResolutionCollector collector) {
        return ComponentResolver.ResolutionResult.UNKNOWN;
    }

    @Override
    public TypeConstant resolveGenerics(ConstantPool pool, GenericTypeResolver resolver) {
        return this;
    }

    @Override
    public TypeConstant resolveConstraints(boolean fPendingOnly) {
        return this;
    }

    @Override
    public TypeConstant resolveDynamicConstraints(Register register) {
        return this;
    }

    @Override
    public TypeConstant adoptParameters(ConstantPool pool, TypeConstant typeFrom) {
        return this;
    }

    @Override
    public TypeConstant adoptParameters(ConstantPool pool, TypeConstant[] atypeParams) {
        return this;
    }

    @Override
    public TypeConstant[] collectGenericParameters() {
        return null;
    }

    @Override
    public TypeConstant resolveAutoNarrowing(ConstantPool pool, boolean fRetainParams, TypeConstant typeTarget, IdentityConstant idCtx) {
        return this;
    }

    @Override
    public TypeConstant resolveTypeParameter(TypeConstant typeActual, String sFormalName) {
        return null;
    }

    @Override
    public boolean isTuple() {
        return false;
    }

    @Override
    public boolean extendsClass(IdentityConstant constClass) {
        return false;
    }

    @Override
    public TypeConstant.Category getCategory() {
        return TypeConstant.Category.OTHER;
    }

    @Override
    public boolean isSingleUnderlyingClass(boolean fAllowInterface) {
        return false;
    }

    @Override
    public IdentityConstant getSingleUnderlyingClass(boolean fAllowInterface) {
        throw new IllegalStateException();
    }

    @Override
    public boolean isExplicitClassIdentity(boolean fAllowParams) {
        return false;
    }

    @Override
    public Component.Format getExplicitClassFormat() {
        throw new IllegalStateException();
    }

    @Override
    public TypeConstant getExplicitClassInto(boolean fResolve) {
        throw new IllegalStateException();
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public boolean isTypeOfType() {
        return false;
    }

    @Override
    public TypeConstant.Relation calculateRelation(TypeConstant typeLeft) {
        return this.getReferredToType().calculateRelation(typeLeft);
    }

    @Override
    protected TypeConstant.Relation calculateRelationToLeft(TypeConstant typeLeft) {
        return this.getReferredToType().calculateRelationToLeft(typeLeft);
    }

    @Override
    protected TypeConstant.Relation calculateRelationToRight(TypeConstant typeRight) {
        return this.getReferredToType().calculateRelationToRight(typeRight);
    }

    @Override
    public Set<SignatureConstant> isInterfaceAssignableFrom(TypeConstant typeRight, Constants.Access accessLeft, List<TypeConstant> listLeft) {
        return this.getConstantPool().typeObject().isInterfaceAssignableFrom(typeRight, accessLeft, listLeft);
    }

    @Override
    public boolean containsSubstitutableMethod(SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams) {
        return this.getConstantPool().typeObject().containsSubstitutableMethod(signature, access, fFunction, listParams);
    }

    @Override
    public TypeConstant.Usage checkConsumption(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return TypeConstant.Usage.NO;
    }

    @Override
    public TypeConstant.Usage checkProduction(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return TypeConstant.Usage.NO;
    }

    @Override
    protected Object getLocator() {
        return null;
    }

    @Override
    public TypeInfo ensureTypeInfoInternal(ErrorListener errs) {
        return this.getConstantPool().typeObject().ensureTypeInfo(errs);
    }

    @Override
    public ClassTemplate getTemplate(Container container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int callEquals(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return this.getReferredToType().callEquals(frame, hValue1, hValue2, iReturn);
    }

    @Override
    public int callCompare(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return this.getReferredToType().callCompare(frame, hValue1, hValue2, iReturn);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.RecursiveType;
    }

    @Override
    public boolean containsUnresolved() {
        return false;
    }

    @Override
    public TypeConstant resolveTypedefs() {
        return this;
    }

    @Override
    public boolean validate(ErrorListener errs) {
        return false;
    }

    @Override
    protected int computeHashCode() {
        TypedefConstant constTypedef = this.getTypedef();
        return Hash.of(constTypedef.getParentConstant(), Hash.of(constTypedef.getName()));
    }
}

