/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class RegExConstant
extends ValueConstant {
    private final String f_regex;
    private final int f_nFlags;

    public RegExConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        this(pool, Handy.readUtf8String(in), in.readInt());
    }

    public RegExConstant(ConstantPool pool, String regex, int nFlags) {
        super(pool);
        assert (regex != null);
        this.f_regex = regex;
        this.f_nFlags = nFlags;
    }

    @Override
    public String getValue() {
        return this.f_regex;
    }

    public int getFlags() {
        return this.f_nFlags;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.RegEx;
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().typeRegEx();
    }

    @Override
    public Object getLocator() {
        return this.f_regex;
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof RegExConstant)) {
            return -1;
        }
        int n = this.f_regex.compareTo(((RegExConstant)that).f_regex);
        if (n == 0) {
            n = Integer.compare(this.f_nFlags, ((RegExConstant)that).f_nFlags);
        }
        return n;
    }

    @Override
    public String getValueString() {
        return Handy.quotedString(this.f_regex);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writeUtf8String(out, this.f_regex);
        out.writeInt(this.f_nFlags);
    }

    @Override
    public String getDescription() {
        return "regEx=" + this.getValueString() + "; flags=" + this.f_nFlags;
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.f_regex, Hash.of(this.f_nFlags));
    }
}

