/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Register;
import org.xvm.asm.constants.FrameDependentConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class RegisterConstant
extends FrameDependentConstant {
    private final int f_nReg;
    private transient Register m_reg;

    public RegisterConstant(ConstantPool pool, Register reg) {
        super(pool);
        this.m_reg = reg;
        this.f_nReg = reg.getIndex();
    }

    public RegisterConstant(ConstantPool pool, DataInput in) throws IOException {
        super(pool);
        this.f_nReg = Handy.readPackedInt(in);
    }

    public Register getRegister() {
        return this.m_reg;
    }

    public int getRegisterIndex() {
        return this.m_reg == null ? this.f_nReg : this.m_reg.getIndex();
    }

    @Override
    public ObjectHandle getHandle(Frame frame) {
        try {
            int nReg = this.getRegisterIndex();
            return nReg == -4 ? ObjectHandle.DEFAULT : frame.getArgument(nReg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return new ObjectHandle.DeferredCallHandle(e.getExceptionHandle());
        }
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Register;
    }

    @Override
    public boolean containsUnresolved() {
        return this.getRegisterIndex() >= 1000000000;
    }

    @Override
    protected int compareDetails(Constant constant) {
        int n;
        assert (this.getRegisterIndex() < 1000000000);
        if (constant instanceof RegisterConstant) {
            RegisterConstant that = (RegisterConstant)constant;
            n = this.getRegisterIndex() - that.getRegisterIndex();
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public TypeConstant getType() {
        TypeConstant type = this.m_reg == null ? null : this.m_reg.getType();
        return type == null ? this.getConstantPool().typeObject() : type;
    }

    @Override
    public String getValueString() {
        int nReg = this.getRegisterIndex();
        return "Register " + (nReg >= 1000000000 ? "?" : String.valueOf(nReg));
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
        if (this.m_reg == null) {
            Handy.writePackedLong(out, this.f_nReg);
        } else {
            assert (!this.m_reg.isUnknown());
            Handy.writePackedLong(out, this.m_reg.getIndex());
        }
    }

    @Override
    public String getDescription() {
        return this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.getRegisterIndex());
    }
}

