/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.xvm.asm.Annotation;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.Register;
import org.xvm.asm.constants.ChildInfo;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.ParamInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.ListMap;

public abstract class RelationalTypeConstant
extends TypeConstant {
    private int m_iType1;
    private int m_iType2;
    protected TypeConstant m_constType1;
    protected TypeConstant m_constType2;

    protected RelationalTypeConstant(ConstantPool pool, TypeConstant constType1, TypeConstant constType2) {
        super(pool);
        if (constType1 == null || constType2 == null) {
            throw new IllegalArgumentException("types required");
        }
        this.m_constType1 = constType1;
        this.m_constType2 = constType2;
    }

    protected RelationalTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iType1 = Handy.readMagnitude(in);
        this.m_iType2 = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_constType1 = (TypeConstant)pool.getConstant(this.m_iType1);
        this.m_constType2 = (TypeConstant)pool.getConstant(this.m_iType2);
    }

    protected abstract TypeConstant cloneRelational(ConstantPool var1, TypeConstant var2, TypeConstant var3);

    public TypeConstant simplify(ConstantPool pool) {
        TypeConstant typeS = this.simplifyInternal(this.m_constType1, this.m_constType2);
        return typeS == null ? this : typeS;
    }

    protected TypeConstant simplifyOrClone(ConstantPool pool, TypeConstant type1, TypeConstant type2) {
        TypeConstant typeS = this.simplifyInternal(type1, type2);
        return typeS == null ? this.cloneRelational(pool, type1, type2) : typeS;
    }

    protected abstract TypeConstant simplifyInternal(TypeConstant var1, TypeConstant var2);

    @Override
    public boolean isRelationalType() {
        return true;
    }

    @Override
    public TypeConstant getUnderlyingType() {
        return this.m_constType1;
    }

    @Override
    public TypeConstant getUnderlyingType2() {
        return this.m_constType2;
    }

    @Override
    public boolean isShared(ConstantPool poolOther) {
        return this.m_constType1.isShared(poolOther) && this.m_constType2.isShared(poolOther);
    }

    @Override
    public boolean isComposedOfAny(Set<IdentityConstant> setIds) {
        return this.m_constType1.isComposedOfAny(setIds) || this.m_constType2.isComposedOfAny(setIds);
    }

    @Override
    public TypeConstant removeImmutable() {
        return this.simplifyOrClone(this.getConstantPool(), this.m_constType1.removeImmutable(), this.m_constType2.removeImmutable());
    }

    @Override
    public boolean isAccessSpecified() {
        return false;
    }

    @Override
    public Constants.Access getAccess() {
        return Constants.Access.PUBLIC;
    }

    @Override
    public boolean isAccessModifiable() {
        return false;
    }

    @Override
    public TypeConstant adjustAccess(IdentityConstant idClass) {
        return this;
    }

    @Override
    public int getTypeDepth() {
        return this.m_constType1.getTypeDepth() + this.m_constType2.getTypeDepth();
    }

    @Override
    public boolean extendsClass(IdentityConstant constClass) {
        return this.m_constType1.extendsClass(constClass) || this.m_constType2.extendsClass(constClass);
    }

    @Override
    public Constant getDefiningConstant() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOnlyNullable() {
        return this.m_constType1.isOnlyNullable() && this.m_constType2.isOnlyNullable();
    }

    @Override
    public TypeConstant freeze() {
        TypeConstant typeOriginal1 = this.m_constType1;
        TypeConstant typeOriginal2 = this.m_constType2;
        TypeConstant typeImmutable1 = typeOriginal1.freeze();
        TypeConstant typeImmutable2 = typeOriginal2.freeze();
        return typeOriginal1 == typeImmutable1 && typeOriginal2 == typeImmutable2 ? this : this.cloneRelational(this.getConstantPool(), typeImmutable1, typeImmutable2);
    }

    @Override
    public TypeConstant resolveTypedefs() {
        TypeConstant constOriginal1 = this.m_constType1;
        TypeConstant constOriginal2 = this.m_constType2;
        TypeConstant constResolved1 = constOriginal1.resolveTypedefs();
        TypeConstant constResolved2 = constOriginal2.resolveTypedefs();
        return constResolved1 == constOriginal1 && constResolved2 == constOriginal2 ? this : this.cloneRelational(this.getConstantPool(), constResolved1, constResolved2);
    }

    @Override
    public TypeConstant resolveGenerics(ConstantPool pool, GenericTypeResolver resolver) {
        TypeConstant constOriginal1 = this.m_constType1;
        TypeConstant constOriginal2 = this.m_constType2;
        TypeConstant constResolved1 = constOriginal1.resolveGenerics(pool, resolver);
        TypeConstant constResolved2 = constOriginal2.resolveGenerics(pool, resolver);
        return constResolved1 == constOriginal1 && constResolved2 == constOriginal2 ? this : this.simplifyOrClone(pool, constResolved1, constResolved2);
    }

    @Override
    public TypeConstant resolveConstraints(boolean fPendingOnly) {
        TypeConstant constOriginal1 = this.m_constType1;
        TypeConstant constOriginal2 = this.m_constType2;
        TypeConstant constResolved1 = constOriginal1.resolveConstraints(fPendingOnly);
        TypeConstant constResolved2 = constOriginal2.resolveConstraints(fPendingOnly);
        return constResolved1 == constOriginal1 && constResolved2 == constOriginal2 ? this : this.simplifyOrClone(this.getConstantPool(), constResolved1, constResolved2);
    }

    @Override
    public TypeConstant resolveDynamicConstraints(Register register) {
        TypeConstant constOriginal1 = this.m_constType1;
        TypeConstant constOriginal2 = this.m_constType2;
        TypeConstant constResolved1 = constOriginal1.resolveDynamicConstraints(register);
        TypeConstant constResolved2 = constOriginal2.resolveDynamicConstraints(register);
        return constResolved1 == constOriginal1 && constResolved2 == constOriginal2 ? this : this.simplifyOrClone(this.getConstantPool(), constResolved1, constResolved2);
    }

    @Override
    public boolean containsFormalType(boolean fAllowParams) {
        return this.m_constType1.containsFormalType(fAllowParams) || this.m_constType2.containsFormalType(fAllowParams);
    }

    @Override
    public void collectFormalTypes(boolean fAllowParams, Set<TypeConstant> setFormal) {
        this.m_constType1.collectFormalTypes(fAllowParams, setFormal);
        this.m_constType2.collectFormalTypes(fAllowParams, setFormal);
    }

    @Override
    public boolean containsDynamicType(Register register) {
        return this.m_constType1.containsDynamicType(register) || this.m_constType2.containsDynamicType(register);
    }

    @Override
    public boolean containsGenericType(boolean fAllowParams) {
        return this.m_constType1.containsGenericType(fAllowParams) || this.m_constType2.containsGenericType(fAllowParams);
    }

    @Override
    public boolean containsTypeParameter(boolean fAllowParams) {
        return this.m_constType1.containsTypeParameter(fAllowParams) || this.m_constType2.containsTypeParameter(fAllowParams);
    }

    @Override
    public boolean containsRecursiveType() {
        return this.m_constType1.containsRecursiveType() || this.m_constType2.containsRecursiveType();
    }

    @Override
    public boolean containsFunctionType() {
        return this.m_constType1.containsFunctionType() || this.m_constType2.containsFunctionType();
    }

    @Override
    public TypeConstant adoptParameters(ConstantPool pool, TypeConstant[] atypeParams) {
        TypeConstant constOriginal1 = this.m_constType1;
        TypeConstant constOriginal2 = this.m_constType2;
        TypeConstant constResolved1 = constOriginal1.adoptParameters(pool, atypeParams);
        TypeConstant constResolved2 = constOriginal2.adoptParameters(pool, atypeParams);
        return constResolved1 == constOriginal1 && constResolved2 == constOriginal2 ? this : this.simplifyOrClone(pool, constResolved1, constResolved2);
    }

    @Override
    public TypeConstant[] collectGenericParameters() {
        TypeConstant[] atype1 = this.m_constType1.collectGenericParameters();
        TypeConstant[] atype2 = this.m_constType2.collectGenericParameters();
        if (atype1 == null || atype2 == null) {
            return null;
        }
        int c1 = atype1.length;
        int c2 = atype2.length;
        if (c1 == c2) {
            for (int i = 0; i < c1; ++i) {
                TypeConstant type1 = atype1[i];
                TypeConstant type2 = atype2[i];
                assert (type1.isGenericType() && type2.isGenericType());
                PropertyConstant id1 = (PropertyConstant)type1.getDefiningConstant();
                PropertyConstant id2 = (PropertyConstant)type2.getDefiningConstant();
                if (id1.getName().equals(id2.getName()) && id1.getConstraintType().equals(id2.getConstraintType())) continue;
                return null;
            }
            return atype1;
        }
        return null;
    }

    @Override
    public boolean containsAutoNarrowing(boolean fAllowVirtChild) {
        return this.m_constType1.containsAutoNarrowing(fAllowVirtChild) || this.m_constType2.containsAutoNarrowing(fAllowVirtChild);
    }

    @Override
    public TypeConstant resolveAutoNarrowing(ConstantPool pool, boolean fRetainParams, TypeConstant typeTarget, IdentityConstant idCtx) {
        TypeConstant constOriginal1 = this.m_constType1;
        TypeConstant constOriginal2 = this.m_constType2;
        TypeConstant constResolved1 = constOriginal1.resolveAutoNarrowing(pool, fRetainParams, typeTarget, idCtx);
        TypeConstant constResolved2 = constOriginal2.resolveAutoNarrowing(pool, fRetainParams, typeTarget, idCtx);
        return constResolved1 == constOriginal1 && constResolved2 == constOriginal2 ? this : this.cloneRelational(pool, constResolved1, constResolved2);
    }

    @Override
    public TypeConstant replaceUnderlying(ConstantPool pool, Function<TypeConstant, TypeConstant> transformer) {
        TypeConstant constOriginal1 = this.m_constType1;
        TypeConstant constOriginal2 = this.m_constType2;
        TypeConstant constResolved1 = transformer.apply(constOriginal1);
        TypeConstant constResolved2 = transformer.apply(constOriginal2);
        return constResolved1 == constOriginal1 && constResolved2 == constOriginal2 ? this : this.simplifyOrClone(pool, constResolved1, constResolved2);
    }

    @Override
    public TypeConstant resolveTypeParameter(TypeConstant typeActual, String sFormalName) {
        typeActual = typeActual.resolveTypedefs();
        if (this.getFormat() != typeActual.getFormat()) {
            return null;
        }
        RelationalTypeConstant that = (RelationalTypeConstant)typeActual;
        TypeConstant constThis1 = this.m_constType1;
        TypeConstant constThis2 = this.m_constType2;
        TypeConstant constThat1 = that.m_constType1;
        TypeConstant constThat2 = that.m_constType2;
        TypeConstant typeResult = constThis1.resolveTypeParameter(constThat1, sFormalName);
        if (typeResult != null) {
            return typeResult;
        }
        typeResult = constThis2.resolveTypeParameter(constThat2, sFormalName);
        if (typeResult != null) {
            return typeResult;
        }
        typeResult = constThis1.resolveTypeParameter(constThat2, sFormalName);
        if (typeResult != null) {
            return typeResult;
        }
        return constThis2.resolveTypeParameter(constThat1, sFormalName);
    }

    @Override
    public boolean isIntoPropertyType() {
        return false;
    }

    @Override
    public TypeConstant getIntoPropertyType() {
        return null;
    }

    @Override
    public boolean isIntoVariableType() {
        return false;
    }

    @Override
    public TypeConstant getIntoVariableType() {
        return null;
    }

    @Override
    public boolean isIntoMetaData(TypeConstant typeTarget, boolean fStrict) {
        return false;
    }

    @Override
    public boolean isTypeOfType() {
        return false;
    }

    @Override
    public TypeConstant widenEnumValueTypes() {
        TypeConstant constOriginal1 = this.m_constType1;
        TypeConstant constOriginal2 = this.m_constType2;
        TypeConstant constResolved1 = constOriginal1.widenEnumValueTypes();
        TypeConstant constResolved2 = constOriginal2.widenEnumValueTypes();
        return constResolved1 == constOriginal1 && constResolved2 == constOriginal2 ? this : this.simplifyOrClone(this.getConstantPool(), constResolved1, constResolved2);
    }

    @Override
    public TypeInfo ensureTypeInfo(IdentityConstant idClass, ErrorListener errs) {
        int cInvals = this.getConstantPool().getInvalidationCount();
        TypeInfo info1 = this.m_constType1.ensureTypeInfo(idClass, errs);
        TypeInfo info2 = this.m_constType2.ensureTypeInfo(idClass, errs);
        return this.mergeTypeInfo(info1, info2, cInvals, errs);
    }

    @Override
    protected TypeInfo buildTypeInfo(ErrorListener errs) {
        int cInvals = this.getConstantPool().getInvalidationCount();
        TypeInfo info1 = this.m_constType1.removeAutoNarrowing().normalizeParameters().ensureTypeInfoInternal(errs);
        TypeInfo info2 = this.m_constType2.removeAutoNarrowing().normalizeParameters().ensureTypeInfoInternal(errs);
        if (info1 == null && info2 == null) {
            return null;
        }
        return this.mergeTypeInfo(info1, info2, cInvals, errs);
    }

    protected TypeInfo mergeTypeInfo(TypeInfo info1, TypeInfo info2, int cInvals, ErrorListener errs) {
        return new TypeInfo(this, cInvals, null, 0, false, this.mergeTypeParams(info1, info2, errs), Annotation.NO_ANNOTATIONS, this.mergeAnnotations(info1, info2, errs), null, null, null, Collections.emptyList(), ListMap.EMPTY, ListMap.EMPTY, this.mergeProperties(info1, info2, errs), this.mergeMethods(info1, info2, errs), Collections.emptyMap(), Collections.emptyMap(), this.mergeChildren(info1, info2, errs), this.mergeDepends(info1, info2), info1 == null || info2 == null ? TypeInfo.Progress.Incomplete : info1.getProgress().worstOf(info2.getProgress()));
    }

    protected abstract Map<Object, ParamInfo> mergeTypeParams(TypeInfo var1, TypeInfo var2, ErrorListener var3);

    protected abstract Annotation[] mergeAnnotations(TypeInfo var1, TypeInfo var2, ErrorListener var3);

    protected abstract Map<PropertyConstant, PropertyInfo> mergeProperties(TypeInfo var1, TypeInfo var2, ErrorListener var3);

    protected abstract Map<MethodConstant, MethodInfo> mergeMethods(TypeInfo var1, TypeInfo var2, ErrorListener var3);

    protected abstract ListMap<String, ChildInfo> mergeChildren(TypeInfo var1, TypeInfo var2, ErrorListener var3);

    protected Set<TypeConstant> mergeDepends(TypeInfo info1, TypeInfo info2) {
        Set<TypeConstant> setDepends = null;
        if (info1 != null) {
            setDepends = info1.collectDependTypes(setDepends);
        }
        if (info2 != null) {
            setDepends = info2.collectDependTypes(setDepends);
        }
        return setDepends;
    }

    @Override
    protected boolean isDuckTypeAbleFrom(TypeConstant typeRight) {
        return this.getUnderlyingType().isDuckTypeAbleFrom(typeRight) && this.getUnderlyingType2().isDuckTypeAbleFrom(typeRight);
    }

    @Override
    protected TypeConstant.Usage checkProduction(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        assert (listParams.isEmpty());
        return TypeConstant.Usage.valueOf(this.m_constType1.producesFormalType(sTypeName, access) || this.m_constType2.producesFormalType(sTypeName, access));
    }

    @Override
    protected TypeConstant.Usage checkConsumption(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        assert (listParams.isEmpty());
        return TypeConstant.Usage.valueOf(this.m_constType1.consumesFormalType(sTypeName, access) || this.m_constType2.consumesFormalType(sTypeName, access));
    }

    @Override
    public ClassTemplate getTemplate(Container container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int callEquals(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int callCompare(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int callHashCode(Frame frame, ObjectHandle hValue, int iReturn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodInfo findFunctionInfo(SignatureConstant sig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && (this.m_constType1.containsUnresolved() || this.m_constType2.containsUnresolved());
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constType1);
        visitor.accept(this.m_constType2);
    }

    @Override
    protected int compareDetails(Constant obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return -1;
        }
        RelationalTypeConstant that = (RelationalTypeConstant)obj;
        int n = this.m_constType1.compareTo(that.m_constType1);
        if (n == 0) {
            n = this.m_constType2.compareTo(that.m_constType2);
        }
        return n;
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constType1 = (TypeConstant)pool.register(this.m_constType1);
        this.m_constType2 = (TypeConstant)pool.register(this.m_constType2);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, RelationalTypeConstant.indexOf(this.m_constType1));
        Handy.writePackedLong(out, RelationalTypeConstant.indexOf(this.m_constType2));
    }

    @Override
    public boolean validate(ErrorListener errs) {
        return !this.isValidated() && this.m_constType1.validate(errs) && this.m_constType2.validate(errs) && super.validate(errs);
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constType1, Hash.of(this.m_constType2));
    }
}

