/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class ServiceTypeConstant
extends TypeConstant {
    private int m_iType;
    private TypeConstant m_constType;

    public ServiceTypeConstant(ConstantPool pool, TypeConstant constType) {
        super(pool);
        if (constType == null) {
            throw new IllegalArgumentException("type required");
        }
        this.m_constType = constType;
    }

    public ServiceTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iType = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_constType = (TypeConstant)this.getConstantPool().getConstant(this.m_iType);
    }

    @Override
    public boolean isModifyingType() {
        return true;
    }

    @Override
    public TypeConstant getUnderlyingType() {
        return this.m_constType;
    }

    @Override
    public boolean isService() {
        return true;
    }

    @Override
    protected TypeConstant cloneSingle(ConstantPool pool, TypeConstant type) {
        return pool.ensureServiceTypeConstant(type);
    }

    @Override
    protected TypeInfo buildTypeInfo(ErrorListener errs) {
        return this.m_constType.ensureTypeInfoInternal(errs);
    }

    @Override
    public TypeConstant.Relation calculateRelation(TypeConstant typeLeft) {
        TypeConstant.Relation relation;
        ConstantPool pool = this.getConstantPool();
        if (typeLeft instanceof ServiceTypeConstant) {
            ServiceTypeConstant that = (ServiceTypeConstant)typeLeft;
            relation = this.m_constType.calculateRelation(that.m_constType);
        } else {
            relation = this.m_constType.equals(pool.typeObject()) ? super.calculateRelation(typeLeft) : this.m_constType.combine(pool, pool.ensureServiceTypeConstant(pool.typeObject())).calculateRelation(typeLeft);
        }
        return relation;
    }

    @Override
    protected TypeConstant.Relation calculateRelationToRight(TypeConstant typeRight) {
        return typeRight.isService() ? this.m_constType.calculateRelationToRight(typeRight) : TypeConstant.Relation.INCOMPATIBLE;
    }

    @Override
    protected boolean isDuckTypeAbleFrom(TypeConstant typeRight) {
        return typeRight.isService() && super.isDuckTypeAbleFrom(typeRight);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ServiceType;
    }

    @Override
    protected Object getLocator() {
        return this.m_constType;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_constType.containsUnresolved();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constType);
    }

    @Override
    protected int compareDetails(Constant obj) {
        int n;
        if (obj instanceof ServiceTypeConstant) {
            ServiceTypeConstant that = (ServiceTypeConstant)obj;
            n = this.m_constType.compareTo(that.m_constType);
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public String getValueString() {
        return "service " + this.m_constType.getValueString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constType = (TypeConstant)pool.register(this.m_constType);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, ServiceTypeConstant.indexOf(this.m_constType));
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constType);
    }
}

