/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.TypeSystem;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class SignatureConstant
extends PseudoConstant {
    private int m_iName;
    private int[] m_aiParams;
    private int[] m_aiReturns;
    private StringConstant m_constName;
    private TypeConstant[] m_aconstParams;
    private TypeConstant[] m_aconstReturns;
    private transient boolean m_fProperty;
    private final StampedLock m_lockPrev = new StampedLock();
    private transient SignatureConstant m_sigPrev;
    private transient int m_nCmpPrev;
    private transient String m_sJitName;

    public SignatureConstant(ConstantPool pool, String sName, TypeConstant[] params, TypeConstant[] returns) {
        super(pool);
        if (sName == null) {
            throw new IllegalArgumentException("name required");
        }
        this.m_constName = pool.ensureStringConstant(sName);
        this.m_aconstParams = SignatureConstant.validateTypes(params);
        this.m_aconstReturns = SignatureConstant.validateTypes(returns);
    }

    public SignatureConstant(ConstantPool pool, PropertyConstant constProperty) {
        super(pool);
        if (constProperty == null) {
            throw new IllegalArgumentException("property required");
        }
        this.m_constName = pool.ensureStringConstant(constProperty.getName());
        this.m_aconstParams = ConstantPool.NO_TYPES;
        this.m_aconstReturns = new TypeConstant[]{constProperty.getType()};
        this.m_fProperty = true;
    }

    public SignatureConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iName = Handy.readMagnitude(in);
        this.m_aiParams = SignatureConstant.readMagnitudeArray(in);
        this.m_aiReturns = SignatureConstant.readMagnitudeArray(in);
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_constName = (StringConstant)pool.getConstant(this.m_iName);
        this.m_aconstParams = SignatureConstant.lookupTypes(pool, this.m_aiParams);
        this.m_aconstReturns = SignatureConstant.lookupTypes(pool, this.m_aiReturns);
        this.m_aiParams = null;
        this.m_aiReturns = null;
    }

    public String getName() {
        return this.m_constName.getValue();
    }

    public int getParamCount() {
        return this.m_aconstParams.length;
    }

    public TypeConstant[] getRawParams() {
        return this.m_aconstParams;
    }

    public List<TypeConstant> getParams() {
        return Arrays.asList((TypeConstant[])this.m_aconstParams.clone());
    }

    public int getReturnCount() {
        return this.m_aconstReturns.length;
    }

    public TypeConstant[] getRawReturns() {
        return this.m_aconstReturns;
    }

    public List<TypeConstant> getReturns() {
        return Arrays.asList(this.m_aconstReturns);
    }

    @Override
    public boolean isProperty() {
        return this.m_fProperty;
    }

    public boolean containsGenericTypes() {
        for (TypeConstant type : this.m_aconstParams) {
            if (!type.containsGenericType(true)) continue;
            return true;
        }
        for (TypeConstant type : this.m_aconstReturns) {
            if (!type.containsGenericType(true)) continue;
            return true;
        }
        return false;
    }

    public boolean containsTypeParameters() {
        for (TypeConstant type : this.m_aconstParams) {
            if (!type.containsTypeParameter(true)) continue;
            return true;
        }
        for (TypeConstant type : this.m_aconstReturns) {
            if (!type.containsTypeParameter(true)) continue;
            return true;
        }
        return false;
    }

    public SignatureConstant resolveGenericTypes(ConstantPool pool, GenericTypeResolver resolver) {
        TypeConstant[] aconstReturnOriginal;
        TypeConstant[] aconstParamOriginal;
        if (resolver == null) {
            return this;
        }
        TypeConstant[] aconstParamResolved = aconstParamOriginal = this.m_aconstParams;
        boolean fDiff = false;
        int c = aconstParamOriginal.length;
        for (int i = 0; i < c; ++i) {
            TypeConstant constOriginal = aconstParamOriginal[i];
            TypeConstant constResolved = constOriginal.resolveGenerics(pool, resolver);
            if (constOriginal == constResolved) continue;
            if (aconstParamResolved == aconstParamOriginal) {
                aconstParamResolved = (TypeConstant[])aconstParamOriginal.clone();
                fDiff = true;
            }
            aconstParamResolved[i] = constResolved;
        }
        TypeConstant[] aconstReturnResolved = aconstReturnOriginal = this.m_aconstReturns;
        int c2 = aconstReturnOriginal.length;
        for (int i = 0; i < c2; ++i) {
            TypeConstant constOriginal = aconstReturnOriginal[i];
            TypeConstant constResolved = constOriginal.resolveGenerics(pool, resolver);
            if (constOriginal == constResolved) continue;
            if (aconstReturnResolved == aconstReturnOriginal) {
                aconstReturnResolved = (TypeConstant[])aconstReturnOriginal.clone();
                fDiff = true;
            }
            aconstReturnResolved[i] = constResolved;
        }
        if (fDiff) {
            SignatureConstant that = pool.ensureSignatureConstant(this.getName(), aconstParamResolved, aconstReturnResolved);
            that.m_fProperty = this.m_fProperty;
            return that;
        }
        return this;
    }

    public boolean containsAutoNarrowing(boolean fAllowVirtChild) {
        for (TypeConstant typeParam : this.m_aconstParams) {
            if (!typeParam.containsAutoNarrowing(fAllowVirtChild)) continue;
            return true;
        }
        for (TypeConstant typeReturn : this.m_aconstReturns) {
            if (!typeReturn.containsAutoNarrowing(fAllowVirtChild)) continue;
            return true;
        }
        return false;
    }

    public SignatureConstant resolveAutoNarrowing(ConstantPool pool, TypeConstant typeTarget, IdentityConstant idCtx) {
        TypeConstant[] aconstReturnOriginal;
        TypeConstant[] aconstParamOriginal;
        TypeConstant[] aconstParamResolved = aconstParamOriginal = this.m_aconstParams;
        boolean fDiff = false;
        int c = aconstParamOriginal.length;
        for (int i = 0; i < c; ++i) {
            TypeConstant constOriginal = aconstParamOriginal[i];
            TypeConstant constResolved = constOriginal.resolveAutoNarrowing(pool, false, typeTarget, idCtx);
            if (constOriginal == constResolved) continue;
            if (aconstParamResolved == aconstParamOriginal) {
                aconstParamResolved = (TypeConstant[])aconstParamOriginal.clone();
                fDiff = true;
            }
            aconstParamResolved[i] = constResolved;
        }
        TypeConstant[] aconstReturnResolved = aconstReturnOriginal = this.m_aconstReturns;
        int c2 = aconstReturnOriginal.length;
        for (int i = 0; i < c2; ++i) {
            TypeConstant constOriginal = aconstReturnOriginal[i];
            TypeConstant constResolved = constOriginal.resolveAutoNarrowing(pool, false, typeTarget, idCtx);
            if (constOriginal == constResolved) continue;
            if (aconstReturnResolved == aconstReturnOriginal) {
                aconstReturnResolved = (TypeConstant[])aconstReturnOriginal.clone();
                fDiff = true;
            }
            aconstReturnResolved[i] = constResolved;
        }
        return fDiff ? pool.ensureSignatureConstant(this.getName(), aconstParamResolved, aconstReturnResolved) : this;
    }

    public SignatureConstant removeAutoNarrowing() {
        return this.resolveAutoNarrowing(this.getConstantPool(), null, null);
    }

    public boolean isSubstitutableFor(SignatureConstant that, TypeConstant typeCtx) {
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        int cR1 = that.getReturnCount();
        int cR2 = this.getReturnCount();
        int cP1 = that.getParamCount();
        int cP2 = this.getParamCount();
        if (cP2 != cP1 || cR2 < cR1) {
            return false;
        }
        TypeConstant[] aR1 = that.getRawReturns();
        TypeConstant[] aR2 = this.getRawReturns();
        int c = Math.min(cR1, cR2);
        for (int i = 0; i < c; ++i) {
            if (aR2[i].isCovariantReturn(aR1[i], typeCtx)) continue;
            return false;
        }
        TypeConstant[] aP1 = that.getRawParams();
        TypeConstant[] aP2 = this.getRawParams();
        for (int i = 0; i < cP1; ++i) {
            if (aP2[i].isContravariantParameter(aP1[i], typeCtx)) continue;
            return false;
        }
        return true;
    }

    public boolean isCallableAs(SignatureConstant that) {
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        int cR1 = that.getReturnCount();
        int cR2 = this.getReturnCount();
        int cP1 = that.getParamCount();
        int cP2 = this.getParamCount();
        if (cP2 != cP1 || cR2 < cR1) {
            return false;
        }
        TypeConstant[] aR1 = that.getRawReturns();
        TypeConstant[] aR2 = this.getRawReturns();
        int c = Math.min(cR1, cR2);
        for (int i = 0; i < c; ++i) {
            if (aR2[i].isA(aR1[i]) || aR1[i].isA(aR2[i])) continue;
            return false;
        }
        TypeConstant[] aP1 = that.getRawParams();
        TypeConstant[] aP2 = this.getRawParams();
        for (int i = 0; i < cP1; ++i) {
            if (aP1[i].isA(aP2[i]) || aP2[i].isA(aP1[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isShared(ConstantPool poolOther) {
        if (poolOther != this.getConstantPool()) {
            for (TypeConstant type : this.m_aconstParams) {
                if (type.isShared(poolOther)) continue;
                return false;
            }
            for (TypeConstant type : this.m_aconstReturns) {
                if (type.isShared(poolOther)) continue;
                return false;
            }
        }
        return true;
    }

    public TypeConstant asFunctionType() {
        return this.getConstantPool().buildFunctionType(this.m_aconstParams, this.m_aconstReturns);
    }

    public TypeConstant asBjarneLambdaType(ConstantPool pool, TypeConstant typeTarget) {
        TypeConstant[] aconstParamsOld = this.m_aconstParams;
        int cParams = aconstParamsOld.length;
        TypeConstant[] aconstParamsNew = new TypeConstant[cParams + 1];
        aconstParamsNew[0] = typeTarget;
        System.arraycopy(aconstParamsOld, 0, aconstParamsNew, 1, cParams);
        return pool.buildFunctionType(aconstParamsNew, this.m_aconstReturns);
    }

    public TypeConstant asMethodType(ConstantPool pool, TypeConstant typeTarget) {
        return pool.ensureParameterizedTypeConstant(pool.typeMethod(), typeTarget, pool.ensureTupleType(this.m_aconstParams), pool.ensureTupleType(this.m_aconstReturns));
    }

    public TypeConstant asConstructorType(ConstantPool pool, TypeConstant typeTarget) {
        assert (this.getName().equals("construct") && this.m_aconstReturns.length == 0);
        return pool.buildFunctionType(this.m_aconstParams, typeTarget);
    }

    public SignatureConstant truncateParams(int ofStart, int cParams) {
        if (cParams < 0) {
            cParams = this.m_aconstParams.length - ofStart;
        }
        assert (ofStart >= 0);
        assert (ofStart + cParams <= this.m_aconstParams.length);
        return this.getConstantPool().ensureSignatureConstant(this.getName(), Arrays.copyOfRange(this.m_aconstParams, ofStart, ofStart + cParams), this.m_aconstReturns);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Signature;
    }

    @Override
    public boolean containsUnresolved() {
        if (this.isHashCached()) {
            return false;
        }
        if (this.m_constName.containsUnresolved()) {
            return true;
        }
        for (TypeConstant constant : this.m_aconstParams) {
            if (!constant.containsUnresolved()) continue;
            return true;
        }
        for (TypeConstant constant : this.m_aconstReturns) {
            if (!constant.containsUnresolved()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constName);
        for (TypeConstant constant : this.m_aconstParams) {
            visitor.accept(constant);
        }
        for (TypeConstant constant : this.m_aconstReturns) {
            visitor.accept(constant);
        }
    }

    @Override
    public SignatureConstant resolveTypedefs() {
        TypeConstant[] atypeOldReturns;
        TypeConstant[] atypeOldParams;
        TypeConstant[] atypeNewParams = atypeOldParams = this.m_aconstParams;
        boolean fDiff = false;
        int c = atypeOldParams.length;
        for (int i = 0; i < c; ++i) {
            TypeConstant constOld = atypeOldParams[i];
            TypeConstant constNew = constOld.resolveTypedefs();
            if (constNew == constOld) continue;
            if (atypeNewParams == atypeOldParams) {
                atypeNewParams = (TypeConstant[])atypeOldParams.clone();
                fDiff = true;
            }
            atypeNewParams[i] = constNew;
        }
        TypeConstant[] atypeNewReturns = atypeOldReturns = this.m_aconstReturns;
        int c2 = atypeOldReturns.length;
        for (int i = 0; i < c2; ++i) {
            TypeConstant constOld = atypeOldReturns[i];
            TypeConstant constNew = constOld.resolveTypedefs();
            if (constNew == constOld) continue;
            if (atypeNewReturns == atypeOldReturns) {
                atypeNewReturns = (TypeConstant[])atypeOldReturns.clone();
                fDiff = true;
            }
            atypeNewReturns[i] = constNew;
        }
        return fDiff ? this.getConstantPool().ensureSignatureConstant(this.getName(), atypeNewParams, atypeNewReturns) : this;
    }

    @Override
    protected int compareDetails(Constant obj) {
        long stamp;
        if (!(obj instanceof SignatureConstant)) {
            return -1;
        }
        SignatureConstant that = (SignatureConstant)obj;
        if (that == this.m_sigPrev) {
            long stamp2 = this.m_lockPrev.tryOptimisticRead();
            int nCmpPrev = this.m_nCmpPrev;
            if (that == this.m_sigPrev && this.m_lockPrev.validate(stamp2)) {
                return nCmpPrev;
            }
        }
        boolean fCache = this.getConstantPool() == that.getConstantPool() && !this.containsUnresolved();
        int n = this.m_constName.compareTo(that.m_constName);
        if (n == 0 && (n = SignatureConstant.compareTypes(this.m_aconstParams, that.m_aconstParams)) == 0 && (n = SignatureConstant.compareTypes(this.m_aconstReturns, that.m_aconstReturns)) == 0) {
            n = (this.m_fProperty ? 1 : 0) - (that.m_fProperty ? 1 : 0);
        }
        if (fCache && (stamp = this.m_lockPrev.tryWriteLock()) != 0L) {
            this.m_sigPrev = that;
            this.m_nCmpPrev = n;
            this.m_lockPrev.unlockWrite(stamp);
        }
        return n;
    }

    @Override
    public String getValueString() {
        boolean first;
        StringBuilder sb = new StringBuilder();
        switch (this.m_aconstReturns.length) {
            case 0: {
                sb.append("void");
                break;
            }
            case 1: {
                sb.append(this.m_aconstReturns[0].getValueString());
                break;
            }
            default: {
                sb.append('(');
                first = true;
                for (TypeConstant type : this.m_aconstReturns) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(type.getValueString());
                }
                sb.append(')');
            }
        }
        sb.append(' ').append(this.m_constName.getValue());
        if (!this.m_fProperty) {
            sb.append('(');
            first = true;
            for (TypeConstant type : this.m_aconstParams) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(type.getValueString());
            }
            sb.append(')');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ensureJitMethodName(TypeSystem ts) {
        Object sJitName = this.m_sJitName;
        if (sJitName == null) {
            SignatureConstant sig;
            ConstantPool pool = ts.findOwnerPool(this);
            SignatureConstant signatureConstant = sig = (SignatureConstant)pool.register(this);
            synchronized (signatureConstant) {
                sJitName = sig.m_sJitName;
                if (sJitName == null) {
                    String sNameOrig = this.getName();
                    sig.m_sJitName = sJitName = sNameOrig + ts.xvm.createUniqueSuffix(sNameOrig);
                }
            }
        }
        return sJitName;
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constName = (StringConstant)pool.register(this.m_constName);
        this.m_aconstParams = TypeConstant.registerTypeConstants(pool, this.m_aconstParams);
        this.m_aconstReturns = TypeConstant.registerTypeConstants(pool, this.m_aconstReturns);
        long stamp = this.m_lockPrev.writeLock();
        this.m_sigPrev = null;
        this.m_lockPrev.unlockWrite(stamp);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        if (this.m_fProperty) {
            throw new IllegalStateException("Signature refers to a property");
        }
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constName.getPosition());
        SignatureConstant.writeTypes(out, this.m_aconstParams);
        SignatureConstant.writeTypes(out, this.m_aconstReturns);
    }

    @Override
    public String getDescription() {
        return "name=" + this.getName() + ", params=" + SignatureConstant.formatTypes(this.m_aconstParams) + ", returns=" + SignatureConstant.formatTypes(this.m_aconstReturns);
    }

    @Override
    protected int computeHashCode() {
        return Hash.of(this.m_aconstParams, Hash.of(this.m_aconstReturns, Hash.of(this.m_constName)));
    }

    protected static int[] readMagnitudeArray(DataInput in) throws IOException {
        int c = Handy.readMagnitude(in);
        int[] an = new int[c];
        for (int i = 0; i < c; ++i) {
            an[i] = Handy.readMagnitude(in);
        }
        return an;
    }

    protected static TypeConstant[] lookupTypes(ConstantPool pool, int[] an) {
        int c = an.length;
        TypeConstant[] aconst = new TypeConstant[c];
        for (int i = 0; i < c; ++i) {
            aconst[i] = (TypeConstant)pool.getConstant(an[i]);
        }
        return aconst;
    }

    protected static void writeTypes(DataOutput out, TypeConstant[] aconst) throws IOException {
        Handy.writePackedLong(out, aconst.length);
        for (TypeConstant typeConstant : aconst) {
            Handy.writePackedLong(out, typeConstant.getPosition());
        }
    }

    protected static TypeConstant[] validateTypes(TypeConstant[] aconst) {
        if (aconst == null) {
            return ConstantPool.NO_TYPES;
        }
        for (TypeConstant constant : aconst) {
            if (constant != null) continue;
            throw new IllegalArgumentException("type required");
        }
        return aconst;
    }

    protected static int compareTypes(TypeConstant[] aconstThis, TypeConstant[] aconstThat) {
        int cThis = aconstThis.length;
        int cThat = aconstThat.length;
        int c = Math.min(cThis, cThat);
        for (int i = 0; i < c; ++i) {
            int n = aconstThis[i].compareTo(aconstThat[i]);
            if (n == 0) continue;
            return n;
        }
        return cThis - cThat;
    }

    protected static String formatTypes(TypeConstant[] aconst) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        int c = aconst.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aconst[i].getValueString());
        }
        sb.append(')');
        return sb.toString();
    }
}

