/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class SingletonConstant
extends ValueConstant {
    private final Constant.Format f_fmt;
    private transient int m_iClass;
    private IdentityConstant m_constClass;
    private transient ObjectHandle m_handle;
    private transient boolean m_fInitializing;

    public SingletonConstant(ConstantPool pool, Constant.Format format, IdentityConstant constClass) {
        super(pool);
        switch (format) {
            case SingletonConst: 
            case EnumValueConst: 
            case SingletonService: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid format " + String.valueOf((Object)format));
            }
        }
        if (constClass == null) {
            throw new IllegalArgumentException("class of the singleton value required");
        }
        this.f_fmt = format;
        this.m_constClass = constClass;
    }

    public SingletonConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.f_fmt = format;
        this.m_iClass = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_constClass = (IdentityConstant)this.getConstantPool().getConstant(this.m_iClass);
    }

    @Override
    public TypeConstant getType() {
        return this.m_constClass.getType();
    }

    public IdentityConstant getClassConstant() {
        return this.m_constClass;
    }

    @Override
    public Constant getValue() {
        return this.m_constClass;
    }

    public ObjectHandle getHandle() {
        return this.m_handle;
    }

    public void setHandle(ObjectHandle handle) {
        assert (handle != null);
        this.m_handle = handle;
        this.m_fInitializing = false;
    }

    public boolean markInitializing() {
        if (this.m_fInitializing) {
            this.m_handle = new ObjectHandle.InitializingHandle(this);
            return false;
        }
        this.m_fInitializing = true;
        return true;
    }

    @Override
    public Constant.Format getFormat() {
        return this.f_fmt;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_constClass.containsUnresolved();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constClass);
    }

    @Override
    public SingletonConstant resolveTypedefs() {
        IdentityConstant constOld = this.m_constClass;
        IdentityConstant constNew = (IdentityConstant)constOld.resolveTypedefs();
        return constNew == constOld ? this : (SingletonConstant)this.getConstantPool().register(new SingletonConstant(this.getConstantPool(), this.f_fmt, constNew));
    }

    @Override
    public Object getLocator() {
        return this.getClassConstant();
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof SingletonConstant)) {
            return -1;
        }
        return this.m_constClass.compareTo(((SingletonConstant)that).m_constClass);
    }

    @Override
    public String getValueString() {
        return this.m_constClass.getName();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constClass = (IdentityConstant)pool.register(this.m_constClass);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constClass.getPosition());
    }

    @Override
    public String getDescription() {
        return "singleton-" + (this.f_fmt == Constant.Format.SingletonConst ? "const=" : "service=") + this.m_constClass.getName();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constClass);
    }
}

