/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.CharConstant;
import org.xvm.asm.constants.EnumValueConstant;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.compiler.Token;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class StringConstant
extends ValueConstant {
    private final String m_sVal;

    public StringConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_sVal = Handy.readUtf8String(in);
    }

    public StringConstant(ConstantPool pool, String sVal) {
        super(pool);
        assert (sVal != null);
        this.m_sVal = sVal;
    }

    @Override
    public String getValue() {
        return this.m_sVal;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.String;
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().typeString();
    }

    @Override
    public Constant apply(Token.Id op, Constant that) {
        ConstantPool pool = this.getConstantPool();
        switch (op.TEXT + that.getFormat().name()) {
            case "+String": {
                return pool.ensureStringConstant(this.m_sVal + ((StringConstant)that).m_sVal);
            }
            case "+Char": {
                assert (Character.isValidCodePoint(((CharConstant)that).getValue()));
                return pool.ensureStringConstant(this.m_sVal + (char)((CharConstant)that).getValue().intValue());
            }
            case "+IntLiteral": 
            case "+FPLiteral": {
                return pool.ensureStringConstant(this.m_sVal + ((LiteralConstant)that).getValue());
            }
            case "+EnumValueConst": {
                return pool.ensureStringConstant(this.m_sVal + ((EnumValueConstant)that).getClassConstant().getName());
            }
            case "*IntLiteral": 
            case "*Int64": {
                int n;
                String s = this.m_sVal;
                int n2 = n = that.getFormat() == Constant.Format.IntLiteral ? ((LiteralConstant)that).getPackedInteger().getInt() : ((IntConstant)that).getValue().getInt();
                assert (n >= 0 && n * s.length() < 1000000);
                return this.getConstantPool().ensureStringConstant(s.repeat(n));
            }
            case "==String": {
                return this.getConstantPool().valOf(this.m_sVal.equals(((StringConstant)that).m_sVal));
            }
            case "!=String": {
                return this.getConstantPool().valOf(!this.m_sVal.equals(((StringConstant)that).m_sVal));
            }
            case "<String": {
                return this.getConstantPool().valOf(this.m_sVal.compareTo(((StringConstant)that).m_sVal) < 0);
            }
            case "<=String": {
                return this.getConstantPool().valOf(this.m_sVal.compareTo(((StringConstant)that).m_sVal) <= 0);
            }
            case ">String": {
                return this.getConstantPool().valOf(this.m_sVal.compareTo(((StringConstant)that).m_sVal) > 0);
            }
            case ">=String": {
                return this.getConstantPool().valOf(this.m_sVal.compareTo(((StringConstant)that).m_sVal) >= 0);
            }
            case "<=>String": {
                return this.getConstantPool().valOrd(this.m_sVal.compareTo(((StringConstant)that).m_sVal));
            }
            case "..String": {
                return this.getConstantPool().ensureRangeConstant(this, that);
            }
        }
        return super.apply(op, that);
    }

    @Override
    public Object getLocator() {
        return this.m_sVal;
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof StringConstant)) {
            return -1;
        }
        return this.m_sVal.compareTo(((StringConstant)that).m_sVal);
    }

    @Override
    public String getValueString() {
        return Handy.quotedString(this.m_sVal);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writeUtf8String(out, this.m_sVal);
    }

    @Override
    public String getDescription() {
        return "char-string=" + this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_sVal);
    }
}

