/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.Register;
import org.xvm.asm.constants.ChildClassConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.DynamicFormalConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.FormalTypeChildConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.KeywordConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.NativeRebaseConstant;
import org.xvm.asm.constants.ParentClassConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.ThisClassConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.asm.constants.TypedefConstant;
import org.xvm.asm.constants.VirtualChildTypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class TerminalTypeConstant
extends TypeConstant {
    private transient int m_iDef;
    private Constant m_constId;

    public TerminalTypeConstant(ConstantPool pool, Constant constId) {
        super(pool);
        if (!constId.getFormat().isTypeable()) {
            throw new IllegalArgumentException("constant " + String.valueOf((Object)constId.getFormat()) + " is not a Module, Package, Class, Typedef, or formal type parameter");
        }
        this.m_constId = constId;
    }

    public TerminalTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iDef = Handy.readIndex(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_constId = this.getConstantPool().getConstant(this.m_iDef);
    }

    @Override
    public boolean isShared(ConstantPool poolOther) {
        Constant constant = this.m_constId;
        return switch (constant.getFormat()) {
            case Constant.Format.NativeClass, Constant.Format.IsConst, Constant.Format.IsEnum, Constant.Format.IsModule, Constant.Format.IsPackage, Constant.Format.IsClass -> true;
            case Constant.Format.Module, Constant.Format.Package, Constant.Format.Class -> ((IdentityConstant)constant).isShared(poolOther);
            case Constant.Format.Property, Constant.Format.TypeParameter, Constant.Format.FormalTypeChild, Constant.Format.DynamicFormal -> ((FormalConstant)constant).getParentConstant().isShared(poolOther);
            case Constant.Format.ThisClass, Constant.Format.ParentClass, Constant.Format.ChildClass -> ((PseudoConstant)constant).getDeclarationLevelClass().isShared(poolOther);
            case Constant.Format.Typedef -> ((TypedefConstant)constant).getParentConstant().isShared(poolOther);
            default -> throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
        };
    }

    @Override
    public boolean isComposedOfAny(Set<IdentityConstant> setIds) {
        Constant constant = this.ensureResolvedConstant();
        return switch (constant.getFormat()) {
            case Constant.Format.Module, Constant.Format.Package, Constant.Format.Class -> setIds.contains((IdentityConstant)constant);
            case Constant.Format.Property, Constant.Format.TypeParameter, Constant.Format.FormalTypeChild -> setIds.contains(((FormalConstant)constant).getParentConstant());
            case Constant.Format.ThisClass, Constant.Format.ParentClass, Constant.Format.ChildClass -> setIds.contains(((PseudoConstant)constant).getDeclarationLevelClass());
            case Constant.Format.NativeClass, Constant.Format.IsConst, Constant.Format.IsEnum, Constant.Format.IsModule, Constant.Format.IsPackage, Constant.Format.IsClass, Constant.Format.UnresolvedName -> false;
            case Constant.Format.Typedef -> ((TypedefConstant)constant).getReferredToType().isComposedOfAny(setIds);
            default -> throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
        };
    }

    @Override
    public boolean isImmutabilitySpecified() {
        TypeConstant type = this.resolveTypedefs();
        return type != this && type.isImmutabilitySpecified();
    }

    @Override
    public boolean isImmutable() {
        IdentityConstant idClass;
        TypeConstant type = this.resolveTypedefs();
        if (type != this) {
            return type.isImmutable();
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case Module: 
            case Package: {
                return true;
            }
            case IsClass: {
                return false;
            }
            case Property: 
            case FormalTypeChild: 
            case DynamicFormal: {
                FormalConstant constFormal = (FormalConstant)constant;
                TypeConstant typeParent = constFormal.getParentConstant().getType();
                TypeConstant typeConstraint = constFormal.getConstraintType();
                return typeConstraint.isImmutable() || typeParent.getAccess() != Constants.Access.STRUCT && typeParent.isImmutable() && !typeConstraint.isA(this.getConstantPool().typeService());
            }
            case TypeParameter: {
                return ((FormalConstant)constant).getConstraintType().isImmutable();
            }
            case NativeClass: {
                constant = ((NativeRebaseConstant)constant).getClassConstant();
            }
            case Class: {
                idClass = (IdentityConstant)constant;
                break;
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                idClass = ((PseudoConstant)constant).getDeclarationLevelClass();
                break;
            }
            default: {
                throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
            }
        }
        ClassStructure clz = (ClassStructure)idClass.getComponent();
        return clz != null && clz.isImmutable();
    }

    @Override
    public boolean isService() {
        IdentityConstant idClass;
        TypeConstant type = this.resolveTypedefs();
        if (type != this) {
            return type.isService();
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: 
            case Module: 
            case Package: {
                return false;
            }
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                return ((FormalConstant)constant).getConstraintType().isService();
            }
            case NativeClass: {
                constant = ((NativeRebaseConstant)constant).getClassConstant();
            }
            case Class: {
                idClass = (IdentityConstant)constant;
                break;
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                idClass = ((PseudoConstant)constant).getDeclarationLevelClass();
                break;
            }
            default: {
                throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
            }
        }
        ClassStructure clz = (ClassStructure)idClass.getComponent();
        return clz != null && clz.isService();
    }

    @Override
    public boolean isAccessSpecified() {
        TypeConstant type = this.resolveTypedefs();
        return type != this && type.isAccessSpecified();
    }

    @Override
    public Constants.Access getAccess() {
        TypeConstant type = this.resolveTypedefs();
        return type == this ? Constants.Access.PUBLIC : type.getAccess();
    }

    @Override
    public boolean isAccessModifiable() {
        return !this.isFormalType();
    }

    @Override
    public boolean isParamsSpecified() {
        TypeConstant type = this.resolveTypedefs();
        return type != this && type.isParamsSpecified();
    }

    @Override
    public int getMaxParamsCount() {
        if (!this.isSingleDefiningConstant()) {
            return 0;
        }
        Constant constant = this.getDefiningConstant();
        return switch (constant.getFormat()) {
            case Constant.Format.Module, Constant.Format.Package, Constant.Format.Property, Constant.Format.TypeParameter, Constant.Format.FormalTypeChild -> 0;
            case Constant.Format.Class -> ((ClassStructure)((ClassConstant)constant).getComponent()).getTypeParamCount();
            case Constant.Format.ThisClass, Constant.Format.ParentClass, Constant.Format.ChildClass -> ((ClassStructure)((PseudoConstant)constant).getDeclarationLevelClass().getComponent()).getTypeParamCount();
            default -> throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
        };
    }

    @Override
    public boolean containsGenericParam(String sName) {
        IdentityConstant idClz;
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().containsGenericParam(sName);
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                return ((FormalConstant)constant).getConstraintType().containsGenericParam(sName);
            }
            case NativeClass: {
                idClz = ((NativeRebaseConstant)constant).getClassConstant();
                break;
            }
            case Module: 
            case Package: 
            case Class: {
                idClz = (IdentityConstant)constant;
                break;
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                idClz = ((PseudoConstant)constant).getDeclarationLevelClass();
                break;
            }
            default: {
                throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
            }
        }
        ClassStructure clz = (ClassStructure)idClz.getComponent();
        return clz.containsGenericParamType(sName);
    }

    @Override
    protected TypeConstant getGenericParamType(String sName, List<TypeConstant> listParams) {
        IdentityConstant idClz;
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().getGenericParamType(sName, listParams);
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                assert (listParams.isEmpty());
                return ((FormalConstant)constant).getConstraintType().getGenericParamType(sName, listParams);
            }
            case NativeClass: {
                idClz = ((NativeRebaseConstant)constant).getClassConstant();
                break;
            }
            case Module: 
            case Package: 
            case Class: {
                idClz = (IdentityConstant)constant;
                break;
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                idClz = ((PseudoConstant)constant).getDeclarationLevelClass();
                break;
            }
            default: {
                throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
            }
        }
        ClassStructure clz = (ClassStructure)idClz.getComponent();
        ConstantPool pool = this.getConstantPool();
        TerminalTypeConstant typeActual = listParams.isEmpty() ? this : pool.ensureParameterizedTypeConstant(this, listParams.toArray(TypeConstant.NO_TYPES));
        return clz.getGenericParamType(pool, sName, typeActual);
    }

    @Override
    public boolean isAnnotated() {
        TypeConstant type = this.resolveTypedefs();
        return type != this && type.isAnnotated();
    }

    @Override
    public boolean isVirtualChild() {
        TypeConstant type = this.resolveTypedefs();
        return type != this && type.isVirtualChild();
    }

    @Override
    public boolean isSingleDefiningConstant() {
        Constant constId = this.ensureResolvedConstant();
        return constId.getFormat() != Constant.Format.Typedef || ((TypedefConstant)constId).getReferredToType().isSingleDefiningConstant();
    }

    @Override
    public Constant getDefiningConstant() {
        Constant constId = this.ensureResolvedConstant();
        return constId.getFormat() == Constant.Format.Typedef ? ((TypedefConstant)constId).getReferredToType().getDefiningConstant() : constId;
    }

    protected Constant ensureResolvedConstant() {
        Constant constId = this.m_constId;
        Constant resolved = constId.resolve();
        if (resolved != constId && resolved != null) {
            this.m_constId = constId = resolved;
            assert (!constId.containsUnresolved());
        }
        return constId;
    }

    @Override
    public ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, MethodConstant idMethod, ComponentResolver.ResolutionCollector collector) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().resolveContributedName(sName, access, idMethod, collector);
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: 
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                return ComponentResolver.ResolutionResult.UNKNOWN;
            }
            case NativeClass: {
                constant = ((NativeRebaseConstant)constant).getClassConstant();
            }
            case Module: 
            case Package: 
            case Class: {
                IdentityConstant idClz = (IdentityConstant)constant;
                if (idMethod != null) {
                    if (idClz.isNestMateOf(idMethod.getClassIdentity())) {
                        access = Constants.Access.PRIVATE;
                    } else {
                        IdentityConstant idParent = idClz.getParentConstant();
                        if (idParent instanceof MethodConstant && idMethod.isDescendant(idParent)) {
                            access = Constants.Access.PRIVATE;
                        }
                    }
                }
                return idClz.getComponent().resolveName(sName, access, collector);
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                return ((PseudoConstant)constant).getDeclarationLevelClass().getType().resolveContributedName(sName, access, idMethod, collector);
            }
            case Typedef: {
                return ((TypedefConstant)constant).getReferredToType().resolveContributedName(sName, access, idMethod, collector);
            }
            case UnresolvedName: {
                return ComponentResolver.ResolutionResult.POSSIBLE;
            }
        }
        throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
    }

    @Override
    public TypeConstant resolveTypedefs() {
        Constant constId = this.ensureResolvedConstant();
        return constId.getFormat() == Constant.Format.Typedef ? ((TypedefConstant)constId).getReferredToType().resolveTypedefs() : this;
    }

    @Override
    public TypeConstant resolveGenerics(ConstantPool pool, GenericTypeResolver resolver) {
        FormalConstant constFormal;
        TypeConstant typeResolved;
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().resolveGenerics(pool, resolver);
        }
        Constant constId = this.getDefiningConstant();
        if (constId instanceof FormalConstant && (typeResolved = (constFormal = (FormalConstant)constId).resolve(resolver)) != null) {
            return typeResolved;
        }
        return this;
    }

    @Override
    public TypeConstant resolveConstraints(boolean fPendingOnly) {
        Constant constId;
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId2 = (TypedefConstant)this.ensureResolvedConstant();
            return constId2.getReferredToType().resolveConstraints(fPendingOnly);
        }
        if (!fPendingOnly && (constId = this.getDefiningConstant()) instanceof FormalConstant) {
            FormalConstant constFormal = (FormalConstant)constId;
            return constFormal.getConstraintType().resolveConstraints(fPendingOnly);
        }
        return this;
    }

    @Override
    public TypeConstant resolveDynamicConstraints(Register register) {
        Constant constId;
        if (this.isSingleDefiningConstant() && (constId = this.getDefiningConstant()) instanceof DynamicFormalConstant) {
            DynamicFormalConstant constDynamic = (DynamicFormalConstant)constId;
            if (register == null || constDynamic.getRegister() == register) {
                return constDynamic.getConstraintType();
            }
        }
        return this;
    }

    @Override
    public TypeConstant adoptParameters(ConstantPool pool, TypeConstant[] atypeParams) {
        IdentityConstant idClz;
        Constant constId = this.ensureResolvedConstant();
        switch (constId.getFormat()) {
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: 
            case Module: 
            case Package: 
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                return this;
            }
            case NativeClass: 
            case Class: {
                idClz = (IdentityConstant)constId;
                break;
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                idClz = ((PseudoConstant)constId).getDeclarationLevelClass();
                break;
            }
            case Typedef: {
                return ((TypedefConstant)constId).getReferredToType().adoptParameters(pool, atypeParams);
            }
            default: {
                throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constId));
            }
        }
        if (atypeParams == null) {
            atypeParams = ConstantPool.NO_TYPES;
        }
        if (this.isTuple()) {
            return pool.ensureParameterizedTypeConstant(this, atypeParams);
        }
        ClassStructure struct = (ClassStructure)idClz.getComponent();
        if (struct.isParameterized()) {
            return pool.ensureParameterizedTypeConstant(this, struct.normalizeParameters(pool, atypeParams));
        }
        return this;
    }

    @Override
    public TypeConstant[] collectGenericParameters() {
        IdentityConstant idClz;
        Constant constId = this.ensureResolvedConstant();
        switch (constId.getFormat()) {
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: 
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                return TypeConstant.NO_TYPES;
            }
            case NativeClass: 
            case Module: 
            case Package: 
            case Class: {
                idClz = (IdentityConstant)constId;
                break;
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                idClz = ((PseudoConstant)constId).getDeclarationLevelClass();
                break;
            }
            case Typedef: {
                return ((TypedefConstant)constId).getReferredToType().collectGenericParameters();
            }
            default: {
                throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constId));
            }
        }
        if (this.isTuple()) {
            return TypeConstant.NO_TYPES;
        }
        ClassStructure struct = (ClassStructure)idClz.getComponent();
        if (struct.isParameterized()) {
            return struct.getFormalType().getParamTypesArray();
        }
        return TypeConstant.NO_TYPES;
    }

    @Override
    public boolean containsAutoNarrowing(boolean fAllowVirtChild) {
        return this.ensureResolvedConstant().isAutoNarrowing();
    }

    @Override
    public boolean isAutoNarrowing() {
        return this.ensureResolvedConstant().isAutoNarrowing();
    }

    @Override
    public TypeConstant ensureAutoNarrowing() {
        return this.isAutoNarrowing() ? this : this.getConstantPool().ensureThisTypeConstant(this.getDefiningConstant(), null);
    }

    @Override
    public TypeConstant resolveAutoNarrowing(ConstantPool pool, boolean fRetainParams, TypeConstant typeTarget, IdentityConstant idCtx) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().resolveAutoNarrowing(pool, fRetainParams, typeTarget, idCtx);
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case ThisClass: {
                IdentityConstant idClass = ((ThisClassConstant)constant).getDeclarationLevelClass();
                TypeConstant typeDecl = idClass.getType();
                if (typeTarget == null || !typeTarget.isA(typeDecl)) {
                    return typeDecl;
                }
                if (idCtx != null && idCtx.getType().isA(typeDecl)) {
                    TypeConstant typeCtx = pool.ensureThisTypeConstant(idCtx, null);
                    if (typeTarget.isParamsSpecified()) {
                        typeCtx = pool.ensureParameterizedTypeConstant(typeCtx, (TypeConstant[])typeTarget.getParamTypesArray().clone());
                    }
                    if (typeTarget.isAnnotated()) {
                        typeCtx = pool.ensureAnnotatedTypeConstant(typeCtx, (Annotation[])typeTarget.getAnnotations().clone());
                    }
                    return typeCtx;
                }
                return typeTarget.removeAccess();
            }
            case ParentClass: {
                ParentClassConstant constParent = (ParentClassConstant)constant;
                if (typeTarget != null) {
                    if (typeTarget.isFormalType()) {
                        typeTarget = typeTarget.resolveConstraints();
                    }
                    if (typeTarget.isVirtualChild()) {
                        int nDepth = constParent.getDepth();
                        TypeConstant typeParent = typeTarget.getParentType();
                        while (--nDepth > 0) {
                            if (typeParent instanceof VirtualChildTypeConstant) {
                                typeParent = typeParent.getParentType();
                                continue;
                            }
                            return constParent.getDeclarationLevelClass().getType();
                        }
                        return typeParent;
                    }
                }
                return constParent.getDeclarationLevelClass().getType();
            }
            case ChildClass: {
                return ((ChildClassConstant)constant).getDeclarationLevelClass().getType();
            }
            case UnresolvedName: {
                throw new IllegalStateException("unexpected unresolved-name constant: " + String.valueOf(constant));
            }
        }
        return this;
    }

    @Override
    public TypeConstant resolveTypeParameter(TypeConstant typeActual, String sFormalName) {
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case TypeParameter: {
                Parameter param;
                TypeParameterConstant idTypeParam = (TypeParameterConstant)constant;
                MethodConstant idMethod = idTypeParam.getMethod();
                MethodStructure method = (MethodStructure)idMethod.getComponent();
                if (method == null || !(param = method.getParam(idTypeParam.getRegister())).getName().equals(sFormalName)) break;
                if (typeActual.isFormalType()) {
                    return typeActual;
                }
                ConstantPool pool = this.getConstantPool();
                TypeConstant typeConstraint = idTypeParam.getConstraintType().resolveConstraints().resolveGenerics(pool, sName -> sFormalName.equals(sName) ? typeActual : null);
                return typeActual.isA(typeConstraint) ? typeActual : null;
            }
            case Property: {
                PropertyConstant idProp = (PropertyConstant)constant;
                if (!idProp.getName().equals(sFormalName)) break;
                ConstantPool pool = this.getConstantPool();
                TypeConstant typeConstraint = idProp.getConstraintType().resolveConstraints().resolveGenerics(pool, sName -> sFormalName.equals(sName) ? typeActual : null);
                return typeActual.isA(typeConstraint) ? typeActual : null;
            }
        }
        return null;
    }

    @Override
    public boolean isTuple() {
        IdentityConstant idClz;
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().isTuple();
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: 
            case Module: 
            case Package: {
                return false;
            }
            case NativeClass: {
                idClz = ((NativeRebaseConstant)constant).getClassConstant();
                break;
            }
            case Class: {
                idClz = (ClassConstant)constant;
                break;
            }
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                return ((FormalConstant)constant).getConstraintType().isTuple();
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                idClz = ((PseudoConstant)constant).getDeclarationLevelClass();
                break;
            }
            default: {
                return false;
            }
        }
        if (idClz.equals(this.getConstantPool().clzTuple())) {
            return true;
        }
        ClassStructure clz = (ClassStructure)idClz.getComponent();
        if (clz == null) {
            throw new IllegalStateException("no ClassStructure for " + String.valueOf(idClz));
        }
        return clz.isTuple();
    }

    @Override
    public boolean isNullable() {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().isNullable();
        }
        Constant constant = this.getDefiningConstant();
        return switch (constant.getFormat()) {
            case Constant.Format.Property, Constant.Format.TypeParameter, Constant.Format.FormalTypeChild, Constant.Format.DynamicFormal -> ((FormalConstant)constant).getConstraintType().isNullable();
            default -> false;
        };
    }

    @Override
    public boolean isOnlyNullable() {
        TypeConstant typeResolved = this.resolveTypedefs();
        return this == typeResolved ? this.equals(this.getConstantPool().typeNullable()) || this.equals(this.getConstantPool().typeNull()) : typeResolved.isOnlyNullable();
    }

    @Override
    public TypeConstant removeNullable() {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().removeNullable();
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                if (!((FormalConstant)constant).getConstraintType().isNullable()) break;
                ConstantPool pool = this.getConstantPool();
                return pool.ensureDifferenceTypeConstant(this, pool.typeNullable());
            }
        }
        return super.removeNullable();
    }

    @Override
    public TypeConstant andNot(ConstantPool pool, TypeConstant that) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().andNot(pool, that);
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                TypeConstant typeR;
                TypeConstant thatBase;
                FormalConstant constFormal = (FormalConstant)constant;
                TypeConstant typeConstraint = constFormal.getConstraintType();
                if (that.isImmutabilitySpecified() && ((thatBase = that.removeImmutable()).equals(this) || thatBase.isFormalType() && thatBase.resolveConstraints().equals(typeConstraint))) {
                    that = pool.ensureImmutableTypeConstant(pool.typeObject());
                }
                return (typeR = typeConstraint.andNot(pool, that)) == null ? null : (typeR.equals(typeConstraint) ? this : this.combine(pool, typeR));
            }
        }
        return super.andNot(pool, that);
    }

    @Override
    protected TypeConstant cloneSingle(ConstantPool pool, TypeConstant type) {
        return this;
    }

    @Override
    public boolean extendsClass(IdentityConstant constClass) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().extendsClass(constClass);
        }
        Constant constant = this.getDefiningConstant();
        if (constant instanceof KeywordConstant) {
            KeywordConstant constKeyword = (KeywordConstant)constant;
            constant = constKeyword.getBaseType().getDefiningConstant();
        }
        return switch (constant.getFormat()) {
            case Constant.Format.Module, Constant.Format.Package, Constant.Format.Class -> ((ClassStructure)((IdentityConstant)constant).getComponent()).extendsClass(constClass);
            case Constant.Format.Property, Constant.Format.TypeParameter, Constant.Format.FormalTypeChild, Constant.Format.DynamicFormal -> ((FormalConstant)constant).getConstraintType().extendsClass(constClass);
            case Constant.Format.ThisClass, Constant.Format.ParentClass, Constant.Format.ChildClass -> ((ClassStructure)((PseudoConstant)constant).getDeclarationLevelClass().getComponent()).extendsClass(constClass);
            default -> throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
        };
    }

    @Override
    public boolean containsFormalType(boolean fAllowParams) {
        return this.isFormalType();
    }

    @Override
    public void collectFormalTypes(boolean fAllowParams, Set<TypeConstant> setFormal) {
        if (this.isFormalType()) {
            setFormal.add(this);
        }
    }

    @Override
    public boolean containsDynamicType(Register register) {
        if (this.isDynamicType()) {
            if (register == null) {
                return true;
            }
            DynamicFormalConstant constDynamic = (DynamicFormalConstant)this.getDefiningConstant();
            return constDynamic.getRegister() == register;
        }
        return false;
    }

    @Override
    public boolean containsGenericType(boolean fAllowParams) {
        return this.isGenericType();
    }

    @Override
    public boolean containsTypeParameter(boolean fAllowParams) {
        return this.isTypeParameter();
    }

    @Override
    public boolean containsRecursiveType() {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().containsRecursiveType();
        }
        return false;
    }

    @Override
    public boolean containsFunctionType() {
        if (this.isSingleDefiningConstant()) {
            return this.getDefiningConstant().equals(this.getConstantPool().clzFunction());
        }
        TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
        return constId.getReferredToType().containsFunctionType();
    }

    @Override
    public boolean isFormalTypeSequence() {
        return this.isGenericType() && ((FormalConstant)this.getDefiningConstant()).getConstraintType().isFormalTypeSequence();
    }

    @Override
    public boolean isDynamicType() {
        if (this.isSingleDefiningConstant()) {
            Constant constant = this.getDefiningConstant();
            return constant.getFormat() == Constant.Format.DynamicFormal;
        }
        return false;
    }

    @Override
    public TypeConstant.Category getCategory() {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().getCategory();
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case Module: 
            case Package: {
                return TypeConstant.Category.CLASS;
            }
            case NativeClass: {
                return TypeConstant.Category.IFACE;
            }
            case Class: {
                ClassStructure clz = (ClassStructure)((ClassConstant)constant).getComponent();
                if (clz == null) {
                    throw new IllegalStateException("missing class for constant: " + String.valueOf(constant));
                }
                return clz.getFormat() == Component.Format.INTERFACE ? TypeConstant.Category.IFACE : TypeConstant.Category.CLASS;
            }
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                return TypeConstant.Category.FORMAL;
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                ClassStructure clz = (ClassStructure)((PseudoConstant)constant).getDeclarationLevelClass().getComponent();
                return clz.getFormat() == Component.Format.INTERFACE ? TypeConstant.Category.IFACE : TypeConstant.Category.CLASS;
            }
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: {
                return TypeConstant.Category.OTHER;
            }
        }
        throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
    }

    @Override
    public boolean isSingleUnderlyingClass(boolean fAllowInterface) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().isSingleUnderlyingClass(fAllowInterface);
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case NativeClass: 
            case Module: 
            case Package: {
                return true;
            }
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: {
                return false;
            }
            case Class: {
                ClassStructure clz = (ClassStructure)((ClassConstant)constant).getComponent();
                return fAllowInterface || clz.getFormat() != Component.Format.INTERFACE;
            }
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                return ((FormalConstant)constant).getConstraintType().isSingleUnderlyingClass(fAllowInterface);
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                ClassStructure clz = (ClassStructure)((PseudoConstant)constant).getDeclarationLevelClass().getComponent();
                return fAllowInterface || clz.getFormat() != Component.Format.INTERFACE;
            }
        }
        throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
    }

    @Override
    public IdentityConstant getSingleUnderlyingClass(boolean fAllowInterface) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().getSingleUnderlyingClass(fAllowInterface);
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case NativeClass: 
            case Module: 
            case Package: {
                return (IdentityConstant)constant;
            }
            case Class: {
                assert (fAllowInterface || ((ClassConstant)constant).getComponent().getFormat() != Component.Format.INTERFACE);
                return (IdentityConstant)constant;
            }
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                return ((FormalConstant)constant).getConstraintType().getSingleUnderlyingClass(fAllowInterface);
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                return ((PseudoConstant)constant).getDeclarationLevelClass();
            }
        }
        throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
    }

    @Override
    public boolean isExplicitClassIdentity(boolean fAllowParams) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().isExplicitClassIdentity(fAllowParams);
        }
        Constant constant = this.getDefiningConstant();
        return switch (constant.getFormat()) {
            case Constant.Format.NativeClass, Constant.Format.Module, Constant.Format.Package, Constant.Format.Class, Constant.Format.ThisClass, Constant.Format.ParentClass, Constant.Format.ChildClass -> true;
            case Constant.Format.IsConst, Constant.Format.IsEnum, Constant.Format.IsModule, Constant.Format.IsPackage, Constant.Format.IsClass, Constant.Format.Property, Constant.Format.TypeParameter, Constant.Format.FormalTypeChild, Constant.Format.DynamicFormal -> false;
            default -> throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
        };
    }

    @Override
    public Component.Format getExplicitClassFormat() {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().getExplicitClassFormat();
        }
        Constant constant = this.getDefiningConstant();
        return switch (constant.getFormat()) {
            case Constant.Format.Module -> Component.Format.MODULE;
            case Constant.Format.Package -> Component.Format.PACKAGE;
            case Constant.Format.Class -> ((ClassConstant)constant).getComponent().getFormat();
            case Constant.Format.ThisClass, Constant.Format.ParentClass, Constant.Format.ChildClass -> ((PseudoConstant)constant).getDeclarationLevelClass().getComponent().getFormat();
            default -> throw new IllegalStateException("no class format for: " + String.valueOf(constant));
        };
    }

    @Override
    public TypeConstant getExplicitClassInto(boolean fResolve) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().getExplicitClassInto(fResolve);
        }
        Constant constId = this.getDefiningConstant();
        ClassStructure structMixin = switch (constId.getFormat()) {
            case Constant.Format.Class -> (ClassStructure)((ClassConstant)constId).getComponent();
            case Constant.Format.ThisClass, Constant.Format.ParentClass, Constant.Format.ChildClass -> (ClassStructure)((PseudoConstant)constId).getDeclarationLevelClass().getComponent();
            default -> throw new IllegalStateException("no class format for: " + String.valueOf(constId));
        };
        if (structMixin == null || structMixin.getFormat() != Component.Format.ANNOTATION && structMixin.getFormat() != Component.Format.MIXIN) {
            throw new IllegalStateException("Invalid format for " + String.valueOf(structMixin));
        }
        return structMixin.getTypeInto();
    }

    @Override
    public boolean isIntoPropertyType() {
        return this.equals(this.getConstantPool().typeProperty()) || this.isIntoVariableType();
    }

    @Override
    public TypeConstant getIntoPropertyType() {
        TypeConstant typeProp = this.getConstantPool().typeProperty();
        return this.equals(typeProp) ? typeProp : this.getIntoVariableType();
    }

    @Override
    public boolean isIntoMetaData(TypeConstant typeTarget, boolean fStrict) {
        return fStrict ? typeTarget.isSingleUnderlyingClass(true) && this.equals(typeTarget.getSingleUnderlyingClass(true).getType()) : this.isA(typeTarget);
    }

    @Override
    public boolean isIntoVariableType() {
        return this.isA(this.getConstantPool().typeRef());
    }

    @Override
    public TypeConstant getIntoVariableType() {
        ConstantPool pool = this.getConstantPool();
        if (this.isA(pool.typeVar())) {
            return pool.typeVar();
        }
        if (this.isA(pool.typeRef())) {
            return pool.typeRef();
        }
        return null;
    }

    @Override
    public boolean isConst() {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().isConst();
        }
        Constant constant = this.getDefiningConstant();
        return switch (constant.getFormat()) {
            case Constant.Format.IsConst, Constant.Format.IsEnum, Constant.Format.IsModule, Constant.Format.IsPackage, Constant.Format.Module, Constant.Format.Package -> true;
            case Constant.Format.NativeClass, Constant.Format.IsClass, Constant.Format.Property, Constant.Format.TypeParameter, Constant.Format.FormalTypeChild, Constant.Format.DynamicFormal, Constant.Format.ThisClass, Constant.Format.ParentClass, Constant.Format.ChildClass -> false;
            case Constant.Format.Class -> ((ClassStructure)((ClassConstant)constant).getComponent()).isConst();
            default -> throw new IllegalStateException("unexpected constant: " + String.valueOf(constant));
        };
    }

    @Override
    public boolean isTypeOfType() {
        Constant constId = this.ensureResolvedConstant();
        return constId.getFormat() == Constant.Format.Typedef ? ((TypedefConstant)constId).getReferredToType().isTypeOfType() : this.isExplicitClassIdentity(true) && this.getDefiningConstant().equals(this.getConstantPool().clzType());
    }

    @Override
    public TypeConstant widenEnumValueTypes() {
        return this.isEnumValue() && !this.isOnlyNullable() ? this.getSingleUnderlyingClass(false).getNamespace().getType() : this;
    }

    @Override
    public TypeInfo ensureTypeInfo(IdentityConstant idClass, ErrorListener errs) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().ensureTypeInfo(idClass, errs);
        }
        if (this.isFormalType()) {
            TypeConstant typeR;
            ConstantPool pool = this.getConstantPool();
            int cInvals = pool.getInvalidationCount();
            if (this.isGenericType() && (typeR = this.resolveGenerics(pool, idClass.getFormalType())) != this) {
                TypeInfo infoR = typeR.ensureTypeInfo(idClass, errs);
                assert (TerminalTypeConstant.isComplete(infoR));
                return new TypeInfo(this, infoR, cInvals);
            }
            TypeConstant typeConstraint = ((FormalConstant)this.getDefiningConstant()).getConstraintType();
            if (typeConstraint.containsAutoNarrowing(false)) {
                typeConstraint = typeConstraint.resolveAutoNarrowingBase();
            }
            TypeInfo infoConstraint = typeConstraint.ensureTypeInfo(idClass, errs);
            assert (TerminalTypeConstant.isComplete(infoConstraint));
            return new TypeInfo(this, infoConstraint, cInvals);
        }
        return super.ensureTypeInfo(idClass, errs);
    }

    @Override
    protected TypeInfo buildTypeInfo(ErrorListener errs) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().ensureTypeInfoInternal(errs);
        }
        Constant constant = this.getDefiningConstant();
        switch (constant.getFormat()) {
            case NativeClass: 
            case Module: 
            case Package: 
            case Class: {
                return super.buildTypeInfo(errs);
            }
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: {
                return ((KeywordConstant)constant).getBaseType().ensureTypeInfoInternal(errs);
            }
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                TypeInfo infoConstraint;
                TypeConstant typeConstraint = ((FormalConstant)constant).getConstraintType();
                int cInvalidations = this.getConstantPool().getInvalidationCount();
                if (typeConstraint.containsAutoNarrowing(false)) {
                    typeConstraint = typeConstraint.resolveAutoNarrowingBase();
                }
                return TerminalTypeConstant.isComplete(infoConstraint = typeConstraint.ensureTypeInfoInternal(errs)) ? new TypeInfo(this, infoConstraint, cInvalidations) : null;
            }
        }
        throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constant));
    }

    @Override
    protected TypeConstant.Relation calculateRelationToLeft(TypeConstant typeLeft) {
        if (this.isFormalType()) {
            if (!this.isSingleDefiningConstant()) {
                TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
                return constId.getReferredToType().calculateRelationToLeft(typeLeft);
            }
            FormalConstant constRight = (FormalConstant)this.getDefiningConstant();
            TypeConstant typeConstraint = constRight.getConstraintType();
            if (this.isDynamicType()) {
                DynamicFormalConstant constDynamic = (DynamicFormalConstant)constRight;
                FormalConstant constFormal = constDynamic.getFormalConstant();
                TypeConstant.Relation relation = constFormal.getConstraintType().calculateRelation(typeLeft);
                if (relation != TypeConstant.Relation.INCOMPATIBLE) {
                    return relation;
                }
                Register regRight = constDynamic.getRegister();
                if (regRight != null && typeLeft.containsDynamicType(regRight)) {
                    typeLeft = typeLeft.resolveDynamicConstraints(regRight);
                }
                return typeConstraint.calculateRelation(typeLeft);
            }
            TypeConstant.Relation relation = typeConstraint.calculateRelation(typeLeft);
            if (relation != TypeConstant.Relation.INCOMPATIBLE) {
                return relation;
            }
        }
        return super.calculateRelationToLeft(typeLeft);
    }

    @Override
    protected TypeConstant.Relation calculateRelationToRight(TypeConstant typeRight) {
        Constant constLeft;
        if (this.isDynamicType()) {
            TypeConstant typeConstraint = ((DynamicFormalConstant)this.getDefiningConstant()).getConstraintType();
            return typeRight.calculateRelation(typeConstraint);
        }
        if (this.isSingleDefiningConstant() && (constLeft = this.getDefiningConstant()) instanceof KeywordConstant) {
            if (constLeft.getFormat() == Constant.Format.IsClass) {
                return typeRight.getCategory() == TypeConstant.Category.CLASS ? TypeConstant.Relation.IS_A : TypeConstant.Relation.INCOMPATIBLE;
            }
            if (typeRight.isSingleUnderlyingClass(true)) {
                ClassStructure clzRight = (ClassStructure)typeRight.getSingleUnderlyingClass(true).getComponent();
                Component.Format formatRight = clzRight.getFormat();
                if (formatRight == Component.Format.ANNOTATION || formatRight == Component.Format.MIXIN) {
                    return typeRight.getExplicitClassInto().calculateRelation(this);
                }
                return switch (constLeft.getFormat()) {
                    case Constant.Format.IsConst -> {
                        switch (formatRight) {
                            case CONST: 
                            case ENUMVALUE: 
                            case PACKAGE: 
                            case MODULE: {
                                yield TypeConstant.Relation.IS_A;
                            }
                        }
                        yield TypeConstant.Relation.INCOMPATIBLE;
                    }
                    case Constant.Format.IsEnum -> {
                        if (formatRight == Component.Format.ENUMVALUE) {
                            yield TypeConstant.Relation.IS_A;
                        }
                        yield TypeConstant.Relation.INCOMPATIBLE;
                    }
                    case Constant.Format.IsModule -> {
                        if (formatRight == Component.Format.MODULE) {
                            yield TypeConstant.Relation.IS_A;
                        }
                        yield TypeConstant.Relation.INCOMPATIBLE;
                    }
                    case Constant.Format.IsPackage -> {
                        if (formatRight == Component.Format.MODULE || formatRight == Component.Format.PACKAGE) {
                            yield TypeConstant.Relation.IS_A;
                        }
                        yield TypeConstant.Relation.INCOMPATIBLE;
                    }
                    default -> throw new IllegalStateException();
                };
            }
        }
        return super.calculateRelationToRight(typeRight);
    }

    @Override
    public boolean isContravariantParameter(TypeConstant typeBase, TypeConstant typeCtx) {
        if (super.isContravariantParameter(typeBase, typeCtx)) {
            return true;
        }
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().isContravariantParameter(typeBase, typeCtx);
        }
        if (!typeBase.isSingleDefiningConstant() || typeBase.isParamsSpecified()) {
            return false;
        }
        Constant constIdThis = this.getDefiningConstant();
        Constant constIdBase = typeBase.getDefiningConstant();
        if (constIdThis.getFormat() != constIdBase.getFormat()) {
            return false;
        }
        switch (constIdBase.getFormat()) {
            case Module: 
            case Package: {
                return false;
            }
            case NativeClass: 
            case Class: {
                return constIdThis.getType().equals(constIdBase.getType());
            }
            case Property: {
                PropertyConstant idBase = (PropertyConstant)constIdBase;
                return ((PropertyConstant)constIdThis).getName().equals(idBase.getName());
            }
            case TypeParameter: {
                TypeParameterConstant idBase = (TypeParameterConstant)constIdBase;
                TypeParameterConstant idThis = (TypeParameterConstant)constIdThis;
                return idThis.getRegister() == idBase.getRegister() || idThis.getName().equals(idBase.getName());
            }
            case FormalTypeChild: {
                FormalTypeChildConstant idBase = (FormalTypeChildConstant)constIdBase;
                return ((FormalTypeChildConstant)constIdThis).getName().equals(idBase.getName());
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                PseudoConstant constBase = (PseudoConstant)constIdBase;
                PseudoConstant constThis = (PseudoConstant)constIdThis;
                if (constBase.isCongruentWith(constThis)) {
                    TypeConstant typeDeclThis;
                    TypeConstant typeDeclBase = constBase.getDeclarationLevelClass().getType();
                    return typeDeclBase.isA(typeDeclThis = constThis.getDeclarationLevelClass().getType()) || typeDeclThis.isA(typeDeclBase);
                }
                return false;
            }
        }
        throw new IllegalStateException("unexpected constant: " + String.valueOf(constIdBase));
    }

    @Override
    protected Set<SignatureConstant> isInterfaceAssignableFrom(TypeConstant typeRight, Constants.Access accessLeft, List<TypeConstant> listLeft) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().isInterfaceAssignableFrom(typeRight, accessLeft, listLeft);
        }
        Constant constIdLeft = this.getDefiningConstant();
        switch (constIdLeft.getFormat()) {
            case NativeClass: {
                constIdLeft = ((NativeRebaseConstant)constIdLeft).getClassConstant();
            }
            case Class: {
                IdentityConstant idLeft = (IdentityConstant)constIdLeft;
                ClassStructure clzLeft = (ClassStructure)idLeft.getComponent();
                assert (clzLeft.getFormat() == Component.Format.INTERFACE);
                return clzLeft.isInterfaceAssignableFrom(typeRight, accessLeft, listLeft);
            }
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: {
                return ((FormalConstant)constIdLeft).getConstraintType().isInterfaceAssignableFrom(typeRight, accessLeft, listLeft);
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                return ((PseudoConstant)constIdLeft).getDeclarationLevelClass().getType().isInterfaceAssignableFrom(typeRight, accessLeft, listLeft);
            }
        }
        throw new IllegalStateException("unexpected constant: " + String.valueOf(constIdLeft));
    }

    @Override
    public boolean containsSubstitutableMethod(SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().containsSubstitutableMethod(signature, access, fFunction, listParams);
        }
        Constant constIdThis = this.getDefiningConstant();
        switch (constIdThis.getFormat()) {
            case NativeClass: {
                constIdThis = ((NativeRebaseConstant)constIdThis).getClassConstant();
            }
            case Module: 
            case Package: 
            case Class: {
                IdentityConstant idThis = (IdentityConstant)constIdThis;
                ClassStructure clzThis = (ClassStructure)idThis.getComponent();
                return clzThis.containsSubstitutableMethod(this.getConstantPool(), signature, access, fFunction, listParams);
            }
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                return ((FormalConstant)constIdThis).getConstraintType().containsSubstitutableMethod(signature, access, fFunction, listParams);
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                return ((PseudoConstant)constIdThis).getDeclarationLevelClass().getType().containsSubstitutableMethod(signature, access, fFunction, listParams);
            }
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: {
                return ((KeywordConstant)constIdThis).getBaseType().containsSubstitutableMethod(signature, access, fFunction, listParams);
            }
        }
        throw new IllegalStateException("unexpected constant: " + String.valueOf(constIdThis));
    }

    @Override
    public TypeConstant.Usage checkConsumption(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().checkConsumption(sTypeName, access, listParams);
        }
        Constant constId = this.getDefiningConstant();
        switch (constId.getFormat()) {
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: 
            case Module: 
            case Package: 
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                return TypeConstant.Usage.NO;
            }
            case NativeClass: {
                constId = ((NativeRebaseConstant)constId).getClassConstant();
            }
            case Class: {
                if (this.isTuple()) {
                    for (TypeConstant constParam : listParams) {
                        if (!constParam.consumesFormalType(sTypeName, access) && !constParam.producesFormalType(sTypeName, access)) continue;
                        return TypeConstant.Usage.YES;
                    }
                } else if (!listParams.isEmpty()) {
                    ConstantPool pool = this.getConstantPool();
                    ClassStructure clz = (ClassStructure)((IdentityConstant)constId).getComponent();
                    ListMap<StringConstant, TypeConstant> mapFormal = clz.getTypeParams();
                    listParams = clz.normalizeParameters(pool, listParams);
                    Iterator<TypeConstant> iterParams = listParams.iterator();
                    Iterator iterNames = mapFormal.keySet().iterator();
                    while (iterParams.hasNext()) {
                        TypeConstant constParam = iterParams.next();
                        String sFormal = ((StringConstant)iterNames.next()).getValue();
                        if ((!constParam.consumesFormalType(sTypeName, access) || !clz.producesFormalType(pool, sFormal, access, listParams)) && (!constParam.producesFormalType(sTypeName, access) || !clz.consumesFormalType(pool, sFormal, access, listParams))) continue;
                        return TypeConstant.Usage.YES;
                    }
                }
                return TypeConstant.Usage.NO;
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                return ((PseudoConstant)constId).getDeclarationLevelClass().getType().checkConsumption(sTypeName, access, listParams);
            }
        }
        throw new IllegalStateException("unexpected constant: " + String.valueOf(constId));
    }

    @Override
    public TypeConstant.Usage checkProduction(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().checkProduction(sTypeName, access, listParams);
        }
        Constant constId = this.getDefiningConstant();
        switch (constId.getFormat()) {
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: 
            case Module: 
            case Package: 
            case TypeParameter: 
            case FormalTypeChild: {
                return TypeConstant.Usage.NO;
            }
            case Property: {
                return TypeConstant.Usage.valueOf(((PropertyConstant)constId).getName().equals(sTypeName));
            }
            case DynamicFormal: {
                FormalConstant constFormal = ((DynamicFormalConstant)constId).getFormalConstant();
                return TypeConstant.Usage.valueOf(constFormal instanceof PropertyConstant && constFormal.getName().equals(sTypeName));
            }
            case NativeClass: {
                constId = ((NativeRebaseConstant)constId).getClassConstant();
            }
            case Class: {
                if (this.isTuple()) {
                    for (TypeConstant constParam : listParams) {
                        if (!constParam.producesFormalType(sTypeName, access) && !constParam.consumesFormalType(sTypeName, access)) continue;
                        return TypeConstant.Usage.YES;
                    }
                } else if (!listParams.isEmpty()) {
                    ConstantPool pool = this.getConstantPool();
                    ClassStructure clz = (ClassStructure)((IdentityConstant)constId).getComponent();
                    ListMap<StringConstant, TypeConstant> mapFormal = clz.getTypeParams();
                    listParams = clz.normalizeParameters(pool, listParams);
                    Iterator<TypeConstant> iterParams = listParams.iterator();
                    Iterator iterNames = mapFormal.keySet().iterator();
                    while (iterParams.hasNext()) {
                        TypeConstant constParam = iterParams.next();
                        String sFormal = ((StringConstant)iterNames.next()).getValue();
                        if ((!constParam.producesFormalType(sTypeName, access) || !clz.producesFormalType(pool, sFormal, access, listParams)) && (!constParam.consumesFormalType(sTypeName, access) || !clz.consumesFormalType(pool, sFormal, access, listParams))) continue;
                        return TypeConstant.Usage.YES;
                    }
                }
                return TypeConstant.Usage.NO;
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                return ((PseudoConstant)constId).getDeclarationLevelClass().getType().checkProduction(sTypeName, access, listParams);
            }
        }
        throw new IllegalStateException("unexpected constant: " + String.valueOf(constId));
    }

    @Override
    public boolean isPrimitive() {
        ClassConstant id;
        Object object;
        if (this.isSingleDefiningConstant() && (object = this.getDefiningConstant()) instanceof ClassConstant && (id = (ClassConstant)object).getModuleConstant().isEcstasyModule()) {
            return switch (id.getName()) {
                case "Int8", "Int16", "Int32", "Int64", "Int128", "UInt8", "UInt16", "UInt32", "UInt64", "UInt128", "Float16", "Float32", "Float64", "Dec32", "Dec64", "Boolean", "Char" -> true;
                default -> false;
            };
        }
        return false;
    }

    @Override
    public ClassTemplate getTemplate(Container container) {
        if (!this.isSingleDefiningConstant()) {
            TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
            return constId.getReferredToType().getTemplate(container);
        }
        Constant constIdThis = this.getDefiningConstant();
        return switch (constIdThis.getFormat()) {
            case Constant.Format.Module, Constant.Format.Package, Constant.Format.Class -> container.getTemplate((IdentityConstant)constIdThis);
            case Constant.Format.NativeClass -> container.getTemplate(((NativeRebaseConstant)constIdThis).getClassConstant());
            case Constant.Format.ThisClass, Constant.Format.ParentClass, Constant.Format.ChildClass -> container.getTemplate(((PseudoConstant)constIdThis).getDeclarationLevelClass());
            default -> throw new IllegalStateException("unexpected defining constant: " + String.valueOf(constIdThis));
        };
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.TerminalType;
    }

    @Override
    public boolean containsUnresolved() {
        if (this.isHashCached()) {
            return false;
        }
        Constant constId = this.ensureResolvedConstant();
        if (constId.containsUnresolved()) {
            return true;
        }
        if (this.getFormat() == Constant.Format.Typedef) {
            return ((TypedefConstant)constId).getReferredToType().containsUnresolved();
        }
        return false;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.ensureResolvedConstant());
    }

    @Override
    protected Object getLocator() {
        Constant constId = this.ensureResolvedConstant();
        return constId.getFormat() == Constant.Format.UnresolvedName ? null : constId;
    }

    @Override
    protected int compareDetails(Constant obj) {
        if (!(obj instanceof TerminalTypeConstant)) {
            return -1;
        }
        TerminalTypeConstant that = (TerminalTypeConstant)obj;
        Constant constThis = this.m_constId.resolve();
        Constant constThat = that.m_constId.resolve();
        return constThis.compareTo(constThat);
    }

    @Override
    public String getValueString() {
        return this.ensureResolvedConstant().getValueString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constId = pool.register(this.ensureResolvedConstant());
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.ensureResolvedConstant().getPosition());
    }

    @Override
    public boolean validate(ErrorListener errs) {
        if (!this.isValidated()) {
            if (!this.isSingleDefiningConstant()) {
                TypedefConstant constId = (TypedefConstant)this.ensureResolvedConstant();
                return constId.getReferredToType().validate(errs) && super.validate(errs);
            }
            Constant constant = this.getDefiningConstant();
            switch (constant.getFormat()) {
                case NativeClass: 
                case Module: 
                case Package: 
                case Class: 
                case Property: 
                case TypeParameter: 
                case FormalTypeChild: 
                case DynamicFormal: 
                case ThisClass: 
                case ParentClass: 
                case ChildClass: {
                    return super.validate(errs);
                }
                case IsConst: 
                case IsEnum: 
                case IsModule: 
                case IsPackage: 
                case IsClass: {
                    break;
                }
                default: {
                    this.log(errs, Severity.ERROR, "VERIFY-01", constant.getValueString() + " (" + String.valueOf((Object)constant.getFormat()) + ")");
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Hash.of(this.ensureResolvedConstant());
    }
}

