/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class ThisClassConstant
extends PseudoConstant {
    public static final String THIS_CLASS = "this:class";
    private int m_iClass;
    private IdentityConstant m_constClass;

    public ThisClassConstant(ConstantPool pool, IdentityConstant constClass) {
        super(pool);
        this.m_constClass = constClass;
    }

    public ThisClassConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iClass = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_constClass = (IdentityConstant)this.getConstantPool().getConstant(this.m_iClass);
    }

    @Override
    public boolean isCongruentWith(PseudoConstant that) {
        return that instanceof ThisClassConstant;
    }

    @Override
    public IdentityConstant getDeclarationLevelClass() {
        return this.m_constClass;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ThisClass;
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().ensureThisTypeConstant(this, null);
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isAutoNarrowing() {
        return true;
    }

    @Override
    protected Object getLocator() {
        return this.m_constClass;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_constClass.containsUnresolved();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constClass);
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof ThisClassConstant)) {
            return -1;
        }
        return this.m_constClass.compareTo(((ThisClassConstant)that).m_constClass);
    }

    @Override
    public String getValueString() {
        return "this:class(" + this.m_constClass.getValueString() + ")";
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constClass = (IdentityConstant)pool.register(this.m_constClass);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constClass.getPosition());
    }

    @Override
    public String getDescription() {
        return "name=this:class, decl-level=" + String.valueOf(this.m_constClass);
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constClass);
    }
}

