/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.xvm.asm.Component;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.Op;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;

public class TypeCollector {
    private final ConstantPool f_pool;
    private ArrayList<TypeConstant> m_listSingle;
    private ArrayList<TypeConstant[]> m_listMulti;
    private transient Boolean m_FConditional;

    public TypeCollector(ConstantPool pool) {
        this.f_pool = pool;
    }

    public void add(TypeConstant type) {
        if (this.isMulti()) {
            this.add(new TypeConstant[]{type});
        } else {
            this.ensureSingle().add(type);
        }
    }

    public void add(TypeConstant[] aTypes) {
        if (!(this.isMulti() || aTypes != null && aTypes.length != 1)) {
            this.add(aTypes == null ? null : aTypes[0]);
        } else {
            this.ensureMulti().add(aTypes);
        }
    }

    public int size() {
        ArrayList<TypeConstant> listSingle = this.m_listSingle;
        if (listSingle != null) {
            return listSingle.size();
        }
        ArrayList<TypeConstant[]> listMulti = this.m_listMulti;
        if (listMulti != null) {
            return listMulti.size();
        }
        return 0;
    }

    public boolean isSingle() {
        return this.m_listMulti == null;
    }

    public List<TypeConstant> getSingle() {
        ArrayList<TypeConstant> listSingle = this.m_listSingle;
        if (listSingle != null) {
            return listSingle;
        }
        assert (this.m_listMulti == null);
        return Collections.emptyList();
    }

    private ArrayList<TypeConstant> ensureSingle() {
        ArrayList<TypeConstant> listSingle = this.m_listSingle;
        if (listSingle == null) {
            assert (this.m_listMulti == null);
            this.m_listSingle = listSingle = new ArrayList();
        }
        return listSingle;
    }

    public boolean isMulti() {
        return this.m_listMulti != null;
    }

    public List<TypeConstant[]> getMulti() {
        ArrayList<TypeConstant[]> list = this.m_listMulti;
        if (list != null) {
            return list;
        }
        return this.m_listSingle == null ? Collections.emptyList() : this.ensureMulti();
    }

    private ArrayList<TypeConstant[]> ensureMulti() {
        ArrayList<Object> listMulti = this.m_listMulti;
        if (listMulti != null) {
            return listMulti;
        }
        listMulti = new ArrayList();
        this.m_listMulti = listMulti;
        ArrayList<TypeConstant> listSingle = this.m_listSingle;
        if (listSingle != null) {
            for (TypeConstant type : listSingle) {
                TypeConstant[] typeConstantArray;
                if (type == null) {
                    typeConstantArray = null;
                } else {
                    TypeConstant[] typeConstantArray2 = new TypeConstant[1];
                    typeConstantArray = typeConstantArray2;
                    typeConstantArray2[0] = type;
                }
                listMulti.add(typeConstantArray);
            }
            this.m_listSingle = null;
        }
        return listMulti;
    }

    public TypeConstant inferSingle(TypeConstant typeRequired) {
        assert (!this.isMulti());
        List<TypeConstant> listTypes = this.getSingle();
        int cTypes = listTypes.size();
        if (cTypes == 0 || listTypes.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        TypeConstant typeCommon = TypeCollector.inferFrom(listTypes.toArray(new TypeConstant[cTypes]), this.f_pool);
        if (typeRequired != null && typeRequired.containsFormalType(true)) {
            typeCommon = typeRequired.resolvePending(this.f_pool, typeCommon);
        }
        typeCommon = Op.selectCommonType(typeCommon, typeRequired, ErrorListener.BLACKHOLE);
        if (!(typeRequired == null || typeCommon != null && typeCommon.isAssignableTo(typeRequired))) {
            TypeConstant typeAlt = Op.selectCommonType(typeRequired, listTypes.get(0), ErrorListener.BLACKHOLE);
            for (int i = 1; i < cTypes; ++i) {
                typeAlt = Op.selectCommonType(typeAlt, listTypes.get(i), ErrorListener.BLACKHOLE);
            }
            if (typeAlt != null) {
                typeCommon = typeAlt;
            }
        }
        return typeCommon;
    }

    public TypeConstant[] inferMulti(TypeConstant[] atypeRequired) {
        TypeConstant[] aResult;
        int cReqTypes;
        if (!this.isMulti()) {
            TypeConstant[] typeConstantArray;
            TypeConstant typeRequired = null;
            int cRequired = atypeRequired == null ? 0 : atypeRequired.length;
            boolean fPacked = false;
            switch (cRequired) {
                case 0: {
                    break;
                }
                case 1: {
                    typeRequired = atypeRequired[0];
                    break;
                }
                default: {
                    List<TypeConstant> listTypes = this.getSingle();
                    if (listTypes.size() == 1 && listTypes.get(0).isTuple()) {
                        fPacked = true;
                        typeRequired = this.f_pool.ensureTupleType(atypeRequired);
                        break;
                    }
                    typeRequired = atypeRequired[0];
                }
            }
            TypeConstant type = this.inferSingle(typeRequired);
            if (type == null) {
                typeConstantArray = TypeConstant.NO_TYPES;
            } else if (fPacked) {
                typeConstantArray = type.getParamTypesArray();
            } else {
                TypeConstant[] typeConstantArray2 = new TypeConstant[1];
                typeConstantArray = typeConstantArray2;
                typeConstantArray2[0] = type;
            }
            return typeConstantArray;
        }
        this.m_FConditional = false;
        List<TypeConstant[]> listTypes = this.getMulti();
        int cHeight = listTypes.size();
        if (cHeight == 0) {
            return TypeConstant.NO_TYPES;
        }
        int cWidth = -1;
        boolean fConditional = true;
        int cCondFalse = 0;
        for (TypeConstant[] aTypes : this.m_listMulti) {
            if (aTypes == null) {
                return TypeConstant.NO_TYPES;
            }
            int cTypes = aTypes.length;
            if (cTypes == 1) {
                if (aTypes[0].equals(this.f_pool.typeFalse())) {
                    ++cCondFalse;
                    continue;
                }
                fConditional = false;
                continue;
            }
            if (cTypes == 0 || !aTypes[0].isA(this.f_pool.typeBoolean())) {
                fConditional = false;
            }
            if (cWidth >= 0 && cWidth <= cTypes) continue;
            cWidth = cTypes;
        }
        if (cWidth == 0 && cCondFalse < cHeight) {
            return TypeConstant.NO_TYPES;
        }
        int n = cReqTypes = atypeRequired == null ? 0 : atypeRequired.length;
        if (cHeight == cCondFalse) {
            aResult = new TypeConstant[]{this.f_pool.typeBoolean()};
        } else {
            boolean fDone = false;
            aResult = new TypeConstant[cWidth];
            if (fConditional) {
                int cNonFalse = cHeight - cCondFalse;
                TypeConstant[] aColType = new TypeConstant[cNonFalse];
                for (int iCol = 0; iCol < cWidth; ++iCol) {
                    int iRow = 0;
                    for (TypeConstant[] aRowType : listTypes) {
                        if (aRowType.length <= 1) continue;
                        aColType[iRow++] = aRowType[iCol];
                    }
                    assert (iRow == cNonFalse);
                    TypeConstant typeResult = TypeCollector.inferFrom(aColType, this.f_pool);
                    if (typeResult == null) {
                        return null;
                    }
                    if (iCol == 0 && !typeResult.equals(this.f_pool.typeBoolean())) {
                        cWidth = 1;
                        break;
                    }
                    aResult[iCol] = typeResult;
                }
                fDone = true;
            }
            if (!fDone) {
                fConditional = false;
                TypeConstant[] aColType = new TypeConstant[cHeight];
                for (int iCol = 0; iCol < cWidth; ++iCol) {
                    for (int iRow = 0; iRow < cHeight; ++iRow) {
                        aColType[iRow] = listTypes.get(iRow)[iCol];
                    }
                    TypeConstant typeResult = TypeCollector.inferFrom(aColType, this.f_pool);
                    if (typeResult == null) {
                        return TypeConstant.NO_TYPES;
                    }
                    aResult[iCol] = typeResult;
                }
            }
            for (int iCol = 0; iCol < cWidth; ++iCol) {
                TypeConstant typeRequired;
                TypeConstant typeConstant = typeRequired = iCol < cReqTypes ? atypeRequired[iCol] : null;
                if (typeRequired == null) continue;
                aResult[iCol] = Op.selectCommonType(aResult[iCol], typeRequired, ErrorListener.BLACKHOLE);
            }
        }
        this.m_FConditional = fConditional;
        return aResult;
    }

    public boolean isConditional() {
        if (this.m_FConditional == null) {
            this.inferMulti(null);
            assert (this.m_FConditional != null);
        }
        return this.m_FConditional;
    }

    public void setConditional(boolean fCond) {
        this.m_FConditional = fCond;
    }

    public static TypeConstant inferFrom(TypeConstant[] aTypes, ConstantPool pool) {
        if (aTypes == null) {
            return null;
        }
        int cTypes = aTypes.length;
        if (cTypes == 0) {
            return null;
        }
        TypeConstant typeCommon = aTypes[0];
        if (typeCommon == null || typeCommon.containsUnresolved()) {
            return null;
        }
        boolean fConvApplied = false;
        boolean fImmutable = typeCommon.isImmutable();
        for (int i = 1; i < cTypes; ++i) {
            MethodConstant idConv;
            TypeConstant type = aTypes[i];
            if (type == null) {
                return null;
            }
            if (type.isA(typeCommon)) continue;
            if (typeCommon.isA(type)) {
                typeCommon = type;
                fImmutable = fImmutable && type.isImmutable();
                continue;
            }
            if (type.getConverterTo(typeCommon) != null) {
                fConvApplied = true;
                continue;
            }
            if (!fConvApplied && (idConv = typeCommon.getConverterTo(type)) != null) {
                fConvApplied = true;
                typeCommon = type;
                fImmutable = fImmutable && type.isImmutable();
                continue;
            }
            if ((typeCommon = Op.selectCommonType(type, typeCommon, ErrorListener.BLACKHOLE)) != null) continue;
            return null;
        }
        TypeInfo info = typeCommon.ensureTypeInfo();
        if (info.getFormat() == Component.Format.ENUMVALUE) {
            typeCommon = info.getExtends();
            assert (typeCommon != null);
        }
        return fImmutable ? typeCommon.freeze() : typeCommon;
    }
}

