/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.constant.ClassDesc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.PackageStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.Register;
import org.xvm.asm.TypedefStructure;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.AccessTypeConstant;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.ChildInfo;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.FormalTypeChildConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.ImmutableTypeConstant;
import org.xvm.asm.constants.KeywordConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.NativeRebaseConstant;
import org.xvm.asm.constants.ParamInfo;
import org.xvm.asm.constants.ParameterizedTypeConstant;
import org.xvm.asm.constants.PropertyBody;
import org.xvm.asm.constants.PropertyClassTypeConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.RecursiveTypeConstant;
import org.xvm.asm.constants.RelationalTypeConstant;
import org.xvm.asm.constants.ServiceTypeConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TerminalTypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.asm.constants.TypeSequenceTypeConstant;
import org.xvm.asm.constants.TypedefConstant;
import org.xvm.asm.constants.UnionTypeConstant;
import org.xvm.asm.constants.UnresolvedTypeConstant;
import org.xvm.asm.constants.VirtualChildTypeConstant;
import org.xvm.javajit.Container;
import org.xvm.javajit.JitFlavor;
import org.xvm.javajit.JitTypeDesc;
import org.xvm.javajit.ModuleLoader;
import org.xvm.javajit.TypeSystem;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xOrdered;
import org.xvm.util.Auto;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;
import org.xvm.util.PackedInteger;
import org.xvm.util.Severity;
import org.xvm.util.TransientThreadLocal;

public abstract class TypeConstant
extends Constant
implements GenericTypeResolver {
    public static final TypeConstant[] NO_TYPES = new TypeConstant[0];
    private transient boolean m_fValidated;
    private volatile transient TypeInfo m_typeinfo;
    private static final AtomicReferenceFieldUpdater<TypeConstant, TypeInfo> s_typeinfo = AtomicReferenceFieldUpdater.newUpdater(TypeConstant.class, TypeInfo.class, "m_typeinfo");
    private final transient AtomicInteger m_cRecursiveDepth = new AtomicInteger();
    private volatile transient int m_cInvalidations;
    private static final AtomicIntegerFieldUpdater<TypeConstant> s_cInvalidations = AtomicIntegerFieldUpdater.newUpdater(TypeConstant.class, "m_cInvalidations");
    private volatile transient Map<TypeConstant, Relation> m_mapRelations;
    private volatile transient TransientThreadLocal<Set<TypeConstant>> m_tloInProgress;
    private static final AtomicReferenceFieldUpdater<TypeConstant, TransientThreadLocal> s_tloInProgress = AtomicReferenceFieldUpdater.newUpdater(TypeConstant.class, TransientThreadLocal.class, "m_tloInProgress");
    private transient Map<String, Usage> m_mapConsumes;
    private transient Map<String, Usage> m_mapProduces;
    private transient xRTType.TypeHandle m_handle;
    private transient Object m_xType;
    private transient String m_sJitName;
    private transient TypeConstant m_typeNormalized;
    private static final Set<String> s_setRecursions = new HashSet<String>();

    protected TypeConstant(ConstantPool pool, Constant.Format format, DataInput in) {
        super(pool);
    }

    protected TypeConstant(ConstantPool pool) {
        super(pool);
    }

    @Override
    public TypeConstant resolveGenericType(String sFormalName) {
        return this.getGenericParamType(sFormalName, Collections.emptyList());
    }

    public boolean isModifyingType() {
        return false;
    }

    public boolean isRelationalType() {
        return false;
    }

    public TypeConstant getUnderlyingType() {
        throw new UnsupportedOperationException();
    }

    public TypeConstant getUnderlyingType2() {
        throw new UnsupportedOperationException();
    }

    public boolean isShared(ConstantPool poolOther) {
        return poolOther == this.getConstantPool() || this.getUnderlyingType().isShared(poolOther);
    }

    public boolean isComposedOfAny(Set<IdentityConstant> setIds) {
        return this.isModifyingType() && this.getUnderlyingType().isComposedOfAny(setIds);
    }

    public boolean isImmutabilitySpecified() {
        return this.getUnderlyingType().isImmutabilitySpecified();
    }

    public boolean isImmutable() {
        return this.getUnderlyingType().isImmutable();
    }

    public boolean isOnlyImmutable() {
        return false;
    }

    public TypeConstant freeze() {
        return this.isImmutable() ? this : this.getConstantPool().ensureImmutableTypeConstant(this);
    }

    public TypeConstant removeImmutable() {
        if (!this.isImmutabilitySpecified()) {
            return this;
        }
        final ConstantPool pool = this.getConstantPool();
        Function<TypeConstant, TypeConstant> transformer = new Function<TypeConstant, TypeConstant>(this){

            @Override
            public TypeConstant apply(TypeConstant type) {
                return type instanceof TerminalTypeConstant ? type : (type instanceof VirtualChildTypeConstant ? type.removeImmutable() : (type instanceof ImmutableTypeConstant ? type.getUnderlyingType() : type.replaceUnderlying(pool, this)));
            }
        };
        return (TypeConstant)transformer.apply(this);
    }

    public boolean isService() {
        return this.isModifyingType() && this.getUnderlyingType().isService();
    }

    public TypeConstant ensureService() {
        return this.isService() ? this : this.getConstantPool().ensureServiceTypeConstant(this);
    }

    public boolean isAccessSpecified() {
        return this.getUnderlyingType().isAccessSpecified();
    }

    public Constants.Access getAccess() {
        return this.getUnderlyingType().getAccess();
    }

    public boolean isAccessModifiable() {
        return this.getUnderlyingType().isAccessModifiable();
    }

    public TypeConstant removeAccess() {
        if (!this.isAccessSpecified()) {
            return this;
        }
        final ConstantPool pool = this.getConstantPool();
        Function<TypeConstant, TypeConstant> transformer = new Function<TypeConstant, TypeConstant>(this){

            @Override
            public TypeConstant apply(TypeConstant type) {
                return type instanceof TerminalTypeConstant || type instanceof VirtualChildTypeConstant ? type : (type instanceof AccessTypeConstant ? type.getUnderlyingType() : type.replaceUnderlying(pool, this));
            }
        };
        return (TypeConstant)transformer.apply(this);
    }

    public TypeConstant ensureAccess(Constants.Access access) {
        return this.getAccess().isMoreAccessibleThan(access) ? this.getConstantPool().ensureAccessTypeConstant(this, access) : this;
    }

    public TypeConstant adjustAccess(IdentityConstant idClass) {
        return this.isAccessSpecified() || !this.isNestMateOf(idClass) ? this : this.ensureAccess(Constants.Access.PRIVATE);
    }

    public boolean isParamsSpecified() {
        return this.isModifyingType() && this.getUnderlyingType().isParamsSpecified();
    }

    public boolean isParameterizedDeep() {
        return this.isParamsSpecified() || this.isVirtualChild() && this.getParentType().isParameterizedDeep();
    }

    public int getParamsCount() {
        return this.getParamTypesArray().length;
    }

    public int getMaxParamsCount() {
        return this.isModifyingType() ? this.getUnderlyingType().getMaxParamsCount() : 0;
    }

    public int getTypeDepth() {
        return this.isModifyingType() ? 1 + this.getUnderlyingType().getTypeDepth() : 1;
    }

    public List<TypeConstant> getParamTypes() {
        return this.isModifyingType() ? this.getUnderlyingType().getParamTypes() : Collections.emptyList();
    }

    public TypeConstant[] getParamTypesArray() {
        return this.isModifyingType() ? this.getUnderlyingType().getParamTypesArray() : ConstantPool.NO_TYPES;
    }

    public TypeConstant getParamType(int i) {
        return i < this.getParamsCount() ? this.getParamTypesArray()[i] : this.getConstantPool().typeObject();
    }

    public boolean containsGenericParam(String sName) {
        return this.isModifyingType() && this.getUnderlyingType().containsGenericParam(sName);
    }

    protected TypeConstant getGenericParamType(String sName, List<TypeConstant> listParams) {
        return this.isModifyingType() ? this.getUnderlyingType().getGenericParamType(sName, listParams) : null;
    }

    public boolean isAnnotated() {
        return this.isModifyingType() && this.getUnderlyingType().isAnnotated();
    }

    public boolean containsAnnotation(ClassConstant idAnno) {
        return this.isAnnotated() && this.getUnderlyingType().containsAnnotation(idAnno);
    }

    public Annotation[] getAnnotations() {
        return this.isAnnotated() ? this.getUnderlyingType().getAnnotations() : Annotation.NO_ANNOTATIONS;
    }

    public boolean isEnumValue() {
        return this.isExplicitClassIdentity(false) && this.getExplicitClassFormat() == Component.Format.ENUMVALUE;
    }

    public boolean isVirtualChild() {
        return this.isModifyingType() && this.getUnderlyingType().isVirtualChild();
    }

    public boolean isAnonymousClass() {
        return this.isModifyingType() && this.getUnderlyingType().isAnonymousClass();
    }

    public boolean isInnerChildClass() {
        return this.isModifyingType() && this.getUnderlyingType().isInnerChildClass();
    }

    public boolean isPhantom() {
        assert (this.isVirtualChild());
        return this.getUnderlyingType().isPhantom();
    }

    public boolean isDecoratedClass() {
        if (!this.isExplicitClassIdentity(true)) {
            return false;
        }
        if (this.isAnnotated() || this.getParamsCount() > 0) {
            return true;
        }
        return (this.isVirtualChild() || this.isAnonymousClass()) && this.getParentType().isDecoratedClass();
    }

    public TypeConstant getParentType() {
        assert (this.isVirtualChild() || this.isInnerChildClass() || this.isAnonymousClass());
        return this.getUnderlyingType().getParentType();
    }

    public TypeConstant getOriginParentType() {
        assert (this.isVirtualChild());
        return this.getUnderlyingType().getOriginParentType();
    }

    public TypeConstant ensureVirtualParent(final TypeConstant typeParent, final boolean fPromote) {
        assert (this.isVirtualChild() && typeParent.isA(this.getParentType()));
        if (typeParent.equals(this.getParentType())) {
            return this;
        }
        final ConstantPool pool = typeParent.getConstantPool();
        Function<TypeConstant, TypeConstant> transformer = new Function<TypeConstant, TypeConstant>(this){

            @Override
            public TypeConstant apply(TypeConstant type) {
                TypeConstant typeConstant;
                if (type instanceof VirtualChildTypeConstant) {
                    VirtualChildTypeConstant typeChild = (VirtualChildTypeConstant)type;
                    typeConstant = fPromote ? pool.ensureVirtualChildTypeConstant(typeParent, typeChild.getChildName()) : new VirtualChildTypeConstant(pool, type.getParentType(), typeChild.getChildName(), typeParent);
                } else {
                    typeConstant = type.replaceUnderlying(pool, this);
                }
                return typeConstant;
            }
        };
        return (TypeConstant)transformer.apply(this);
    }

    public boolean isSingleDefiningConstant() {
        return this.isModifyingType() && this.getUnderlyingType().isSingleDefiningConstant();
    }

    public Constant getDefiningConstant() {
        return this.getUnderlyingType().getDefiningConstant();
    }

    public boolean isConst() {
        return this.getUnderlyingType().isConst();
    }

    public boolean isTypeOfType() {
        return this.getUnderlyingType().isTypeOfType();
    }

    public boolean isPublicEcstasyType() {
        ClassConstant idClass;
        Constant constant;
        return this.isSingleDefiningConstant() && (constant = this.getDefiningConstant()) instanceof ClassConstant && (idClass = (ClassConstant)constant).getModuleConstant().isEcstasyModule() && this.getAccess() == Constants.Access.PUBLIC;
    }

    public boolean isEcstasy(String sName) {
        IdentityConstant constId = this.getConstantPool().getImplicitlyImportedIdentity(sName);
        if (constId == null) {
            throw new IllegalArgumentException("no such implicit name: " + sName);
        }
        return this.isSingleDefiningConstant() && this.getDefiningConstant().equals(constId);
    }

    public String getEcstasyClassName() {
        return this.isPublicEcstasyType() ? ((ClassConstant)this.getDefiningConstant()).getPathString() : "?";
    }

    public boolean isNullable() {
        return false;
    }

    public boolean isOnlyNullable() {
        return this.getUnderlyingType().isOnlyNullable();
    }

    public TypeConstant ensureNullable() {
        return this.getConstantPool().ensureNullableTypeConstant(this);
    }

    public TypeConstant removeNullable() {
        return this;
    }

    public boolean isIncompatibleCombo(TypeConstant that) {
        if (that instanceof RelationalTypeConstant && !(this instanceof RelationalTypeConstant)) {
            return that.isIncompatibleCombo(this);
        }
        if (this.isFormalType() || that.isFormalType()) {
            return false;
        }
        if (this.isA(that) || that.isA(this)) {
            return false;
        }
        if (this.isTypeOfType()) {
            if (that.isTypeOfType()) {
                return this.getParamType(0).isIncompatibleCombo(that.getParamType(0));
            }
            return true;
        }
        if (that.isTypeOfType()) {
            return true;
        }
        TypeConstant typeThis = this;
        while (typeThis.isModifyingType()) {
            typeThis = typeThis.getUnderlyingType();
        }
        TypeConstant typeThat = that;
        while (typeThat.isModifyingType()) {
            typeThat = typeThat.getUnderlyingType();
        }
        return !typeThis.isA(typeThat) && !typeThat.isA(typeThis) && (typeThis.isIncompatibleComboImpl(typeThat) || typeThat.isIncompatibleComboImpl(typeThis));
    }

    private boolean isIncompatibleComboImpl(TypeConstant that) {
        if (this.isSingleUnderlyingClass(false)) {
            Component clzThis = this.getSingleUnderlyingClass(false).getComponent();
            switch (clzThis.getFormat()) {
                case ENUMVALUE: 
                case PACKAGE: 
                case MODULE: {
                    return true;
                }
                case ENUM: {
                    for (Component component : clzThis.children()) {
                        if (component.getFormat() != Component.Format.ENUMVALUE || !component.getIdentityConstant().getType().isA(that)) continue;
                        return false;
                    }
                    return true;
                }
                case CLASS: 
                case CONST: 
                case SERVICE: {
                    if (!that.isSingleUnderlyingClass(false)) break;
                    return switch (that.getSingleUnderlyingClass(false).getComponent().getFormat()) {
                        case Component.Format.ENUMVALUE, Component.Format.PACKAGE, Component.Format.MODULE, Component.Format.ENUM, Component.Format.CLASS, Component.Format.CONST, Component.Format.SERVICE -> true;
                        default -> false;
                    };
                }
            }
        }
        return false;
    }

    public TypeConstant combine(ConstantPool pool, TypeConstant that) {
        TypeConstant typeThat;
        TypeConstant typeThis;
        TypeConstant thisResolved = this.resolveTypedefs();
        TypeConstant thatResolved = that.resolveTypedefs();
        if (thisResolved != this || thatResolved != that) {
            return thisResolved.combine(pool, thatResolved);
        }
        if (that instanceof UnionTypeConstant && !(this instanceof UnionTypeConstant) || that instanceof TypeSequenceTypeConstant && !(this instanceof TypeSequenceTypeConstant)) {
            return that.combine(pool, this);
        }
        if (this.isA(that)) {
            return this;
        }
        if (that.isA(this)) {
            return that;
        }
        if (this instanceof ImmutableTypeConstant && that.isA(this.getUnderlyingType())) {
            return that.freeze();
        }
        if (that instanceof ImmutableTypeConstant && this.isA(that.getUnderlyingType())) {
            return this.freeze();
        }
        TypeConstant typeConstant = TypeConstant.combineOneParameterized(pool, this, that);
        if (typeConstant instanceof TypeConstant) {
            TypeConstant typeCombined = typeConstant;
            return typeCombined;
        }
        typeConstant = TypeConstant.combineOneParameterized(pool, that, this);
        if (typeConstant instanceof TypeConstant) {
            TypeConstant typeCombined = typeConstant;
            return typeCombined;
        }
        if (this.getClass() == that.getClass() && this.isSingleUnderlyingClass(true) && this instanceof ParameterizedTypeConstant && (typeThis = this.getUnderlyingType()).equals(typeThat = that.getUnderlyingType())) {
            TypeConstant[] atypeThis = this.getParamTypesArray();
            TypeConstant[] atypeThat = that.getParamTypesArray();
            int cTypes = Math.max(atypeThis.length, atypeThat.length);
            TypeConstant[] atypeInter = new TypeConstant[cTypes];
            for (int i = 0; i < cTypes; ++i) {
                atypeInter[i] = this.getParamType(i).combine(pool, that.getParamType(i));
            }
            return pool.ensureParameterizedTypeConstant(typeThis, atypeInter);
        }
        return pool.ensureIntersectionTypeConstant(this, that);
    }

    private static TypeConstant combineOneParameterized(ConstantPool pool, TypeConstant t1, TypeConstant t2) {
        if (t1 instanceof ParameterizedTypeConstant && t1.isA(pool.typeClass()) == t2.isA(pool.typeClass()) && t2.isA(t1.getUnderlyingType()) && t2.isSingleUnderlyingClass(true) && !t2.isParamsSpecified()) {
            TypeConstant[] atype1 = t1.getParamTypesArray();
            ClassStructure clz2 = (ClassStructure)t2.getSingleUnderlyingClass(true).getComponent();
            if (!clz2.isParameterized()) {
                return null;
            }
            TypeConstant[] atype2 = clz2.getCanonicalType().getParamTypesArray();
            boolean fClone = false;
            int c = atype2.length;
            for (int i = 0; i < c; ++i) {
                TypeConstant te1 = atype1[i];
                TypeConstant te2 = atype2[i];
                if (te1.equals(te2)) continue;
                if (!fClone) {
                    atype2 = (TypeConstant[])atype2.clone();
                    fClone = true;
                }
                atype2[i] = te1.combine(pool, te2);
            }
            return pool.ensureParameterizedTypeConstant(t2, atype2);
        }
        return null;
    }

    public TypeConstant union(ConstantPool pool, TypeConstant that) {
        TypeConstant thisResolved = this.resolveTypedefs();
        TypeConstant thatResolved = that.resolveTypedefs();
        if (thisResolved != this || thatResolved != that) {
            return thisResolved.union(pool, thatResolved);
        }
        if (this.isA(that)) {
            return that;
        }
        if (that.isA(this)) {
            return this;
        }
        if (this.getClass() == that.getClass() && this.isSingleUnderlyingClass(true)) {
            IdentityConstant idEnumThat;
            IdentityConstant idEnumThis;
            if (this instanceof ParameterizedTypeConstant) {
                TypeConstant typeThat;
                TypeConstant typeThis = this.getUnderlyingType();
                if (typeThis.equals(typeThat = that.getUnderlyingType())) {
                    TypeConstant[] atypeThis = this.getParamTypesArray();
                    TypeConstant[] atypeThat = that.getParamTypesArray();
                    int cTypes = Math.max(atypeThis.length, atypeThat.length);
                    TypeConstant[] atypeUnion = new TypeConstant[cTypes];
                    for (int i = 0; i < cTypes; ++i) {
                        atypeUnion[i] = this.getParamType(i).union(pool, that.getParamType(i));
                    }
                    return pool.ensureParameterizedTypeConstant(typeThis, atypeUnion);
                }
            } else if (this instanceof ImmutableTypeConstant) {
                TypeConstant typeThat;
                TypeConstant typeThis = this.getUnderlyingType();
                TypeConstant typeUnion = typeThis.union(pool, typeThat = that.getUnderlyingType());
                if (typeUnion.isSingleUnderlyingClass(true)) {
                    return typeUnion.freeze();
                }
            } else if (this.isEnumValue() && that.isEnumValue() && (idEnumThis = this.getSingleUnderlyingClass(false).getNamespace()).equals(idEnumThat = that.getSingleUnderlyingClass(false).getNamespace())) {
                return idEnumThis.getType();
            }
        }
        return pool.ensureUnionTypeConstant(this, that);
    }

    public TypeConstant andNot(ConstantPool pool, TypeConstant that) {
        TypeConstant thisResolved = this.resolveTypedefs();
        TypeConstant thatResolved = that.resolveTypedefs();
        if (thisResolved != this || thatResolved != that) {
            return thisResolved.andNot(pool, thatResolved);
        }
        if (thisResolved.isA(thatResolved)) {
            return null;
        }
        return this.isTypeOfType() && this.getParamsCount() > 0 && that.isTypeOfType() && that.getParamsCount() > 0 ? this.getParamType(0).andNot(pool, that.getParamType(0)).getType() : this;
    }

    protected TypeConstant cloneSingle(ConstantPool pool, TypeConstant type) {
        throw new UnsupportedOperationException();
    }

    public ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, MethodConstant idMethod, ComponentResolver.ResolutionCollector collector) {
        return this.getUnderlyingType().resolveContributedName(sName, access, idMethod, collector);
    }

    @Override
    public TypeConstant resolveTypedefs() {
        TypeConstant constOriginal = this.getUnderlyingType();
        TypeConstant constResolved = constOriginal.resolveTypedefs();
        return constResolved == constOriginal ? this : this.cloneSingle(this.getConstantPool(), constResolved);
    }

    public TypeConstant resolveGenerics(ConstantPool pool, GenericTypeResolver resolver) {
        TypeConstant constOriginal = this.getUnderlyingType();
        TypeConstant constResolved = constOriginal.resolveGenerics(pool, resolver);
        return constResolved == constOriginal ? this : this.cloneSingle(pool, constResolved);
    }

    public TypeConstant resolveConstraints() {
        return this.resolveConstraints(false);
    }

    public TypeConstant resolveConstraints(boolean fPendingOnly) {
        TypeConstant constOriginal = this.getUnderlyingType();
        TypeConstant constResolved = constOriginal.resolveConstraints(fPendingOnly);
        return constResolved == constOriginal ? this : this.cloneSingle(this.getConstantPool(), constResolved);
    }

    public TypeConstant resolveDynamicConstraints(Register register) {
        TypeConstant constOriginal = this.getUnderlyingType();
        TypeConstant constResolved = constOriginal.resolveDynamicConstraints(register);
        return constResolved == constOriginal ? this : this.cloneSingle(this.getConstantPool(), constResolved);
    }

    public TypeConstant normalizeParameters() {
        TypeConstant typeNormalized = this.m_typeNormalized;
        if (typeNormalized == null && !(typeNormalized = this.adoptParameters(this.getConstantPool(), (TypeConstant[])null)).containsUnresolved()) {
            this.m_typeNormalized = typeNormalized;
        }
        return typeNormalized;
    }

    public TypeConstant adoptAnnotations(final ConstantPool pool, TypeConstant typeFrom) {
        assert (!this.isAnnotated() && typeFrom.isAnnotated());
        final TypeConstant typeBase = this;
        Function<TypeConstant, TypeConstant> transformer = new Function<TypeConstant, TypeConstant>(this){

            @Override
            public TypeConstant apply(TypeConstant type) {
                return type.isAnnotated() ? type.replaceUnderlying(pool, this) : typeBase;
            }
        };
        return (TypeConstant)transformer.apply(typeFrom);
    }

    public TypeConstant adoptParameters(ConstantPool pool, TypeConstant typeFrom) {
        assert (!this.isParamsSpecified());
        TypeConstant typeSansParams = typeFrom;
        if (typeFrom.isParamsSpecified()) {
            while ((typeSansParams = typeSansParams.getUnderlyingType()).isParamsSpecified()) {
            }
        }
        if (this.isA(typeSansParams)) {
            return this.adoptParameters(pool, typeFrom.getParamTypesArray());
        }
        if (!this.isVirtualChild() && typeSansParams.isVirtualChild()) {
            TypeConstant typeParent = typeSansParams.getParentType();
            while (true) {
                if (typeParent.isParamsSpecified()) {
                    return this.adoptParameters(pool, typeParent.getParamTypesArray());
                }
                if (!typeParent.isVirtualChild()) break;
                typeParent = typeParent.getParentType();
            }
        }
        return this;
    }

    public TypeConstant adoptParameters(ConstantPool pool, TypeConstant[] atypeParams) {
        TypeConstant constOriginal = this.getUnderlyingType();
        TypeConstant constResolved = constOriginal.adoptParameters(pool, atypeParams);
        return constResolved == constOriginal ? this : this.cloneSingle(pool, constResolved);
    }

    public TypeConstant[] collectGenericParameters() {
        return this.getUnderlyingType().collectGenericParameters();
    }

    public boolean containsAutoNarrowing(boolean fAllowVirtChild) {
        return this.getUnderlyingType().containsAutoNarrowing(fAllowVirtChild);
    }

    @Override
    public boolean isAutoNarrowing() {
        return this.isModifyingType() && this.getUnderlyingType().isAutoNarrowing();
    }

    public TypeConstant ensureAutoNarrowing() {
        assert (this.isModifyingType());
        TypeConstant constOriginal = this.getUnderlyingType();
        TypeConstant constResolved = constOriginal.ensureAutoNarrowing();
        return constResolved == constOriginal ? this : this.cloneSingle(this.getConstantPool(), constResolved);
    }

    public TypeConstant resolveAutoNarrowing(ConstantPool pool, boolean fRetainParams, TypeConstant typeTarget, IdentityConstant idCtx) {
        if (!this.isModifyingType()) {
            return this;
        }
        TypeConstant constOriginal = this.getUnderlyingType();
        TypeConstant constResolved = constOriginal.resolveAutoNarrowing(pool, fRetainParams, typeTarget, idCtx);
        return constResolved == constOriginal ? this : this.cloneSingle(pool, constResolved);
    }

    public TypeConstant resolveAutoNarrowingBase() {
        return this.resolveAutoNarrowing(this.getConstantPool(), true, null, null);
    }

    public TypeConstant removeAutoNarrowing() {
        return this.resolveAutoNarrowing(this.getConstantPool(), false, null, null);
    }

    public TypeConstant replaceUnderlying(ConstantPool pool, Function<TypeConstant, TypeConstant> transformer) {
        TypeConstant constOriginal = this.getUnderlyingType();
        TypeConstant constResolved = transformer.apply(constOriginal);
        return constResolved == constOriginal ? this : this.cloneSingle(pool, constResolved);
    }

    public TypeConstant resolveTypeParameter(TypeConstant typeActual, String sFormalName) {
        return this.getUnderlyingType().resolveTypeParameter(typeActual, sFormalName);
    }

    public TypeConstant resolvePending(ConstantPool pool, TypeConstant typeActual) {
        return this;
    }

    public boolean isTuple() {
        return this.isSingleDefiningConstant() && this.getUnderlyingType().isTuple();
    }

    public List<TypeConstant> getTupleParamTypes() {
        assert (this.isTuple());
        IdentityConstant idTuple = this.getSingleUnderlyingClass(true);
        ClassStructure clzTuple = (ClassStructure)idTuple.getComponent();
        return clzTuple.getTupleParamTypes(this.getConstantPool(), this.getParamTypes());
    }

    public boolean isArray() {
        TypeConstant constThis = this.resolveTypedefs();
        assert (!constThis.containsUnresolved());
        return constThis.isA(this.getConstantPool().typeArray());
    }

    public boolean supportsEquals(TypeConstant that, boolean fThatIsConstant) {
        assert (that != null);
        ConstantPool pool = this.getConstantPool();
        if (this.isTypeOfType() && that.isTypeOfType() || this.isA(pool.typeRef()) && that.isA(pool.typeRef())) {
            return true;
        }
        if (this.isTuple() && that.isTuple()) {
            TypeConstant[] atypeThis = this.getParamTypesArray();
            TypeConstant[] atypeThat = that.getParamTypesArray();
            int c = Math.min(atypeThis.length, atypeThat.length);
            for (int i = 0; i < c; ++i) {
                if (atypeThis[i].supportsEquals(atypeThat[i], false)) continue;
                return false;
            }
            return true;
        }
        TypeConstant typeThis = this.removeAutoNarrowing();
        TypeConstant typeThat = that.removeAutoNarrowing();
        if (typeThat.isA(typeThis) && (fThatIsConstant || typeThis.isA(typeThat))) {
            return true;
        }
        if (typeThis.isImmutabilitySpecified() ^ typeThat.isImmutabilitySpecified()) {
            return typeThis.isImmutabilitySpecified() ? typeThis.removeImmutable().supportsEquals(typeThat, fThatIsConstant) : typeThis.supportsEquals(typeThat.removeImmutable(), false);
        }
        if (typeThat.isAccessSpecified() || typeThis.isAccessSpecified()) {
            return typeThis.removeAccess().supportsEquals(typeThat.removeAccess(), fThatIsConstant);
        }
        if (typeThis.isNullable()) {
            return typeThis.removeNullable().supportsEquals(typeThat, fThatIsConstant);
        }
        if (typeThat.isNullable()) {
            return typeThis.supportsEquals(typeThat.removeNullable(), false);
        }
        return false;
    }

    public boolean supportsCompare(TypeConstant that, boolean fThatIsConstant) {
        assert (that != null);
        if (this.isTypeOfType() && that.isTypeOfType()) {
            return true;
        }
        TypeConstant typeThis = this.removeAutoNarrowing();
        TypeConstant typeThat = that.removeAutoNarrowing();
        if (typeThat.isA(typeThis) && (fThatIsConstant || typeThis.isA(typeThat))) {
            return this.findFunctionInfo(this.getConstantPool().sigCompare()) != null;
        }
        if (typeThis.isImmutabilitySpecified() ^ typeThat.isImmutabilitySpecified()) {
            return typeThis.isImmutabilitySpecified() ? typeThis.removeImmutable().supportsCompare(typeThat, fThatIsConstant) : typeThis.supportsCompare(typeThat.removeImmutable(), false);
        }
        if (typeThat.isAccessSpecified() || typeThis.isAccessSpecified()) {
            return typeThis.removeAccess().supportsCompare(typeThat.removeAccess(), fThatIsConstant);
        }
        return false;
    }

    public boolean isNestMateOf(IdentityConstant idClass) {
        return !this.isFormalType() && this.isExplicitClassIdentity(true) && this.isSingleUnderlyingClass(false) && this.getSingleUnderlyingClass(false).isNestMateOf(idClass);
    }

    public TypeConstant widenEnumValueTypes() {
        return this.isModifyingType() ? this.cloneSingle(this.getConstantPool(), this.getUnderlyingType().widenEnumValueTypes()) : this;
    }

    public TypeInfo ensureTypeInfo() {
        return this.ensureTypeInfo(this.getErrorListener());
    }

    public TypeInfo ensureTypeInfo(IdentityConstant idClass, ErrorListener errs) {
        return this.adjustAccess(idClass).ensureTypeInfo(errs);
    }

    public TypeInfo ensureTypeInfo(ErrorListener errs) {
        TypeInfo info = this.getTypeInfo();
        if (TypeConstant.isComplete(info) && this.isUpToDate(info)) {
            return info;
        }
        return this.ensureTypeInfo(info, errs);
    }

    private synchronized TypeInfo ensureTypeInfo(TypeInfo info, ErrorListener errs) {
        ConstantPool pool = this.getConstantPool();
        if (info == null && (this.validate(errs) || this.containsUnresolved())) {
            this.log(errs, Severity.ERROR, "COMPILER-38", this.getValueString());
            return pool.typeObject().ensureTypeInfo(errs);
        }
        TypeConstant typeResolved = (TypeConstant)pool.register(this);
        if ((typeResolved = typeResolved.removeAutoNarrowing().normalizeParameters()) != this) {
            info = typeResolved.ensureTypeInfo(errs);
            typeResolved.setTypeInfo(info);
            return info;
        }
        this.setTypeInfo(pool.infoPlaceholder());
        if (this.hasDeferredTypeInfo()) {
            throw new IllegalStateException("Infinite loop while producing a TypeInfo for " + String.valueOf(this) + "; deferred types=" + String.valueOf(this.takeDeferredTypeInfo()));
        }
        errs = errs.branch(null);
        HashSet<TypeConstant> setInvalidate = null;
        try {
            info = this.buildTypeInfo(errs);
            if (info != null) {
                this.setTypeInfo(info);
            }
            int cDeferredPrev = 0;
            int iTry = 0;
            while (this.hasDeferredTypeInfo()) {
                List<TypeConstant> listDeferred = this.takeDeferredTypeInfo();
                int cDeferred = listDeferred.size();
                if (iTry > 2 && cDeferred >= cDeferredPrev) {
                    errs.merge();
                    throw new IllegalStateException("Failure to make progress on a TypeInfo for " + String.valueOf(this) + "; deferred types=" + String.valueOf(listDeferred) + "\nErrors: " + String.valueOf(errs));
                }
                cDeferredPrev = cDeferred;
                for (TypeConstant typeDeferred : listDeferred) {
                    TypeInfo infoDeferred;
                    if (typeDeferred == this) continue;
                    if (typeDeferred.getConstantPool() != pool) {
                        typeDeferred = (TypeConstant)pool.register(typeDeferred);
                    }
                    if (TypeConstant.isComplete(infoDeferred = typeDeferred.getTypeInfo())) continue;
                    if (this.m_cRecursiveDepth.getAndIncrement() > 2) {
                        throw new IllegalStateException("Infinite loop while producing a TypeInfo for " + String.valueOf(this) + "; deferred type=" + String.valueOf(typeDeferred));
                    }
                    ErrorListener errsTemp = errs.branch(null);
                    infoDeferred = typeDeferred.buildTypeInfo(errsTemp);
                    this.m_cRecursiveDepth.getAndDecrement();
                    if (TypeConstant.isComplete(infoDeferred)) {
                        if (errsTemp.hasSeriousErrors()) {
                            if (setInvalidate == null) {
                                setInvalidate = new HashSet<TypeConstant>();
                            }
                            setInvalidate.add(typeDeferred);
                        }
                        errsTemp.merge();
                    }
                    if (infoDeferred == null) continue;
                    typeDeferred.setTypeInfo(infoDeferred);
                }
                if (!TypeConstant.isComplete(info) && (info = this.buildTypeInfo(errs)) != null) {
                    this.setTypeInfo(info);
                }
                ++iTry;
            }
        }
        catch (Error | Exception e) {
            this.takeDeferredTypeInfo();
            throw e;
        }
        if (errs.hasSeriousErrors()) {
            this.invalidateTypeInfo();
            if (setInvalidate != null) {
                setInvalidate.forEach(TypeConstant::invalidateTypeInfo);
            }
        }
        errs.merge();
        return info;
    }

    protected TypeInfo ensureTypeInfoInternal(ErrorListener errs) {
        TypeInfo info = this.getTypeInfo();
        if (info != null && info.isPlaceHolder()) {
            this.addDeferredTypeInfo(this);
            return null;
        }
        if (info == null || !this.isUpToDate(info)) {
            this.setTypeInfo(this.getConstantPool().infoPlaceholder());
            info = this.buildTypeInfo(errs);
            if (info != null) {
                this.setTypeInfo(info);
                if (errs.hasSeriousErrors()) {
                    info.markWithError();
                }
            }
        }
        if (!TypeConstant.isComplete(info)) {
            this.addDeferredTypeInfo(this);
        }
        return info;
    }

    protected TypeInfo getTypeInfo() {
        return s_typeinfo.get(this);
    }

    protected void setTypeInfo(TypeInfo info) {
        block1: {
            TypeInfo infoOld;
            do {
                infoOld = s_typeinfo.get(this);
                if (TypeConstant.rankTypeInfo(info) <= TypeConstant.rankTypeInfo(infoOld) && !info.isPlaceHolder()) break block1;
            } while (!s_typeinfo.compareAndSet(this, infoOld, info));
            this.setInvalidationCount(info.getInvalidationCount());
        }
    }

    protected int getInvalidationCount() {
        return s_cInvalidations.get(this);
    }

    protected void setInvalidationCount(int cNew) {
        int cOld;
        while ((cOld = s_cInvalidations.get(this)) < cNew) {
            s_cInvalidations.compareAndSet(this, cOld, cNew);
        }
    }

    public void invalidateTypeInfo() {
        this.clearTypeInfo();
        if (this.isSingleUnderlyingClass(true)) {
            this.getConstantPool().invalidateTypeInfos(this.getSingleUnderlyingClass(true));
        }
        if (this.isSingleDefiningConstant() && !this.isAccessSpecified()) {
            this.getConstantPool().ensureAccessTypeConstant(this, Constants.Access.PRIVATE).clearTypeInfo();
        }
    }

    protected void clearTypeInfo() {
        s_typeinfo.set(this, null);
    }

    private static int rankTypeInfo(TypeInfo info) {
        return info == null ? 0 : info.getProgress().ordinal();
    }

    public static boolean isComplete(TypeInfo info) {
        return TypeConstant.rankTypeInfo(info) == 3;
    }

    protected boolean isUpToDate(TypeInfo info) {
        ConstantPool pool = this.getConstantPool();
        int cOldInvals = this.getInvalidationCount();
        int cNewInvals = pool.getInvalidationCount();
        if (cNewInvals == cOldInvals) {
            return true;
        }
        if (info.needsRebuild(pool.invalidationsSince(cOldInvals))) {
            return false;
        }
        this.setInvalidationCount(cNewInvals);
        return true;
    }

    protected TypeInfo buildTypeInfo(ErrorListener errs) {
        try (Auto ignore = ConstantPool.withPool(this.getConstantPool());){
            TypeInfo typeInfo = this.buildTypeInfoImpl(errs);
            return typeInfo;
        }
    }

    private TypeInfo buildTypeInfoImpl(ErrorListener errs) {
        PackageStructure pkg;
        ClassStructure struct;
        IdentityConstant constId;
        switch (this.getAccess()) {
            case STRUCT: {
                return this.buildStructInfo(errs);
            }
            case PRIVATE: {
                break;
            }
            case PROTECTED: {
                throw new IllegalStateException();
            }
            case PUBLIC: {
                assert (!this.isAccessSpecified());
                TypeInfo info = this.getConstantPool().ensureAccessTypeConstant(this, Constants.Access.PRIVATE).ensureTypeInfoInternal(errs);
                return info == null ? null : info.limitAccess(Constants.Access.PUBLIC);
            }
        }
        TypeConstant typeUnderlying = this.getUnderlyingType();
        if (typeUnderlying.isAnnotated()) {
            if (typeUnderlying instanceof AnnotatedTypeConstant) {
                AnnotatedTypeConstant typeAnno = (AnnotatedTypeConstant)typeUnderlying;
                return typeAnno.buildPrivateInfo(errs);
            }
            this.log(errs, Severity.ERROR, "VERIFY-13", this.getAnnotations()[0], typeUnderlying.getValueString());
            return null;
        }
        if (typeUnderlying instanceof PropertyClassTypeConstant) {
            PropertyClassTypeConstant typePropClass = (PropertyClassTypeConstant)typeUnderlying;
            return typePropClass.buildTypeInfo(errs);
        }
        ConstantPool pool = this.getConstantPool();
        try {
            constId = (IdentityConstant)this.getDefiningConstant();
            struct = (ClassStructure)constId.getComponent();
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Unable to determine class for " + this.getValueString(), e);
        }
        if (struct instanceof PackageStructure && (pkg = (PackageStructure)struct).isModuleImport()) {
            ModuleStructure module = pkg.getImportedModule();
            module = module.isFingerprint() ? module.getFingerprintOrigin() : module;
            return pool.ensureAccessTypeConstant(module.getCanonicalType(), Constants.Access.PRIVATE).buildTypeInfoImpl(errs);
        }
        int cInvals = pool.getInvalidationCount();
        Annotation[] aAnnoMixin = struct.collectAnnotations(false);
        Annotation[] aAnnoClass = struct.collectAnnotations(true);
        if (aAnnoMixin.length > 0) {
            TypeInfo infoBase = this.buildBaseTypeInfoImpl(constId, struct, Annotation.NO_ANNOTATIONS, cInvals, false, errs);
            return this.layerOnAnnotations(constId, struct, infoBase, aAnnoMixin, aAnnoClass, cInvals, errs);
        }
        return this.buildBaseTypeInfoImpl(constId, struct, aAnnoClass, cInvals, true, errs);
    }

    private TypeInfo buildBaseTypeInfoImpl(IdentityConstant constId, ClassStructure struct, Annotation[] aAnnoClass, int cInvalidations, boolean fComplete, ErrorListener errs) {
        MethodInfo methodInvalid;
        HashMap<Object, PropertyInfo> mapVirtProps;
        List<Component.Contribution> listContribs = struct.getContributionsAsList();
        TypeConstant[] atypeContrib = this.resolveContributionTypes(listContribs);
        TypeConstant[] atypeCondInc = this.extractConditionalContributes(constId, struct, listContribs, atypeContrib, errs);
        ArrayList<Component.Contribution> listProcess = new ArrayList<Component.Contribution>();
        TypeConstant[] atypeSpecial = this.createContributionList(constId, struct, atypeContrib, listProcess, errs);
        TypeConstant typeInto = atypeSpecial[0];
        TypeConstant typeExtends = atypeSpecial[1];
        TypeConstant typeRebase = atypeSpecial[2];
        Map<Object, ParamInfo> mapTypeParams = this.collectTypeParameters(constId, struct, errs);
        ListMap<IdentityConstant, Origin> listmapClassChain = new ListMap<IdentityConstant, Origin>();
        ListMap<IdentityConstant, Origin> listmapDefaultChain = new ListMap<IdentityConstant, Origin>();
        HashSet<TypeConstant> setDepends = new HashSet<TypeConstant>();
        fComplete &= this.createCallChains(constId, struct, mapTypeParams, listProcess, setDepends, listmapClassChain, listmapDefaultChain, errs);
        HashMap<PropertyConstant, PropertyInfo> mapProps = new HashMap<PropertyConstant, PropertyInfo>();
        HashMap<MethodConstant, MethodInfo> mapMethods = new HashMap<MethodConstant, MethodInfo>();
        HashMap<Object, MethodInfo> mapVirtMethods = new HashMap<Object, MethodInfo>();
        ListMap<String, ChildInfo> mapChildren = new ListMap<String, ChildInfo>();
        this.checkTypeParameterProperties(mapTypeParams, mapVirtProps, (fComplete &= this.collectMemberInfo(constId, struct, mapTypeParams, listProcess, setDepends, listmapClassChain, listmapDefaultChain, mapProps, mapMethods, mapVirtProps = new HashMap<Object, PropertyInfo>(), mapVirtMethods, mapChildren, errs)) && !errs.hasSeriousErrors() ? errs : ErrorListener.BLACKHOLE);
        Annotation[] aAnnoMixin = fComplete ? this.collectMixinAnnotations(listProcess) : Annotation.NO_ANNOTATIONS;
        TypeInfo info = new TypeInfo(this, cInvalidations, struct, 0, false, mapTypeParams, aAnnoClass, aAnnoMixin, typeExtends, typeRebase, typeInto, listProcess, listmapClassChain, listmapDefaultChain, mapProps, mapMethods, mapVirtProps, mapVirtMethods, mapChildren, setDepends.isEmpty() ? null : setDepends, fComplete ? TypeInfo.Progress.Complete : TypeInfo.Progress.Incomplete);
        if (fComplete && (methodInvalid = info.validateCapped()) != null) {
            MethodConstant id = methodInvalid.getIdentity();
            id.log(errs, Severity.ERROR, "VERIFY-69", this.getValueString(), id.getValueString(), methodInvalid.getHead().getNarrowingNestedIdentity());
        }
        return atypeCondInc == null || !fComplete ? info : this.mergeConditionalIncorporates(cInvalidations, constId, info, atypeCondInc, errs);
    }

    private Annotation[] collectMixinAnnotations(List<Component.Contribution> listContrib) {
        ArrayList<Annotation> listAnnos = null;
        int c = listContrib.size();
        block4: for (int i = c - 1; i >= 0; --i) {
            Component.Contribution contrib = listContrib.get(i);
            switch (contrib.getComposition()) {
                case Annotation: {
                    Annotation anno = contrib.getAnnotation();
                    TypeConstant typeInto = anno.getAnnotationType().getExplicitClassInto().resolveGenerics(this.getConstantPool(), this);
                    if (!this.isA(typeInto)) continue block4;
                    if (listAnnos == null) {
                        listAnnos = new ArrayList();
                    }
                    listAnnos.add(anno);
                    continue block4;
                }
                case Extends: {
                    TypeInfo infoExtend = contrib.getTypeConstant().ensureTypeInfo();
                    Annotation[] aAnnoExtend = infoExtend.getMixinAnnotations();
                    if (aAnnoExtend.length <= 0) continue block4;
                    if (listAnnos == null) {
                        listAnnos = new ArrayList<Annotation>();
                    }
                    listAnnos.addAll(Arrays.asList(aAnnoExtend));
                    continue block4;
                }
            }
        }
        return listAnnos == null ? Annotation.NO_ANNOTATIONS : listAnnos.toArray(Annotation.NO_ANNOTATIONS);
    }

    protected TypeInfo layerOnAnnotations(IdentityConstant constId, ClassStructure struct, TypeInfo infoBase, Annotation[] aAnnoMixin, Annotation[] aAnnoClass, int cInvalidations, ErrorListener errs) {
        ConstantPool pool = this.getConstantPool();
        TypeInfo infoNext = infoBase;
        TypeConstant typeNext = infoBase.getType();
        int c = aAnnoMixin.length;
        for (int i = c - 1; i >= 0; --i) {
            Annotation anno = aAnnoMixin[i];
            AnnotatedTypeConstant constAnno = pool.ensureAnnotatedTypeConstant(typeNext, anno);
            TypeConstant typeAnno = constAnno.getAnnotationType();
            TypeConstant typeAnnoPrivate = pool.ensureAccessTypeConstant(typeAnno, Constants.Access.PRIVATE);
            TypeInfo infoAnno = typeAnnoPrivate.ensureTypeInfoInternal(errs);
            if (infoAnno == null) {
                return TypeConstant.isComplete(infoBase) ? null : infoBase;
            }
            infoNext = typeNext.mergeMixinTypeInfo(this, cInvalidations, constId, struct, infoNext, infoAnno, i == 0 ? aAnnoClass : Annotation.NO_ANNOTATIONS, anno, errs);
            typeNext = constAnno;
        }
        assert (infoNext.getType().equals(this));
        return infoNext;
    }

    private TypeInfo buildStructInfo(ErrorListener errs) {
        assert (this instanceof AccessTypeConstant && this.getAccess() == Constants.Access.STRUCT);
        HashMap<PropertyConstant, PropertyInfo> mapProps = new HashMap<PropertyConstant, PropertyInfo>();
        HashMap<MethodConstant, MethodInfo> mapMethods = new HashMap<MethodConstant, MethodInfo>();
        HashMap<Object, PropertyInfo> mapVirtProps = new HashMap<Object, PropertyInfo>();
        ConstantPool pool = this.getConstantPool();
        int cInvals = pool.getInvalidationCount();
        TypeInfo infoPri = pool.ensureAccessTypeConstant(this.getUnderlyingType(), Constants.Access.PRIVATE).ensureTypeInfoInternal(errs);
        if (!TypeConstant.isComplete(infoPri)) {
            return infoPri;
        }
        ClassStructure struct = infoPri.getClassStructure();
        for (Map.Entry<PropertyConstant, PropertyInfo> entry : infoPri.getProperties().entrySet()) {
            PropertyInfo prop = entry.getValue();
            if (prop.isFormalType() || prop.isConstant() || prop.hasField()) {
                PropertyConstant id = entry.getKey();
                if (prop.hasField() && prop.isRefAnnotated()) {
                    prop = prop.ensureVar();
                }
                if (prop.isVirtual()) {
                    mapVirtProps.put(id.resolveNestedIdentity(pool, null), prop);
                }
                mapProps.put(id, prop);
                continue;
            }
            if (!"outer".equals(prop.getName()) || !struct.isInstanceChild()) continue;
            mapProps.put(entry.getKey(), prop);
        }
        for (Map.Entry<IdentityConstant, Constants> entry : infoPri.getMethods().entrySet()) {
            MethodInfo method = (MethodInfo)entry.getValue();
            if (!method.isFunction() && !method.isConstructor()) continue;
            mapMethods.put((MethodConstant)entry.getKey(), method);
        }
        boolean fIncomplete = false;
        block5: for (Component.Contribution contrib : infoPri.getContributionList()) {
            switch (contrib.getComposition()) {
                case Annotation: 
                case Extends: 
                case Incorporates: 
                case RebasesOnto: {
                    TypeConstant typeContrib = contrib.getTypeConstant();
                    typeContrib = typeContrib.removeAccess();
                    typeContrib = pool.ensureAccessTypeConstant(typeContrib, Constants.Access.STRUCT);
                    TypeInfo infoContrib = typeContrib.ensureTypeInfoInternal(errs);
                    if (TypeConstant.isComplete(infoContrib)) {
                        for (Map.Entry<PropertyConstant, PropertyInfo> entry : infoContrib.getProperties().entrySet()) {
                            PropertyInfo prop = entry.getValue();
                            if (!prop.hasField() || prop.getRefAccess() != Constants.Access.PRIVATE || prop.getHead().getImplementation() == MethodBody.Implementation.Implicit) continue;
                            mapProps.putIfAbsent(entry.getKey(), prop);
                        }
                        continue block5;
                    }
                    fIncomplete = true;
                    errs = ErrorListener.BLACKHOLE;
                    break;
                }
            }
        }
        MethodInfo methodInfo = pool.typeObject().ensureTypeInfo(errs).getMethodBySignature(pool.sigToString());
        mapMethods.putIfAbsent(methodInfo.getIdentity(), methodInfo);
        return new TypeInfo(this, cInvals, struct, 0, false, infoPri.getTypeParams(), infoPri.getClassAnnotations(), infoPri.getMixinAnnotations(), infoPri.getExtends(), infoPri.getRebases(), infoPri.getInto(), infoPri.getContributionList(), infoPri.getClassChain(), infoPri.getDefaultChain(), mapProps, mapMethods, mapVirtProps, Collections.emptyMap(), ListMap.EMPTY, null, fIncomplete ? TypeInfo.Progress.Incomplete : TypeInfo.Progress.Complete);
    }

    private Map<Object, ParamInfo> collectTypeParameters(IdentityConstant constId, ClassStructure struct, ErrorListener errs) {
        ConstantPool pool = this.getConstantPool();
        HashMap<Object, ParamInfo> mapTypeParams = new HashMap<Object, ParamInfo>();
        if (this.isTuple()) {
            TypeSequenceTypeConstant typeConstraint = pool.ensureTypeSequenceTypeConstant();
            ParamInfo param = new ParamInfo("ElementTypes", typeConstraint, null);
            mapTypeParams.put(param.getName(), param);
        } else {
            List<Map.Entry<StringConstant, TypeConstant>> listClassParams;
            int cClassParams;
            TypeConstant[] atypeParams = this.getParamTypesArray();
            int cTypeParams = atypeParams.length;
            if (cTypeParams > (cClassParams = (listClassParams = struct.getTypeParamsAsList()).size())) {
                if (cClassParams == 0) {
                    this.log(errs, Severity.ERROR, "VERIFY-02", constId.getPathString());
                } else {
                    this.log(errs, Severity.ERROR, "VERIFY-03", constId.getPathString(), cClassParams, cTypeParams);
                }
            }
            TypeConstant typeNormalized = this.normalizeParameters();
            for (int i = 0; i < cClassParams; ++i) {
                Map.Entry<StringConstant, TypeConstant> entryClassParam = listClassParams.get(i);
                String sName = entryClassParam.getKey().getValue();
                TypeConstant typeConstraint = entryClassParam.getValue();
                TypeConstant typeActual = null;
                if (!typeConstraint.isFormalTypeSequence()) {
                    typeConstraint = typeConstraint.resolveGenerics(pool, typeNormalized);
                }
                if (i < cTypeParams) {
                    typeActual = atypeParams[i];
                    assert (typeActual != null);
                    if (!typeActual.isA(typeConstraint)) {
                        this.log(errs, Severity.ERROR, "VERIFY-05", constId.getPathString(), sName, typeConstraint.getValueString(), typeActual.getValueString(), this.removeAccess().getValueString());
                    }
                }
                if (mapTypeParams.containsKey(sName)) {
                    this.log(errs, Severity.ERROR, "VERIFY-36", struct.getIdentityConstant().getValueString(), sName);
                    continue;
                }
                mapTypeParams.put(sName, new ParamInfo(sName, typeConstraint, typeActual));
            }
        }
        return mapTypeParams;
    }

    private TypeConstant[] createContributionList(IdentityConstant constId, ClassStructure struct, TypeConstant[] aContribType, List<Component.Contribution> listProcess, ErrorListener errs) {
        Component.Contribution contrib;
        ConstantPool pool = this.getConstantPool();
        List<Component.Contribution> listContribs = struct.getContributionsAsList();
        int cContribs = listContribs.size();
        int iContrib = 0;
        ClassStructure classStructure = struct;
        Objects.requireNonNull(classStructure);
        listProcess.add((Component)classStructure.new Component.Contribution(Component.Composition.Equal, this));
        TypeConstant typeInto = null;
        TypeConstant typeExtends = null;
        TypeConstant typeRebase = null;
        Component.Format format = struct.getFormat();
        switch (format) {
            case ENUMVALUE: 
            case PACKAGE: 
            case MODULE: 
            case ENUM: 
            case CLASS: 
            case CONST: 
            case SERVICE: {
                boolean fExtends;
                typeRebase = (TypeConstant)pool.register(struct.getRebaseType());
                contrib = iContrib < cContribs ? listContribs.get(iContrib) : null;
                boolean bl = fExtends = contrib != null && contrib.getComposition() == Component.Composition.Extends;
                if (!fExtends) {
                    if (format == Component.Format.ENUMVALUE) {
                        this.log(errs, Severity.ERROR, "VERIFY-09", constId.getPathString());
                    }
                    ++cContribs;
                    break;
                }
                typeExtends = aContribType[iContrib];
                ++iContrib;
                if (!typeExtends.isExplicitClassIdentity(true)) {
                    this.log(errs, Severity.ERROR, "VERIFY-10", constId.getPathString(), typeExtends.getValueString());
                    typeExtends = null;
                    break;
                }
                if (typeExtends.isAccessSpecified() || typeExtends.isAnnotated()) {
                    this.log(errs, Severity.ERROR, "VERIFY-88", constId.getPathString(), typeExtends.getValueString());
                    typeExtends = null;
                    break;
                }
                if (typeExtends.extendsClass(constId)) {
                    this.log(errs, Severity.ERROR, "VERIFY-11", constId.getPathString(), "extends");
                    typeExtends = null;
                    break;
                }
                IdentityConstant constExtends = typeExtends.getSingleUnderlyingClass(true);
                ClassStructure structExtends = (ClassStructure)constExtends.getComponent();
                if (!format.isExtendsLegal(structExtends.getFormat())) {
                    this.log(errs, Severity.ERROR, "VERIFY-23", new Object[]{constId.getPathString(), format, constExtends.getPathString(), structExtends.getFormat()});
                    typeExtends = null;
                    break;
                }
                if (!typeExtends.isVirtualChild()) break;
                if (this.isVirtualChild() && this.getParentType().isA(typeExtends.getOriginParentType())) {
                    typeExtends = typeExtends.ensureVirtualParent(this.getOriginParentType(), !struct.getName().equals(structExtends.getName()));
                    break;
                }
                this.log(errs, Severity.ERROR, "VERIFY-23", new Object[]{this.removeAccess().getValueString(), format, typeExtends.getValueString(), "virtual " + String.valueOf((Object)structExtends.getFormat())});
                typeExtends = null;
                break;
            }
            case ANNOTATION: 
            case MIXIN: {
                boolean fExtends;
                boolean fInto;
                contrib = iContrib < cContribs ? listContribs.get(iContrib) : null;
                boolean bl = fInto = contrib != null && contrib.getComposition() == Component.Composition.Into;
                if (fInto) {
                    typeInto = aContribType[iContrib];
                    contrib = ++iContrib < cContribs ? listContribs.get(iContrib) : null;
                }
                boolean bl2 = fExtends = contrib != null && contrib.getComposition() == Component.Composition.Extends;
                if (fExtends) {
                    typeExtends = aContribType[iContrib];
                    ++iContrib;
                    if (!typeExtends.isExplicitClassIdentity(true)) {
                        this.log(errs, Severity.ERROR, "VERIFY-10", constId.getPathString(), typeExtends.getValueString());
                        typeExtends = null;
                        break;
                    }
                    if (typeExtends.getExplicitClassFormat() != format) {
                        this.log(errs, Severity.ERROR, "VERIFY-23", new Object[]{constId.getPathString(), format, typeExtends.getValueString(), typeExtends.getExplicitClassFormat()});
                        typeExtends = null;
                        break;
                    }
                    if (typeExtends.extendsClass(constId)) {
                        this.log(errs, Severity.ERROR, "VERIFY-11", constId.getPathString(), "extends");
                        typeExtends = null;
                        break;
                    }
                    if (fInto) break;
                    typeInto = typeExtends.getExplicitClassInto(true);
                    break;
                }
                if (fInto) break;
                typeInto = pool.typeObject();
                break;
            }
            case INTERFACE: {
                if (constId instanceof NativeRebaseConstant) {
                    NativeRebaseConstant idNative = (NativeRebaseConstant)constId;
                    TypeConstant typeNatural = (TypeConstant)pool.register(idNative.getClassConstant().getType());
                    if (this.isParamsSpecified()) {
                        typeNatural = pool.ensureParameterizedTypeConstant(typeNatural, this.getParamTypesArray());
                    }
                    ClassStructure classStructure2 = struct;
                    Objects.requireNonNull(classStructure2);
                    listProcess.add((Component)classStructure2.new Component.Contribution(Component.Composition.Implements, typeNatural));
                    ClassStructure classStructure3 = struct;
                    Objects.requireNonNull(classStructure3);
                    listProcess.add((Component)classStructure3.new Component.Contribution(Component.Composition.Implements, pool.typeObject()));
                    break;
                }
                if (constId.equals(pool.clzObject())) {
                    cContribs = 0;
                    break;
                }
                typeInto = pool.typeObject();
                break;
            }
            default: {
                throw new IllegalStateException(this.getValueString() + "=" + String.valueOf((Object)format));
            }
        }
        while (iContrib < cContribs) {
            TypeConstant typeContrib;
            if (iContrib < listContribs.size()) {
                contrib = listContribs.get(iContrib);
                typeContrib = aContribType[iContrib];
            } else {
                assert (iContrib == listContribs.size());
                typeContrib = pool.typeObject();
                ClassStructure classStructure4 = struct;
                Objects.requireNonNull(classStructure4);
                contrib = (Component)classStructure4.new Component.Contribution(Component.Composition.Implements, typeContrib);
            }
            switch (contrib.getComposition()) {
                case Annotation: {
                    this.validateAnnotation(constId, typeContrib, errs);
                    break;
                }
                case Into: {
                    this.log(errs, Severity.ERROR, "VERIFY-14", typeContrib.getValueString(), constId.getPathString());
                    break;
                }
                case Extends: {
                    this.log(errs, Severity.ERROR, "VERIFY-08", typeContrib.getValueString(), constId.getPathString());
                    break;
                }
                case Incorporates: {
                    if (contrib.getTypeParams() != null) break;
                    this.processMixins(constId, typeContrib, struct, listProcess, errs);
                    break;
                }
                case Delegates: {
                    this.processDelegates(constId, typeContrib, contrib, struct, listProcess, errs);
                    break;
                }
                case Implements: {
                    this.processImplements(constId, typeContrib, struct, listProcess, errs);
                    break;
                }
                case Import: {
                    break;
                }
                default: {
                    throw new IllegalStateException(constId.getPathString() + ", contribution=" + String.valueOf(contrib));
                }
            }
            ++iContrib;
        }
        if (struct.containsVirtualChild() && !constId.equals(pool.clzOuter())) {
            ClassStructure classStructure5 = struct;
            Objects.requireNonNull(classStructure5);
            listProcess.add((Component)classStructure5.new Component.Contribution(Component.Composition.Implements, pool.typeOuter()));
        }
        if (this.isVirtualChild() && !constId.equals(pool.clzInner())) {
            ClassStructure classStructure6 = struct;
            Objects.requireNonNull(classStructure6);
            listProcess.add((Component)classStructure6.new Component.Contribution(Component.Composition.Implements, pool.typeInner()));
        }
        if (typeInto != null) {
            if (!typeInto.equals(pool.typeObject()) && !typeInto.isAccessSpecified() && typeInto.isSingleUnderlyingClass(true)) {
                Constants.Access access = struct.isDescendant(typeInto.getSingleUnderlyingClass(true)) ? Constants.Access.PRIVATE : Constants.Access.PROTECTED;
                typeInto = pool.ensureAccessTypeConstant(typeInto, access);
            }
            ClassStructure classStructure7 = struct;
            Objects.requireNonNull(classStructure7);
            listProcess.add((Component)classStructure7.new Component.Contribution(Component.Composition.Into, typeInto));
        }
        if (typeExtends != null) {
            ClassStructure classStructure8 = struct;
            Objects.requireNonNull(classStructure8);
            listProcess.add((Component)classStructure8.new Component.Contribution(Component.Composition.Extends, pool.ensureAccessTypeConstant(typeExtends, Constants.Access.PROTECTED)));
        }
        if (typeRebase != null) {
            ClassStructure classStructure9 = struct;
            Objects.requireNonNull(classStructure9);
            listProcess.add((Component)classStructure9.new Component.Contribution(Component.Composition.RebasesOnto, pool.ensureAccessTypeConstant(typeRebase, Constants.Access.PROTECTED)));
        }
        return new TypeConstant[]{typeInto, typeExtends, typeRebase};
    }

    private TypeConstant[] extractConditionalContributes(IdentityConstant constId, ClassStructure struct, List<Component.Contribution> listContribs, TypeConstant[] aContribType, ErrorListener errs) {
        ArrayList<TypeConstant> listCondContribs = null;
        int cContribs = listContribs.size();
        for (int iContrib = 0; iContrib < cContribs; ++iContrib) {
            Component.Contribution contrib = listContribs.get(iContrib);
            TypeConstant typeMixin = aContribType[iContrib];
            Component.Composition compose = contrib.getComposition();
            if (compose != Component.Composition.Incorporates) continue;
            if (contrib.getTypeParams() == null) {
                assert (typeMixin != null);
                continue;
            }
            if (typeMixin == null) continue;
            if (!typeMixin.isExplicitClassIdentity(true)) {
                this.log(errs, Severity.ERROR, "VERIFY-16", constId.getPathString(), typeMixin.getValueString());
                continue;
            }
            if (typeMixin.getExplicitClassFormat() != Component.Format.MIXIN) {
                this.log(errs, Severity.ERROR, "VERIFY-30", typeMixin.getValueString());
                continue;
            }
            if (listCondContribs == null) {
                listCondContribs = new ArrayList<TypeConstant>();
            } else {
                Iterator iter = listCondContribs.iterator();
                while (iter.hasNext()) {
                    TypeConstant typeOther = (TypeConstant)iter.next();
                    IdentityConstant idOther = typeOther.getSingleUnderlyingClass(true);
                    if (!typeMixin.extendsClass(idOther)) continue;
                    iter.remove();
                }
            }
            listCondContribs.add(typeMixin);
            this.processMixins(constId, typeMixin, struct, new ArrayList<Component.Contribution>(), errs);
        }
        return listCondContribs == null ? null : listCondContribs.toArray(NO_TYPES);
    }

    private TypeConstant[] resolveContributionTypes(List<Component.Contribution> listContribs) {
        ConstantPool pool = this.getConstantPool();
        int cContribs = listContribs.size();
        TypeConstant[] aContribType = new TypeConstant[cContribs];
        for (int iContrib = 0; iContrib < cContribs; ++iContrib) {
            aContribType[iContrib] = listContribs.get(iContrib).resolveGenerics(pool, this);
        }
        return aContribType;
    }

    private void validateAnnotation(IdentityConstant constId, TypeConstant typeContrib, ErrorListener errs) {
        if (!typeContrib.isExplicitClassIdentity(true)) {
            this.log(errs, Severity.ERROR, "VERIFY-07", typeContrib.getValueString(), constId.getPathString());
            return;
        }
        if (typeContrib.getExplicitClassFormat() != Component.Format.ANNOTATION) {
            this.log(errs, Severity.ERROR, "VERIFY-27", typeContrib.getValueString());
            return;
        }
        TypeConstant typeInto = typeContrib.getExplicitClassInto(true);
        if (!typeInto.isIntoClassType() || typeInto.isA(this.getConstantPool().typeEnumeration())) {
            if (!(!typeContrib.isVirtualChild() || this.isVirtualChild() && this.getParentType().isA(typeContrib.getParentType()))) {
                this.log(errs, Severity.ERROR, "VERIFY-91", constId.getPathString(), typeContrib.getValueString(), typeContrib.getParentType().getValueString());
                return;
            }
            if (!this.isA(typeInto)) {
                this.log(errs, Severity.ERROR, "VERIFY-32", constId.getPathString(), typeContrib.getValueString(), typeInto.getValueString());
            }
        }
    }

    private void processMixins(IdentityConstant constId, TypeConstant typeContrib, ClassStructure struct, List<Component.Contribution> listProcess, ErrorListener errs) {
        if (struct.getFormat() == Component.Format.INTERFACE) {
            this.log(errs, Severity.ERROR, "VERIFY-15", typeContrib.getValueString(), constId.getPathString());
            return;
        }
        if (!typeContrib.isExplicitClassIdentity(true)) {
            this.log(errs, Severity.ERROR, "VERIFY-16", typeContrib.getValueString(), constId.getPathString());
            return;
        }
        if (typeContrib.getExplicitClassFormat() != Component.Format.MIXIN) {
            this.log(errs, Severity.ERROR, "VERIFY-17", typeContrib.getValueString(), constId.getPathString());
            return;
        }
        TypeConstant typeInto = typeContrib.getExplicitClassInto(true);
        if (!(!typeContrib.isVirtualChild() || this.isVirtualChild() && this.getParentType().isA(typeContrib.getParentType()))) {
            this.log(errs, Severity.ERROR, "VERIFY-90", constId.getPathString(), typeContrib.getValueString(), typeContrib.getParentType().getValueString());
            return;
        }
        if (!this.isA(typeInto)) {
            this.log(errs, Severity.ERROR, "VERIFY-18", constId.getPathString(), typeContrib.getValueString(), typeInto.getValueString());
            return;
        }
        if (listProcess.stream().anyMatch(contribPrev -> contribPrev.getTypeConstant().equals(typeContrib))) {
            this.log(errs, Severity.ERROR, "VERIFY-53", constId.getPathString(), typeContrib.getValueString());
            return;
        }
        ClassStructure classStructure = struct;
        Objects.requireNonNull(classStructure);
        listProcess.add((Component)classStructure.new Component.Contribution(Component.Composition.Incorporates, this.getConstantPool().ensureAccessTypeConstant(typeContrib, Constants.Access.PROTECTED)));
    }

    private void processDelegates(IdentityConstant constId, TypeConstant typeContrib, Component.Contribution contrib, ClassStructure struct, List<Component.Contribution> listProcess, ErrorListener errs) {
        if (struct.getFormat() == Component.Format.INTERFACE) {
            this.log(errs, Severity.ERROR, "VERIFY-21", typeContrib.getValueString(), constId.getPathString());
            return;
        }
        if (typeContrib.isExplicitClassIdentity(true) && typeContrib.getExplicitClassFormat() != Component.Format.INTERFACE) {
            this.log(errs, Severity.ERROR, "VERIFY-19", typeContrib.getValueString(), constId.getPathString());
            return;
        }
        if (listProcess.stream().anyMatch(contribPrev -> contribPrev.getComposition() == Component.Composition.Delegates && contribPrev.getTypeConstant().equals(typeContrib))) {
            this.log(errs, Severity.ERROR, "VERIFY-54", constId.getPathString(), typeContrib.getValueString());
        } else {
            ClassStructure classStructure = struct;
            Objects.requireNonNull(classStructure);
            listProcess.add((Component)classStructure.new Component.Contribution(typeContrib, contrib.getDelegatePropertyConstant()));
        }
    }

    private void processImplements(IdentityConstant constId, TypeConstant typeContrib, ClassStructure struct, List<Component.Contribution> listProcess, ErrorListener errs) {
        if (!typeContrib.isExplicitClassIdentity(true)) {
            this.log(errs, Severity.ERROR, "VERIFY-12", constId.getPathString(), typeContrib.getValueString());
            return;
        }
        if (typeContrib.isSingleUnderlyingClass(false)) {
            this.log(errs, Severity.ERROR, "VERIFY-20", typeContrib.getValueString(), constId.getPathString());
            return;
        }
        if (typeContrib.isAccessSpecified() || typeContrib.isAnnotated()) {
            this.log(errs, Severity.ERROR, "VERIFY-88", constId.getPathString(), typeContrib.getValueString());
            return;
        }
        if (listProcess.stream().anyMatch(contribPrev -> contribPrev.getComposition() == Component.Composition.Implements && contribPrev.getTypeConstant().equals(typeContrib))) {
            this.log(errs, Severity.ERROR, "VERIFY-55", constId.getPathString(), typeContrib.getValueString());
        } else {
            ClassStructure classStructure = struct;
            Objects.requireNonNull(classStructure);
            listProcess.add((Component)classStructure.new Component.Contribution(Component.Composition.Implements, typeContrib.ensureAccess(Constants.Access.PROTECTED)));
        }
    }

    private boolean createCallChains(IdentityConstant constId, ClassStructure struct, Map<Object, ParamInfo> mapTypeParams, List<Component.Contribution> listProcess, Set<TypeConstant> setDepends, ListMap<IdentityConstant, Origin> listmapClassChain, ListMap<IdentityConstant, Origin> listmapDefaultChain, ErrorListener errs) {
        boolean fIncomplete = false;
        block4: for (Component.Contribution contrib : listProcess) {
            Component.Composition composition = contrib.getComposition();
            switch (composition) {
                case Equal: {
                    assert (!listmapClassChain.containsKey(constId));
                    assert (!listmapDefaultChain.containsKey(constId));
                    (TypeConstant.isInterface(constId, struct) ? listmapDefaultChain : listmapClassChain).put(constId, new Origin(true));
                    break;
                }
                case Extends: 
                case Incorporates: 
                case RebasesOnto: 
                case Into: 
                case Delegates: 
                case Implements: {
                    TypeConstant typeContrib = contrib.getTypeConstant();
                    TypeInfo infoContrib = typeContrib.adjustAccess(constId).ensureTypeInfoInternal(errs);
                    if (!TypeConstant.isComplete(infoContrib) && (fIncomplete = this.computeIncomplete(composition, typeContrib, infoContrib, setDepends))) {
                        errs = ErrorListener.BLACKHOLE;
                        if (infoContrib == null) continue block4;
                        if (composition == Component.Composition.Into) break;
                    }
                    infoContrib.contributeChains(listmapClassChain, listmapDefaultChain, composition);
                    this.layerOnTypeParams(mapTypeParams, typeContrib, infoContrib.getTypeParams(), errs);
                    break;
                }
                default: {
                    throw new IllegalStateException("composition=" + String.valueOf((Object)composition));
                }
            }
        }
        return !fIncomplete;
    }

    private boolean computeIncomplete(Component.Composition composition, TypeConstant typeContrib, TypeInfo infoContrib, Set<TypeConstant> setDepends) {
        if (composition == Component.Composition.Into || infoContrib == null) {
            if (typeContrib instanceof UnionTypeConstant) {
                UnionTypeConstant typeUnion = (UnionTypeConstant)typeContrib;
                typeUnion.decompose(setDepends);
            } else {
                setDepends.add(typeContrib.removeAccess());
            }
        } else {
            if (composition == Component.Composition.Incorporates && infoContrib.dependsOn(this.removeAccess())) {
                return !setDepends.isEmpty();
            }
            infoContrib.collectDependTypes(setDepends);
        }
        return true;
    }

    private static boolean isInterface(IdentityConstant constId, ClassStructure struct) {
        return struct.getFormat() == Component.Format.INTERFACE && !(constId instanceof NativeRebaseConstant);
    }

    private boolean collectMemberInfo(IdentityConstant constId, ClassStructure struct, Map<Object, ParamInfo> mapTypeParams, List<Component.Contribution> listProcess, Set<TypeConstant> setDepends, ListMap<IdentityConstant, Origin> listmapClassChain, ListMap<IdentityConstant, Origin> listmapDefaultChain, Map<PropertyConstant, PropertyInfo> mapProps, Map<MethodConstant, MethodInfo> mapMethods, Map<Object, PropertyInfo> mapVirtProps, Map<Object, MethodInfo> mapVirtMethods, Map<String, ChildInfo> mapChildren, ErrorListener errs) {
        ConstantPool pool = this.getConstantPool();
        boolean fIncomplete = false;
        boolean fNative = constId instanceof NativeRebaseConstant;
        for (int i = listProcess.size() - 1; i >= 0; --i) {
            Constants infoCheck;
            Object nid;
            Constants infoOld;
            ListMap<Object, Object> mapContribChildren;
            Map<Object, Object> mapContribMethods;
            Map<Object, Object> mapContribProps;
            boolean fSelf;
            Component.Contribution contrib = listProcess.get(i);
            TypeConstant typeContrib = contrib.getTypeConstant();
            Component.Composition composition = contrib.getComposition();
            PropertyConstant idDelegate = contrib.getDelegatePropertyConstant();
            boolean bl = fSelf = composition == Component.Composition.Equal;
            if (fSelf) {
                boolean bl2;
                mapContribProps = new HashMap();
                mapContribMethods = new HashMap();
                mapContribChildren = new ListMap();
                int nBasePropRank = mapProps.size();
                int nBaseMethRank = mapMethods.size();
                if (!this.collectSelfTypeParameters(struct, mapTypeParams, mapContribProps, nBasePropRank, errs)) {
                    fIncomplete = true;
                    errs = ErrorListener.BLACKHOLE;
                }
                ArrayList listExplode = new ArrayList();
                boolean bl3 = bl2 = struct.getFormat() == Component.Format.INTERFACE;
                if (!this.collectChildInfo(constId, bl2, struct, mapTypeParams, mapContribProps, mapContribMethods, mapContribChildren, listExplode, nBasePropRank, nBaseMethRank, errs)) {
                    fIncomplete = true;
                    errs = ErrorListener.BLACKHOLE;
                }
                Iterator iterator = listExplode.iterator();
                while (iterator.hasNext()) {
                    PropertyConstant idProp = (PropertyConstant)iterator.next();
                    PropertyInfo propertyInfo = (PropertyInfo)mapContribProps.remove(idProp);
                    assert (propertyInfo != null);
                    this.layerOnProp(constId, true, null, mapProps, mapVirtProps, typeContrib, idProp, propertyInfo, errs);
                    if (fNative || this.explodeProperty(constId, struct, idProp, propertyInfo, mapProps, mapVirtProps, mapMethods, mapVirtMethods, errs)) continue;
                    fIncomplete = true;
                    errs = ErrorListener.BLACKHOLE;
                }
            } else {
                TypeInfo infoContrib = typeContrib.adjustAccess(constId).ensureTypeInfoInternal(errs);
                if (!TypeConstant.isComplete(infoContrib) && (fIncomplete = this.computeIncomplete(composition, typeContrib, infoContrib, setDepends))) {
                    errs = ErrorListener.BLACKHOLE;
                    if (infoContrib == null || composition == Component.Composition.Into) continue;
                }
                switch (composition) {
                    case Into: {
                        infoContrib = infoContrib.asInto();
                        break;
                    }
                    case Delegates: {
                        infoContrib = infoContrib.asDelegates();
                    }
                }
                mapContribProps = infoContrib.getProperties();
                mapContribMethods = infoContrib.getMethods();
                mapContribChildren = infoContrib.getChildInfosByName();
                if (composition != Component.Composition.Into) {
                    HashSet<IdentityConstant> setClass = new HashSet<IdentityConstant>();
                    for (Map.Entry entry : listmapClassChain.entrySet()) {
                        if (!((Origin)entry.getValue()).getType().equals(typeContrib)) continue;
                        setClass.add((IdentityConstant)entry.getKey());
                    }
                    HashSet<IdentityConstant> setDefault = new HashSet<IdentityConstant>();
                    for (Map.Entry<IdentityConstant, Origin> entry : listmapDefaultChain.entrySet()) {
                        if (!entry.getValue().getType().equals(typeContrib)) continue;
                        setDefault.add(entry.getKey());
                    }
                    if (setClass.size() < infoContrib.getClassChain().size() || setDefault.size() < infoContrib.getDefaultChain().size()) {
                        Map.Entry<IdentityConstant, Origin> entry;
                        HashMap<PropertyConstant, PropertyInfo> hashMap = new HashMap<PropertyConstant, PropertyInfo>();
                        entry = mapContribProps.entrySet().iterator();
                        while (entry.hasNext()) {
                            Map.Entry entry2 = (Map.Entry)entry.next();
                            PropertyInfo propertyInfo = ((PropertyInfo)entry2.getValue()).retainOnly((PropertyConstant)entry2.getKey(), setClass, setDefault);
                            if (propertyInfo == null) continue;
                            hashMap.put((PropertyConstant)entry2.getKey(), propertyInfo);
                        }
                        mapContribProps = hashMap;
                        HashMap<MethodConstant, MethodInfo> mapReducedMethods = new HashMap<MethodConstant, MethodInfo>();
                        for (Map.Entry entry2 : mapContribMethods.entrySet()) {
                            MethodInfo infoReduced = ((MethodInfo)entry2.getValue()).retainOnly((MethodConstant)entry2.getKey(), setClass, setDefault);
                            if (infoReduced == null) continue;
                            mapReducedMethods.put((MethodConstant)entry2.getKey(), infoReduced);
                        }
                        mapContribMethods = mapReducedMethods;
                    }
                }
            }
            this.layerOnProps(constId, fSelf, idDelegate, mapProps, mapVirtProps, typeContrib, mapContribProps, errs);
            if (fSelf && !TypeConstant.isInterface(constId, struct) && !struct.isExplicitlyAbstract()) {
                for (Map.Entry<PropertyConstant, PropertyInfo> entry : mapProps.entrySet()) {
                    infoOld = entry.getValue();
                    PropertyInfo propertyInfo = ((PropertyInfo)infoOld).finishAdoption(fNative, errs);
                    if (propertyInfo == infoOld) continue;
                    entry.setValue(propertyInfo);
                    if (!propertyInfo.isVirtual()) continue;
                    assert (((PropertyInfo)infoOld).isVirtual());
                    nid = entry.getKey().resolveNestedIdentity(pool, this);
                    infoCheck = mapVirtProps.put(nid, propertyInfo);
                    assert (infoOld == infoCheck);
                }
            }
            if (!mapContribMethods.isEmpty()) {
                this.layerOnMethods(constId, fSelf ? ContribSource.Self : ContribSource.Regular, idDelegate, mapMethods, mapVirtMethods, typeContrib, mapContribMethods, errs);
            }
            if (!mapContribChildren.isEmpty()) {
                for (Map.Entry<Object, Object> entry : mapContribChildren.entrySet()) {
                    ChildInfo childInfo;
                    String sName = (String)entry.getKey();
                    ChildInfo infoPrev = mapChildren.putIfAbsent(sName, childInfo = (ChildInfo)entry.getValue());
                    if (infoPrev == null) continue;
                    ChildInfo infoNew = infoPrev.layerOn(childInfo);
                    if (infoNew == null) {
                        this.log(errs, Severity.ERROR, "VERIFY-85", constId, sName, contrib.getTypeConstant(), infoPrev.getIdentity());
                        continue;
                    }
                    mapChildren.put(sName, infoNew);
                }
            }
            if (!fSelf || !fNative) continue;
            for (Map.Entry<MethodConstant, MethodInfo> entry : mapMethods.entrySet()) {
                infoOld = entry.getValue();
                MethodInfo methodInfo = ((MethodInfo)infoOld).finishAdoption(fNative, errs);
                if (methodInfo == infoOld) continue;
                entry.setValue(methodInfo);
                if (!methodInfo.isVirtual()) continue;
                assert (((MethodInfo)infoOld).isVirtual());
                nid = entry.getKey().getNestedIdentity();
                infoCheck = mapVirtMethods.put(nid, methodInfo);
                assert (infoOld == infoCheck);
            }
        }
        return !fIncomplete;
    }

    protected boolean explodeProperty(IdentityConstant constId, ClassStructure struct, PropertyConstant idProp, PropertyInfo info, Map<PropertyConstant, PropertyInfo> mapProps, Map<Object, PropertyInfo> mapVirtProps, Map<MethodConstant, MethodInfo> mapMethods, Map<Object, MethodInfo> mapVirtMethods, ErrorListener errs) {
        PropertyStructure prop;
        TypeConstant typeInto;
        TypeInfo infoInto;
        TypeConstant typeBase;
        boolean fComplete = true;
        ConstantPool pool = this.getConstantPool();
        TypeConstant typeProp = info.getType();
        TypeConstant typeConstant = info.isVar() ? pool.typeVarRB() : (typeBase = info.requiresNativeRef() ? pool.typeRefRB() : null);
        if (typeBase == null) {
            infoInto = pool.getNakedRefInfo(typeProp);
            typeInto = infoInto.getType();
        } else {
            typeInto = pool.ensureAccessTypeConstant(pool.ensureParameterizedTypeConstant(typeBase, typeProp), Constants.Access.PROTECTED);
            infoInto = typeInto.ensureTypeInfoInternal(errs);
        }
        if (TypeConstant.isComplete(infoInto)) {
            this.nestAndLayerOn(constId, idProp, mapProps, mapVirtProps, mapMethods, mapVirtMethods, typeInto, infoInto, errs);
        } else {
            fComplete = false;
            errs = ErrorListener.BLACKHOLE;
        }
        Annotation[] aAnnos = info.getRefAnnotations();
        int cAnnos = aAnnos.length;
        for (int i = cAnnos - 1; i >= 0; --i) {
            TypeInfo infoAnno;
            ClassStructure clzAnno;
            Annotation anno = aAnnos[i];
            TypeConstant typeAnno = anno.getAnnotationType();
            if (typeAnno.isIntoPropertyType() && (clzAnno = (ClassStructure)((IdentityConstant)anno.getAnnotationClass()).getComponent()).isParameterized()) {
                typeAnno = pool.ensureParameterizedTypeConstant(typeAnno, typeProp);
            }
            if ((infoAnno = (typeAnno = pool.ensureAccessTypeConstant(typeAnno, Constants.Access.PROTECTED)).ensureTypeInfoInternal(errs)) == null) {
                fComplete = false;
                errs = ErrorListener.BLACKHOLE;
                continue;
            }
            this.nestAndLayerOn(constId, idProp, mapProps, mapVirtProps, mapMethods, mapVirtMethods, typeAnno, infoAnno, errs);
        }
        if (struct.getFormat() != Component.Format.INTERFACE && (prop = (PropertyStructure)idProp.getComponent()) != null) {
            MethodConstant idGet = info.getGetterId();
            MethodConstant idSet = info.getSetterId();
            MethodInfo infoGet = mapMethods.get(idGet);
            MethodInfo infoSet = mapMethods.get(idSet);
            int nRank = mapMethods.size();
            if (prop.isNative()) {
                infoGet = new MethodInfo(new MethodBody(idGet, idGet.getSignature(), MethodBody.Implementation.Native), nRank);
                if (infoSet != null) {
                    infoSet = new MethodInfo(new MethodBody(idSet, idSet.getSignature(), MethodBody.Implementation.Native), nRank + 1);
                }
            } else {
                if (infoGet == null) {
                    if (!fComplete) {
                        return false;
                    }
                    throw new IllegalStateException("Missing getter for " + idGet.getValueString() + " at " + this.getValueString());
                }
                infoGet = infoGet.layerOn(new MethodInfo(new MethodBody(idGet, idGet.getSignature(), MethodBody.Implementation.Implicit), nRank), false, errs);
                if (infoSet != null) {
                    infoSet = infoSet.layerOn(new MethodInfo(new MethodBody(idSet, idSet.getSignature(), MethodBody.Implementation.Implicit), nRank + 1), false, errs);
                }
            }
            mapMethods.put(idGet, infoGet);
            mapVirtMethods.put(idGet.resolveNestedIdentity(pool, null), infoGet);
            if (infoSet != null) {
                mapMethods.put(idSet, infoSet);
                mapVirtMethods.put(idSet.resolveNestedIdentity(pool, null), infoSet);
            }
        }
        return fComplete;
    }

    protected void nestAndLayerOn(IdentityConstant constId, PropertyConstant idProp, Map<PropertyConstant, PropertyInfo> mapProps, Map<Object, PropertyInfo> mapVirtProps, Map<MethodConstant, MethodInfo> mapMethods, Map<Object, MethodInfo> mapVirtMethods, TypeConstant typeContrib, TypeInfo infoContrib, ErrorListener errs) {
        Map<MethodConstant, MethodInfo> mapOrigMethods;
        ConstantPool pool = this.getConstantPool();
        Map<PropertyConstant, PropertyInfo> mapOrigProps = infoContrib.getProperties();
        if (!mapOrigProps.isEmpty()) {
            HashMap<PropertyConstant, PropertyInfo> mapContribProps = new HashMap<PropertyConstant, PropertyInfo>(mapOrigProps.size());
            for (Map.Entry<PropertyConstant, PropertyInfo> entry : mapOrigProps.entrySet()) {
                Object nidContrib = entry.getKey().resolveNestedIdentity(pool, null);
                PropertyConstant idContrib = (PropertyConstant)idProp.appendNestedIdentity(pool, nidContrib);
                mapContribProps.put(idContrib, entry.getValue());
            }
            this.layerOnProps(constId, false, null, mapProps, mapVirtProps, typeContrib, mapContribProps, errs);
        }
        if (!(mapOrigMethods = infoContrib.getMethods()).isEmpty()) {
            HashMap<MethodConstant, MethodInfo> mapContribMethods = new HashMap<MethodConstant, MethodInfo>(mapOrigMethods.size());
            for (Map.Entry<MethodConstant, MethodInfo> entry : mapOrigMethods.entrySet()) {
                Object nidContrib = entry.getKey().resolveNestedIdentity(pool, null);
                MethodConstant idContrib = (MethodConstant)idProp.appendNestedIdentity(pool, nidContrib);
                MethodInfo infoMethod = entry.getValue();
                if (infoMethod.isCapped()) {
                    infoMethod = infoMethod.nestNarrowingIdentity(pool, idProp);
                }
                mapContribMethods.put(idContrib, infoMethod);
            }
            this.layerOnMethods(constId, ContribSource.Regular, null, mapMethods, mapVirtMethods, typeContrib, mapContribMethods, errs);
        }
    }

    protected void layerOnTypeParams(Map<Object, ParamInfo> mapTypeParams, TypeConstant typeContrib, Map<Object, ParamInfo> mapContribParams, ErrorListener errs) {
        for (ParamInfo paramContrib : mapContribParams.values()) {
            Object nid = paramContrib.getNestedIdentity();
            ParamInfo paramCurr = mapTypeParams.get(nid);
            if (paramCurr == null) {
                mapTypeParams.put(nid, paramContrib);
                continue;
            }
            if (paramContrib.isActualTypeSpecified() != paramCurr.isActualTypeSpecified()) {
                if (paramContrib.isFormalType() && paramContrib.getFormalTypeName().equals(paramCurr.getName()) || paramContrib.isFormalTypeSequence()) continue;
                if (paramCurr.isActualTypeSpecified()) {
                    this.log(errs, Severity.ERROR, "VERIFY-35", this.removeAccess().getValueString(), nid, paramCurr.getActualType().getValueString(), typeContrib.getValueString());
                    continue;
                }
                this.log(errs, Severity.ERROR, "VERIFY-34", this.removeAccess().getValueString(), nid, typeContrib.getValueString(), paramContrib.getActualType().getValueString());
                continue;
            }
            if (paramCurr.getActualType().isA(paramContrib.getActualType())) continue;
            if (paramContrib.getActualType().isA(paramCurr.getActualType())) {
                mapTypeParams.put(nid, paramContrib);
                continue;
            }
            this.log(errs, Severity.ERROR, "VERIFY-33", this.removeAccess().getValueString(), nid, paramCurr.getActualType().getValueString(), typeContrib.getValueString(), paramContrib.getActualType().getValueString());
        }
    }

    protected void layerOnProps(IdentityConstant constId, boolean fSelf, PropertyConstant idDelegate, Map<PropertyConstant, PropertyInfo> mapProps, Map<Object, PropertyInfo> mapVirtProps, TypeConstant typeContrib, Map<PropertyConstant, PropertyInfo> mapContribProps, ErrorListener errs) {
        for (Map.Entry<PropertyConstant, PropertyInfo> entry : mapContribProps.entrySet()) {
            this.layerOnProp(constId, fSelf, idDelegate, mapProps, mapVirtProps, typeContrib, entry.getKey(), entry.getValue(), errs);
        }
    }

    protected void layerOnProp(IdentityConstant constId, boolean fSelf, PropertyConstant idDelegate, Map<PropertyConstant, PropertyInfo> mapProps, Map<Object, PropertyInfo> mapVirtProps, TypeConstant typeContrib, PropertyConstant idContrib, PropertyInfo propContrib, ErrorListener errs) {
        PropertyInfo propResult;
        ConstantPool pool = this.getConstantPool();
        Object nidContrib = idContrib.resolveNestedIdentity(pool, this);
        PropertyConstant idResult = (PropertyConstant)constId.appendNestedIdentity(pool, nidContrib);
        boolean fVirtual = propContrib.isVirtual();
        PropertyInfo propBase = mapVirtProps.get(nidContrib);
        if (propContrib.getRefAccess() == Constants.Access.PRIVATE && propBase != null) {
            constId.log(errs, Severity.ERROR, "VERIFY-79", propBase.getIdentity().getParentConstant().getValueString(), propContrib.getName());
            propBase = null;
        }
        PropertyInfo propertyInfo = propBase == null ? propContrib : (propResult = propContrib.getIdentity().equals(propBase.getIdentity()) ? propBase : propBase.layerOn(propContrib, fSelf, false, errs));
        if (idDelegate != null && !propResult.isFormalType()) {
            PropertyBody head = propResult.getHead();
            TypeConstant type = propResult.getType();
            PropertyBody bodyDelegate = new PropertyBody(head.getStructure(), MethodBody.Implementation.Delegating, idDelegate, type, head.isRO(), head.isRW(), false, PropertyBody.Effect.BlocksSuper, head.isRO() ? PropertyBody.Effect.None : PropertyBody.Effect.BlocksSuper, false, false, null, null);
            propResult = new PropertyInfo(propResult, bodyDelegate);
        }
        if (propBase == null && propContrib.isOverride()) {
            this.log(errs, Severity.ERROR, "VERIFY-51", typeContrib.removeAccess().getValueString(), propContrib.getName());
        }
        mapProps.put(idResult, propResult);
        if (fVirtual) {
            mapVirtProps.put(nidContrib, propResult);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void layerOnMethods(IdentityConstant constId, ContribSource contribSource, PropertyConstant idDelegate, Map<MethodConstant, MethodInfo> mapMethods, Map<Object, MethodInfo> mapVirtMethods, TypeConstant typeContrib, Map<MethodConstant, MethodInfo> mapContribMethods, ErrorListener errs) {
        ConstantPool pool = this.getConstantPool();
        HashMap<Object, MethodInfo> mapVirtMods = new HashMap<Object, MethodInfo>();
        Map<Object, Set<Object>> mapNarrowedNids = null;
        boolean fSelf = contribSource == ContribSource.Self;
        boolean fAnnotation = contribSource == ContribSource.Annotation;
        boolean fOnTop = fAnnotation || contribSource == ContribSource.ConditionalIncorp;
        for (Map.Entry<MethodConstant, MethodInfo> entry : mapContribMethods.entrySet()) {
            List<Object> listMatches;
            Object nidContrib;
            MethodConstant idContrib = entry.getKey();
            MethodInfo methodContrib = entry.getValue();
            MethodBody bodyContrib = methodContrib.getHead();
            MethodBody bodyContribTail = methodContrib.getTail();
            SignatureConstant sigContrib = methodContrib.getSignature();
            if (!methodContrib.isVirtual() && !methodContrib.isPotentialPropertyOverlay()) {
                boolean fKeep = true;
                nidContrib = idContrib.resolveNestedIdentity(pool, this);
                if (methodContrib.isConstructor()) {
                    if (!idContrib.isTopLevel()) continue;
                    idContrib = (MethodConstant)constId.appendNestedIdentity(pool, idContrib.getSignature());
                    if (methodContrib.isValidator()) {
                        MethodInfo methodBase = mapMethods.get(idContrib);
                        if (methodBase != null) {
                            methodContrib = methodBase.layerOnValidator(methodContrib);
                        }
                    } else if (!fAnnotation) {
                        fKeep = fSelf || methodContrib.containsVirtualConstructor();
                        listMatches = this.collectConstructors(methodContrib, mapMethods);
                        if (listMatches.isEmpty()) {
                            if (fSelf && bodyContrib.isOverride()) {
                                MethodConstant id = methodContrib.getIdentity();
                                id.log(errs, Severity.ERROR, "VERIFY-80", constId.getValueString(), id.getSignature().getValueString(), id.getNamespace().getValueString());
                            }
                        } else {
                            for (MethodConstant methodConstant : listMatches) {
                                MethodInfo ctor = mapMethods.get(methodConstant);
                                if (ctor.containsVirtualConstructor()) {
                                    if (ctor.containsBody(idContrib) || !bodyContrib.isOverride()) continue;
                                    methodContrib = ctor.layerOnVirtualConstructor(methodContrib);
                                    fKeep = true;
                                    if (methodConstant.equals(idContrib)) continue;
                                    mapNarrowedNids = this.addNarrowingNid(mapNarrowedNids, methodConstant.getSignature(), nidContrib);
                                    continue;
                                }
                                if (!this.isVirtualChild() || !fSelf || ctor.getHead().getImplementation() != MethodBody.Implementation.Implicit) continue;
                                mapMethods.remove(methodConstant);
                            }
                        }
                        if (this.isVirtualChild() && !fSelf && constId.extendsClass((ClassConstant)(idContribClz = (ClassConstant)methodContrib.getIdentity().getNamespace()))) {
                            methodContrib = methodContrib.markImplicitConstructor();
                            fKeep = true;
                        }
                    }
                } else if (idContrib.isTopLevel()) {
                    listMatches = this.collectCoveredMethods(sigContrib, mapMethods);
                    if (listMatches != null && !listMatches.isEmpty()) {
                        idContribClz = listMatches.iterator();
                        while (idContribClz.hasNext()) {
                            MethodConstant methodConstant = (MethodConstant)idContribClz.next();
                            MethodInfo method = mapMethods.get(methodConstant);
                            if (method.isFunction()) {
                                methodContrib = methodContrib.subsumeFunction(mapMethods.remove(methodConstant));
                                continue;
                            }
                            constId.log(errs, Severity.ERROR, "VERIFY-87", constId.getValueString(), method.getIdentity().getValueString());
                        }
                    } else if (fSelf && bodyContribTail.isOverride() && !constId.equals(pool.clzObject())) {
                        this.log(errs, Severity.ERROR, "VERIFY-70", methodContrib.getIdentity().getPathString(), constId.getValueString());
                    }
                } else {
                    boolean bl = fKeep = fSelf && !methodContrib.isAbstract();
                }
                if (!fKeep) continue;
                if (methodContrib.containsVirtualConstructor()) {
                    mapVirtMods.put(nidContrib, methodContrib);
                    continue;
                }
                mapMethods.put(idContrib, methodContrib);
                continue;
            }
            MethodInfo methodResult = methodContrib;
            Object object = nidContrib = fSelf ? idContrib.resolveNestedIdentity(pool, this) : idContrib.getNestedIdentity();
            if (fAnnotation) {
                if (methodContrib.isAbstract()) continue;
                if (methodContrib.isCapped()) {
                    mapVirtMods.put(nidContrib, methodContrib);
                    continue;
                }
            }
            listMatches = this.collectPotentialSuperMethods(methodContrib, nidContrib, mapVirtMethods);
            if (bodyContribTail.isOverride()) {
                if (listMatches.isEmpty()) {
                    if (bodyContribTail.isNative()) {
                        mapVirtMods.put(nidContrib, methodResult);
                    } else if (bodyContribTail.getImplementation() != MethodBody.Implementation.Implicit) {
                        this.log(errs, Severity.ERROR, "VERIFY-70", methodContrib.getIdentity().getPathString(), constId.getValueString());
                    }
                } else {
                    Object nidBase = null;
                    if (listMatches.size() == 1) {
                        nidBase = listMatches.get(0);
                        MethodInfo methodInfo = mapVirtMethods.get(nidBase);
                        if (methodInfo.isCapped()) {
                            if (fAnnotation) {
                                nidBase = methodInfo.getNarrowingMethod(mapVirtMethods);
                                assert (nidBase != null);
                                methodResult = mapVirtMethods.get(nidBase);
                            } else {
                                MethodConstant id = methodInfo.getIdentity();
                                this.log(errs, Severity.ERROR, "VERIFY-80", idContrib.getNamespace().getValueString(), id.getSignature().getValueString(), id.getNamespace().getValueString());
                                nidBase = null;
                            }
                        } else {
                            methodResult = methodInfo.layerOn(methodContrib, fSelf, errs);
                        }
                    } else {
                        HashMap<SignatureConstant, Object> mapNids = new HashMap<SignatureConstant, Object>();
                        for (Object object2 : listMatches) {
                            MethodInfo info = mapVirtMethods.get(object2);
                            if (info.isCapped()) continue;
                            mapNids.put(info.getSignature(), object2);
                        }
                        SignatureConstant signatureConstant = this.selectBest(mapNids.keySet(), bodyContrib.getSignature());
                        if (signatureConstant == null) {
                            if (bodyContrib.usesSuper()) {
                                this.log(errs, Severity.ERROR, "VERIFY-65", methodContrib.getIdentity().getPathString());
                                continue;
                            }
                        } else {
                            void var26_37;
                            nidBase = mapNids.get(signatureConstant);
                            MethodInfo methodInfo = mapVirtMethods.get(nidBase);
                            if (methodInfo.isCapped()) {
                                nidBase = methodInfo.getNarrowingMethod(mapVirtMethods);
                                MethodInfo methodInfo2 = mapVirtMethods.get(nidBase);
                                assert (nidBase != null);
                                listMatches.remove(signatureConstant);
                            }
                            methodResult = var26_37.layerOn(methodContrib, fSelf, errs);
                        }
                        for (Object nid3 : listMatches) {
                            MethodInfo method;
                            if (nid3.equals(nidBase) || (method = mapVirtMethods.get(nid3)).isCapped()) continue;
                            method = method.layerOn(methodContrib, fSelf, errs);
                            mapVirtMods.put(nid3, method);
                        }
                    }
                    if (nidBase != null) {
                        if (nidBase.equals(nidContrib)) {
                            nidContrib = nidBase;
                        } else if (!mapVirtMods.containsKey(nidBase)) {
                            mapNarrowedNids = this.addNarrowingNid(mapNarrowedNids, nidBase, nidContrib);
                        }
                    }
                }
            } else {
                MethodBody methodBody;
                MethodConstant idMethod;
                MethodInfo methodBase;
                if (fSelf || fOnTop && !methodContrib.isCapped() && !bodyContrib.isOverride()) {
                    for (Object object3 : listMatches) {
                        MethodInfo methodMatch = mapVirtMethods.get(object3);
                        if (methodMatch == null) continue;
                        MethodConstant methodConstant = methodContrib.getIdentity();
                        MethodBody methodBody2 = methodMatch.getHead();
                        MethodBody bodyTail = methodMatch.getTail();
                        if (methodBody2.getIdentity().equals(methodConstant) || bodyTail != methodBody2 && bodyTail.getIdentity().equals(methodConstant)) continue;
                        if (fAnnotation) {
                            if (errs.hasSeriousErrors() || methodBody2.isAbstract()) continue;
                            this.log(errs, Severity.WARNING, "VERIFY-92", methodBody2.getIdentity().getNamespace().getValueString(), bodyContrib.getIdentity().getNamespace().getValueString(), methodBody2.getIdentity().getPathString());
                            continue;
                        }
                        MethodBody bodyOverride = fOnTop ? methodBody2 : bodyTail;
                        this.log(errs, Severity.ERROR, "VERIFY-81", methodConstant.getNamespace().getValueString(), bodyOverride.getSignature().getValueString(), bodyOverride.getIdentity().getNamespace().getValueString());
                    }
                }
                if ((methodBase = mapVirtMethods.get(nidContrib)) == null || methodBase.isCapped()) {
                    if (methodBase != null && methodBase.containsBody(idContrib)) continue;
                    Object var26_39 = null;
                    for (Object e : listMatches) {
                        MethodInfo methodInfo = mapVirtMethods.get(e);
                        if (methodInfo == null || e.equals(nidContrib)) continue;
                        if (methodInfo.isCapped()) {
                            if (methodBase != null) continue;
                            methodBase = methodInfo;
                            Object e2 = e;
                            continue;
                        }
                        methodBase = methodInfo;
                        Object e3 = e;
                        break;
                    }
                    if (methodBase != null && methodBase.getHead().getImplementation() == MethodBody.Implementation.Implicit) {
                        void var26_43;
                        mapMethods.remove((MethodConstant)constId.appendNestedIdentity(pool, var26_43));
                    }
                } else if (!methodContrib.isCapped() && !listMatches.contains(nidContrib)) {
                    this.log(errs, Severity.ERROR, "VERIFY-65", methodContrib.getIdentity().getValueString());
                }
                if (methodBase != null) {
                    methodResult = methodBase.layerOn(methodContrib, fSelf, errs);
                }
                if (idDelegate != null && !methodResult.isCapped() && (idMethod = (methodBody = methodResult.getHead()).getIdentity().ensureNestedIdentity(pool, constId)).isTopLevel()) {
                    MethodBody methodBody3 = new MethodBody(idMethod, methodBody.getSignature(), MethodBody.Implementation.Delegating, idDelegate);
                    methodResult = new MethodInfo(Handy.prepend(methodResult.getChain(), methodBody3), methodResult.getRank());
                }
            }
            mapVirtMods.put(nidContrib, methodResult);
        }
        if (mapNarrowedNids != null) {
            mapNarrowedNids.keySet().removeAll(mapVirtMods.keySet());
            for (Map.Entry<MethodConstant, MethodInfo> entry : mapNarrowedNids.entrySet()) {
                MethodConstant nidNarrowed = entry.getKey();
                Set setNarrowing = (Set)((Object)entry.getValue());
                if (setNarrowing.size() == 1) {
                    Iterator nidNarrowing = setNarrowing.iterator().next();
                    MethodInfo infoNarrowing = (MethodInfo)mapVirtMods.get(nidNarrowing);
                    MethodInfo infoNarrowed = mapVirtMethods.get(nidNarrowed);
                    assert (!nidNarrowing.equals(nidNarrowed));
                    if (infoNarrowing.getAccess().isAsAccessibleAs(infoNarrowed.getAccess())) {
                        mapVirtMods.put(nidNarrowed, infoNarrowed.capWith(this, infoNarrowing));
                        continue;
                    }
                    this.log(errs, Severity.ERROR, "VERIFY-87", constId.getValueString(), infoNarrowing.getIdentity().getValueString());
                    continue;
                }
                for (Object nidNarrowing : setNarrowing) {
                    this.log(errs, Severity.ERROR, "VERIFY-69", constId.getValueString(), mapVirtMethods.get(nidNarrowed).getIdentity().getValueString(), ((MethodInfo)mapVirtMods.get(nidNarrowing)).getIdentity().getSignature().getValueString());
                }
            }
        }
        for (Map.Entry<MethodConstant, MethodInfo> entry : mapVirtMods.entrySet()) {
            MethodConstant nid = entry.getKey();
            MethodInfo info = entry.getValue();
            MethodConstant id = (MethodConstant)constId.appendNestedIdentity(pool, nid);
            mapMethods.put(id, info);
            mapVirtMethods.put(nid, info);
        }
    }

    private Map<Object, Set<Object>> addNarrowingNid(Map<Object, Set<Object>> mapNarrowedNids, Object nidBase, Object nidContrib) {
        if (mapNarrowedNids == null) {
            mapNarrowedNids = new HashMap<Object, Set<Object>>();
        }
        Set setNarrowing = mapNarrowedNids.computeIfAbsent(nidBase, key_ -> new HashSet());
        setNarrowing.add(nidContrib);
        return mapNarrowedNids;
    }

    protected List<MethodConstant> collectCoveredMethods(SignatureConstant sigSub, Map<MethodConstant, MethodInfo> mapBase) {
        ArrayList<MethodConstant> listMatch = new ArrayList<MethodConstant>();
        for (Map.Entry<MethodConstant, MethodInfo> entry : mapBase.entrySet()) {
            MethodConstant id = entry.getKey();
            MethodInfo info = entry.getValue();
            if (!id.getName().equals(sigSub.getName()) || !id.isTopLevel() || info.getHead().isVisibilityReductionAllowed() || !sigSub.isSubstitutableFor(id.getSignature(), this)) continue;
            if (listMatch == null) {
                listMatch = new ArrayList();
            }
            listMatch.add(id);
        }
        return listMatch;
    }

    protected List<Object> collectPotentialSuperMethods(MethodInfo methodInfo, Object nidSub, Map<Object, MethodInfo> mapSupers) {
        MethodStructure method = methodInfo.getHead().getMethodStructure();
        SignatureConstant sigSub = methodInfo.getSignature();
        int cDefaults = method == null ? 0 : method.getDefaultParamCount();
        ArrayList<Object> listMatch = null;
        for (Map.Entry<Object, MethodInfo> entry : mapSupers.entrySet()) {
            SignatureConstant sigSubReq;
            MethodInfo infoCandidate;
            SignatureConstant sigCandidate;
            Object nidCandidate = entry.getKey();
            if (!IdentityConstant.isNestedSibling(nidSub, nidCandidate) || !(sigCandidate = (infoCandidate = entry.getValue()).getSignature()).getName().equals(sigSub.getName())) continue;
            if (infoCandidate.containsBody(methodInfo.getIdentity()) || sigSub.isSubstitutableFor(sigCandidate, this)) {
                if (listMatch == null) {
                    listMatch = new ArrayList<Object>();
                }
                listMatch.add(nidCandidate);
                continue;
            }
            if (cDefaults <= 0) continue;
            int cParamsReq = sigCandidate.getParamCount();
            int cParamsSub = sigSub.getParamCount();
            if (cParamsSub <= cParamsReq || cParamsSub - cDefaults > cParamsReq || !(sigSubReq = sigSub.truncateParams(0, cParamsReq)).isSubstitutableFor(sigCandidate, this)) continue;
            if (listMatch == null) {
                listMatch = new ArrayList();
            }
            listMatch.add(nidCandidate);
        }
        return listMatch == null ? Collections.emptyList() : listMatch;
    }

    protected List<MethodConstant> collectConstructors(MethodInfo infoConstruct, Map<MethodConstant, MethodInfo> mapMethods) {
        MethodStructure method = infoConstruct.getHead().getMethodStructure();
        SignatureConstant sigSub = infoConstruct.getSignature();
        ArrayList<MethodConstant> listMatch = null;
        boolean fExact = true;
        for (Map.Entry<MethodConstant, MethodInfo> entry : mapMethods.entrySet()) {
            SignatureConstant sigSubReq;
            int cDefault;
            MethodInfo infoCandidate;
            SignatureConstant sigCandidate;
            MethodConstant idCandidate = entry.getKey();
            if (!idCandidate.isTopLevel() || !(sigCandidate = (infoCandidate = entry.getValue()).getSignature()).getName().equals(sigSub.getName())) continue;
            if (sigSub.isSubstitutableFor(sigCandidate, this)) {
                if (!fExact && listMatch != null) {
                    listMatch.clear();
                }
                if (listMatch == null) {
                    listMatch = new ArrayList<MethodConstant>();
                }
                listMatch.add(idCandidate);
                continue;
            }
            if (method == null || listMatch != null && fExact || (cDefault = method.getDefaultParamCount()) <= 0) continue;
            int cParamsReq = sigCandidate.getParamCount();
            int cParamsSub = sigSub.getParamCount();
            if (cParamsSub <= cParamsReq || cParamsSub - cDefault > cParamsReq || !(sigSubReq = sigSub.truncateParams(0, cParamsReq)).isSubstitutableFor(sigCandidate, this)) continue;
            if (listMatch == null) {
                listMatch = new ArrayList();
            }
            listMatch.add(idCandidate);
            fExact = false;
        }
        return listMatch == null ? Collections.emptyList() : listMatch;
    }

    public SignatureConstant selectBest(Set<SignatureConstant> setSigs, SignatureConstant sigSub) {
        SignatureConstant sigBest = null;
        int cParamsBest = -1;
        Iterator<SignatureConstant> iter = setSigs.iterator();
        block0: while (iter.hasNext()) {
            SignatureConstant sigCandidate = iter.next();
            int cParams = sigCandidate.getParamCount();
            if (sigCandidate.equals(sigSub)) {
                return sigCandidate;
            }
            if (cParams > cParamsBest) {
                sigBest = sigCandidate;
                cParamsBest = cParams;
                continue;
            }
            if (cParams != cParamsBest) continue;
            if (sigBest == null) {
                SignatureConstant sigPrev;
                Iterator<SignatureConstant> iterPrev = setSigs.iterator();
                while (iter.hasNext() && (sigPrev = iterPrev.next()) != sigCandidate) {
                    if (sigPrev.getParamCount() != cParamsBest || sigPrev.isSubstitutableFor(sigCandidate, this)) continue;
                    continue block0;
                }
                sigBest = sigCandidate;
                continue;
            }
            if (sigBest.isSubstitutableFor(sigCandidate, this)) {
                sigBest = sigCandidate;
                continue;
            }
            if (sigCandidate.isSubstitutableFor(sigBest, this)) continue;
            sigBest = null;
        }
        return sigBest;
    }

    private boolean collectSelfTypeParameters(ClassStructure struct, Map<Object, ParamInfo> mapTypeParams, Map<PropertyConstant, PropertyInfo> mapProps, int nBaseRank, ErrorListener errs) {
        boolean fComplete = true;
        if (this.isVirtualChild() || this.isInnerChildClass() || this.isAnonymousClass()) {
            TypeInfo infoParent = this.getParentType().ensureTypeInfoInternal(errs);
            if (TypeConstant.isComplete(infoParent)) {
                for (ParamInfo paramInfo : infoParent.getTypeParams().values()) {
                    if (paramInfo.getNestedIdentity() instanceof IdentityConstant.NestedIdentity) continue;
                    String sParam = paramInfo.getName();
                    mapTypeParams.put(sParam, paramInfo);
                    PropertyInfo infoProp = infoParent.findProperty(sParam);
                    if (infoProp == null) {
                        this.log(errs, Severity.ERROR, "VERIFY-37", this.getParentType().getValueString(), sParam);
                        continue;
                    }
                    mapProps.put(infoProp.getIdentity(), infoProp);
                }
            } else {
                fComplete = false;
            }
        }
        int nRank = nBaseRank + mapProps.size();
        for (Component component : struct.children()) {
            PropertyStructure prop;
            if (!(component instanceof PropertyStructure) || !(prop = (PropertyStructure)component).isGenericTypeParameter()) continue;
            PropertyConstant id = prop.getIdentityConstant();
            mapProps.put(id, new PropertyInfo(new PropertyBody(prop, mapTypeParams.get(id.getName())), nRank++));
        }
        return fComplete;
    }

    protected boolean collectChildInfo(IdentityConstant constId, boolean fInterface, Component structContrib, Map<Object, ParamInfo> mapTypeParams, Map<PropertyConstant, PropertyInfo> mapProps, Map<MethodConstant, MethodInfo> mapMethods, ListMap<String, ChildInfo> mapChildren, List<PropertyConstant> listExplode, int nBasePropRank, int nBaseMethRank, ErrorListener errs) {
        boolean fComplete = true;
        for (Component component : structContrib.children()) {
            String sName;
            if (component instanceof MultiMethodStructure) {
                MultiMethodStructure mms = (MultiMethodStructure)component;
                for (MethodStructure method : mms.methods()) {
                    if (method.isLambda()) continue;
                    fComplete &= method.isConstructorFinalizer() ? this.collectChildInfo(constId, fInterface, method, mapTypeParams, mapProps, mapMethods, mapChildren, listExplode, nBasePropRank, nBaseMethRank, errs) : this.createMemberInfo(constId, fInterface, method, mapTypeParams, mapProps, mapMethods, mapChildren, listExplode, nBasePropRank, nBaseMethRank, errs);
                }
                continue;
            }
            if (component instanceof PropertyStructure) {
                fComplete &= this.createMemberInfo(constId, fInterface, component, mapTypeParams, mapProps, mapMethods, mapChildren, listExplode, nBasePropRank, nBaseMethRank, errs);
                continue;
            }
            if (!(component instanceof ClassStructure) && !(component instanceof TypedefStructure) || (sName = component.getIdentityConstant().getNestedName()) == null) continue;
            if (mapChildren.containsKey(sName)) {
                this.log(errs, Severity.ERROR, "VERIFY-84", constId, sName);
            }
            mapChildren.put(sName, new ChildInfo(component));
        }
        return fComplete;
    }

    private boolean createMemberInfo(IdentityConstant constId, boolean fInterface, Component structContrib, Map<Object, ParamInfo> mapTypeParams, Map<PropertyConstant, PropertyInfo> mapProps, Map<MethodConstant, MethodInfo> mapMethods, ListMap<String, ChildInfo> mapChildren, List<PropertyConstant> listExplode, int nBasePropRank, int nBaseMethRank, ErrorListener errs) {
        ConstantPool pool = this.getConstantPool();
        boolean fRebase = constId instanceof NativeRebaseConstant;
        assert (fInterface || !fRebase);
        if (structContrib instanceof MethodStructure) {
            MethodStructure method = (MethodStructure)structContrib;
            boolean fHasNoCode = !method.hasCode();
            boolean fNative = method.isNative();
            boolean fStatic = method.isStatic();
            boolean fHasAbstract = method.findAnnotation(pool.clzAbstract()) != null;
            MethodConstant id = method.getIdentityConstant();
            SignatureConstant sig = id.getSignature().resolveGenericTypes(pool, method.isFunction() ? null : this);
            if (fRebase && fHasNoCode && !fNative) {
                fNative = true;
                method.markNative();
                pool.invalidateTypeInfos(id.getNamespace());
            }
            MethodBody body = new MethodBody(id, sig, fNative ? MethodBody.Implementation.Native : (fInterface && fHasNoCode ? MethodBody.Implementation.Declared : (fInterface && !fStatic ? MethodBody.Implementation.Default : (fHasAbstract ? MethodBody.Implementation.Abstract : (fHasNoCode ? MethodBody.Implementation.SansCode : MethodBody.Implementation.Explicit)))));
            MethodInfo infoNew = new MethodInfo(body, nBaseMethRank + mapMethods.size());
            mapMethods.put(id, infoNew);
        } else if (structContrib instanceof PropertyStructure) {
            PropertyStructure prop = (PropertyStructure)structContrib;
            if (prop.isGenericTypeParameter()) {
                return true;
            }
            boolean fFromIface = fInterface && !fRebase;
            PropertyConstant id = prop.getIdentityConstant();
            int nRank = nBasePropRank + mapProps.size();
            PropertyInfo info = this.createPropertyInfo(prop, constId, fRebase | prop.isNative(), fFromIface, nRank, errs);
            mapProps.put(id, info);
            if (info.isCustomLogic() || info.isRefAnnotated()) {
                listExplode.add(id);
                PropertyConstant idParam = pool.ensurePropertyConstant(id, "Referent");
                Object nidParam = idParam.resolveNestedIdentity(pool, this);
                ParamInfo param = new ParamInfo(nidParam, "Referent", pool.typeObject(), info.getType());
                PropertyInfo propParam = new PropertyInfo(new PropertyBody(null, param), nRank + 1);
                mapTypeParams.put(nidParam, param);
                mapProps.put(idParam, propParam);
            }
        }
        return this.collectChildInfo(constId, fInterface, structContrib, mapTypeParams, mapProps, mapMethods, mapChildren, listExplode, nBasePropRank, nBaseMethRank, errs);
    }

    private PropertyInfo createPropertyInfo(PropertyStructure prop, IdentityConstant constId, boolean fNative, boolean fInterface, int nRank, ErrorListener errs) {
        MethodBody.Implementation impl;
        Constants.Access access;
        Constants.Access accessRef;
        ConstantPool pool = this.getConstantPool();
        String sName = prop.getName();
        Annotation[] aPropAnno = prop.getPropertyAnnotations();
        boolean fHasRO = false;
        boolean fHasAbstract = false;
        boolean fHasOverride = false;
        boolean fHasInject = false;
        int c = aPropAnno.length;
        for (int i = 0; i < c; ++i) {
            Annotation annotation = aPropAnno[i];
            Constant constMixin = annotation.getAnnotationClass();
            if (this.scanForDups(aPropAnno, i, constMixin)) {
                this.log(errs, Severity.ERROR, "VERIFY-52", prop.getIdentityConstant().getValueString(), constMixin.getValueString());
            }
            fHasRO |= constMixin.equals(pool.clzRO());
            fHasAbstract |= constMixin.equals(pool.clzAbstract());
            fHasOverride |= constMixin.equals(pool.clzOverride());
        }
        Annotation[] aRefAnno = prop.getRefAnnotations();
        boolean fHasRefAnno = false;
        boolean fHasVarAnno = false;
        int c2 = aRefAnno.length;
        for (int i = 0; i < c2; ++i) {
            Annotation annotation = aRefAnno[i];
            Constant constAnno = annotation.getAnnotationClass();
            TypeConstant typeAnno = pool.ensureTerminalTypeConstant(constAnno);
            if (!typeAnno.isExplicitClassIdentity(true) || typeAnno.getExplicitClassFormat() != Component.Format.ANNOTATION) {
                this.log(errs, Severity.ERROR, "VERIFY-27", typeAnno.getValueString());
                continue;
            }
            TypeConstant typeInto = typeAnno.getExplicitClassInto(true);
            TypeConstant typeIntoCat = typeInto.getIntoPropertyType();
            if (typeIntoCat == null || typeIntoCat.equals(pool.typeProperty())) {
                this.log(errs, Severity.ERROR, "VERIFY-39", sName, constId.getPathString(), typeAnno.getValueString());
                continue;
            }
            assert (typeInto.isA(pool.typeRef()));
            if (this.scanForDups(aRefAnno, i, constAnno)) {
                this.log(errs, Severity.ERROR, "VERIFY-52", prop.getIdentityConstant().getValueString(), constAnno.getValueString());
            }
            if (constAnno.equals(pool.clzInject())) {
                fHasInject = true;
                continue;
            }
            fHasRefAnno = true;
            fHasVarAnno |= typeInto.isA(pool.typeVar());
        }
        IdentityConstant constParent = prop.getIdentityConstant().getParentConstant();
        boolean fConstant = prop.isStatic();
        switch (constParent.getFormat()) {
            case Property: {
                if (fConstant || !prop.getParent().isStatic()) break;
                this.log(errs, Severity.ERROR, "VERIFY-57", constParent.getValueString(), sName);
                break;
            }
            case Method: {
                if (fConstant || !prop.getParent().isStatic()) break;
                this.log(errs, Severity.ERROR, "VERIFY-74", constParent.getValueString(), sName);
                break;
            }
            case Module: 
            case Package: 
            case Class: {
                break;
            }
            default: {
                throw new IllegalStateException("a property (" + sName + ") cannot be nested under a " + String.valueOf((Object)constParent.getFormat()) + " (on " + constId.getValueString() + ")");
            }
        }
        MethodStructure methodInit = null;
        MethodStructure methodGet = null;
        MethodStructure methodSet = null;
        MethodStructure methodBadGet = null;
        MethodStructure methodBadSet = null;
        int cCustomMethods = 0;
        for (Component component : prop.children()) {
            if (!(component instanceof MultiMethodStructure)) continue;
            MultiMethodStructure mms = (MultiMethodStructure)component;
            for (MethodStructure method : mms.methods()) {
                if (method.isPotentialInitializer()) {
                    if (methodInit == null && method.isInitializer(prop.getType(), this)) {
                        methodInit = method;
                        continue;
                    }
                    this.log(errs, Severity.ERROR, "VERIFY-56", this.getValueString(), sName);
                    continue;
                }
                if (fConstant) {
                    this.log(errs, Severity.ERROR, "VERIFY-57", this.getValueString(), sName);
                    continue;
                }
                if (method.isPotentialGetter()) {
                    if (method.isGetter(prop.getType(), this)) {
                        if (methodGet != null) {
                            this.log(errs, Severity.ERROR, "VERIFY-40", this.getValueString(), sName);
                        }
                        methodGet = method;
                    } else {
                        methodBadGet = method;
                    }
                } else if (method.isPotentialSetter()) {
                    if (method.isSetter(prop.getType(), this)) {
                        if (methodSet != null) {
                            this.log(errs, Severity.ERROR, "VERIFY-42", this.getValueString(), sName);
                        }
                        methodSet = method;
                    } else {
                        methodBadSet = method;
                    }
                }
                if (method.isAbstract() || method.isStatic() || fNative) continue;
                ++cCustomMethods;
            }
        }
        if (methodBadGet != null && methodGet == null) {
            this.log(errs, Severity.ERROR, "VERIFY-41", this.getValueString(), sName);
        }
        if (methodBadSet != null && methodSet == null) {
            this.log(errs, Severity.ERROR, "VERIFY-43", this.getValueString(), sName);
        }
        if ((accessRef = prop.getAccess()) == Constants.Access.STRUCT | (access = prop.getVarAccess()) == Constants.Access.STRUCT) {
            this.log(errs, Severity.ERROR, "VERIFY-58", this.getValueString(), sName);
        } else if (access != null && accessRef.isLessAccessibleThan(access)) {
            this.log(errs, Severity.ERROR, "VERIFY-59", this.getValueString(), sName);
        }
        boolean fRW = false;
        boolean fRO = false;
        boolean fField = false;
        PropertyBody.Effect effectGet = PropertyBody.Effect.None;
        PropertyBody.Effect effectSet = PropertyBody.Effect.None;
        if (fConstant) {
            impl = MethodBody.Implementation.Native;
            if (!fHasInject && !prop.hasInitialValue() && prop.getInitialValue() == null == (methodInit == null)) {
                if (methodInit == null) {
                    this.log(errs, Severity.ERROR, "VERIFY-60", this.getValueString(), sName);
                } else {
                    this.log(errs, Severity.ERROR, "VERIFY-61", this.getValueString(), sName);
                }
            }
            if (fHasAbstract) {
                this.log(errs, Severity.ERROR, "VERIFY-62", this.getValueString(), sName);
            }
            if (fHasOverride) {
                this.log(errs, Severity.ERROR, "VERIFY-73", this.getValueString(), sName);
            }
            if (fHasRefAnno) {
                this.log(errs, Severity.ERROR, "VERIFY-72", this.getValueString(), sName);
            }
            if (access != null) {
                this.log(errs, Severity.ERROR, "VERIFY-63", this.getValueString(), sName);
            }
        } else if (fInterface) {
            impl = MethodBody.Implementation.Declared;
            fRW |= !(fRO |= fHasRO) | access != null;
            fField = false;
            if (cCustomMethods > 0) {
                if (cCustomMethods == 1 && methodGet != null) {
                    if (fHasRO) {
                        effectGet = PropertyBody.Effect.BlocksSuper;
                    } else {
                        this.log(errs, Severity.ERROR, "VERIFY-78", this.getValueString(), sName);
                    }
                } else {
                    this.log(errs, Severity.ERROR, "VERIFY-44", this.getValueString(), sName);
                }
            }
            if (fHasRefAnno) {
                this.log(errs, Severity.ERROR, "VERIFY-45", this.getValueString(), sName);
            }
            if (fHasInject) {
                this.log(errs, Severity.ERROR, "VERIFY-46", this.getValueString(), sName);
            }
            if (fHasAbstract && prop.getParent().getFormat() == Component.Format.INTERFACE) {
                this.log(errs, Severity.ERROR, "VERIFY-71", this.getValueString(), sName);
            }
        } else {
            boolean fSetBlocksSuper;
            impl = MethodBody.Implementation.Explicit;
            boolean fGetSupers = methodGet != null && methodGet.usesSuper();
            boolean fSetSupers = methodSet != null && methodSet.usesSuper();
            boolean fGetBlocksSuper = methodGet != null && !methodGet.isAbstract() && !fGetSupers;
            boolean bl = fSetBlocksSuper = methodSet != null && !methodSet.isAbstract() && !fSetSupers;
            if (fNative) {
                fGetSupers = false;
                fGetBlocksSuper = methodGet != null;
                fField = !fHasRO && !fGetBlocksSuper || fHasVarAnno;
                fRO = fHasRO;
                fRW = !fHasRO;
            } else {
                if (fHasRO && (fSetSupers || fHasVarAnno)) {
                    this.log(errs, Severity.ERROR, "VERIFY-48", this.getValueString(), sName);
                }
                if (fSetSupers && fGetBlocksSuper) {
                    this.log(errs, Severity.ERROR, "VERIFY-48", this.getValueString(), sName);
                }
                boolean fAbstractClass = prop.getContainingClass().isExplicitlyAbstract();
                if (!(!fHasRO || fAbstractClass || fHasAbstract || fHasOverride || fHasInject || methodGet != null)) {
                    this.log(errs, Severity.ERROR, "VERIFY-50", this.getValueString(), sName);
                }
                if (fHasInject && (methodGet != null || methodSet != null || fHasRefAnno)) {
                    this.log(errs, Severity.ERROR, "VERIFY-49", this.getValueString(), sName);
                }
                fField = !fHasRO & !fHasAbstract & !fGetBlocksSuper;
                fRO |= !fHasVarAnno && (fHasRO || fGetBlocksSuper && methodSet == null);
                fRW |= fHasVarAnno | access != null | methodSet != null;
            }
            effectGet = this.effectOf(fGetSupers, fGetBlocksSuper);
            effectSet = this.effectOf(fSetSupers, fSetBlocksSuper);
        }
        if (fRO && fRW) {
            this.log(errs, Severity.ERROR, "VERIFY-64", this.getValueString(), sName);
            fRO = false;
        }
        TypeConstant typeProp = prop.getType().resolveGenerics(pool, this);
        return new PropertyInfo(new PropertyBody(prop, impl, null, typeProp, fRO, fRW, cCustomMethods > 0, effectGet, effectSet, fField, fConstant, prop.getInitialValue(), methodInit == null ? null : methodInit.getIdentityConstant()), nRank);
    }

    private PropertyBody.Effect effectOf(boolean fSupers, boolean fBlocks) {
        return fSupers ? PropertyBody.Effect.MayUseSuper : (fBlocks ? PropertyBody.Effect.BlocksSuper : PropertyBody.Effect.None);
    }

    private boolean scanForDups(Annotation[] aAnno, int cScan, Constant constScanFor) {
        for (int i = 0; i < cScan; ++i) {
            if (!aAnno[i].getAnnotationClass().equals(constScanFor)) continue;
            return true;
        }
        return false;
    }

    private void checkTypeParameterProperties(Map<Object, ParamInfo> mapTypeParams, Map<Object, PropertyInfo> mapProps, ErrorListener errs) {
        for (ParamInfo param : mapTypeParams.values()) {
            if (param.getNestedIdentity() instanceof IdentityConstant.NestedIdentity) continue;
            String sParam = param.getName();
            PropertyInfo info = mapProps.get(sParam);
            if (info == null) {
                this.log(errs, Severity.ERROR, "VERIFY-37", this.removeAccess().getValueString(), sParam);
                continue;
            }
            if (info.isFormalType() && info.getType().getParamType(0).isA(param.getConstraintType())) continue;
            this.log(errs, Severity.ERROR, "VERIFY-38", this.removeAccess().getValueString(), sParam);
        }
    }

    private TypeInfo mergeConditionalIncorporates(int cInvalidations, IdentityConstant idBase, TypeInfo infoBase, TypeConstant[] atypeCondInc, ErrorListener errs) {
        ConstantPool pool = this.getConstantPool();
        TypeInfo info = infoBase;
        for (TypeConstant typeMixin : atypeCondInc) {
            TypeConstant typePrivate = pool.ensureAccessTypeConstant(typeMixin, Constants.Access.PRIVATE);
            TypeInfo infoMixin = typePrivate.ensureTypeInfoInternal(errs);
            if (infoMixin == null) {
                return new TypeInfo(this, cInvalidations, infoBase.getClassStructure(), 0, false, info.getTypeParams(), Annotation.NO_ANNOTATIONS, Annotation.NO_ANNOTATIONS, info.getExtends(), info.getRebases(), info.getInto(), info.getContributionList(), info.getClassChain(), info.getDefaultChain(), info.getProperties(), info.getMethods(), info.getVirtProperties(), info.getVirtMethods(), info.getChildInfosByName(), Collections.singleton(typePrivate.removeAccess()), TypeInfo.Progress.Incomplete);
            }
            info = this.mergeMixinTypeInfo(this, cInvalidations, idBase, infoBase.getClassStructure(), info, infoMixin, Annotation.NO_ANNOTATIONS, null, errs);
        }
        return info;
    }

    protected TypeInfo mergeMixinTypeInfo(TypeConstant typeTarget, int cInvalidations, IdentityConstant idBase, ClassStructure structBase, TypeInfo infoSource, TypeInfo infoMixin, Annotation[] aAnnoClass, Annotation annotation, ErrorListener errs) {
        ConstantPool pool = this.getConstantPool();
        Map<Object, ParamInfo> mapMixinParams = infoMixin.getTypeParams();
        Map<PropertyConstant, PropertyInfo> mapMixinProps = infoMixin.getProperties();
        Map<MethodConstant, MethodInfo> mapMixinMethods = infoMixin.getMethods();
        ListMap<String, ChildInfo> mapMixinChildren = infoMixin.getChildInfosByName();
        TypeConstant typeMixin = infoMixin.getType();
        HashMap<Object, ParamInfo> mapTypeParams = new HashMap<Object, ParamInfo>(infoSource.getTypeParams());
        HashMap<PropertyConstant, PropertyInfo> mapProps = new HashMap<PropertyConstant, PropertyInfo>(infoSource.getProperties());
        HashMap<MethodConstant, MethodInfo> mapMethods = new HashMap<MethodConstant, MethodInfo>(infoSource.getMethods());
        HashMap<Object, PropertyInfo> mapVirtProps = new HashMap<Object, PropertyInfo>(infoSource.getVirtProperties());
        HashMap<Object, MethodInfo> mapVirtMethods = new HashMap<Object, MethodInfo>(infoSource.getVirtMethods());
        ListMap<String, ChildInfo> mapChildren = new ListMap<String, ChildInfo>(infoSource.getChildInfosByName());
        typeTarget.layerOnTypeParams(mapTypeParams, typeMixin, mapMixinParams, errs);
        HashMap<String, Constant> mapDefaults = null;
        if (annotation != null) {
            Constant[] aconstArgs = annotation.getParams();
            MethodStructure ctor = infoMixin.getClassStructure().findConstructor(aconstArgs, typeTarget);
            if (ctor == null) {
                this.log(errs, Severity.ERROR, "COMPILER-140", annotation.getValueString(), typeTarget.getValueString());
            } else {
                mapDefaults = new HashMap<String, Constant>();
                ctor.collectDefaultParams(aconstArgs, mapDefaults);
            }
        }
        int nBaseRank = mapProps.values().stream().map(PropertyInfo::getRank).max(Integer::compare).orElse(0);
        for (Map.Entry entry : mapMixinProps.entrySet()) {
            PropertyConstant idProp = (PropertyConstant)entry.getKey();
            this.layerOnMixinProp(pool, infoSource, idBase, mapProps, mapVirtProps, idProp, (PropertyInfo)entry.getValue(), mapDefaults == null ? null : (Constant)mapDefaults.get(idProp.getName()), nBaseRank, errs);
        }
        for (Map.Entry entry : mapMixinChildren.entrySet()) {
            String sName = (String)entry.getKey();
            ChildInfo childNew = (ChildInfo)entry.getValue();
            ChildInfo childOld = mapChildren.get(sName);
            if (childOld == null) {
                mapChildren.put((String)entry.getKey(), (ChildInfo)entry.getValue());
                continue;
            }
            if (childOld.equals(childNew)) continue;
        }
        ContribSource contribSource = annotation == null ? ContribSource.ConditionalIncorp : ContribSource.Annotation;
        typeTarget.layerOnMethods(idBase, contribSource, null, mapMethods, mapVirtMethods, typeMixin, mapMixinMethods, errs);
        ArrayList<Component.Contribution> arrayList = new ArrayList<Component.Contribution>(infoSource.getContributionList());
        if (annotation == null) {
            ClassStructure classStructure = structBase;
            Objects.requireNonNull(classStructure);
            arrayList.add((Component)classStructure.new Component.Contribution(typeMixin, (ListMap<StringConstant, TypeConstant>)null));
        } else {
            ClassStructure classStructure = structBase;
            Objects.requireNonNull(classStructure);
            arrayList.add((Component)classStructure.new Component.Contribution(annotation, typeMixin));
        }
        Annotation[] aAnnoMixin = this.collectMixinAnnotations(arrayList);
        return new TypeInfo(typeTarget, cInvalidations, structBase, 0, false, mapTypeParams, aAnnoClass, aAnnoMixin, infoSource.getExtends(), infoSource.getRebases(), infoSource.getInto(), arrayList, infoSource.getClassChain(), infoSource.getDefaultChain(), mapProps, mapMethods, mapVirtProps, mapVirtMethods, mapChildren, null, TypeInfo.Progress.Complete);
    }

    protected void layerOnMixinProp(ConstantPool pool, TypeInfo infoBase, IdentityConstant idBaseClass, Map<PropertyConstant, PropertyInfo> mapProps, Map<Object, PropertyInfo> mapVirtProps, PropertyConstant idMixinProp, PropertyInfo propMixin, Constant constInit, int nBaseRank, ErrorListener errs) {
        PropertyInfo propResult;
        Object nidContrib = idMixinProp.getNestedIdentity();
        PropertyConstant idResult = (PropertyConstant)idBaseClass.appendNestedIdentity(pool, nidContrib);
        PropertyInfo propBase = infoBase.findPropertyByNid(nidContrib);
        if (constInit != null) {
            propMixin = propMixin.withInitialValue(constInit);
        }
        if (!propMixin.isVirtual()) {
            if (propBase != null) {
                mapProps.values().remove(propBase);
            }
            mapProps.put(idMixinProp, propMixin);
            return;
        }
        if (propBase == null) {
            if (nBaseRank > 0) {
                propMixin = propMixin.withRank(nBaseRank + propMixin.getRank());
            }
            propResult = propMixin;
        } else {
            propResult = propBase.layerOn(propMixin, false, true, errs);
        }
        mapProps.put(idResult, propResult);
        mapVirtProps.put(nidContrib, propResult);
    }

    public boolean isA(TypeConstant typeLeft) {
        return this.calculateRelation(typeLeft) != Relation.INCOMPATIBLE;
    }

    public Relation calculateRelation(TypeConstant typeLeft) {
        TypeConstant typeLeftResolved;
        ConstantPool pool = this.getConstantPool();
        if (this.equals(typeLeft) || typeLeft.equals(pool.typeObject())) {
            return Relation.IS_A;
        }
        ConstantPool poolLeft = typeLeft.getConstantPool();
        if (pool != poolLeft && !typeLeft.isShared(pool)) {
            return this.isShared(poolLeft) ? ((TypeConstant)poolLeft.register(this)).calculateRelation(typeLeft) : Relation.INCOMPATIBLE;
        }
        TypeConstant typeRight = this.getPosition() >= 0 ? this : (TypeConstant)pool.register(this);
        TypeConstant typeConstant = typeLeftResolved = poolLeft == pool && typeLeft.getPosition() >= 0 ? typeLeft : (TypeConstant)pool.register(typeLeft);
        if (typeRight != this || typeLeftResolved != typeLeft) {
            return typeRight.calculateRelation(typeLeftResolved);
        }
        if (typeLeft instanceof RecursiveTypeConstant) {
            RecursiveTypeConstant typeRecursive = (RecursiveTypeConstant)typeLeft;
            return this.calculateRelation(typeRecursive.getReferredToType());
        }
        Map<TypeConstant, Relation> mapRelations = this.ensureRelationMap();
        Relation relation = mapRelations.get(typeLeft);
        if (relation != null) {
            return relation;
        }
        Set<TypeConstant> setInProgress = this.m_tloInProgress.get();
        if (setInProgress != null && setInProgress.contains(typeLeft)) {
            String sRecursion;
            if (!typeLeft.isInterfaceType() && !typeLeft.containsRecursiveType() && !typeRight.containsRecursiveType() && s_setRecursions.add(sRecursion = "left=" + typeLeft.getValueString() + "; right=" + typeRight.getValueString())) {
                System.err.println("rejecting isA() due to a recursion: " + sRecursion);
            }
            mapRelations.put(typeLeft, Relation.INCOMPATIBLE);
            return Relation.INCOMPATIBLE;
        }
        if (typeLeft.isImmutable() && !typeRight.isImmutable() && !typeLeft.isTypeParameter() && !typeLeft.isDynamicType()) {
            mapRelations.put(typeLeft, Relation.INCOMPATIBLE);
            return Relation.INCOMPATIBLE;
        }
        if (!(typeLeft instanceof RelationalTypeConstant) && !(typeRight instanceof RelationalTypeConstant)) {
            if (typeLeft.isAccessSpecified() || typeRight.isAccessSpecified()) {
                Constants.Access accessLeft = typeLeft.getAccess();
                Constants.Access accessRight = typeRight.getAccess();
                switch (accessRight) {
                    case STRUCT: {
                        if (typeLeft.equals(this.getConstantPool().typeStruct())) {
                            relation = Relation.IS_A;
                            break;
                        }
                        if (accessLeft == Constants.Access.STRUCT) break;
                        relation = Relation.INCOMPATIBLE;
                        break;
                    }
                    case PRIVATE: 
                    case PROTECTED: 
                    case PUBLIC: {
                        if (accessLeft != Constants.Access.STRUCT && !accessLeft.isLessAccessibleThan(accessRight)) break;
                        relation = Relation.INCOMPATIBLE;
                    }
                }
                if (relation == null && (relation = typeRight.removeAccess().calculateRelation(typeLeft.removeAccess())) == Relation.INCOMPATIBLE && accessRight != Constants.Access.PUBLIC) {
                    relation = this.calculateDuckTypeRelation(typeLeft, typeRight, accessRight);
                }
                mapRelations.put(typeLeft, relation);
                return relation;
            }
            if (typeLeft instanceof ServiceTypeConstant) {
                relation = typeRight.isService() ? typeRight.calculateRelation(typeLeft.getUnderlyingType()) : Relation.INCOMPATIBLE;
                mapRelations.put(typeLeft, relation);
                return relation;
            }
            relation = TypeConstant.checkReservedCompatibility(typeLeft, typeRight);
            if (relation != null) {
                mapRelations.put(typeLeft, relation);
                return relation;
            }
        }
        if (setInProgress == null) {
            setInProgress = new HashSet<TypeConstant>();
            this.m_tloInProgress.set(setInProgress);
        }
        setInProgress.add(typeLeft);
        try {
            relation = typeRight.calculateRelationToLeft(typeLeft);
            if (relation == Relation.INCOMPATIBLE) {
                relation = this.calculateDuckTypeRelation(typeLeft, typeRight, Constants.Access.PUBLIC);
            }
            mapRelations.put(typeLeft, relation);
        }
        catch (Error | RuntimeException e) {
            mapRelations.remove(typeLeft);
            throw e;
        }
        finally {
            setInProgress.remove(typeLeft);
            if (setInProgress.isEmpty()) {
                this.m_tloInProgress.remove();
            }
        }
        return relation;
    }

    protected Relation calculateRelationToLeft(TypeConstant typeLeft) {
        return typeLeft.calculateRelationToRight(this);
    }

    protected Relation calculateRelationToRight(TypeConstant typeRight) {
        return typeRight.calculateRelationToContribution(this);
    }

    protected Relation calculateRelationToContribution(TypeConstant typeLeft) {
        TypeConstant typeRight = this;
        assert (!typeLeft.isRelationalType() && typeLeft.isSingleDefiningConstant());
        assert (!typeRight.isRelationalType() && typeRight.isSingleDefiningConstant());
        Constant constIdLeft = typeLeft.getDefiningConstant();
        Constant constIdRight = typeRight.getDefiningConstant();
        Constant.Format format = constIdRight.getFormat();
        switch (format) {
            case Module: 
            case Package: 
            case Class: 
            case NativeClass: {
                ClassStructure clzRight = (ClassStructure)((IdentityConstant)constIdRight).getComponent();
                return clzRight.calculateRelation(this.getConstantPool(), typeLeft, typeRight);
            }
            case Property: {
                PropertyConstant idRight = (PropertyConstant)constIdRight;
                if (constIdLeft.getFormat() == format && ((PropertyConstant)constIdLeft).getName().equals(idRight.getName())) {
                    return Relation.IS_A;
                }
                assert (typeRight.resolveTypedefs() instanceof TerminalTypeConstant);
                return idRight.getConstraintType().calculateRelation(typeLeft);
            }
            case TypeParameter: {
                TypeParameterConstant idLeft;
                TypeParameterConstant idRight = (TypeParameterConstant)constIdRight;
                if (constIdLeft.getFormat() == format && ((idLeft = (TypeParameterConstant)constIdLeft).getName().equals(idRight.getName()) || idLeft.equals(idRight))) {
                    return Relation.IS_A;
                }
                assert (typeRight instanceof TerminalTypeConstant);
                return idRight.getConstraintType().calculateRelation(typeLeft);
            }
            case FormalTypeChild: {
                FormalTypeChildConstant idRight = (FormalTypeChildConstant)constIdRight;
                if (constIdLeft.getFormat() == format && ((FormalTypeChildConstant)constIdLeft).getName().equals(idRight.getName())) {
                    return Relation.IS_A;
                }
                assert (typeRight instanceof TerminalTypeConstant);
                return idRight.getConstraintType().calculateRelation(typeLeft);
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                PseudoConstant idRight = (PseudoConstant)constIdRight;
                if (constIdLeft.getFormat() == format && idRight.isCongruentWith((PseudoConstant)constIdLeft)) {
                    Relation relRightIsLeft = (typeRight = typeRight.removeAutoNarrowing()).calculateRelation(typeLeft = typeLeft.removeAutoNarrowing());
                    return relRightIsLeft == Relation.INCOMPATIBLE ? typeLeft.calculateRelation(typeRight) : relRightIsLeft;
                }
                ClassStructure clzRight = (ClassStructure)idRight.getDeclarationLevelClass().getComponent();
                return clzRight.calculateRelation(this.getConstantPool(), typeLeft, typeRight);
            }
            case Typedef: {
                return ((TypedefConstant)constIdRight).getReferredToType().calculateRelation(typeLeft);
            }
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: {
                return ((KeywordConstant)constIdRight).getBaseType().calculateRelationToContribution(typeLeft);
            }
            case UnresolvedName: {
                return Relation.INCOMPATIBLE;
            }
        }
        throw new IllegalStateException("unexpected constant: " + String.valueOf(constIdRight));
    }

    protected Relation calculateDuckTypeRelation(TypeConstant typeLeft, TypeConstant typeRight, Constants.Access accessRight) {
        TypeConstant typeRightN;
        TypeConstant typeLeftN = typeLeft.normalizeParameters();
        return typeLeftN.isDuckTypeAbleFrom(typeRightN = typeRight.normalizeParameters()) && typeLeftN.isInterfaceAssignableFrom(typeRightN, accessRight, Collections.emptyList()).isEmpty() ? Relation.IS_A : Relation.INCOMPATIBLE;
    }

    public boolean isCovariantReturn(TypeConstant typeBase, TypeConstant typeCtx) {
        TypeConstant typeBaseR;
        if (this.isA(typeBase)) {
            return true;
        }
        ConstantPool pool = ConstantPool.getCurrentPool();
        TypeConstant typeThisR = this.containsAutoNarrowing(true) ? this.resolveAutoNarrowing(pool, false, typeCtx, null) : this;
        TypeConstant typeConstant = typeBaseR = typeBase.containsAutoNarrowing(true) ? typeBase.resolveAutoNarrowing(pool, false, typeCtx, null) : typeBase;
        if (typeThisR != this || typeBaseR != typeBase) {
            return typeThisR.isA(typeBaseR);
        }
        if (typeCtx != null && typeBase.containsGenericType(true) && (typeBaseR = typeBase.resolveGenerics(pool, typeCtx)) != typeBase && typeBaseR.getTypeDepth() == typeBase.getTypeDepth()) {
            return this.isCovariantReturn(typeBaseR, typeCtx);
        }
        return false;
    }

    public boolean isContravariantParameter(TypeConstant typeBase, TypeConstant typeCtx) {
        TypeConstant typeBaseR;
        if (typeBase.isA(this)) {
            return true;
        }
        ConstantPool pool = ConstantPool.getCurrentPool();
        TypeConstant typeThisR = this.containsAutoNarrowing(true) ? this.resolveAutoNarrowing(pool, false, typeCtx, null) : this;
        TypeConstant typeConstant = typeBaseR = typeBase.containsAutoNarrowing(true) ? typeBase.resolveAutoNarrowing(pool, false, typeCtx, null) : typeBase;
        if ((typeThisR != this || typeBaseR != typeBase) && typeBaseR.isA(typeThisR) && typeThisR.isA(typeBaseR)) {
            return true;
        }
        if (typeCtx != null && typeBase.containsGenericType(true) && (typeBaseR = typeBase.resolveGenerics(pool, typeCtx)) != typeBase && typeBaseR.getTypeDepth() == typeBase.getTypeDepth()) {
            return this.isContravariantParameter(typeBaseR, typeCtx);
        }
        return false;
    }

    protected Relation findUnionContribution(UnionTypeConstant typeLeft) {
        assert (!(this instanceof UnionTypeConstant));
        ConstantPool pool = this.getConstantPool();
        TypeConstant typeRight = this;
        assert (!typeRight.isRelationalType() && typeRight.isSingleDefiningConstant());
        Constant constIdRight = typeRight.getDefiningConstant();
        switch (constIdRight.getFormat()) {
            case Property: 
            case Module: 
            case Package: 
            case TypeParameter: 
            case FormalTypeChild: 
            case DynamicFormal: {
                return Relation.INCOMPATIBLE;
            }
            case Class: 
            case NativeClass: {
                ClassStructure clzRight = (ClassStructure)((IdentityConstant)constIdRight).getComponent();
                return clzRight.findUnionContribution(pool, typeLeft, typeRight.getParamTypes());
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                PseudoConstant idRight = (PseudoConstant)constIdRight;
                ClassStructure clzRight = (ClassStructure)idRight.getDeclarationLevelClass().getComponent();
                return clzRight.findUnionContribution(pool, typeLeft, typeRight.getParamTypes());
            }
            case Typedef: {
                return ((TypedefConstant)constIdRight).getReferredToType().findUnionContribution(typeLeft);
            }
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: {
                TypeConstant typeBase = ((KeywordConstant)constIdRight).getBaseType();
                ClassStructure clzRight = (ClassStructure)typeBase.getSingleUnderlyingClass(true).getComponent();
                return clzRight.findUnionContribution(pool, typeLeft, typeRight.getParamTypes());
            }
        }
        throw new IllegalStateException("unexpected constant: " + String.valueOf(constIdRight));
    }

    protected static Relation checkReservedCompatibility(TypeConstant typeLeft, TypeConstant typeRight) {
        if (!(typeLeft.isSingleUnderlyingClass(true) && typeRight.isSingleUnderlyingClass(true) && typeLeft.isExplicitClassIdentity(true) && typeRight.isExplicitClassIdentity(true))) {
            return null;
        }
        ConstantPool pool = typeLeft.getConstantPool();
        IdentityConstant idLeft = typeLeft.getSingleUnderlyingClass(true);
        if (idLeft.getFormat() == Constant.Format.NativeClass) {
            idLeft = ((NativeRebaseConstant)idLeft).getClassConstant();
        }
        if (idLeft.equals(pool.clzFunction())) {
            return pool.checkFunctionCompatibility(typeLeft, typeRight);
        }
        if (idLeft.equals(pool.clzMethod())) {
            return pool.checkMethodCompatibility(typeLeft, typeRight);
        }
        if (typeLeft.isTuple()) {
            return typeRight.isTuple() ? pool.checkTupleCompatibility(typeLeft, typeRight) : Relation.INCOMPATIBLE;
        }
        if (typeRight.isTypeOfType() && typeRight.getParamType(0).isTuple() && pool.ensureIndexedType(pool.typeType()).isA(typeLeft)) {
            return Relation.IS_A;
        }
        return null;
    }

    protected Set<SignatureConstant> isInterfaceAssignableFrom(TypeConstant typeRight, Constants.Access accessLeft, List<TypeConstant> listLeft) {
        return this.getUnderlyingType().isInterfaceAssignableFrom(typeRight, accessLeft, listLeft);
    }

    public boolean containsSubstitutableMethod(SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams) {
        return this.getUnderlyingType().containsSubstitutableMethod(signature, access, fFunction, listParams);
    }

    public boolean consumesFormalType(String sTypeName, Constants.Access access) {
        Map<String, Usage> mapUsage = this.ensureConsumesMap();
        Usage usage = mapUsage.get(sTypeName);
        if (usage == null) {
            mapUsage.put(sTypeName, Usage.IN_PROGRESS);
            try {
                usage = this.checkConsumption(sTypeName, access, Collections.emptyList());
            }
            catch (Error | RuntimeException e) {
                mapUsage.remove(sTypeName);
                throw e;
            }
            mapUsage.put(sTypeName, usage);
        } else if (usage == Usage.IN_PROGRESS) {
            usage = Usage.NO;
            mapUsage.put(sTypeName, usage);
        }
        return usage == Usage.YES;
    }

    protected Usage checkConsumption(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return this.getUnderlyingType().checkConsumption(sTypeName, access, listParams);
    }

    public boolean producesFormalType(String sTypeName, Constants.Access access) {
        Map<String, Usage> mapUsage = this.ensureProducesMap();
        Usage usage = mapUsage.get(sTypeName);
        if (usage == null) {
            mapUsage.put(sTypeName, Usage.IN_PROGRESS);
            try {
                usage = this.checkProduction(sTypeName, access, Collections.emptyList());
            }
            catch (Error | RuntimeException e) {
                mapUsage.remove(sTypeName);
                throw e;
            }
            mapUsage.put(sTypeName, usage);
        } else if (usage == Usage.IN_PROGRESS) {
            usage = Usage.NO;
            mapUsage.put(sTypeName, usage);
        }
        return usage == Usage.YES;
    }

    protected Usage checkProduction(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return this.getUnderlyingType().checkProduction(sTypeName, access, listParams);
    }

    public boolean isAssignableTo(TypeConstant that) {
        return this.isA(that) || this.getConverterTo(that) != null;
    }

    public MethodConstant getConverterTo(TypeConstant that) {
        return this.ensureTypeInfo().findConversion(that);
    }

    public boolean extendsClass(IdentityConstant constClass) {
        return this.getUnderlyingType().extendsClass(constClass);
    }

    public boolean isClassType() {
        return this.getCategory() == Category.CLASS;
    }

    public boolean isInterfaceType() {
        return this.getCategory() == Category.IFACE;
    }

    public boolean isFormalType() {
        return this.getCategory() == Category.FORMAL;
    }

    public boolean isFormalTypeType() {
        return this.isTypeOfType() && this.getParamType(0).isFormalType();
    }

    public boolean isDynamicType() {
        return false;
    }

    public boolean containsFormalType(boolean fAllowParams) {
        return this.getUnderlyingType().containsFormalType(fAllowParams);
    }

    public void collectFormalTypes(boolean fAllowParams, Set<TypeConstant> setFormal) {
        this.getUnderlyingType().collectFormalTypes(fAllowParams, setFormal);
    }

    public boolean containsDynamicType(Register register) {
        return this.getUnderlyingType().containsDynamicType(register);
    }

    public boolean containsDynamicType() {
        return this.containsDynamicType(null);
    }

    public boolean isGenericType() {
        if (this.getCategory() == Category.FORMAL) {
            Constant constant = this.getDefiningConstant();
            switch (constant.getFormat()) {
                case Property: {
                    return true;
                }
                case FormalTypeChild: {
                    return ((FormalTypeChildConstant)constant).getTopParent().getFormat() == Constant.Format.Property;
                }
            }
        }
        return false;
    }

    public boolean containsGenericType(boolean fAllowParams) {
        return this.getUnderlyingType().containsGenericType(fAllowParams);
    }

    public boolean isTypeParameter() {
        return this.isSingleDefiningConstant() && this.getDefiningConstant().getFormat() == Constant.Format.TypeParameter;
    }

    public boolean containsTypeParameter(boolean fAllowParams) {
        return this.getUnderlyingType().containsTypeParameter(fAllowParams);
    }

    public boolean containsRecursiveType() {
        return this.getUnderlyingType().containsRecursiveType();
    }

    public boolean containsFunctionType() {
        return this.getUnderlyingType().containsFunctionType();
    }

    public boolean isFormalTypeSequence() {
        return false;
    }

    public Category getCategory() {
        return this.getUnderlyingType().getCategory();
    }

    public boolean isSingleUnderlyingClass(boolean fAllowInterface) {
        return this.getUnderlyingType().isSingleUnderlyingClass(fAllowInterface);
    }

    public IdentityConstant getSingleUnderlyingClass(boolean fAllowInterface) {
        assert (this.isSingleUnderlyingClass(fAllowInterface));
        return this.getUnderlyingType().getSingleUnderlyingClass(fAllowInterface);
    }

    public boolean isExplicitClassIdentity(boolean fAllowParams) {
        return this.isModifyingType() && this.getUnderlyingType().isExplicitClassIdentity(fAllowParams);
    }

    public Component.Format getExplicitClassFormat() {
        return this.getUnderlyingType().getExplicitClassFormat();
    }

    public TypeConstant getExplicitClassInto() {
        return this.getExplicitClassInto(false);
    }

    public TypeConstant getExplicitClassInto(boolean fResolve) {
        return this.getUnderlyingType().getExplicitClassInto(fResolve);
    }

    public boolean isIntoClassType() {
        return this.isIntoMetaData(this.getConstantPool().typeClass(), true);
    }

    public boolean isIntoMethodType() {
        return this.isIntoMetaData(this.getConstantPool().typeMethod(), false);
    }

    public boolean isIntoMethodParameterType() {
        return this.isIntoMetaData(this.getConstantPool().typeParameter(), false);
    }

    public boolean isIntoMetaData(TypeConstant typeTarget, boolean fStrict) {
        return this.getUnderlyingType().isIntoMetaData(typeTarget, fStrict);
    }

    public boolean isIntoPropertyType() {
        return this.getUnderlyingType().isIntoPropertyType();
    }

    public TypeConstant getIntoPropertyType() {
        return this.getUnderlyingType().getIntoPropertyType();
    }

    public boolean isIntoVariableType() {
        return this.getUnderlyingType().isIntoVariableType();
    }

    public TypeConstant getIntoVariableType() {
        return this.getUnderlyingType().getIntoVariableType();
    }

    public boolean isIntConvertible() {
        if (!this.isExplicitClassIdentity(false)) {
            return false;
        }
        return switch (this.getEcstasyClassName()) {
            case "numbers.Bit", "numbers.Nibble", "text.Char", "numbers.Int8", "numbers.Int16", "numbers.Int32", "numbers.Int64", "numbers.Int128", "numbers.IntN", "numbers.UInt8", "numbers.UInt16", "numbers.UInt32", "numbers.UInt64", "numbers.UInt128", "numbers.UIntN" -> true;
            default -> this.getExplicitClassFormat() == Component.Format.ENUM;
        };
    }

    public int getIntCardinality() {
        assert (this.isIntConvertible());
        switch (this.getEcstasyClassName()) {
            case "numbers.Bit": {
                return 2;
            }
            case "numbers.Nibble": {
                return 16;
            }
            case "text.Char": {
                return 0x110000;
            }
            case "numbers.Int8": 
            case "numbers.UInt8": {
                return 256;
            }
            case "numbers.Int16": 
            case "numbers.UInt16": {
                return 65536;
            }
            case "numbers.Int32": 
            case "numbers.UInt32": 
            case "numbers.Int64": 
            case "numbers.UInt64": 
            case "numbers.Int128": 
            case "numbers.UInt128": 
            case "numbers.IntN": 
            case "numbers.UIntN": {
                return Integer.MAX_VALUE;
            }
        }
        ClassStructure clzEnum = (ClassStructure)this.getSingleUnderlyingClass(false).getComponent();
        int c = 0;
        for (Component component : clzEnum.children()) {
            if (component.getFormat() != Component.Format.ENUMVALUE) continue;
            ++c;
        }
        return c;
    }

    public Constant getCardinalBase() {
        assert (this.isIntConvertible());
        ConstantPool pool = this.getConstantPool();
        switch (this.getEcstasyClassName()) {
            case "numbers.Bit": {
                return pool.ensureBitConstant(0);
            }
            case "numbers.Nibble": {
                return pool.ensureIntConstant(PackedInteger.valueOf(0L), Constant.Format.Nibble);
            }
            case "text.Char": {
                return pool.ensureCharConstant(0);
            }
            case "numbers.Int8": {
                return pool.ensureIntConstant(PackedInteger.valueOf(-128L), Constant.Format.Int8);
            }
            case "numbers.UInt8": {
                return pool.ensureIntConstant(PackedInteger.valueOf(0L), Constant.Format.UInt8);
            }
            case "numbers.Int16": {
                return pool.ensureIntConstant(PackedInteger.valueOf(-32768L), Constant.Format.Int16);
            }
            case "numbers.UInt16": {
                return pool.ensureIntConstant(PackedInteger.valueOf(0L), Constant.Format.UInt16);
            }
            case "numbers.UInt32": {
                return pool.ensureIntConstant(PackedInteger.valueOf(0L), Constant.Format.UInt32);
            }
            case "numbers.UInt64": {
                return pool.ensureIntConstant(PackedInteger.valueOf(0L), Constant.Format.UInt64);
            }
            case "numbers.UInt128": {
                return pool.ensureIntConstant(PackedInteger.valueOf(0L), Constant.Format.UInt128);
            }
            case "numbers.Int32": 
            case "numbers.Int64": 
            case "numbers.Int128": 
            case "numbers.IntN": {
                return null;
            }
        }
        ClassStructure clzEnum = (ClassStructure)this.getSingleUnderlyingClass(false).getComponent();
        for (Component component : clzEnum.children()) {
            if (component.getFormat() != Component.Format.ENUMVALUE) continue;
            return pool.ensureSingletonConstConstant(component.getIdentityConstant());
        }
        return null;
    }

    public Constant getDefaultValue() {
        if (this.isExplicitClassIdentity(false) && this.isSingleUnderlyingClass(false)) {
            IdentityConstant id = this.getSingleUnderlyingClass(false);
            ClassStructure clz = (ClassStructure)id.getComponent();
            Component prop = clz.getChild("default");
            if (prop instanceof PropertyStructure) {
                PropertyStructure propDefault = (PropertyStructure)prop;
                Constant constDefault = propDefault.getInitialValue();
                if (constDefault == null) {
                    constDefault = this.getConstantPool().ensureSingletonConstConstant(prop.getIdentityConstant());
                }
                return constDefault;
            }
        } else if (this.isNullable()) {
            return this.getConstantPool().valNull();
        }
        return null;
    }

    public ClassDesc ensureClassDesc(TypeSystem ts) {
        return ClassDesc.of(this.ensureJitClassName(ts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ensureJitClassName(TypeSystem ts) {
        Object sJitName = this.m_sJitName;
        if (sJitName == null) {
            TypeConstant type;
            ModuleLoader loader = ts.findOwnerLoader(this);
            TypeConstant typeConstant = type = (TypeConstant)loader.module.getConstantPool().register(this);
            synchronized (typeConstant) {
                sJitName = type.m_sJitName;
                if (sJitName == null) {
                    String name = ts.xvm.nativeTypeSystem.nativeByType.get(type);
                    sJitName = name == null ? loader.prefix + this.getSingleUnderlyingClass(true).getJitName(ts) : name;
                }
                type.m_sJitName = sJitName;
            }
        }
        return sJitName;
    }

    public boolean isPrimitive() {
        return false;
    }

    public JitTypeDesc getJitDesc(TypeSystem ts) {
        ClassDesc cd = JitTypeDesc.getPrimitiveClass(this);
        if (cd != null) {
            return new JitTypeDesc(this, JitFlavor.Primitive, cd);
        }
        cd = JitTypeDesc.getMultiSlotPrimitiveClass(this);
        if (cd != null) {
            return new JitTypeDesc(this.removeNullable(), JitFlavor.MultiSlotPrimitive, cd);
        }
        cd = JitTypeDesc.getWidenedClass(this);
        if (cd != null) {
            return new JitTypeDesc(this, JitFlavor.Widened, cd);
        }
        assert (this.isSingleUnderlyingClass(true));
        return new JitTypeDesc(this, JitFlavor.Specific, ClassDesc.of(ts.ensureJitClassName(this)));
    }

    public ClassTemplate getTemplate(org.xvm.runtime.Container container) {
        return this.getUnderlyingType().getTemplate(container);
    }

    public TypeComposition ensureClass(Frame frame) {
        return frame.f_context.f_container.resolveClass(this);
    }

    public xRTType.TypeHandle ensureTypeHandle(org.xvm.runtime.Container container) {
        ConstantPool poolThat = container.getConstantPool();
        if (this.isShared(poolThat)) {
            xRTType.TypeHandle hType = this.m_handle;
            if (hType == null) {
                if (poolThat == this.getConstantPool()) {
                    hType = this.m_handle = xRTType.makeHandle(container, this, true);
                    assert (this.getConstantPool() == hType.getComposition().getConstantPool());
                } else {
                    return ((TypeConstant)poolThat.register(this)).ensureTypeHandle(container);
                }
            }
            return hType;
        }
        return xRTType.makeForeignHandle(this);
    }

    public int callEquals(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        if (hValue1 == hValue2) {
            return frame.assignValue(iReturn, xBoolean.TRUE);
        }
        TypeComposition clz1 = hValue1.getComposition();
        TypeComposition clz2 = hValue2.getComposition();
        TypeComposition clz = clz1.getType().equals(this) ? clz1 : (clz2.getType().equals(this) ? clz2 : this.ensureClass(frame));
        return clz == null ? frame.raiseException("Unknown common type for " + clz1.getType().getValueString() + " and " + clz2.getType().getValueString()) : clz.getTemplate().callEquals(frame, clz, hValue1, hValue2, iReturn);
    }

    public int callCompare(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        if (hValue1 == hValue2) {
            return frame.assignValue(iReturn, xOrdered.EQUAL);
        }
        TypeComposition clz1 = hValue1.getComposition();
        TypeComposition clz2 = hValue2.getComposition();
        TypeComposition clz = clz1.getType().equals(this) ? clz1 : (clz2.getType().equals(this) ? clz2 : this.ensureClass(frame));
        return clz == null ? frame.raiseException("Unknown common type for " + clz1.getType().getValueString() + " and " + clz2.getType().getValueString()) : clz.getTemplate().callCompare(frame, clz, hValue1, hValue2, iReturn);
    }

    public int callHashCode(Frame frame, ObjectHandle hValue, int iReturn) {
        xConst template = (xConst)frame.f_context.f_container.getTemplate(this);
        return template.callHashCode(frame, this, hValue, iReturn);
    }

    public MethodStructure findCallable(SignatureConstant sig) {
        TypeInfo infoType = this.ensureTypeInfo();
        MethodInfo infoFn = infoType.getMethodBySignature(sig, true);
        return infoFn == null || infoFn.isAbstract() ? null : infoFn.getTopmostMethodStructure(infoType);
    }

    public MethodInfo findFunctionInfo(SignatureConstant sig) {
        return this.ensureTypeInfo().getMethodBySignature(sig);
    }

    @Override
    public abstract Constant.Format getFormat();

    @Override
    public TypeConstant getType() {
        ConstantPool pool = this.getConstantPool();
        TypeConstant typeParent = this.isVirtualChild() ? this.getParentType() : pool.typeObject();
        return pool.ensureParameterizedTypeConstant(pool.typeType(), this, typeParent);
    }

    @Override
    public boolean isValueCacheable() {
        return !this.containsFormalType(true);
    }

    @Override
    protected abstract int compareDetails(Constant var1);

    @Override
    protected void setContaining(XvmStructure pool) {
        assert (this.isShared((ConstantPool)pool));
        super.setContaining(pool);
        this.m_cInvalidations = 0;
        this.m_typeinfo = null;
        this.m_mapRelations = null;
        this.m_handle = null;
        this.m_typeNormalized = null;
    }

    @Override
    protected abstract void registerConstants(ConstantPool var1);

    @Override
    protected abstract void assemble(DataOutput var1) throws IOException;

    @Override
    public boolean validate(ErrorListener errs) {
        boolean fHalt = false;
        if (!this.m_fValidated) {
            fHalt |= super.validate(errs);
            this.m_fValidated = !(fHalt |= this.isModifyingType() && this.getUnderlyingType().validate(errs));
        }
        return fHalt;
    }

    protected boolean isValidated() {
        return this.m_fValidated;
    }

    @Override
    public String getDescription() {
        return "type=" + this.getValueString();
    }

    @Override
    protected abstract int computeHashCode();

    @Override
    public boolean equals(Object obj) {
        TypeConstant typeConstant;
        TypeConstant typeThis;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeConstant)) {
            return false;
        }
        TypeConstant that = (TypeConstant)obj;
        TypeConstant typeConstant2 = this;
        if (typeConstant2 instanceof UnresolvedTypeConstant) {
            UnresolvedTypeConstant typeUnresolvedThis = (UnresolvedTypeConstant)typeConstant2;
            v0 = typeUnresolvedThis.getResolvedType();
        } else {
            v0 = typeThis = this;
        }
        if (obj instanceof UnresolvedTypeConstant) {
            UnresolvedTypeConstant typeUnresolvedThat = (UnresolvedTypeConstant)obj;
            typeConstant = typeUnresolvedThat.getResolvedType();
        } else {
            typeConstant = that;
        }
        TypeConstant typeThat = typeConstant;
        return typeThis != null && typeThat != null && typeThis.getFormat() == typeThat.getFormat() && typeThis.compareDetails(typeThat) == 0;
    }

    private Map<TypeConstant, Relation> ensureRelationMap() {
        Map<TypeConstant, Relation> mapRelations = this.m_mapRelations;
        if (mapRelations == null) {
            s_tloInProgress.compareAndSet(this, null, new TransientThreadLocal());
            mapRelations = this.m_mapRelations = new ConcurrentHashMap<TypeConstant, Relation>();
        }
        return mapRelations;
    }

    private Map<String, Usage> ensureConsumesMap() {
        Map<String, Usage> mapConsumes = this.m_mapConsumes;
        if (mapConsumes == null) {
            mapConsumes = this.m_mapConsumes = new HashMap<String, Usage>();
        }
        return mapConsumes;
    }

    private Map<String, Usage> ensureProducesMap() {
        Map<String, Usage> mapProduces = this.m_mapProduces;
        if (mapProduces == null) {
            mapProduces = this.m_mapProduces = new HashMap<String, Usage>();
        }
        return mapProduces;
    }

    protected boolean isDuckTypeAbleFrom(TypeConstant typeRight) {
        if (!this.isInterfaceType() || this.isVirtualChild() || this.isTuple()) {
            return false;
        }
        TypeConstant typeLeft = this;
        if (typeLeft.isSingleDefiningConstant() && typeRight.isSingleDefiningConstant() && typeRight.getDefiningConstant().equals(typeLeft.getDefiningConstant())) {
            return false;
        }
        ConstantPool pool = this.getConstantPool();
        if (typeRight.equals(pool.typeObject()) || typeRight.isFormalTypeSequence()) {
            return false;
        }
        if (typeLeft.isExplicitClassIdentity(true)) {
            IdentityConstant idLeft = typeLeft.getSingleUnderlyingClass(true);
            if (idLeft.equals(pool.clzFunction()) || idLeft.equals(pool.clzOrderable())) {
                return false;
            }
            ClassStructure clzLeft = (ClassStructure)idLeft.getComponent();
            int cParamsLeft = clzLeft.getTypeParamCount();
            if (typeRight.isExplicitClassIdentity(true)) {
                IdentityConstant idRight = typeRight.getSingleUnderlyingClass(true);
                if (clzLeft.hasContribution(idRight)) {
                    return false;
                }
                ClassStructure clzRight = (ClassStructure)idRight.getComponent();
                if (cParamsLeft > clzRight.getTypeParamCount()) {
                    return false;
                }
                if (cParamsLeft > 0) {
                    ListMap<StringConstant, TypeConstant> mapParamsLeft = clzLeft.getTypeParams();
                    ListMap<StringConstant, TypeConstant> mapParamsRight = clzRight.getTypeParams();
                    for (StringConstant constName : mapParamsLeft.keySet()) {
                        if (!mapParamsRight.containsKey(constName)) {
                            return false;
                        }
                        String sName = constName.getValue();
                        TypeConstant typePLeft = typeLeft.getGenericParamType(sName, Collections.emptyList());
                        TypeConstant typePRight = typeRight.getGenericParamType(sName, Collections.emptyList());
                        if (typePRight.equals(typePLeft)) continue;
                        return false;
                    }
                }
            } else {
                return cParamsLeft <= 0;
            }
        }
        return true;
    }

    protected static TypeConstant[] registerTypeConstants(ConstantPool pool, TypeConstant[] atype) {
        for (TypeConstant typeConstant : atype = (TypeConstant[])TypeConstant.registerConstants(pool, atype)) {
            typeConstant.registerConstants(pool);
        }
        return atype;
    }

    public Object ensureXType(Container container) {
        Object type = this.m_xType;
        if (type == null) {
            // empty if block
        }
        return type;
    }

    static {
        s_setRecursions.add("left=this:class(Array); right=this:class(Hashable)");
    }

    public class Origin {
        private final boolean m_fAnchored;

        public Origin(boolean fAnchored) {
            this.m_fAnchored = fAnchored;
        }

        public TypeConstant getType() {
            return TypeConstant.this;
        }

        public boolean isAnchored() {
            return this.m_fAnchored;
        }

        public String toString() {
            return "Origin{type=" + String.valueOf(this.getType()) + ", anchored=" + this.isAnchored() + "}";
        }
    }

    protected static enum ContribSource {
        Regular,
        Self,
        Annotation,
        ConditionalIncorp;

    }

    public static enum Relation {
        IS_A,
        IS_A_WEAK,
        INCOMPATIBLE;


        public Relation bestOf(Relation that) {
            return this.ordinal() < that.ordinal() ? this : that;
        }

        public Relation worseOf(Relation that) {
            return this.ordinal() < that.ordinal() ? that : this;
        }
    }

    public static enum Usage {
        IN_PROGRESS,
        YES,
        NO;


        public static Usage valueOf(boolean f) {
            return f ? YES : NO;
        }
    }

    public static enum Category {
        CLASS,
        IFACE,
        FORMAL,
        OTHER;

    }
}

